	NAME	COLORS
	INCLUDE	PAGESIZE.INC
	TITLE	.COLORS - Color/attribute selection tables
DATA	SEGMENT PUBLIC
	ASSUME	DS:DATA

	PUBLIC	COLORS

COLOR	RECORD	BLK:1=0,BGND:3=0,INTS:1=0,FGND:3=7

;	COLOR	<BLINK/NORMAL, BACKGROUND, BRIGHT/NORMAL, FOREGROUND>


COMMENT	|	ATTRIBUTE COLOR NUMBERING CONVENTION

a:b:c	a: 0-3 EAB mode	b: 0-7 Attribute mode	COLOR	c: 0-7 EAB color
	---------------	-----------------------	-------	----------------
	0 - Normal	0 - Unprot alpha dim	GREEN	0 - Normal (White)
	1 - Blink	1 - Unprot alpha brite	RED	1 - Blue
	2 - Reverse	2 - Unprot numer dim	CYAN  	2 - Red
	3 - Underscore	3 - Unprot numer brite	RED	3 - Magenta
			4 - Protec alpha dim	YELLOW  4 - Green
			5 - Protec alpha brite	WHITE   5 - Cyan
			6 - Protec numer dim	YELLOW  6 - Yellow
			7 - Protec numer brite	WHITE   7 - White

	The column above marked COLOR indicates the color assigned
	to the attribute mode immediately to the left when pseudo
	color is enabled (Color mode 1)

	Color modes are as follows underscore
					work properly.

	Use of color modes (1,2) with monochrome displays attached to 
	color display adapters may result in unreadable screens.
	This situation is not harmful, just not useful.

	Mode 3 table contains only 32 entrys as color information is
	discarded when monochrome adapters are used.  This table must
	be the last table in the COLORS area and must be area number 3.
	If this needs to be modified, change monochrome constants in
	procedure ATCALC in module MKATTR.

|	PAGE
COMMENT	|	MONOCHROME / COLOR MODE 0 
		
	All colors are equivalenced to white to make
	monochrome adapters happy.

	Intensity and blink bits are processed as
	themselves on the assumption that all
	monochrome displays will follow intensity
	commands.

	Underscored areas are displayed as reverse video.

	ATTRIBUTE COLOR NUMBERING CONVENTION

a:b:c	a: 0-3 EAB mode	b: 0-7 Attribute mode	c: 0-7 EAB color
	---------------	-----------------------	----------------
	0 - Normal	0 - Unprot alpha dim	0 - Normal (White)
	1 - Blink	1 - Unprot alpha brite	1 - Blue
	2 - Reverse	2 - Unprot numer dim	2 - Red
	3 - Underscore	3 - Unprot numer brite	3 - Magenta
			4 - Protec alpha dim	4 - Green
			5 - Protec alpha brite	5 - Cyan
			6 - Protec numer dim	6 - Yellow
			7 - Protec numer brite	7 - White

	|

	BLACK=	0			; Black is normal
	BLUE=	7			; Subsititute white
	GREEN=	7
	CYAN=	7
	RED=	7
	MAGENTA=7
	YELLOW=	7
	WHITE=	7

	NORMAL=	0			; Modifiers are as normal
	BLINK=	1
	BRIGHT=	1

	USCORE=	0

	PAGE
COLORS	LABEL	BYTE			; Monochrome (Mode 0) definition

	COLOR <	NORMAL,	BLACK,	NORMAL,	GREEN	> ; 0:0:0 Normal base colors
	COLOR <	NORMAL,	BLACK,	NORMAL,	BLUE 	> ; 0:0:1 Unprotected
	COLOR <	NORMAL,	BLACK,	NORMAL,	RED  	> ; 0:0:2 Alphanumeric
	COLOR <	NORMAL,	BLACK,	NORMAL,	MAGENTA	> ; 0:0:3 Dim
	COLOR <	NORMAL,	BLACK,	NORMAL,	GREEN	> ; 0:0:4 Normal
	COLOR <	NORMAL,	BLACK,	NORMAL,	CYAN	> ; 0:0:5
	COLOR <	NORMAL,	BLACK,	NORMAL,	YELLOW	> ; 0:0:6
	COLOR <	NORMAL,	BLACK,	NORMAL,	WHITE	> ; 0:0:7

	COLOR <	NORMAL,	BLACK,	BRIGHT,	WHITE	> ; 0:1:0 Normal base colors
	COLOR <	NORMAL,	BLACK,	BRIGHT,	BLUE 	> ; 0:1:1 Unprotected
	COLOR <	NORMAL,	BLACK,	BRIGHT,	RED  	> ; 0:1:2 Alphanumeric
	COLOR <	NORMAL,	BLACK,	BRIGHT,	MAGENTA	> ; 0:1:3 Bright
	COLOR <	NORMAL,	BLACK,	BRIGHT,	GREEN	> ; 0:1:4 Normal
	COLOR <	NORMAL,	BLACK,	BRIGHT,	CYAN	> ; 0:1:5
	COLOR <	NORMAL,	BLACK,	BRIGHT,	YELLOW	> ; 0:1:6
	COLOR <	NORMAL,	BLACK,	BRIGHT,	WHITE	> ; 0:1:7

	COLOR <	NORMAL,	BLACK,	NORMAL,	GREEN	> ; 0:2:0 Normal base colors
	COLOR <	NORMAL,	BLACK,	NORMAL,	BLUE 	> ; 0:2:1 Unprotected
	COLOR <	NORMAL,	BLACK,	NORMAL,	RED  	> ; 0:2:2 Numeric only
	COLOR <	NORMAL,	BLACK,	NORMAL,	MAGENTA	> ; 0:2:3 Dim
	COLOR <	NORMAL,	BLACK,	NORMAL,	GREEN	> ; 0:2:4 Normal
	COLOR <	NORMAL,	BLACK,	NORMAL,	CYAN	> ; 0:2:5
	COLOR <	NORMAL,	BLACK,	NORMAL,	YELLOW	> ; 0:2:6
	COLOR <	NORMAL,	BLACK,	NORMAL,	WHITE	> ; 0:2:7

	COLOR <	NORMAL,	BLACK,	BRIGHT,	WHITE	> ; 0:3:0 Normal base colors
	COLOR <	NORMAL,	BLACK,	BRIGHT,	BLUE 	> ; 0:3:1 Unprotected
	COLOR <	NORMAL,	BLACK,	BRIGHT,	RED  	> ; 0:3:2 Numeric only
	COLOR <	NORMAL,	BLACK,	BRIGHT,	MAGENTA	> ; 0:3:3 Bright
	COLOR <	NORMAL,	BLACK,	BRIGHT,	GREEN	> ; 0:3:4 Normal
	COLOR <	NORMAL,	BLACK,	BRIGHT,	CYAN	> ; 0:3:5
	COLOR <	NORMAL,	BLACK,	BRIGHT,	YELLOW	> ; 0:3:6
	COLOR <	NORMAL,	BLACK,	BRIGHT,	WHITE	> ; 0:3:7

	COLOR <	NORMAL,	BLACK,	NORMAL,	GREEN	> ; 0:4:0 Normal base colors
	COLOR <	NORMAL,	BLACK,	NORMAL,	BLUE 	> ; 0:4:1 Protected
	COLOR <	NORMAL,	BLACK,	NORMAL,	RED  	> ; 0:4:2 Alphanumeric
	COLOR <	NORMAL,	BLACK,	NORMAL,	MAGENTA	> ; 0:4:3 Dim
	COLOR <	NORMAL,	BLACK,	NORMAL,	GREEN	> ; 0:4:4 Normal
	COLOR <	NORMAL,	BLACK,	NORMAL,	CYAN	> ; 0:4:5
	COLOR <	NORMAL,	BLACK,	NORMAL,	YELLOW	> ; 0:4:6
	COLOR <	NORMAL,	BLACK,	NORMAL,	WHITE	> ; 0:4:7

	COLOR <	NORMAL,	BLACK,	BRIGHT,	WHITE	> ; 0:5:0 Normal base colors
	COLOR <	NORMAL,	BLACK,	BRIGHT,	BLUE 	> ; 0:5:1 Protected
	COLOR <	NORMAL,	BLACK,	BRIGHT,	RED  	> ; 0:5:2 Alphanumeric
	COLOR <	NORMAL,	BLACK,	BRIGHT,	MAGENTA:

	0 - Monochrome display 		Used when color adapter is attached
					to monochrome display.  No color or
					underscoring is attempted.

	1 - 3279 TWO COLOR 		Used with color displays for
	    				adding color to monochrome
					application programs.  

	2 - 3279/2A FOUR COLOR		Used with color displays for
					applications which make use
					of 3279 type color character
					modes.

	3 - Monochrome adapter		Used for all modes when a
					monochrome display adapter
					is in use.  Makes	> ; 0:5:3 Bright
	COLOR <	NORMAL,	BLACK,	BRIGHT,	GREEN	> ; 0:5:4 Normal
	COLOR <	NORMAL,	BLACK,	BRIGHT,	CYAN	> ; 0:5:5
	COLOR <	NORMAL,	BLACK,	BRIGHT,	YELLOW	> ; 0:5:6
	COLOR <	NORMAL,	BLACK,	BRIGHT,	WHITE	> ; 0:5:7

	COLOR <	NORMAL,	BLACK,	NORMAL,	GREEN	> ; 0:6:0 Normal base colors
	COLOR <	NORMAL,	BLACK,	NORMAL,	BLUE 	> ; 0:6:1 Protected
	COLOR <	NORMAL,	BLACK,	NORMAL,	RED  	> ; 0:6:2 Numeric only
	COLOR <	NORMAL,	BLACK,	NORMAL,	MAGENTA	> ; 0:6:3 Dim
	COLOR <	NORMAL,	BLACK,	NORMAL,	GREEN	> ; 0:6:4 Normal
	COLOR <	NORMAL,	BLACK,	NORMAL,	CYAN	> ; 0:6:5
	COLOR <	NORMAL,	BLACK,	NORMAL,	YELLOW	> ; 0:6:6
	COLOR <	NORMAL,	BLACK,	NORMAL,	WHITE	> ; 0:6:7

	COLOR <	NORMAL,	BLACK,	BRIGHT,	WHITE	> ; 0:7:0 Normal base colors
	COLOR <	NORMAL,	BLACK,	BRIGHT,	BLUE 	> ; 0:7:1 Protected
	COLOR <	NORMAL,	BLACK,	BRIGHT,	RED  	> ; 0:7:2 Numeric only
	COLOR <	NORMAL,	BLACK,	BRIGHT,	MAGENTA	> ; 0:7:3 Bright
	COLOR <	NORMAL,	BLACK,	BRIGHT,	GREEN	> ; 0:7:4 Normal
	COLOR <	NORMAL,	BLACK,	BRIGHT,	CYAN	> ; 0:7:5
	COLOR <	NORMAL,	BLACK,	BRIGHT,	YELLOW	> ; 0:7:6
	COLOR <	NORMAL,	BLACK,	BRIGHT,	WHITE	> ; 0:7:7

	COLOR <	BLINK,	BLACK,	NORMAL,	GREEN	> ; 1:0:0 Normal base colors
	COLOR <	BLINK,	BLACK,	NORMAL,	BLUE 	> ; 1:0:1 Unprotected
	COLOR <	BLINK,	BLACK,	NORMAL,	RED  	> ; 1:0:2 Alphanumeric
	COLOR <	BLINK,	BLACK,	NORMAL,	MAGENTA	> ; 1:0:3 Dim
	COLOR <	BLINK,	BLACK,	NORMAL,	GREEN	> ; 1:0:4 Blink
	COLOR <	BLINK,	BLACK,	NORMAL,	CYAN	> ; 1:0:5
	COLOR <	BLINK,	BLACK,	NORMAL,	YELLOW	> ; 1:0:6
	COLOR <	BLINK,	BLACK,	NORMAL,	WHITE	> ; 1:0:7

	COLOR <	BLINK,	BLACK,	BRIGHT,	WHITE	> ; 1:1:0 Normal base colors
	COLOR <	BLINK,	BLACK,	BRIGHT,	BLUE 	> ; 1:1:1 Unprotected
	COLOR <	BLINK,	BLACK,	BRIGHT,	RED  	> ; 1:1:2 Alphanumeric
	COLOR <	BLINK,	BLACK,	BRIGHT,	MAGENTA	> ; 1:1:3 Bright
	COLOR <	BLINK,	BLACK,	BRIGHT,	GREEN	> ; 1:1:4 Blink
	COLOR <	BLINK,	BLACK,	BRIGHT,	CYAN	> ; 1:1:5
	COLOR <	BLINK,	BLACK,	BRIGHT,	YELLOW	> ; 1:1:6
	COLOR <	BLINK,	BLACK,	BRIGHT,	WHITE	> ; 1:1:7

	COLOR <	BLINK,	BLACK,	NORMAL,	WHITE	> ; 1:2:0 Normal base colors
	COLOR <	BLINK,	BLACK,	NORMAL,	BLUE 	> ; 1:2:1 Unprotected
	COLOR <	BLINK,	BLACK,	NORMAL,	RED  	> ; 1:2:2 Numeric only
	COLOR <	BLINK,	BLACK,	NORMAL,	MAGENTA	> ; 1:2:3 Dim
	COLOR <	BLINK,	BLACK,	NORMAL,	GREEN	> ; 1:2:4 Blink
	COLOR <	BLINK,	BLACK,	NORMAL,	CYAN	> ; 1:2:5
	COLOR <	BLINK,	BLACK,	NORMAL,	YELLOW	> ; 1:2:6
	COLOR <	BLINK,	BLACK,	NORMAL,	WHITE	> ; 1:2:7

	COLOR <	BLINK,	BLACK,	BRIGHT,	WHITE	> ; 1:3:0 Normal base colors
	COLOR <	BLINK,	BLACK,	BRIGHT,	BLUE 	> ; 1:3:1 Unprotected
	COLOR <	BLINK,	BLACK,	BRIGHT,	RED  	> ; 1:3:2 Numeric only
	COLOR <	BLINK,	BLACK,	BRIGHT,	MAGENTA	> ; 1:3:3 Bright
	COLOR <	BLINK,	BLACK,	BRIGHT,	GREEN	> ; 1:3:4 Blink
	COLOR <	BLINK,	BLACK,	BRIGHT,	CYAN	> ; 1:3:5
	COLOR <	BLINK,	BLACK,	BRIGHT,	YELLOW	> ; 1:3:6
	COLOR <	BLINK,	BLACK,	BRIGHT,	WHITE	> ; 1:3:7

	COLOR <	BLINK,	BLACK,	NORMAL,	GREEN	> ; 1:4:0 Normal base colors
	COLOR <	BLINK,	BLACK,	NORMAL,	BLUE 	> ; 1:4:1 Protected
	COLOR <	BLINK,	BLACK,	NORMAL,	RED  	> ; 1:4:2 Alphanumeric
	COLOR <	BLINK,	BLACK,	NORMAL,	MAGENTA	> ; 1:4:3 Dim
	COLOR <	BLINK,	BLACK,	NORMAL,	GREEN	> ; 1:4:4 Blink
	COLOR <	BLINK,	BLACK,	NORMAL,	CYAN	> ; 1:4:5
	COLOR <	BLINK,	BLACK,	NORMAL,	YELLOW	> ; 1:4:6
	COLOR <	BLINK,	BLACK,	NORMAL,	WHITE	> ; 1:4:7

	COLOR <	BLINK,	BLACK,	BRIGHT,	WHITE	> ; 1:5:0 Normal base colors
	COLOR <	BLINK,	BLACK,	BRIGHT,	BLUE 	> ; 1:5:1 Protected
	COLOR <	BLINK,	BLACK,	BRIGHT,	RED  	> ; 1:5:2 Alphanumeric
	COLOR <	BLINK,	BLACK,	BRIGHT,	MAGENTA	> ; 1:5:3 Bright
	COLOR <	BLINK,	BLACK,	BRIGHT,	GREEN	> ; 1:5:4 Blink
	COLOR <	BLINK,	BLACK,	BRIGHT,	CYAN	> ; 1:5:5
	COLOR <	BLINK,	BLACK,	BRIGHT,	YELLOW	> ; 1:5:6
	COLOR <	BLINK,	BLACK,	BRIGHT,	WHITE	> ; 1:5:7

	COLOR <	BLINK,	BLACK,	NORMAL,	GREEN	> ; 1:6:0 Normal base colors
	COLOR <	BLINK,	BLACK,	NORMAL,	BLUE 	> ; 1:6:1 Protected
	COLOR <	BLINK,	BLACK,	NORMAL,	RED  	> ; 1:6:2 Numeric only
	COLOR <	BLINK,	BLACK,	NORMAL,	MAGENTA	> ; 1:6:3 Dim
	COLOR <	BLINK,	BLACK,	NORMAL,	GREEN	> ; 1:6:4 Blink
	COLOR <	BLINK,	BLACK,	NORMAL,	CYAN	> ; 1:6:5
	COLOR <	BLINK,	BLACK,	NORMAL,	YELLOW	> ; 1:6:6
	COLOR <	BLINK,	BLACK,	NORMAL,	WHITE	> ; 1:6:7

	COLOR <	BLINK,	BLACK,	BRIGHT,	WHITE	> ; 1:7:0 Normal base colors
	COLOR <	BLINK,	BLACK,	BRIGHT,	BLUE 	> ; 1:7:1 Protected
	COLOR <	BLINK,	BLACK,	BRIGHT,	RED  	> ; 1:7:2 Numeric only
	COLOR <	BLINK,	BLACK,	BRIGHT,	MAGENTA	> ; 1:7:3 Bright
	COLOR <	BLINK,	BLACK,	BRIGHT,	GREEN	> ; 1:7:4 Blink
	COLOR <	BLINK,	BLACK,	BRIGHT,	CYAN	> ; 1:7:5
	COLOR <	BLINK,	BLACK,	BRIGHT,	YELLOW	> ; WHITE,	BRIGHT,	BLACK	> ; 2:1:0 Reverse video
	COLOR <	NORMAL,	BLUE,	BRIGHT,	BLACK 	> ; 2:1:1 Unprotected
	COLOR <	NORMAL,	RED,	BRIGHT,	BLACK  	> ; 2:1:2 Alphanumeric
	COLOR <	NORMAL,	MAGENTA,BRIGHT,	BLACK	> ; 2:1:3 Bright
	COLOR <	NORMAL,	GREEN,	BRIGHT,	BLACK	> ; 2:1:4
	COLOR <	NORMAL,	CYAN,	BRIGHT,	BLACK	> ; 2:1:5
	COLOR <	NORMAL,	YELLOW,	BRIGHT,	BLACK	> ; 2:1:6
	COLOR <	NORMAL,	WHITE,	BRIGHT,	BLACK	> ; 2:1:7

	COLOR <	NORMAL,	GREEN,	NORMAL,	BLACK	> ; 2:2:0 Reverse video
	COLOR <	NORMAL,	BLUE,	NORMAL,	BLACK 	> ; 2:2:1 Unprotected
	COLOR <	NORMAL,	RED,	NORMAL,	BLACK  	> ; 2:2:2 Numeric only
	COLOR <	NORMAL,	MAGENTA,NORMAL,	BLACK	> ; 2:2:3 Dim
	COLOR <	NORMAL,	GREEN,	NORMAL,	BLACK	> ; 2:2:4
	COLOR <	NORMAL,	CYAN,	NORMAL,	BLACK	> ; 2:2:5
	COLOR <	NORMAL,	YELLOW,	NORMAL,	BLACK	> ; 2:2:6
	COLOR <	NORMAL,	WHITE,	NORMAL,	BLACK	> ; 2:2:7

	COLOR <	NORMAL,	WHITE,	BRIGHT,	BLACK	> ; 2:3:0 Reverse video
	COLOR <	NORMAL,	BLUE,	BRIGHT,	BLACK 	> ; 2:3:1 Unprotected
	COLOR <	NORMAL,	RED,	BRIGHT,	BLACK  	> ; 2:3:2 Numeric only
	COLOR <	NORMAL,	MAGENTA,BRIGHT,	BLACK	> ; 2:3:3 Bright
	COLOR <	NORMAL,	GREEN,	BRIGHT,	BLACK	> ; 2:3:4
	COLOR <	NORMAL,	CYAN,	BRIGHT,	BLACK	> ; 2:3:5
	COLOR <	NORMAL,	YELLOW,	BRIGHT,	BLACK	> ; 2:3:6
	COLOR <	NORMAL,	WHITE,	BRIGHT,	BLACK	> ; 2:3:7

	COLOR <	NORMAL,	GREEN,	NORMAL,	BLACK	> ; 2:4:0 Reverse video
	COLOR <	NORMAL,	BLUE,	NORMAL,	BLACK 	> ; 2:4:1 Protected
	COLOR <	NORMAL,	RED,	NORMAL,	BLACK  	> ; 2:4:2 Alphanumeric
	COLOR <	NORMAL,	MAGENTA,NORMAL,	BLACK	> ; 2:4:3 Dim
	COLOR <	NORMAL,	GREEN,	NORMAL,	BLACK	> ; 2:4:4
	COLOR <	NORMAL,	CYAN,	NORMAL,	BLACK	> ; 2:4:5
	COLOR <	NORMAL,	YELLOW,	NORMAL,	BLACK	> ; 2:4:6
	COLOR <	NORMAL,	WHITE,	NORMAL,	BLACK	> ; 2:4:7

	COLOR <	NORMAL,	WHITE,	BRIGHT,	BLACK	> ; 2:5:0 Reverse video
	COLOR <	NORMAL,	BLUE,	BRIGHT,	BLACK 	> ; 2:5:1 Protected
	COLOR <	NORMAL,	RED,	BRIGHT,	BLACK  	> ; 2:5:2 Alphanumeric
	COLOR <	NORMAL,	MAGENTA,BRIGHT,	BLACK	> ; 2:5:3 Bright
	COLOR <	NORMAL,	GREEN,	BRIGHT,	BLACK	> ; 2:5:4
	COLOR <	NORMAL,	CYAN,	BRIGHT,	BLACK	> ; 2:5:5
	COLOR <	NORMAL,	YELLOW,	BRIGHT,	BLACK	> ; 2:5:6
	COLOR <	NORMAL,	WHITE,	BRIGHT,	BLACK	> ; 2:5:7

	COLOR <	NORMAL,	GREEN,	NORMAL,	BLACK	> ; 2:6:0 Reverse video
	COLOR <	NORMAL,	BLUE,	NORMAL,	BLACK 	> ; 2:6:1 Protected
	COLOR <	NORMAL,	RED,	NORMAL,	BLACK  	> ; 2:6:2 Numeric only
	COLOR <	NORMAL,	MAGENTA,NORMAL,	BLACK	> ; 2:6:3 Dim
	COLOR <	NORMAL,	GREEN,	NORMAL,	BLACK	> ; 2:6:4
	COLOR <	NORMAL,	CYAN,	NORMAL,	BLACK	> ; 2:6:5
	COLOR <	NORMAL,	YELLOW,	NORMAL,	BLACK	> ; 2:6:6
	COLOR <	NORMAL,	WHITE,	NORMAL,	BLACK	> ; 2:6:7

	COLOR <	NORMAL,	WHITE,	BRIGHT,	BLACK	> ; 2:7:0 Reverse video
	COLOR <	NORMAL,	BLUE,	BRIGHT,	BLACK 	> ; 2:7:1 Protected
	COLOR <	NORMAL,	RED,	BRIGHT,	BLACK  	> ; 2:7:2 Numeric only
	COLOR <	NORMAL,	MAGENTA,BRIGHT,	BLACK	> ; 2:7:3 Bright
	COLOR <	NORMAL,	GREEN,	BRIGHT,	BLACK	> ; 2:7:4
	COLOR <	NORMAL,	CYAN,	BRIGHT,	BLACK	> ; 2:7:5
	COLOR <	NORMAL,	YELLOW,	BRIGHT,	BLACK	> ; 2:7:6
	COLOR <	NORMAL,	WHITE,	BRIGHT,	BLACK	> ; 2:7:7

	COLOR <	NORMAL,	GREEN,	NORMAL,	USCORE	> ; 3:0:0 Underscored
	COLOR <	NORMAL,	BLUE,	NORMAL,	USCORE 	> ; 3:0:1 Unprotected
	COLOR <	NORMAL,	RED,	NORMAL,	USCORE	> ; 3:0:2 Alphanumeric
	COLOR <	NORMAL,	MAGENTA,NORMAL,	USCORE	> ; 3:0:3 Dim
	COLOR <	NORMAL,	GREEN,	NORMAL,	USCORE	> ; 3:0:4
	COLOR <	NORMAL,	CYAN,	NORMAL,	USCORE	> ; 3:0:5
	COLOR <	NORMAL,	YELLOW,	NORMAL,	USCORE	> ; 3:0:6
	COLOR <	NORMAL,	WHITE,	NORMAL,	USCORE	> ; 3:0:7

	COLOR <	NORMAL,	WHITE,	BRIGHT,	USCORE	> ; 3:1:0 Underscored
	COLOR <	NORMAL,	BLUE,	BRIGHT,	USCORE 	> ; 3:1:1 Unprotected
	COLOR <	NORMAL,	RED,	BRIGHT,	USCORE	> ; 3:1:2 Alphanumeric
	COLOR <	NORMAL,	MAGENTA,BRIGHT,	USCORE	> ; 3:1:3 Bright
	COLOR <	NORMAL,	GREEN,	BRIGHT,	USCORE	> ; 3:1:4
	COLOR <	NORMAL,	CYAN,	BRIGHT,	USCORE	> ; 3:1:5
	COLOR <	NORMAL,	YELLOW,	BRIGHT,	USCORE	> ; 3:1:6
	COLOR <	NORMAL,	WHITE,	BRIGHT,	USCORE	> ; 3:1:7

	COLOR <	NORMAL,	GREEN,	NORMAL,	USCORE	> ; 3:2:0 Underscored
	COLOR <	NORMAL,	BLUE,	NORMAL,	USCORE 	> ; 3:2:1 Unprotected
	COLOR <	NORMAL,	RED,	NORMAL,	US1:7:6
	COLOR <	BLINK,	BLACK,	BRIGHT,	WHITE	> ; 1:7:7

	COLOR <	NORMAL,	GREEN,	NORMAL,	BLACK	> ; 2:0:0 Reverse video
	COLOR <	NORMAL,	BLUE,	NORMAL,	BLACK 	> ; 2:0:1 Unprotected
	COLOR <	NORMAL,	RED,	NORMAL,	BLACK  	> ; 2:0:2 Alphanumeric
	COLOR <	NORMAL,	MAGENTA,NORMAL,	BLACK	> ; 2:0:3 Dim
	COLOR <	NORMAL,	GREEN,	NORMAL,	BLACK	> ; 2:0:4
	COLOR <	NORMAL,	CYAN,	NORMAL,	BLACK	> ; 2:0:5
	COLOR <	NORMAL,	YELLOW,	NORMAL,	BLACK	> ; 2:0:6
	COLOR <	NORMAL,	WHITE,	NORMAL,	BLACK	> ; 2:0:7

	COLOR <	NORMAL,	CORE	> ; 3:2:2 Numeric only
	COLOR <	NORMAL,	MAGENTA,NORMAL,	USCORE	> ; 3:2:3 Dim
	COLOR <	NORMAL,	GREEN,	NORMAL,	USCORE	> ; 3:2:4
	COLOR <	NORMAL,	CYAN,	NORMAL,	USCORE	> ; 3:2:5
	COLOR <	NORMAL,	YELLOW,	NORMAL,	USCORE	> ; 3:2:6
	COLOR <	NORMAL,	WHITE,	NORMAL,	USCORE	> ; 3:2:7

	COLOR <	NORMAL,	WHITE,	BRIGHT,	USCORE	> ; 3:3:0 Underscored
	COLOR <	NORMAL,	BLUE,	BRIGHT,	USCORE 	> ; 3:3:1 Unprotected
	COLOR <	NORMAL,	RED,	BRIGHT,	USCORE	> ; 3:3:2 Numeric only
	COLOR <	NORMAL,	MAGENTA,BRIGHT,	USCORE	> ; 3:3:3 Bright
	COLOR <	NORMAL,	GREEN,	BRIGHT,	USCORE	> ; 3:3:4
	COLOR <	NORMAL,	CYAN,	BRIGHT,	USCORE	> ; 3:3:5
	COLOR <	NORMAL,	YELLOW,	BRIGHT,	USCORE	> ; 3:3:6
	COLOR <	NORMAL,	WHITE,	BRIGHT,	USCORE	> ; 3:3:7

	COLOR <	NORMAL,	GREEN,	NORMAL,	USCORE	> ; 3:4:0 Underscored
	COLOR <	NORMAL,	BLUE,	NORMAL,	USCORE 	> ; 3:4:1 Protected
	COLOR <	NORMAL,	RED,	NORMAL,	USCORE	> ; 3:4:2 Alphanumeric
	COLOR <	NORMAL,	MAGENTA,NORMAL,	USCORE	> ; 3:4:3 Dim
	COLOR <	NORMAL,	GREEN,	NORMAL,	USCORE	> ; 3:4:4
	COLOR <	NORMAL,	CYAN,	NORMAL,	USCORE	> ; 3:4:5
	COLOR <	NORMAL,	YELLOW,	NORMAL,	USCORE	> ; 3:4:6
	COLOR <	NORMAL,	WHITE,	NORMAL,	USCORE	> ; 3:4:7

	COLOR <	NORMAL,	WHITE,	BRIGHT,	USCORE	> ; 3:5:0 Underscored
	COLOR <	NORMAL,	BLUE,	BRIGHT,	USCORE 	> ; 3:5:1 Protected
	COLOR <	NORMAL,	RED,	BRIGHT,	USCORE	> ; 3:5:2 Alphanumeric
	COLOR <	NORMAL,	MAGENTA,BRIGHT,	USCORE	> ; 3:5:3 Bright
	COLOR <	NORMAL,	GREEN,	BRIGHT,	USCORE	> ; 3:5:4
	COLOR <	NORMAL,	CYAN,	BRIGHT,	USCORE	> ; 3:5:5
	COLOR <	NORMAL,	YELLOW,	BRIGHT,	USCORE	> ; 3:5:6
	COLOR <	NORMAL,	WHITE,	BRIGHT,	USCORE	> ; 3:5:7

	COLOR <	NORMAL,	GREEN,	NORMAL,	USCORE	> ; 3:6:0 Underscored
	COLOR <	NORMAL,	BLUE,	NORMAL,	USCORE 	> ; 3:6:1 Protected
	COLOR <	NORMAL,	RED,	NORMAL,	USCORE	> ; 3:6:2 Numeric only
	COLOR <	NORMAL,	MAGENTA,NORMAL,	USCORE	> ; 3:6:3 Dim
	COLOR <	NORMAL,	GREEN,	NORMAL,	USCORE	> ; 3:6:4
	COLOR <	NORMAL,	CYAN,	NORMAL,	USCORE	> ; 3:6:5
	COLOR <	NORMAL,	YELLOW,	NORMAL,	USCORE	> ; 3:6:6
	COLOR <	NORMAL,	WHITE,	NORMAL,	USCORE	> ; 3:6:7

	COLOR <	NORMAL,	WHITE,	BRIGHT,	USCORE	> ; 3:7:0 Underscored
	COLOR <	NORMAL,	BLUE,	BRIGHT,	USCORE 	> ; 3:7:1 Protected
	COLOR <	NORMAL,	RED,	BRIGHT,	USCORE	> ; 3:7:2 Numeric only
	COLOR <	NORMAL,	MAGENTA,BRIGHT,	USCORE	> ; 3:7:3 Bright
	COLOR <	NORMAL,	GREEN,	BRIGHT,	USCORE	> ; 3:7:4
	COLOR <	NORMAL,	CYAN,	BRIGHT,	USCORE	> ; 3:7:5
	COLOR <	NORMAL,	YELLOW,	BRIGHT,	USCORE	> ; 3:7:6
	COLOR <	NORMAL,	WHITE,	BRIGHT,	USCORE	> ; 3:7:7
	PAGE
COMMENT	|	COLOR MODE 1 - Two color for monochrome applications
		
	Using this mode with a monochrome display on
	a color adapter will cause unreadable displays.

	This table allows full EAB color as well as
	providing color information for default color
	fields.

	Blink is passed through as normal.

	Intensity is used to select a color in case
	of color monitors which are unable to respond
	to the PCs intensity output.

	Underscored areas are represented by characters
	placed on a BLUE background with the exception
	of BLUE characters which are placed on a GREEN
	background.

	ATTRIBUTE COLOR NUMBERING CONVENTION

a:b:c	a: 0-3 EAB mode	b: 0-7 Attribute mode	c: 0-7 EAB color
	---------------	-----------------------	----------------
	0 - Normal	0 - Unprot alpha dim	0 - Normal (White)
	1 - Blink	1 - Unprot alpha brite	1 - Blue
	2 - Reverse	2 - Unprot numer dim	2 - Red
	3 - Underscore	3 - Unprot numer brite	3 - Magenta
			4 - Protec alpha dim	4 - Green
			5 - Protec alpha brite	5 - Cyan
			6 - Protec numer dim	6 - Yellow
			7 - Protec numer brite	7 - White

	|

	BLACK=	0			; Black is normal
	BLUE=	1			
	GREEN=	2
	CYAN=	3
	RED=	4
	MAGENTA=5
	YELLOW=	6
	WHITE=	7

	NORMAL=	0			; Modifiers are as normal
	BLINK=	1
	BRIGHT=	1

	USCORE=	BLUE
	USCTWO=	GREEN
	PAGE
	COLOR <	NORMAL,	BLACK,	NORMAL,	GREEN	> ; 0:0:0 Normal base colors
	COLOR <	NORMAL,	BLACK,	NORMAL,	BLUE 	> ; 0:0:1 Unprotected
	COLOR <	NORMAL,	BLACK,	NORMAL,	RED  	> ; 0:0:2 Alphanumeric
	COLOR <	NORMAL,	BLACK,	NORMAL,	MAGENTA	> ; 0:0:3 Dim
	COLOR <	NORMAL,	BLACK,	NORMAL,	GREEN	> ; 0:0:4 Normal
	COLOR <	NORMAL,	BLACK,	NORMAL,	CYAN	> ; 0:0:5
	COLOR <	NORMAL,	BLACK,	NORMAL,	YELLOW	> ; 0:0:6
	COLOR <	NORMAL,	BLACK,	NORMAL,	WHITE	> ; 0:0:7

	COLOR <	NORMAL,	BLACK,	BRIGHT,	WHITE   > ; 0:1:0 Normal base colors
	COLOR <	NORMAL,	BLACK,	BRIGHT,	BLUE 	> ; 0:1:1 Unprotected
	COLOR <	NORMAL,	BLACK,	BRIGHT,	RED  	> ; 0:1:2 Alphanumeric
	COLOR <	NORMAL,	BLACK,	BRIGHT,	MAGENTA	> ; 0:1:3 Bright
	COLOR <	NORMAL,	BLACK,	BRIGHT,	GREEN	> ; 0:1:4 Normal
	COLOR <	NORMAL,	BLACK,	BW	> ; 0:2:6
	COLOR <	NORMAL,	BLACK,	NORMAL,	WHITE	> ; 0:2:7

	COLOR <	NORMAL,	BLACK,	BRIGHT,	WHITE	> ; 0:3:0 Normal base colors
	COLOR <	NORMAL,	BLACK,	BRIGHT,	BLUE 	> ; 0:3:1 Unprotected
	COLOR <	NORMAL,	BLACK,	BRIGHT,	RED  	> ; 0:3:2 Numeric only
	COLOR <	NORMAL,	BLACK,	BRIGHT,	MAGENTA	> ; 0:3:3 Bright
	COLOR <	NORMAL,	BLACK,	BRIGHT,	GREEN	> ; 0:3:4 Normal
	COLOR <	NORMAL,	BLACK,	BRIGHT,	CYAN	> ; 0:3:5
	COLOR <	NORMAL,	BLACK,	BRIGHT,	YELLOW	> ; 0:3:6
	COLOR <	NORMAL,	BLACK,	BRIGHT,	WHITE	> ; 0:3:7

	COLOR <	NORMAL,	BLACK,	NORMAL,	GREEN	> ; 0:4:0 Normal base colors
	COLOR <	NORMAL,	BLACK,	NORMAL,	BLUE 	> ; 0:4:1 Protected
	COLOR <	NORMAL,	BLACK,	NORMAL,	RED  	> ; 0:4:2 Alphanumeric
	COLOR <	NORMAL,	BLACK,	NORMAL,	MAGENTA	> ; 0:4:3 Dim
	COLOR <	NORMAL,	BLACK,	NORMAL,	GREEN	> ; 0:4:4 Normal
	COLOR <	NORMAL,	BLACK,	NORMAL,	CYAN	> ; 0:4:5
	COLOR <	NORMAL,	BLACK,	NORMAL,	YELLOW	> ; 0:4:6
	COLOR <	NORMAL,	BLACK,	NORMAL,	WHITE	> ; 0:4:7

	COLOR <	NORMAL,	BLACK,	BRIGHT,	WHITE	> ; 0:5:0 Normal base colors
	COLOR <	NORMAL,	BLACK,	BRIGHT,	BLUE 	> ; 0:5:1 Protected
	COLOR <	NORMAL,	BLACK,	BRIGHT,	RED  	> ; 0:5:2 Alphanumeric
	COLOR <	NORMAL,	BLACK,	BRIGHT,	MAGENTA	> ; 0:5:3 Bright
	COLOR <	NORMAL,	BLACK,	BRIGHT,	GREEN	> ; 0:5:4 Normal
	COLOR <	NORMAL,	BLACK,	BRIGHT,	CYAN	> ; 0:5:5
	COLOR <	NORMAL,	BLACK,	BRIGHT,	YELLOW	> ; 0:5:6
	COLOR <	NORMAL,	BLACK,	BRIGHT,	WHITE	> ; 0:5:7

	COLOR < NORMAL, BLACK,  NORMAL, GREEN   > ; 0:6:0 Normal
	COLOR <	NORMAL,	BLACK,	NORMAL,	BLUE 	> ; 0:6:1 Protected
	COLOR <	NORMAL,	BLACK,	NORMAL,	RED  	> ; 0:6:2 Numeric only
	COLOR <	NORMAL,	BLACK,	NORMAL,	MAGENTA	> ; 0:6:3 Dim
	COLOR <	NORMAL,	BLACK,	NORMAL,	GREEN	> ; 0:6:4 Normal
	COLOR <	NORMAL,	BLACK,	NORMAL,	CYAN	> ; 0:6:5
	COLOR <	NORMAL,	BLACK,	NORMAL,	YELLOW	> ; 0:6:6
	COLOR <	NORMAL,	BLACK,	NORMAL,	WHITE	> ; 0:6:7

	COLOR <	NORMAL,	BLACK,	BRIGHT,	WHITE	> ; 0:7:0 Normal base colors
	COLOR <	NORMAL,	BLACK,	BRIGHT,	BLUE 	> ; 0:7:1 Protected
	COLOR <	NORMAL,	BLACK,	BRIGHT,	RED  	> ; 0:7:2 Numeric only
	COLOR <	NORMAL,	BLACK,	BRIGHT,	MAGENTA	> ; 0:7:3 Bright
	COLOR <	NORMAL,	BLACK,	BRIGHT,	GREEN	> ; 0:7:4 Normal
	COLOR <	NORMAL,	BLACK,	BRIGHT,	CYAN	> ; 0:7:5
	COLOR <	NORMAL,	BLACK,	BRIGHT,	YELLOW	> ; 0:7:6
	COLOR <	NORMAL,	BLACK,	BRIGHT,	WHITE	> ; 0:7:7

	COLOR <	BLINK,	BLACK,	NORMAL,	GREEN	> ; 1:0:0 Normal base colors
	COLOR <	BLINK,	BLACK,	NORMAL,	BLUE 	> ; 1:0:1 Unprotected
	COLOR <	BLINK,	BLACK,	NORMAL,	RED  	> ; 1:0:2 Alphanumeric
	COLOR <	BLINK,	BLACK,	NORMAL,	MAGENTA	> ; 1:0:3 Dim
	COLOR <	BLINK,	BLACK,	NORMAL,	GREEN	> ; 1:0:4 Blink
	COLOR <	BLINK,	BLACK,	NORMAL,	CYAN	> ; 1:0:5
	COLOR <	BLINK,	BLACK,	NORMAL,	YELLOW	> ; 1:0:6
	COLOR <	BLINK,	BLACK,	NORMAL,	WHITE	> ; 1:0:7

	COLOR <	BLINK,	BLACK,	BRIGHT,	WHITE	> ; 1:1:0 Normal base colors
	COLOR <	BLINK,	BLACK,	BRIGHT,	BLUE 	> ; 1:1:1 Unprotected
	COLOR <	BLINK,	BLACK,	BRIGHT,	RED  	> ; 1:1:2 Alphanumeric
	COLOR <	BLINK,	BLACK,	BRIGHT,	MAGENTA	> ; 1:1:3 Bright
	COLOR <	BLINK,	BLACK,	BRIGHT,	GREEN	> ; 1:1:4 Blink
	COLOR <	BLINK,	BLACK,	BRIGHT,	CYAN	> ; 1:1:5
	COLOR <	BLINK,	BLACK,	BRIGHT,	YELLOW	> ; 1:1:6
	COLOR <	BLINK,	BLACK,	BRIGHT,	WHITE	> ; 1:1:7

	COLOR <	BLINK,	BLACK,	NORMAL,	GREEN	> ; 1:2:0 Normal base colors
	COLOR <	BLINK,	BLACK,	NORMAL,	BLUE 	> ; 1:2:1 Unprotected
	COLOR <	BLINK,	BLACK,	NORMAL,	RED  	> ; 1:2:2 Numeric only
	COLOR <	BLINK,	BLACK,	NORMAL,	MAGENTA	> ; 1:2:3 Dim
	COLOR <	BLINK,	BLACK,	NORMAL,	GREEN	> ; 1:2:4 Blink
	COLOR <	BLINK,	BLACK,	NORMAL,	CYAN	> ; 1:2:5
	COLOR <	BLINK,	BLACK,	NORMAL,	YELLOW	> ; 1:2:6
	COLOR <	BLINK,	BLACK,	NORMAL,	WHITE	> ; 1:2:7

	COLOR <	BLINK,	BLACK,	BRIGHT,	WHITE	> ; 1:3:0 Normal base colors
	COLOR <	BLINK,	BLACK,	BRIGHT,	BLUE 	> ; 1:3:1 Unprotected
	COLOR <	BLINK,	BLACK,	BRIGHT,	RED  	> ; 1:3:2 Numeric only
	COLOR <	BLINK,	BLACK,	BRIGHT,	MAGENTA	> ; 1:3:3 Bright
	COLOR <	BLINK,	BLACK,	BRIGHT,	GREEN	> ; 1:3:4 Blink
	COLOR <	BLINK,	BLACK,	BRIGHT,	CYAN	> ; 1:3:5
	COLOR <	BLINK,	BLACK,	BRIGHT,	YELLOW	> ; 1:3:6
	COLOR <	BLINK,	BLACK,	BRIGHT,	WHITE	> ; 1:3:7

	COLOR <	BLRIGHT,	CYAN	> ; 0:1:5
	COLOR <	NORMAL,	BLACK,	BRIGHT,	YELLOW	> ; 0:1:6
	COLOR <	NORMAL,	BLACK,	BRIGHT,	WHITE	> ; 0:1:7

	COLOR <	NORMAL,	BLACK,	NORMAL,	GREEN 	> ; 0:2:0 Normal base colors
	COLOR <	NORMAL,	BLACK,	NORMAL,	BLUE 	> ; 0:2:1 Unprotected
	COLOR <	NORMAL,	BLACK,	NORMAL,	RED  	> ; 0:2:2 Numeric only
	COLOR <	NORMAL,	BLACK,	NORMAL,	MAGENTA	> ; 0:2:3 Dim
	COLOR <	NORMAL,	BLACK,	NORMAL,	GREEN	> ; 0:2:4 Normal
	COLOR <	NORMAL,	BLACK,	NORMAL,	CYAN	> ; 0:2:5
	COLOR <	NORMAL,	BLACK,	NORMAL,	YELLOINK,	BLACK,	NORMAL,	GREEN	> ; 1:4:0 Normal base colors
	COLOR <	BLINK,	BLACK,	NORMAL,	BLUE 	> ; 1:4:1 Protected
	COLOR <	BLINK,	BLACK,	NORMAL,	RED  	> ; 1:4:2 Alphanumeric
	COLOR <	BLINK,	BLACK,	NORMAL,	MAGENTA	> ; 1:4:3 Dim
	COLOR <	BLINK,	BLACK,	NORMAL,	GREEN	> ; 1:4:4 Blink
	COLOR <	BLINK,	BLACK,	NORMAL,	CYAN	> ; 1:4:5
	COLOR <	BLINK,	BLACK,	NORMAL,	YELLOW	> ; 1:4:6
	COLOR <	BLINK,	BLACK,	NORMAL,	WHITE	> ; 1:4:7

	COLOR <	BLINK,	BLACK,	BRIGHT,	WHITE	> ; 1:5:0 Normal base colors
	COLOR <	BLINK,	BLACK,	BRIGHT,	BLUE 	> ; 1:5:1 Protected
	COLOR <	BLINK,	BLACK,	BRIGHT,	RED  	> ; 1:5:2 Alphanumeric
	COLOR <	BLINK,	BLACK,	BRIGHT,	MAGENTA	> ; 1:5:3 Bright
	COLOR <	BLINK,	BLACK,	BRIGHT,	GREEN	> ; 1:5:4 Blink
	COLOR <	BLINK,	BLACK,	BRIGHT,	CYAN	> ; 1:5:5
	COLOR <	BLINK,	BLACK,	BRIGHT,	YELLOW	> ; 1:5:6
	COLOR <	BLINK,	BLACK,	BRIGHT,	WHITE	> ; 1:5:7

	COLOR <	BLINK,	BLACK,	NORMAL,	GREEN	> ; 1:6:0 Normal base colors
	COLOR <	BLINK,	BLACK,	NORMAL,	BLUE 	> ; 1:6:1 Protected
	COLOR <	BLINK,	BLACK,	NORMAL,	RED  	> ; 1:6:2 Numeric only
	COLOR <	BLINK,	BLACK,	NORMAL,	MAGENTA	> ; 1:6:3 Dim
	COLOR <	BLINK,	BLACK,	NORMAL,	GREEN	> ; 1:6:4 Blink
	COLOR <	BLINK,	BLACK,	NORMAL,	CYAN	> ; 1:6:5
	COLOR <	BLINK,	BLACK,	NORMAL,	YELLOW	> ; 1:6:6
	COLOR <	BLINK,	BLACK,	NORMAL,	WHITE	> ; 1:6:7

	COLOR <	BLINK,	BLACK,	BRIGHT,	WHITE	> ; 1:7:0 Normal base colors
	COLOR <	BLINK,	BLACK,	BRIGHT,	BLUE 	> ; 1:7:1 Protected
	COLOR <	BLINK,	BLACK,	BRIGHT,	RED  	> ; 1:7:2 Numeric only
	COLOR <	BLINK,	BLACK,	BRIGHT,	MAGENTA	> ; 1:7:3 Bright
	COLOR <	BLINK,	BLACK,	BRIGHT,	GREEN	> ; 1:7:4 Blink
	COLOR <	BLINK,	BLACK,	BRIGHT,	CYAN	> ; 1:7:5
	COLOR <	BLINK,	BLACK,	BRIGHT,	YELLOW	> ; 1:7:6
	COLOR <	BLINK,	BLACK,	BRIGHT,	WHITE	> ; 1:7:7

	COLOR <	NORMAL,	GREEN,	NORMAL,	BLACK	> ; 2:0:0 Reverse video
	COLOR <	NORMAL,	BLUE,	NORMAL,	BLACK 	> ; 2:0:1 Unprotected
	COLOR <	NORMAL,	RED,	NORMAL,	BLACK  	> ; 2:0:2 Alphanumeric
	COLOR <	NORMAL,	MAGENTA,NORMAL,	BLACK	> ; 2:0:3 Dim
	COLOR <	NORMAL,	GREEN,	NORMAL,	BLACK	> ; 2:0:4
	COLOR <	NORMAL,	CYAN,	NORMAL,	BLACK	> ; 2:0:5
	COLOR <	NORMAL,	YELLOW,	NORMAL,	BLACK	> ; 2:0:6
	COLOR <	NORMAL,	WHITE,	NORMAL,	BLACK	> ; 2:0:7

	COLOR <	NORMAL,	WHITE,	BRIGHT,	BLACK	> ; 2:1:0 Reverse video
	COLOR <	NORMAL,	BLUE,	BRIGHT,	BLACK 	> ; 2:1:1 Unprotected
	COLOR <	NORMAL,	RED,	BRIGHT,	BLACK  	> ; 2:1:2 Alphanumeric
	COLOR <	NORMAL,	MAGENTA,BRIGHT,	BLACK	> ; 2:1:3 Bright
	COLOR <	NORMAL,	GREEN,	BRIGHT,	BLACK	> ; 2:1:4
	COLOR <	NORMAL,	CYAN,	BRIGHT,	BLACK	> ; 2:1:5
	COLOR <	NORMAL,	YELLOW,	BRIGHT,	BLACK	> ; 2:1:6
	COLOR <	NORMAL,	WHITE,	BRIGHT,	BLACK	> ; 2:1:7

	COLOR <	NORMAL,	GREEN,	NORMAL,	BLACK	> ; 2:2:0 Reverse video
	COLOR <	NORMAL,	BLUE,	NORMAL,	BLACK 	> ; 2:2:1 Unprotected
	COLOR <	NORMAL,	RED,	NORMAL,	BLACK  	> ; 2:2:2 Numeric only
	COLOR <	NORMAL,	MAGENTA,NORMAL,	BLACK	> ; 2:2:3 Dim
	COLOR <	NORMAL,	GREEN,	NORMAL,	BLACK	> ; 2:2:4
	COLOR <	NORMAL,	CYAN,	NORMAL,	BLACK	> ; 2:2:5
	COLOR <	NORMAL,	YELLOW,	NORMAL,	BLACK	> ; 2:2:6
	COLOR <	NORMAL,	WHITE,	NORMAL,	BLACK	> ; 2:2:7

	COLOR <	NORMAL,	WHITE,	BRIGHT,	BLACK	> ; 2:3:0 Reverse video
	COLOR <	NORMAL,	BLUE,	BRIGHT,	BLACK 	> ; 2:3:1 Unprotected
	COLOR <	NORMAL,	RED,	BRIGHT,	BLACK  	> ; 2:3:2 Numeric only
	COLOR <	NORMAL,	MAGENTA,BRIGHT,	BLACK	> ; 2:3:3 Bright
	COLOR <	NORMAL,	GREEN,	BRIGHT,	BLACK	> ; 2:3:4
	COLOR <	NORMAL,	CYAN,	BRIGHT,	BLACK	> ; 2:3:5
	COLOR <	NORMAL,	YELLOW,	BRIGHT,	BLACK	> ; 2:3:6
	COLOR <	NORMAL,	WHITE,	BRIGHT,	BLACK	> ; 2:3:7

	COLOR <	NORMAL,	GREEN,	NORMAL,	BLACK	> ; 2:4:0 Reverse video
	COLOR <	NORMAL,	BLUE,	NORMAL,	BLACK 	> ; 2:4:1 Protected
	COLOR <	NORMAL,	RED,	NORMAL,	BLACK  	> ; 2:4:2 Alphanumeric
	COLOR <	NORMAL,	MAGENTA,NORMAL,	BLACK	> ; 2:4:3 Dim
	COLOR <	NORMAL,	GREEN,	NORMAL,	BLACK	> ; 2:4:4
	COLOR <	NORMAL,	CYAN,	NORMAL,	BLACK	> ; 2:4:5
	COLOR <	NORMAL,	YELLOW,	NORMAL,	BLACK	> ; 2:4:6
	COLOR <	NORMAL,	WHITE,	NORMAL,	BLACK	> ; 2:4:7

	COLOR <	NORMAL,	WHITE,	BRIGHT,	BLACK	> ; 2:5:0 Reverse video
	COLOR <	NORMAL,	BLUE,	BRIGHT,	BLACK 	> ; 2:5:1 Protected
	COLOR <	NORMAL,	RED,	BRIGHT,	BLACK  	> ; 2:5:2 Alphanumeric
	COLOR <	NORMAL,	MAGENTA,BRIGHT,	BLACK	> ; 2:5:3 Bright
	COLOR <	NORMAL,	GREEN,	BRIGHT,	BLACK	> ; 2:5:4
	COLOR <	NORMAL,	CYAN,	BRIGHT,	BLACK	> ; 2:5:5
	COLOR <	NORMAL,	YELLOW,	BRIGHT,	BLACK	> ; 2:5:6
	COLOR <	NORMAL,	WHITE,	BRIGHT,	BLACK	> ; 2:5:7

	COLOR <	NORMAL,	GREEN,	NORMAL,	BLACK	> ; 2:6:0 Reverse video
	COLOR <	NORMAL,	BLUE,	NORMAL,	BLACK 	> ; 2:6:1 Protected
	COLOR <	NORMAL,	RED,	NORMAL,	BLACK  	> ; 2:6:2 Numeric only
	COLOR <	NORMAL,	MAGENTA,NORMAL,	BLA <	NORMAL,	CYAN,	BRIGHT,	BLACK	> ; 2:7:5
	COLOR <	NORMAL,	YELLOW,	BRIGHT,	BLACK	> ; 2:7:6
	COLOR <	NORMAL,	WHITE,	BRIGHT,	BLACK	> ; 2:7:7

	COLOR <	NORMAL,	USCORE,	NORMAL,	GREEN	> ; 3:0:0 Underscored
	COLOR <	NORMAL,	USCTWO,	NORMAL,	BLUE 	> ; 3:0:1 Unprotected
	COLOR <	NORMAL,	USCORE,	NORMAL,	RED  	> ; 3:0:2 Alphanumeric
	COLOR <	NORMAL,	USCORE,	NORMAL,	MAGENTA	> ; 3:0:3 Dim
	COLOR <	NORMAL,	USCORE,	NORMAL,	GREEN	> ; 3:0:4 
	COLOR <	NORMAL,	USCORE,	NORMAL,	CYAN	> ; 3:0:5
	COLOR <	NORMAL,	USCORE,	NORMAL,	YELLOW	> ; 3:0:6
	COLOR <	NORMAL,	USCORE,	NORMAL,	WHITE	> ; 3:0:7

	COLOR <	NORMAL,	USCORE,	BRIGHT,	WHITE	> ; 3:1:0 Underscored
	COLOR <	NORMAL,	USCTWO,	BRIGHT,	BLUE 	> ; 3:1:1 Unprotected
	COLOR <	NORMAL,	USCORE,	BRIGHT,	RED  	> ; 3:1:2 Alphanumeric
	COLOR <	NORMAL,	USCORE,	BRIGHT,	MAGENTA	> ; 3:1:3 Bright
	COLOR <	NORMAL,	USCORE,	BRIGHT,	GREEN	> ; 3:1:4 
	COLOR <	NORMAL,	USCORE,	BRIGHT,	CYAN	> ; 3:1:5
	COLOR <	NORMAL,	USCORE,	BRIGHT,	YELLOW	> ; 3:1:6
	COLOR <	NORMAL,	USCORE,	BRIGHT,	WHITE	> ; 3:1:7

	COLOR <	NORMAL,	USCORE,	NORMAL,	GREEN	> ; 3:2:0 Underscored
	COLOR <	NORMAL,	USCTWO,	NORMAL,	BLUE 	> ; 3:2:1 Unprotected
	COLOR <	NORMAL,	USCORE,	NORMAL,	RED  	> ; 3:2:2 Numeric only
	COLOR <	NORMAL,	USCORE,	NORMAL,	MAGENTA	> ; 3:2:3 Dim
	COLOR <	NORMAL,	USCORE,	NORMAL,	GREEN	> ; 3:2:4 
	COLOR <	NORMAL,	USCORE,	NORMAL,	CYAN	> ; 3:2:5
	COLOR <	NORMAL,	USCORE,	NORMAL,	YELLOW	> ; 3:2:6
	COLOR <	NORMAL,	USCORE,	NORMAL,	WHITE	> ; 3:2:7

	COLOR <	NORMAL,	USCORE,	BRIGHT,	WHITE	> ; 3:3:0 Underscored
	COLOR <	NORMAL,	USCTWO,	BRIGHT,	BLUE 	> ; 3:3:1 Unprotected
	COLOR <	NORMAL,	USCORE,	BRIGHT,	RED  	> ; 3:3:2 Numeric only
	COLOR <	NORMAL,	USCORE,	BRIGHT,	MAGENTA	> ; 3:3:3 Bright
	COLOR <	NORMAL,	USCORE,	BRIGHT,	GREEN	> ; 3:3:4 
	COLOR <	NORMAL,	USCORE,	BRIGHT,	CYAN	> ; 3:3:5
	COLOR <	NORMAL,	USCORE,	BRIGHT,	YELLOW	> ; 3:3:6
	COLOR <	NORMAL,	USCORE,	BRIGHT,	WHITE	> ; 3:3:7

	COLOR <	NORMAL,	USCORE,	NORMAL,	GREEN	> ; 3:4:0 Underscored
	COLOR <	NORMAL,	USCTWO,	NORMAL,	BLUE 	> ; 3:4:1 Protected
	COLOR <	NORMAL,	USCORE,	NORMAL,	RED  	> ; 3:4:2 Alphanumeric
	COLOR <	NORMAL,	USCORE,	NORMAL,	MAGENTA	> ; 3:4:3 Dim
	COLOR <	NORMAL,	USCORE,	NORMAL,	GREEN	> ; 3:4:4 
	COLOR <	NORMAL,	USCORE,	NORMAL,	CYAN	> ; 3:4:5
	COLOR <	NORMAL,	USCORE,	NORMAL,	YELLOW	> ; 3:4:6
	COLOR <	NORMAL,	USCORE,	NORMAL,	WHITE	> ; 3:4:7

	COLOR <	NORMAL,	USCORE,	BRIGHT,	WHITE	> ; 3:5:0 Underscored
	COLOR <	NORMAL,	USCTWO,	BRIGHT,	BLUE 	> ; 3:5:1 Protected
	COLOR <	NORMAL,	USCORE,	BRIGHT,	RED  	> ; 3:5:2 Alphanumeric
	COLOR <	NORMAL,	USCORE,	BRIGHT,	MAGENTA	> ; 3:5:3 Bright
	COLOR <	NORMAL,	USCORE,	BRIGHT,	GREEN	> ; 3:5:4 
	COLOR <	NORMAL,	USCORE,	BRIGHT,	CYAN	> ; 3:5:5
	COLOR <	NORMAL,	USCORE,	BRIGHT,	YELLOW	> ; 3:5:6
	COLOR <	NORMAL,	USCORE,	BRIGHT,	WHITE	> ; 3:5:7

	COLOR <	NORMAL,	USCORE,	NORMAL,	GREEN	> ; 3:6:0 Underscored
	COLOR <	NORMAL,	USCTWO,	NORMAL,	BLUE 	> ; 3:6:1 Protected
	COLOR <	NORMAL,	USCORE,	NORMAL,	RED  	> ; 3:6:2 Numeric only
	COLOR <	NORMAL,	USCORE,	NORMAL,	MAGENTA	> ; 3:6:3 Dim
	COLOR <	NORMAL,	USCORE,	NORMAL,	GREEN	> ; 3:6:4 
	COLOR <	NORMAL,	USCORE,	NORMAL,	CYAN	> ; 3:6:5
	COLOR <	NORMAL,	USCORE,	NORMAL,	YELLOW	> ; 3:6:6
	COLOR <	NORMAL,	USCORE,	NORMAL,	WHITE	> ; 3:6:7

	COLOR <	NORMAL,	USCORE,	BRIGHT,	WHITE	> ; 3:7:0 Underscored
	COLOR <	NORMAL,	USCTWO,	BRIGHT,	BLUE 	> ; 3:7:1 Protected
	COLOR <	NORMAL,	USCORE,	BRIGHT,	RED  	> ; 3:7:2 Numeric only
	COLOR <	NORMAL,	USCORE,	BRIGHT,	MAGENTA	> ; 3:7:3 Bright
	COLOR <	NORMAL,	USCORE,	BRIGHT,	GREEN	> ; 3:7:4 
	COLOR <	NORMAL,	USCORE,	BRIGHT,	CYAN	> ; 3:7:5
	COLOR <	NORMAL,	USCORE,	BRIGHT,	YELLOW	> ; 3:7:6
	COLOR <	NORMAL,	USCORE,	BRIGHT,	WHITE	> ; 3:7:7
	PAGE
COMMENT	|	COLOR MODE 2 - Full EAB color, 3279 FOUR COLOR MODE
		
	Using this mode with a monochrome mon tor 
	on a color adapter will produce an un-
	readable display.

	The blink bit is passed through as normal.
	
	The intensity bit is passed through since
	all the colors are supposedly in use.

	Underscored areas are represented by the
	selected color on a BLURE,	BRIGHT,	CYAN	> ; 3:7:5
	COLOR <	NORMAL,	USCORE,	BRIGHT,	YELLOW	> ; 3:7:6
	COLOR <	NORMAL,	USCORE,	BRIGHT,	WHITE	> ; 3:7:7
	PAGE
COMMENT	|	COLOR MODE 2 - Full EAB color, 3279 FOUR COLOR MODE
		
	Using this mode with a monochrome mon tor 
	on a color adapter will produce an un-
	readable display.

	The blink bit is passed through as normal.
	
	The intensity bit is passed through since
	all the colors are supposedly in use.

	Underscored areas are represented by the
	selected color on a BLUE background,
	except for blue characters which are 
	displayed on a green background.

	ATTRIBUTE COLOR NUMBERING CONVENTION

a:b:c	a: 0-3 EAB mode	b: 0-7 Attribute mode	c: 0-7 EAB color
	---------------	-----------------------	----------------
	0 - Normal	0 - Unprot alpha dim	0 - Normal (White)
	1 - Blink	1 - Unprot alpha brite	1 - Blue
	2 - Reverse	2 - Unprot numer dim	2 - Red
	3 - Underscore	3 - Unprot numer brite	3 - Magenta
			4 - Protec alpha dim	4 - Green
			5 - Protec alpha brite	5 - Cyan
			6 - Protec numer dim	6 - Yellow
			7 - Protec numer brite	7 - White

	|

	BLACK=	0
	BLUE=	1			
	GREEN=	2
	CYAN=	3
	RED=	4
	MAGENTA=5
	YELLOW=	6
	WHITE=	7

	NORMAL=	0			; Modifiers are as normal
	BLINK=	1
	BRIGHT=	1

	USCORE=	BLUE
	USCTWO=	GREEN
	PAGE
	COLOR <	NORMAL,	BLACK,	NORMAL,	GREEN	> ; 0:0:0 Normal base colors
	COLOR <	NORMAL,	BLACK,	NORMAL,	BLUE 	> ; 0:0:1 Unprotected
	COLOR <	NORMAL,	BLACK,	NORMAL,	RED  	> ; 0:0:2 Alphanumeric
	COLOR <	NORMAL,	BLACK,	NORMAL,	MAGENTA	> ; 0:0:3 Dim
	COLOR <	NORMAL,	BLACK,	NORMAL,	GREEN	> ; 0:0:4 Normal
	COLOR <	NORMAL,	BLACK,	NORMAL,	CYAN	> ; 0:0:5
	COLOR <	NORMAL,	BLACK,	NORMAL,	YELLOW	> ; 0:0:6
	COLOR <	NORMAL,	BLACK,	NORMAL,	WHITE	> ; 0:0:7

	COLOR <	NORMAL,	BLACK,	BRIGHT,	RED  	> ; 0:1:0 Normal base colors
	COLOR <	NORMAL,	BLACK,	BRIGHT,	BLUE 	> ; 0:1:1 Unprotected
	COLOR <	NORMAL,	BLACK,	BRIGHT,	RED  	> ; 0:1:2 Alphanumeric
	COLOR <	NORMAL,	BLACK,	BRIGHT,	MAGENTA	> ; 0:1:3 Bright
	COLOR <	NORMAL,	BLACK,	BRIGHT,	GREEN	> ; 0:1:4 Normal
	COLOR <	NORMAL,	BLACK,	BRIGHT,	CYAN	> ; 0:1:5
	COLOR <	NORMAL,	BLACK,	BRIGHT,	YELLOW	> ; 0:1:6
	COLOR <	NORMAL,	BLACK,	BRIGHT,	WHITE	> ; 0:1:7

	COLOR <	NORMAL,	BLACK,	NORMAL,	CYAN 	> ; 0:2:0 Normal base colors
	COLOR <	NORMAL,	BLACK,	NORMAL,	BLUE 	> ; 0:2:1 Unprotected
	COLOR <	NORMAL,	BLACK,	NORMAL,	RED  	> ; 0:2:2 Numeric only
	COLOR <	NORMAL,	BLACK,	NORMAL,	MAGENTA	> ; 0:2:3 Dim
	COLOR <	NORMAL,	BLACK,	NORMAL,	GREEN	> ; 0:2:4 Normal
	COLOR <	NORMAL,	BLACK,	NORMAL,	CYAN	> ; 0:2:5
	COLOR <	NORMAL,	BLACK,	NORMAL,	YELLOW	> ; 0:2:6
	COLOR <	NORMAL,	BLACK,	NORMAL,	WHITE	> ; 0:2:7

	COLOR <	NORMAL,	BLACK,	BRIGHT,	RED  	> ; 0:3:0 Normal base colors
	COLOR <	NORMAL,	BLACK,	BRIGHT,	BLUE 	> ; 0:3:1 Unprotected
	COLOR <	NORMAL,	BLACK,	BRIGHT,	RED  	> ; 0:3:2 Numeric only
	COLOR <	NORMAL,	BLACK,	BRIGHT,	MAGENTA	> ; 0:3:3 Bright
	COLOR <	NORMAL,	BLACK,	BRIGHT,	GREEN	> ; 0:3:4 Normal
	COLOR <	NORMAL,	BLACK,	BRIGHT,	CYAN	> ; 0:3:5
	COLOR <	NORMAL,	BLACK,	BRIGHT,	YELLOW	> ; 0:3:6
	COLOR <	NORMAL,	BLACK,	BRIGHT,	WHITE	> ; 0:3:7

	COLOR <	NORMAL,	BLACK,	BRIGHT,	BLUE  	> ; 0:4:0 Normal base colors
	COLOR <	NORMAL,	BLACK,	NORMAL,	BLUE 	> ; 0:4:1 Protected
	COLOR <	NORMAL,	BLACK,	NORMAL,	RED  	> ; 0:4:2 Alphanumeric
	COLOR <	NORMAL,	BLACK,	NORMAL,	MAGENTA	> ; 0:4:3 Dim
	COLOR <	NORMAL,	BLACK,	NORMAL,	GREEN	> ; 0:4:4 Normal
	COLOR <	NORMAL,	BLACK,	NORMAL,	CYAN	> ; 0:4:5
	COLOR <	NORMAL,	BLACK,	NORMAL,	YELLOW	> ; 0:4:6
	COLOR <	NORMAL,	BLACK,	NORMAL,	WHITE	> ; 0:4:7

	COLOR <	NORMAL,	BLACK,	BRIGHT,	WHITE	> ; 0:5:0 Normal base colors
	COLOR <	NORMAL,	BLACK,	BRIGHT,	BLUE 	> ; 0:5:1 Protected
	COLOR <	NORMAL,	BLACK,	BRIGHT,	RED  	> ; 0:5:2 Alphanumeric
	COLOR <	NORMAL,	BLACK,	BRIGHT,	MAGENTA	> ; 0:5:3 Bright
	COLOR <	NORMAL,	BLACK,	BRIGHT,	GREEN	> ; 0:5:4 Normal
	COLOR <	NORMAL,	BLACK,	BRIGHT,	CYAN	> ; 0:5:5
	COLOR <	NORMAL,	BLACK,	BRIGHT,	YELLOW	> ; 0:5:6
	COLOR <	NORMAL,	BLACK,	BRIGHT,	WHITE	> ; 0:5:7

	COLOR <	NORMAL,	BLACK,	BRIGHT,	BLUE  	> ; 0:6:0 Normal base colors
	COLOR <	NORMAL,	BLACK,	NORMAL,	BLUE 	> ; 0:6:1 Protected
	COLOR <	NORMAL,	BLACK,	NORMAL,	RED  	> ; 0:6:2 Numeric only
	COLOR <	NORMAL,	BLACK,	NORMAL,	MAGENTA	> ; 0:6:3 Dim
	COLOR <	NORMAL,	BLACK,	NORMAL,	GREEN	> ; 0:6:4 Normal
	COLOR <	NORMAL,	BLACK,	NORMAL,	CYAN	> ; 0:6:5
	COLOR <	NORMAL,	BLACK,	NORMAL,	YELLOW	> ; 0:6:6
	COLOR <	NORMAL,	BLACK,	NORMAL,	WHITE	> ; 0:6:7

	COLOR <	NORMAL,	BLACK,	BRIGHT,	WHITE	> ; 0:7:0 Normal base colors
	COLOR <	NORMAL,	BLACK,	BRIGHT,	BLUE 	> ; 0:7:1 Protected
	COLOR <	NORMAL,	BLACK,	BRIGHT,	RED  	> ; 0:7:2 Numeric only
	COLOR <	NORMAL,	BLACK,	BRIGHT,	MAGENTA	> ; 0:7:3 Bright
	COLOR <	NORMAL,	BLACK,	BRIGHT,	GREEN	> ; 0:7:4 Normal
	COLOR <	NORMAL,	BLACK,	BRIGHT,	CYAN	> ; 0:7:5
	COLOR <	NORMAL,	BLACK,	BRIGHT,	YELLOW	> ; 0:7:6
	COLOR <	NORMAL,	BLACK,	BRIGHT,	WHITE	> ; 0:7:7

	COLOR <	BLINK,	BLACK,	NORMAL,	GREEN	> ; 1:0:0 Normal base colors
	COLOR <	BLINK,	BLACK,	NORMAL,	BLUE 	> ; 1:0:1 Unprotected
	COLOR <	BLINK,	BLACK,	NORMAL,	RED  	> ; 1:0:2 Alphanumeric
	COLOR <	BLINKHT,	GREEN	> ; 1:1:4 Blink
	COLOR <	BLINK,	BLACK,	BRIGHT,	CYAN	> ; 1:1:5
	COLOR <	BLINK,	BLACK,	BRIGHT,	YELLOW	> ; 1:1:6
	COLOR <	BLINK,	BLACK,	BRIGHT,	WHITE	> ; 1:1:7

	COLOR <	BLINK,	BLACK,	NORMAL,	CYAN 	> ; 1:2:0 Normal base colors
	COLOR <	BLINK,	BLACK,	NORMAL,	BLUE 	> ; 1:2:1 Unprotected
	COLOR <	BLINK,	BLACK,	NORMAL,	RED  	> ; 1:2:2 Numeric only
	COLOR <	BLINK,	BLACK,	NORMAL,	MAGENTA	> ; 1:2:3 Dim
	COLOR <	BLINK,	BLACK,	NORMAL,	GREEN	> ; 1:2:4 Blink
	COLOR <	BLINK,	BLACK,	NORMAL,	CYAN	> ; 1:2:5
	COLOR <	BLINK,	BLACK,	NORMAL,	YELLOW	> ; 1:2:6
	COLOR <	BLINK,	BLACK,	NORMAL,	WHITE	> ; 1:2:7

	COLOR <	BLINK,	BLACK,	BRIGHT,	WHITE	> ; 1:3:0 Normal base colors
	COLOR <	BLINK,	BLACK,	BRIGHT,	BLUE 	> ; 1:3:1 Unprotected
	COLOR <	BLINK,	BLACK,	BRIGHT,	RED  	> ; 1:3:2 Numeric only
	COLOR <	BLINK,	BLACK,	BRIGHT,	MAGENTA	> ; 1:3:3 Bright
	COLOR <	BLINK,	BLACK,	BRIGHT,	GREEN	> ; 1:3:4 Blink
	COLOR <	BLINK,	BLACK,	BRIGHT,	CYAN	> ; 1:3:5
	COLOR <	BLINK,	BLACK,	BRIGHT,	YELLOW	> ; 1:3:6
	COLOR <	BLINK,	BLACK,	BRIGHT,	WHITE	> ; 1:3:7

	COLOR <	BLINK,	BLACK,	BRIGHT,	BLUE  	> ; 1:4:0 Normal base colors
	COLOR <	BLINK,	BLACK,	NORMAL,	BLUE 	> ; 1:4:1 Protected
	COLOR <	BLINK,	BLACK,	NORMAL,	RED  	> ; 1:4:2 Alphanumeric
	COLOR <	BLINK,	BLACK,	NORMAL,	MAGENTA	> ; 1:4:3 Dim
	COLOR <	BLINK,	BLACK,	NORMAL,	GREEN	> ; 1:4:4 Blink
	COLOR <	BLINK,	BLACK,	NORMAL,	CYAN	> ; 1:4:5
	COLOR <	BLINK,	BLACK,	NORMAL,	YELLOW	> ; 1:4:6
	COLOR <	BLINK,	BLACK,	NORMAL,	WHITE	> ; 1:4:7

	COLOR <	BLINK,	BLACK,	BRIGHT,	WHITE	> ; 1:5:0 Normal base colors
	COLOR <	BLINK,	BLACK,	BRIGHT,	BLUE 	> ; 1:5:1 Protected
	COLOR <	BLINK,	BLACK,	BRIGHT,	RED  	> ; 1:5:2 Alphanumeric
	COLOR <	BLINK,	BLACK,	BRIGHT,	MAGENTA	> ; 1:5:3 Bright
	COLOR <	BLINK,	BLACK,	BRIGHT,	GREEN	> ; 1:5:4 Blink
	COLOR <	BLINK,	BLACK,	BRIGHT,	CYAN	> ; 1:5:5
	COLOR <	BLINK,	BLACK,	BRIGHT,	YELLOW	> ; 1:5:6
	COLOR <	BLINK,	BLACK,	BRIGHT,	WHITE	> ; 1:5:7

	COLOR < BLINK,  BLACK,  BRIGHT, BLUE    > ; 1:6:0 Normal
	COLOR <	BLINK,	BLACK,	NORMAL,	BLUE 	> ; 1:6:1 Protected
	COLOR <	BLINK,	BLACK,	NORMAL,	RED  	> ; 1:6:2 Numeric only
	COLOR <	BLINK,	BLACK,	NORMAL,	MAGENTA	> ; 1:6:3 Dim
	COLOR <	BLINK,	BLACK,	NORMAL,	GREEN	> ; 1:6:4 Blink
	COLOR <	BLINK,	BLACK,	NORMAL,	CYAN	> ; 1:6:5
	COLOR <	BLINK,	BLACK,	NORMAL,	YELLOW	> ; 1:6:6
	COLOR <	BLINK,	BLACK,	NORMAL,	WHITE	> ; 1:6:7

	COLOR <	BLINK,	BLACK,	BRIGHT,	WHITE	> ; 1:7:0 Normal base colors
	COLOR <	BLINK,	BLACK,	BRIGHT,	BLUE 	> ; 1:7:1 Protected
	COLOR <	BLINK,	BLACK,	BRIGHT,	RED  	> ; 1:7:2 Numeric only
	COLOR <	BLINK,	BLACK,	BRIGHT,	MAGENTA	> ; 1:7:3 Bright
	COLOR <	BLINK,	BLACK,	BRIGHT,	GREEN	> ; 1:7:4 Blink
	COLOR <	BLINK,	BLACK,	BRIGHT,	CYAN	> ; 1:7:5
	COLOR <	BLINK,	BLACK,	BRIGHT,	YELLOW	> ; 1:7:6
	COLOR <	BLINK,	BLACK,	BRIGHT,	WHITE	> ; 1:7:7

	COLOR <	NORMAL,	GREEN,	NORMAL,	BLACK	> ; 2:0:0 Reverse video
	COLOR <	NORMAL,	BLUE,	NORMAL,	BLACK 	> ; 2:0:1 Unprotected
	COLOR <	NORMAL,	RED,	NORMAL,	BLACK  	> ; 2:0:2 Alphanumeric
	COLOR <	NORMAL,	MAGENTA,NORMAL,	BLACK	> ; 2:0:3 Dim
	COLOR <	NORMAL,	GREEN,	NORMAL,	BLACK	> ; 2:0:4
	COLOR <	NORMAL,	CYAN,	NORMAL,	BLACK	> ; 2:0:5
	COLOR <	NORMAL,	YELLOW,	NORMAL,	BLACK	> ; 2:0:6
	COLOR <	NORMAL,	WHITE,	NORMAL,	BLACK	> ; 2:0:7

	COLOR <	NORMAL,	RED,	BRIGHT,	BLACK	> ; 2:1:0 Reverse video
	COLOR <	NORMAL,	BLUE,	BRIGHT,	BLACK 	> ; 2:1:1 Unprotected
	COLOR <	NORMAL,	RED,	BRIGHT,	BLACK  	> ; 2:1:2 Alphanumeric
	COLOR <	NORMAL,	MAGENTA,BRIGHT,	BLACK	> ; 2:1:3 Bright
	COLOR <	NORMAL,	GREEN,	BRIGHT,	BLACK	> ; 2:1:4
	COLOR <	NORMAL,	CYAN,	BRIGHT,	BLACK	> ; 2:1:5
	COLOR <	NORMAL,	YELLOW,	BRIGHT,	BLACK	> ; 2:1:6
	COLOR <	NORMAL,	WHITE,	BRIGHT,	BLACK	> ; 2:1:7

	COLOR <	NORMAL,	CYAN,	NORMAL,	BLACK	> ; 2:2:0 Reverse video
	COLOR <	NORMAL,	BLUE,	NORMAL,	BLACK 	> ; 2:2:1 Unprotected
	COLOR <	NORMAL,	RED,	NORMAL,	BLACK  	> ; 2:2:2 Numeric only
	COLOR <	NORMAL,	MAGENTA,NORMAL,	BLACK	> ; 2:2:3 Dim
	COLOR <	NORMAL,	GREEN,	NORMAL,	BLACK	> ; 2:2:4
	COLOR <	NORMAL,	CYAN,	NORMAL,	BLACK	> ; 2:2:5
	COLOR <	NORMAL,	YELLOW,	NORMAL,	BLACK	> ; 2:2:6
	COLOR <	NORMA,	BLACK,	NORMAL,	MAGENTA	> ; 1:0:3 Dim
	COLOR <	BLINK,	BLACK,	NORMAL,	GREEN	> ; 1:0:4 Blink
	COLOR <	BLINK,	BLACK,	NORMAL,	CYAN	> ; 1:0:5
	COLOR <	BLINK,	BLACK,	NORMAL,	YELLOW	> ; 1:0:6
	COLOR <	BLINK,	BLACK,	NORMAL,	WHITE	> ; 1:0:7

	COLOR <	BLINK,	BLACK,	BRIGHT,	RED  	> ; 1:1:0 Normal base colors
	COLOR <	BLINK,	BLACK,	BRIGHT,	BLUE 	> ; 1:1:1 Unprotected
	COLOR <	BLINK,	BLACK,	BRIGHT,	RED  	> ; 1:1:2 Alphanumeric
	COLOR <	BLINK,	BLACK,	BRIGHT,	MAGENTA	> ; 1:1:3 Bright
	COLOR <	BLINK,	BLACK,	BRIGL,	WHITE,	NORMAL,	BLACK	> ; 2:2:7

	COLOR <	NORMAL,	RED,	BRIGHT,	BLACK	> ; 2:3:0 Reverse video
	COLOR <	NORMAL,	BLUE,	BRIGHT,	BLACK 	> ; 2:3:1 Unprotected
	COLOR <	NORMAL,	RED,	BRIGHT,	BLACK  	> ; 2:3:2 Numeric only
	COLOR <	NORMAL,	MAGENTA,BRIGHT,	BLACK	> ; 2:3:3 Bright
	COLOR <	NORMAL,	GREEN,	BRIGHT,	BLACK	> ; 2:3:4
	COLOR <	NORMAL,	CYAN,	BRIGHT,	BLACK	> ; 2:3:5
	COLOR <	NORMAL,	YELLOW,	BRIGHT,	BLACK	> ; 2:3:6
	COLOR <	NORMAL,	WHITE,	BRIGHT,	BLACK	> ; 2:3:7

	COLOR <	NORMAL,	BLUE,	BRIGHT,	BLACK	> ; 2:4:0 Reverse video
	COLOR <	NORMAL,	BLUE,	NORMAL,	BLACK 	> ; 2:4:1 Protected
	COLOR <	NORMAL,	RED,	NORMAL,	BLACK  	> ; 2:4:2 Alphanumeric
	COLOR <	NORMAL,	MAGENTA,NORMAL,	BLACK	> ; 2:4:3 Dim
	COLOR <	NORMAL,	GREEN,	NORMAL,	BLACK	> ; 2:4:4
	COLOR <	NORMAL,	CYAN,	NORMAL,	BLACK	> ; 2:4:5
	COLOR <	NORMAL,	YELLOW,	NORMAL,	BLACK	> ; 2:4:6
	COLOR <	NORMAL,	WHITE,	NORMAL,	BLACK	> ; 2:4:7

	COLOR <	NORMAL,	WHITE,	BRIGHT,	BLACK	> ; 2:5:0 Reverse video
	COLOR <	NORMAL,	BLUE,	BRIGHT,	BLACK 	> ; 2:5:1 Protected
	COLOR <	NORMAL,	RED,	BRIGHT,	BLACK  	> ; 2:5:2 Alphanumeric
	COLOR <	NORMAL,	MAGENTA,BRIGHT,	BLACK	> ; 2:5:3 Bright
	COLOR <	NORMAL,	GREEN,	BRIGHT,	BLACK	> ; 2:5:4
	COLOR <	NORMAL,	CYAN,	BRIGHT,	BLACK	> ; 2:5:5
	COLOR <	NORMAL,	YELLOW,	BRIGHT,	BLACK	> ; 2:5:6
	COLOR <	NORMAL,	WHITE,	BRIGHT,	BLACK	> ; 2:5:7

	COLOR <	NORMAL,	BLUE,	BRIGHT,	BLACK	> ; 2:6:0 Reverse video
	COLOR <	NORMAL,	BLUE,	NORMAL,	BLACK 	> ; 2:6:1 Protected
	COLOR <	NORMAL,	RED,	NORMAL,	BLACK  	> ; 2:6:2 Numeric only
	COLOR <	NORMAL,	MAGENTA,NORMAL,	BLACK	> ; 2:6:3 Dim
	COLOR <	NORMAL,	GREEN,	NORMAL,	BLACK	> ; 2:6:4
	COLOR <	NORMAL,	CYAN,	NORMAL,	BLACK	> ; 2:6:5
	COLOR <	NORMAL,	YELLOW,	NORMAL,	BLACK	> ; 2:6:6
	COLOR <	NORMAL,	WHITE,	NORMAL,	BLACK	> ; 2:6:7

	COLOR <	NORMAL,	WHITE,	BRIGHT,	BLACK	> ; 2:7:0 Reverse video
	COLOR <	NORMAL,	BLUE,	BRIGHT,	BLACK 	> ; 2:7:1 Protected
	COLOR <	NORMAL,	RED,	BRIGHT,	BLACK  	> ; 2:7:2 Numeric only
	COLOR <	NORMAL,	MAGENTA,BRIGHT,	BLACK	> ; 2:7:3 Bright
	COLOR <	NORMAL,	GREEN,	BRIGHT,	BLACK	> ; 2:7:4
	COLOR <	NORMAL,	CYAN,	BRIGHT,	BLACK	> ; 2:7:5
	COLOR <	NORMAL,	YELLOW,	BRIGHT,	BLACK	> ; 2:7:6
	COLOR <	NORMAL,	WHITE,	BRIGHT,	BLACK	> ; 2:7:7

	COLOR <	NORMAL,	USCORE,	NORMAL,	GREEN	> ; 3:0:0 Normal base colors
	COLOR <	NORMAL,	USCTWO,	NORMAL,	BLUE 	> ; 3:0:1 Unprotected
	COLOR <	NORMAL,	USCORE,	NORMAL,	RED  	> ; 3:0:2 Alphanumeric
	COLOR <	NORMAL,	USCORE,	NORMAL,	MAGENTA	> ; 3:0:3 Dim
	COLOR <	NORMAL,	USCORE,	NORMAL,	GREEN	> ; 3:0:4 Blink
	COLOR <	NORMAL,	USCORE,	NORMAL,	CYAN	> ; 3:0:5
	COLOR <	NORMAL,	USCORE,	NORMAL,	YELLOW	> ; 3:0:6
	COLOR <	NORMAL,	USCORE,	NORMAL,	WHITE	> ; 3:0:7

	COLOR <	NORMAL,	USCORE,	BRIGHT,	RED  	> ; 3:1:0 Normal base colors
	COLOR <	NORMAL,	USCTWO,	BRIGHT,	BLUE 	> ; 3:1:1 Unprotected
	COLOR <	NORMAL,	USCORE,	BRIGHT,	RED  	> ; 3:1:2 Alphanumeric
	COLOR <	NORMAL,	USCORE,	BRIGHT,	MAGENTA	> ; 3:1:3 Bright
	COLOR <	NORMAL,	USCORE,	BRIGHT,	GREEN	> ; 3:1:4 Blink
	COLOR <	NORMAL,	USCORE,	BRIGHT,	CYAN	> ; 3:1:5
	COLOR <	NORMAL,	USCORE,	BRIGHT,	YELLOW	> ; 3:1:6
	COLOR <	NORMAL,	USCORE,	BRIGHT,	WHITE	> ; 3:1:7

	COLOR <	NORMAL,	USCORE,	NORMAL,	CYAN 	> ; 3:2:0 Normal base colors
	COLOR <	NORMAL,	USCTWO,	NORMAL,	BLUE 	> ; 3:2:1 Unprotected
	COLOR <	NORMAL,	USCORE,	NORMAL,	RED  	> ; 3:2:2 Numeric only
	COLOR <	NORMAL,	USCORE,	NORMAL,	MAGENTA	> ; 3:2:3 Dim
	COLOR <	NORMAL,	USCORE,	NORMAL,	GREEN	> ; 3:2:4 Blink
	COLOR <	NORMAL,	USCORE,	NORMAL,	CYAN	> ; 3:2:5
	COLOR <	NORMAL,	USCORE,	NORMAL,	YELLOW	> ; 3:2:6
	COLOR <	NORMAL,	USCORE,	NORMAL,	WHITE	> ; 3:2:7

	COLOR <	NORMAL,	USCORE,	BRIGHT,	RED  	> ; 3:3:0 Normal base colors
	COLOR <	NORMAL,	USCTWO,	BRIGHT,	BLUE 	> ; 3:3:1 Unprotected
	COLOR <	NORMAL,	USCORE,	BRIGHT,	RED  	> ; 3:3:2 Numeric only
	COLOR <	NORMAL,	USCORE,	BRIGHT,	MAGENTA	> ; 3:3:3 Bright
	COLOR <	NORMAL,	USCORE,	BRIGHT,	GREEN	> ; 3:3:4 Blink
	COLOR <	NORMAL,	USCORE,	BRIGHT,	CYAN	> ; 3:3:5
	COLOR <	NORMAL,	USCORE,	BRIGHT,	YELLOW	> ; 3:3:6
	COLOR <	NORMAL,	USCORE,	BRIGHT,	WHITE	> ; 3:3:7

	COLOR <	NORMAL,	USCORE,	BRIGHT,	BLUE	> ; 3:4:0 Normal base colors
	COLOR <	NORMAL,	USCTWO,	NORMAL,	BLUE 	> ; 3:4:1 Protected
	COLOR <	NORMAL,	USCORE,	NORMAL,	RED  	> ; 3:4:2 Alphanumeric
	COLOR <	NORMAL,	USCORE,	NORMAL,	MAGENTA	> ; 3:4:3 Dim
	COLOR <	NORMAL,	USCORE,	NORMAL,	GREEN	> ; 3:4:4 Blink
	COLOR <	NORMAL,	USCORE,	NORMAL,	CYAN	> ; 3:4:5
	COLOR <	NORMAL,	USCORE,	NORMAL,	YELLOW	> ; 3:4:6
	COLOR <	NORMAL,	USCORE,	NORMAL,	WHITE	> ; 3:4:7

	COLOR <	NORMAL,	USCORE,	BRIGHT,	WHITE	> ; 3:5:0 Normal base colors
	COLOR <	NORMAL,	USCTWL,	USCORE,	NORMAL,	RED  	> ; 3:6:2 Numeric only
	COLOR <	NORMAL,	USCORE,	NORMAL,	MAGENTA	> ; 3:6:3 Dim
	COLOR <	NORMAL,	USCORE,	NORMAL,	GREEN	> ; 3:6:4 Blink
	COLOR <	NORMAL,	USCORE,	NORMAL,	CYAN	> ; 3:6:5
	COLOR <	NORMAL,	USCORE,	NORMAL,	YELLOW	> ; 3:6:6
	COLOR <	NORMAL,	USCORE,	NORMAL,	WHITE	> ; 3:6:7

	COLOR <	NORMAL,	USCORE,	BRIGHT,	WHITE	> ; 3:7:0 Normal base colors
	COLOR <	NORMAL,	USCTWO,	BRIGHT,	BLUE 	> ; 3:7:1 Protected
	COLOR <	NORMAL,	USCORE,	BRIGHT,	RED  	> ; 3:7:2 Numeric only
	COLOR <	NORMAL,	USCORE,	BRIGHT,	MAGENTA	> ; 3:7:3 Bright
	COLOR <	NORMAL,	USCORE,	BRIGHT,	GREEN	> ; 3:7:4 Blink
	COLOR <	NORMAL,	USCORE,	BRIGHT,	CYAN	> ; 3:7:5
	COLOR <	NORMAL,	USCORE,	BRIGHT,	YELLOW	> ; 3:7:6
	COLOR <	NORMAL,	USCORE,	BRIGHT,	WHITE	> ; 3:7:7
	PAGE
COMMENT	|	MONOCHROME DISPLAY ADAPTER MODE 3
		
	All colors are equivalenced to white to make
	monochrome adapters happy.

	ATTRIBUTE COLOR NUMBERING CONVENTION

a:b:c	a: 0-3 EAB mode	b: 0-7 Attribute mode	c: 0 EAB color
	---------------	-----------------------	----------------
	0 - Normal	0 - Unprot alpha dim	0 - Normal (White)
	1 - Blink	1 - Unprot alpha brite	
	2 - Reverse	2 - Unprot numer dim	
	3 - Underscore	3 - Unprot numer brite	
			4 - Protec alpha dim	
			5 - Protec alpha brite	
			6 - Protec numer dim	
			7 - Protec numer brite	

	|

	BLACK=	0			; Black is normal
	WHITE=	7

	NORMAL=	0			; Modifiers are as normal
	BLINK=	1
	BRIGHT=	1

	USCORE=	1

	PAGE
	COLOR <	NORMAL,	BLACK,	NORMAL,	WHITE	> ; 0:0:0 Normal base colors
	COLOR <	NORMAL,	BLACK,	BRIGHT,	WHITE	> ; 0:1:0 
	COLOR <	NORMAL,	BLACK,	NORMAL,	WHITE	> ; 0:2:0 
	COLOR <	NORMAL,	BLACK,	BRIGHT,	WHITE	> ; 0:3:0 
	COLOR <	NORMAL,	BLACK,	NORMAL,	WHITE	> ; 0:4:0 
	COLOR <	NORMAL,	BLACK,	BRIGHT,	WHITE	> ; 0:5:0 
	COLOR <	NORMAL,	BLACK,	NORMAL,	WHITE	> ; 0:6:0 
	COLOR <	NORMAL,	BLACK,	BRIGHT,	WHITE	> ; 0:7:0 

	COLOR <	BLINK,	BLACK,	NORMAL,	WHITE	> ; 1:0:0 Blinking
	COLOR <	BLINK,	BLACK,	BRIGHT,	WHITE	> ; 1:1:0 
	COLOR <	BLINK,	BLACK,	NORMAL,	WHITE	> ; 1:2:0 
	COLOR <	BLINK,	BLACK,	BRIGHT,	WHITE	> ; 1:3:0 
	COLOR <	BLINK,	BLACK,	NORMAL,	WHITE	> ; 1:4:0 
	COLOR <	BLINK,	BLACK,	BRIGHT,	WHITE	> ; 1:5:0 
	COLOR <	BLINK,	BLACK,	NORMAL,	WHITE	> ; 1:6:0 
	COLOR <	BLINK,	BLACK,	BRIGHT,	WHITE	> ; 1:7:0 

	COLOR <	NORMAL,	WHITE,	NORMAL,	BLACK	> ; 2:0:0 Reverse video
	COLOR <	NORMAL,	WHITE,	BRIGHT,	BLACK	> ; 2:1:0 
	COLOR <	NORMAL,	WHITE,	NORMAL,	BLACK	> ; 2:2:0 
	COLOR <	NORMAL,	WHITE,	BRIGHT,	BLACK	> ; 2:3:0 
	COLOR <	NORMAL,	WHITE,	NORMAL,	BLACK	> ; 2:4:0 
	COLOR <	NORMAL,	WHITE,	BRIGHT,	BLACK	> ; 2:5:0 
	COLOR <	NORMAL,	WHITE,	NORMAL,	BLACK	> ; 2:6:0 
	COLOR <	NORMAL,	WHITE,	BRIGHT,	BLACK	> ; 2:7:0 

	COLOR <	NORMAL,	BLACK,	NORMAL,	USCORE	> ; 3:0:0 Underscored
	COLOR <	NORMAL,	BLACK,	BRIGHT,	USCORE	> ; 3:1:0 
	COLOR <	NORMAL,	BLACK,	NORMAL,	USCORE	> ; 3:2:0 
	COLOR <	NORMAL,	BLACK,	BRIGHT,	USCORE	> ; 3:3:0 
	COLOR <	NORMAL,	BLACK,	NORMAL,	USCORE	> ; 3:4:0 
	COLOR <	NORMAL,	BLACK,	BRIGHT,	USCORE	> ; 3:5:0 
	COLOR <	NORMAL,	BLACK,	NORMAL,	USCORE	> ; 3:6:0 
	COLOR <	NORMAL,	BLACK,	BRIGHT,	USCORE	> ; 3:7:0 

DATA	ENDS

	END
DR      COM           KYI  DR      HLP           K^k  2COL    EXE           nQ
ea  DCA     TRF           ф
l  REVR    EXE           Z<
n?  8XSUPERBEXE           k" r  PH      BAT           hA
{!   TROL    EXE           Z|n  PR      EXE           rF
b  SBLD    EXE           VIR
  SHOWDEV EXE           @S)
 P  SBLD    HLP           HR
G4   3:6:0 
	COLOR <	NORMAL,	BLACK,	BRIGHT,	USCORE	> ; 3:7:0 

DATA	ENDS

	END
