                                                          
/* readrtv.c - Read RT-11 volume info */
/* Copyright 1994 Syndesis Corporation, by John Foust <jfoust@threedee.com> */
/* March 17, 1998 */

#include <stdio.h>
#include <string.h>

#include "diskdecl.h"

#include "rt11decl.h"
#include "rt11vars.h"


/* Read in a rtDirRoot struct, the volume info */

USHORT readRT11VolInfo( FILE *infp, rtDirRoot *root )
{
USHORT lerr;
rtFileEntry *ptr;
short each;


    /* Read the volume info into dirRoot, from block 6 and 7 of the disk */
    fseek( infp, (long) RT11_BLK_SIZE * 6, SEEK_SET );

    /* Read the volume info */
    if ((lerr=getShort( infp, &root->segsAvailable )) != TE_NOERROR) {
        goto out;
    }
    if ((lerr=getShort( infp, &root->nextSegment )) != TE_NOERROR) {
        goto out;
    }
    if ((lerr=getShort( infp, &root->highSegment )) != TE_NOERROR) {
        goto out;
    }
    if ((lerr=getShort( infp, &root->filler )) != TE_NOERROR) {
        goto out;
    }
    if ((lerr=getShort( infp, &root->beginSegment )) != TE_NOERROR) {
        goto out;
    }

    ptr = root->files;
    for (each=0; each<RT_NUM_FILES; each++) {

        if ((lerr=getShort( infp, &ptr->status )) != TE_NOERROR) {
            goto out;
        }
        if ((lerr=getShort( infp, &ptr->name[0] )) != TE_NOERROR) {
            goto out;
        }
        if ((lerr=getShort( infp, &ptr->name[1] )) != TE_NOERROR) {
            goto out;
        }
        if ((lerr=getShort( infp, &ptr->name[2] )) != TE_NOERROR) {
            goto out;
        }
        if ((lerr=getShort( infp, &ptr->length )) != TE_NOERROR) {
            goto out;
        }
        if ((lerr=getShort( infp, &ptr->filler )) != TE_NOERROR) {
            goto out;
        }
        if ((lerr=getShort( infp, &ptr->date )) != TE_NOERROR) {
            goto out;
        }

        ptr ++;
    }

    lerr = TE_NOERROR;
out:
    return lerr;
} 

