/* string.h */
#define size_t unsigned int
#define _MAXSTRING 65535

extern void *memchr(void *s, int c, size_t n);

#undef memcmp
extern int memcmp(const void *s1, const void *s2, size_t n);
#define memcmp(s1, s2, n) (_compare(s1, s2, n))

/* #undef memcpy */
extern void *memcpy(void *s1, const void *s2, size_t n);
/* #define memcpy(s1, s2, size) (_move(s2, s1, size), s1) */

/* #undef memset */
extern void *memset(void *s, int c, size_t n);
/* #define memset(s, c, n) (_fill_char(s, n, c), s) */

#undef strcat
extern char *strcat(char *s1, const char *s2);
#define strcat(s1, s2) \
  (_move(s2, ((char *)s1)+_find_char(s1, _MAXSTRING, 0), _find_char(s2,_MAXSTRING,0)+1), s1)

extern char *strchr(char *s, int c);

#undef strcmp
extern int strcmp(const char *s1, const char *s2);
#define strcmp(s1, s2) (strncmp(s1,s2,_MAXSTRING))

#undef strcpy
extern char *strcpy(char *s1, const char *s2);
#define strcpy(s1, s2) (_move(s2, s1, _find_char(s2, _MAXSTRING, 0)+1), s1)

extern size_t strcspn(char *s1, char *s2);

#undef strlen
extern size_t strlen(const char *s);
#define strlen(s) (_find_char(s, _MAXSTRING, 0))

extern char *strncat(char *s1, const char*s2, size_t n);

extern int strncmp(const char *s1, const char *s2, size_t n);

extern char *strncpy(char *s1, const char *s2, size_t n);

extern char *strpbrk(const char *s1, const char *s2);

extern char *strrchr(char *s, int c);

extern size_t strspn(const char *s1, const char *s2);

extern char *strtok(char *s1, const char *s2);

extern char *_cat_many(size_t n, char *s1, const char *s2, ...);

#undef _rmemcpy
extern void *_rmemcpy(void *dest, const void *source, size_t n);
#define _rmemcpy(dest, source, size) (_move_right(source, dest, size), dest)

#undef _rstrcpy
extern char *_rstrcpy(char *dest, const char *source);
#define _rstrcpy(dest, source) \
   (_move_right(source, dest, _find_char(source, _MAXSTRING, 0)+1), dest)

extern char *_rstrncpy(char *dest, const char *source, size_t n);

extern char *_strncat(char *s1, const char*s2, size_t n);
