/*****************************  MODULE HEADER  *******************************/
/*                                                                           */
/*                                                                           */
/*  MACHINE:                LANGUAGE:  Metaware C            OS: CTOS        */
/*                                                                           */
/*  seq_access.h                                                             */
/*                                                                           */
/*  CTOS procedural interfaces to the Sequential Access service.             */
/*                                                                           */
/*  HISTORY:                                                                 */
/*  --------                                                                 */
/*                                                                           */
/*  MM/DD/YY  VVVV/MM  PROGRAMMER    /  DESCRIPTION                          */
/*                                                                           */
/*  03/28/91  121H.03  P. Johansson  /  Correction to SeqAccessVersion.      */
/*  03/04/91  121G.02  P. Johansson  /  Medium density codes.                */
/*  02/01/91  121F.01  P. Johansson  /  SeqAccessDiscardBufferData added.    */
/*  11/30/90  121E.00  P. Johansson  /  Created.                             */
/*                                                                           */
/*                    PROPRIETARY  PROGRAM  MATERIAL                         */
/*                                                                           */
/*  THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO         */
/*  BE REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM       */
/*  LICENSE OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF          */
/*  UNISYS CORPORATION, DETROIT, MICHIGAN 48232, USA.                        */
/*                                                                           */
/*  COPYRIGHT (C) 1990 UNISYS CORPORATION. ALL RIGHTS RESERVED               */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*  UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE         */
/*  AND RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION. HOWEVER,  */
/*  NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY       */
/*  CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS     */
/*  OF PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO     */
/*  WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                */
/*                                                                           */
/*  THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE     */
/*  WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE       */
/*  JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                          */
/*                                                                           */
/**************************  END OF MODULE HEADER  ***************************/

extern word SeqAccessCheckpoint(word seq_handle, pointer residual);

extern word SeqAccessClose(word seq_handle);

extern word SeqAccessControl(word seq_handle, word ctrl_function,
                             integer ctrl_qualifier, pointer residual);

extern word SeqAccessDiscardBufferData(word seq_handle);

extern word SeqAccessModeQuery(word seq_handle, pointer mode_parameters_ret,
                               word mode_parameters_max);

extern word SeqAccessModeSet(word seq_handle, pointer mode_parameters,
                             word mode_parameters_len);

extern word SeqAccessOpen(pointer seq_handle_ret, pointer device_name,
                          word device_name_len, pointer password,
                          word password_len, word access_mode,
                          pointer mode_parameters,
                          word mode_parameters_len);

extern word SeqAccessRead(word seq_handle, pointer data_ret, word data_max,
                          pointer residual);

extern word SeqAccessRecoverBufferData(word seq_handle, pointer data_ret,
                                       word data_max, pointer residual);

extern word SeqAccessStatus(word seq_handle, pointer status_ret,
                            word status_max, pointer residual);

extern word SeqAccessVersion(pointer device_name, word device_name_len,
                             pointer version_info_ret, word version_info_max);

extern word SeqAccessWrite(word seq_handle, pointer data, word data,
                           pointer residual);

/*-----------------------------------------------------------------------------
 Data structure (and other) definitions for the Sequential Access service. */

#define MODE_READ 0x6D72	/* Modes for SeqAccessOpen */
#define MODE_MODIFY 0x6D6D

#define CTRL_REWIND 1		/* Control functions for SeqAccessControl */
#define CTRL_UNLOAD 2
#define CTRL_RETENSION 3
#define CTRL_ERASE_MEDIUM 4
#define CTRL_WRITE_FILEMARK 5
#define CTRL_SCAN_FILEMARK 6
#define CTRL_SPACE_RECORD 7
#define CTRL_ERASE_GAP 8

#define SYNCHRONIZE 0		/* Control qualifiers (wait until done...) */
#define IMMEDIATE 0xFFFF	/* (...or buffered mode) */

#define SEQ_RESET 0x0080	/* Status word bit assignments */
#define SEQ_ON_LINE 0x0040
#define SEQ_BOM 0x0020
#define SEQ_EOM 0x0010
#define SEQ_READY 0x0008
#define SEQ_BUSY 0x0004
#define SEQ_WRITE_PROTECT 0x0002

/*-----------------------------------------------------------------------------
 The version information returned by the Sequential Access service is
 structured as shown below. */

#define MAX_SEQ_DEVICES 8

typedef struct {
   word version;
   word revision;
   word subrevision;
   word devices;
   char version_text[65];
   char node[MAX_NODE_LENGTH + 1];
   char device[MAX_SEQ_DEVICES][MAX_DEVICE_LENGTH + 1];
} version_info_type;

typedef struct {		/* Mode parameters used by SeqAccessOpen,   */
   Boolean write_protected;	/*  SeqAccessModeQuery and SeqAccessModeSet */
   Boolean variable_length;
   Boolean unbuffered;
   Boolean suppress_default_mode_on_open;
   unsigned speed;
   unsigned density;
   unsigned long total_blocks;
   unsigned long block_size;
   unsigned min_record_size;
   unsigned long max_record_size;
   unsigned long device_buffer_size;
   unsigned long service_buffer_pool_size;
   unsigned service_buffers;
   unsigned service_buffer_size;
   unsigned long write_buffer_threshold;
   unsigned long read_buffer_threshold;
   Boolean data_buffer_nonrecoverable;
   Boolean disable_automatic_velocity;
   Boolean buffer_recovery_LIFO;
   Boolean checkpoint_EOM;
   Boolean data_compression;
   char gap_size;
   unsigned long buffer_size_EOM;
   Boolean report_soft_errors;
   Boolean disable_error_correction;
   Boolean disable_read_retries;
   Boolean disable_write_retries;
   unsigned read_retry_limit;
   unsigned write_retry_limit;
} seq_parameters_type;

#define NRZI_800 0x01		/* 1/2" reel-to-reel 800bpi NRZI */
#define PE_1600 0x02		/* 1/2" reel-to-reel 1600bpi PE */
#define GCR_6250 0x03		/* 1/2" reel-to-reel 6250bpi GCR */
#define QIC_11 0x04		/* Quarter-inch cartridge 8000bpi GCR */
#define QIC_24 0x05		/* Quarter-inch cartridge 8000bpi GCR */
#define PE_3200 0x06		/* 1/2" reel-to-reel 3200bpi PE */
#define HI_TC1 0x0C		/* 1/2" cartridge 12690bpi GCR */
#define HI_TC2 0x0D		/* 1/2" cartridge 25380bpi GCR */
#define QIC_120 0x0F		/* Quarter-inch cartridge 10000bpi GCR */
#define QIC_150 0x10		/* Quarter-inch cartridge 10000bpi GCR */
#define QIC_320 0x11		/* Quarter-inch cartridge 16000bpi GCR */
#define QIC_1350 0x12		/* Quarter-inch cartridge 51667bpi RLL */
#define DDS 0x13		/* Digital Data Storage 61000bpi DDS */
