/*****************************  MODULE HEADER  *******************************/
/*                                                                           */
/*                                                                           */
/*  MACHINE:                LANGUAGE:  Metaware C            OS: CTOS        */
/*                                                                           */
/*  archive_msgs.h                                                           */
/*                                                                           */
/*  HISTORY:                                                                 */
/*  --------                                                                 */
/*                                                                           */
/*  MM/DD/YY  VVVV/MM  PROGRAMMER    /  DESCRIPTION                          */
/*                                                                           */
/*  07/10/92  122K.12  D. Gilson     /  P15511893 Suppress Confirm msg should*/
/*                                      not be tied to non-interactive       */
/*  07/07/92  122J.11  D. Gilson     /  Added new msg for invalid dev spec.  */
/*                                      NLS_DEVICE_INVALID_2 PLE 15591773    */
/*  10/07/91  130D.10  D. Gilson     /  Added NLS_INVALID_TAPE_MARK_SPEC     */
/*  08/22/91  130B.09  W. Chiu       /  Added NLS_REPLACE 32499              */
/*  08/05/91  130A.08  P. Johansson  /  New message for service buffer too   */
/*                                      small.                               */
/*  07/15/91  122A.07  P. Johansson  /  New message for '[Overwrite ok?]'.   */
/*  05/10/91  121J.06  P. Johansson  /  Additional summary messages for      */
/*                                      Volume Archive and Restore Archive.  */
/*  05/01/91  121J.05  P. Johansson  /  "Processing file header n of N ... " */
/*  04/18/91  121J.04  P. Johansson  /  Buffer parameters for configuration  */
/*                                      file.                                */
/*  03/24/91  121H.03  P. Johansson  /  Additional messages.                 */
/*  02/05/91  121G.02  P. Johansson  /  Additional messages.                 */
/*  01/23/91  121F.01  P. Johansson  /  Additional messages.                 */
/*  12/13/90  121E.00  P. Johansson  /  Created.                             */
/*                                                                           */
/*                    PROPRIETARY  PROGRAM  MATERIAL                         */
/*                                                                           */
/*  THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO         */
/*  BE REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM       */
/*  LICENSE OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF          */
/*  UNISYS CORPORATION, DETROIT, MICHIGAN 48232, USA.                        */
/*                                                                           */
/*  COPYRIGHT (C) 1990 UNISYS CORPORATION. ALL RIGHTS RESERVED               */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*  UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE         */
/*  AND RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION. HOWEVER,  */
/*  NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY       */
/*  CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS     */
/*  OF PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO     */
/*  WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                */
/*                                                                           */
/*  THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE     */
/*  WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE       */
/*  JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                          */
/*                                                                           */
/**************************  END OF MODULE HEADER  ***************************/

/*-----------------------------------------------------------------------------
 Message codes and the default file name from which to retrieve them are
 defined below.  An array of message descriptors that maps the message number
 to a pointer to the message and its length is kept by the Sequential Access
 service. */

#define LINES_PER_PAGE 66
#define ERC_MSG_FILE "[Sys]<Sys>ErcMsg.Bin"
#define MSG_FILE "[Sys]<Sys>VolUtilMsg.Bin"
#define default_msg(INDEX, TEXT) INDEX, TEXT, last(TEXT)

typedef struct {
   unsigned msg_num;
   char *msg;
   unsigned msg_len;
} msg_descriptor_type;

#define NLS_COMMAND_VERSION 34000
#define NLS_VOLUME 34001
#define NLS_PASSWORD 34002
#define NLS_ARCHIVE_AFTER_DATE 34003
#define NLS_SUPPRESS_ARCHIVE 34004
#define NLS_SUPPRESS_VERIFY 34005
#define NLS_ARCHIVE_DATASET 34006
#define NLS_DELETE_EXISTING 34007
#define NLS_LOG_FILE 34008
#define NLS_DISPLAY_STRUCTURES 34009
#define NLS_VERIFY 34010
#define NLS_NONINTERACTIVE 34011
#define NLS_FILE_LIST 34012
#define NLS_CONFIRM 34013
#define NLS_FILE_LIST_FROM 34014
#define NLS_FILE_LIST_TO 34015
#define NLS_OVERWRITE_OK 34016
#define NLS_ARCHIVE_SEQUENCE 34017
#define NLS_MERGE_WITH_EXISTING_FILE 34018
#define NLS_LIST_FILES_ONLY 34019
#define NLS_SUPPRESS_CONFIRMATION_MSG 34020

#define NLS_CASE_INVALID 34030
#define NLS_RGPARAM_ERROR 34031
#define NLS_WRONG_NUMBER_ARGUMENTS 34032
#define NLS_SYNTAX_ERROR 34033
#define NLS_FILE_SPEC_INVALID 34034
#define NLS_NODE_INVALID 34035
#define NLS_VOLUME_INVALID 34036
#define NLS_DIRECTORY_INVALID 34037
#define NLS_FILENAME_INVALID 34038
#define NLS_PASSWORD_INVALID 34039
#define NLS_DATE_TIME_INVALID 34040
#define NLS_YEAR_INVALID 34041
#define NLS_YES_OR_NO_EXPECTED 34042
#define NLS_NUMBER_INVALID 34043

#define NLS_SEQ_DEVICE_PARAMETERS 34050
#define NLS_MIN_RECORD_SIZE 34051
#define NLS_MAX_RECORD_SIZE 34052
#define NLS_BLOCK_SIZE 34053
#define NLS_DENSITY 34054
#define NLS_SPEED 34055
#define NLS_UNBUFFERED 34056
#define NLS_ERASE_ON_CLOSE 34057
#define NLS_REWIND_ON_CLOSE 34058

#define NLS_SEQ_CONFIG_FILE 34060
#define NLS_MIN_RECORD_SIZE_FIELD 34061
#define NLS_MAX_RECORD_SIZE_FIELD 34062
#define NLS_BLOCK_SIZE_FIELD 34063
#define NLS_DENSITY_FIELD 34064
#define NLS_SPEED_FIELD 34065
#define NLS_UNBUFFERED_FIELD 34066
#define NLS_ERASE_ON_CLOSE_FIELD 34067
#define NLS_REWIND_ON_CLOSE_FIELD 34068

#define NLS_DONE 34070
#define NLS_NEWLINE 34071
#define NLS_VID 34072
#define NLS_CLEAR_VID1 34073
#define NLS_PROCESSING_FILE_N 34074
#define NLS_PROCESSING_FILE_N_OF 34075
#define NLS_PROMPT 34076
#define NLS_PROCESSING_FILE_HEADER_N_OF 34077

#define NLS_CANT_OPEN_LOG_FILE 34080
#define NLS_PAGE_HEADER 34081
#define NLS_DATE_TIME 34082

#define NLS_ARCHIVE_SUFFIX 34090
#define NLS_MOUNT_ARCHIVE_DISK 34091
#define NLS_ARCHIVE_FILE_EXISTS 34092
#define NLS_CREATING_ARCHIVE 34093
#define NLS_DISK_FULL 34094
#define NLS_CANT_CREATE_ARCHIVE_DATASET 34095
#define NLS_ARCHIVE_DATASET_EXISTS 34096
#define NLS_CANT_OPEN_ARCHIVE_DATASET 34097

#define NLS_NEED_SEQ_ACCESS_SERVICE 34100
#define NLS_DEFAULT_DATASET 34101
#define NLS_DEFAULT_FLOPPY 34102
#define NLS_OLD_BACKUP_BOV 34103
#define NLS_OLD_BACKUP_EOV 34104
#define NLS_OLD_BACKUP_EOD 34105
#define NLS_ARCHIVE_BOV 34106
#define NLS_ARCHIVE_EOV 34107
#define NLS_ARCHIVE_EOD 34108
#define NLS_OEM_TEXT 34109
#define NLS_DEVICE_INVALID 34110
#define NLS_APPEND_INVALID 34111
#define NLS_DEVICE_IN_USE 34112
#define NLS_WRITE_PROTECTED 34113
#define NLS_DEVICE_NOT_READY 34114
#define NLS_MEDIUM_FULL 34115
#define NLS_POSITIONING_ERROR 34116
#define NLS_REQUEST_INTERVENTION 34117
#define NLS_RETENSIONING 34118
#define NLS_CONFIRM_ERASE_OLD_FORMAT 34119
#define NLS_CONFIRM_ERASE 34120
#define NLS_ERASING 34121
#define NLS_OLD_FORMAT_DATASET_EXISTS 34122
#define NLS_ARCHIVE_SEQ_DATASET_EXISTS 34123
#define NLS_MOUNT_ARCHIVE_TAPE 34124
#define NLS_NO_ARCHIVE_LABEL 34125
#define NLS_ARCHIVE_SEQUENCE_ERROR 34126
#define NLS_RESTORING_FROM_OLD_FORMAT 34127
#define NLS_RESTORING_FROM 34128
#define NLS_REWINDING 34129

#define NLS_NO_BIT_MAP 34130
#define NLS_NO_MFD 34131
#define NLS_NO_FILE_HEADERS 34132
#define NLS_VHB_IO_ERROR 34133
#define NLS_NO_INITIAL_VHB 34134
#define NLS_INVALID_INITIAL_VHB 34135
#define NLS_INVALID_WORKING_VHB 34136
#define NLS_VHB_HEADER 34137
#define NLS_BAD_BLOCK_IO_ERROR 34138

#define NLS_CANT_VERIFY_BIT_MAP 34140
#define NLS_BIT_MAP_TOO_SMALL 34141
#define NLS_BIT_MAP_IO_ERROR 34142
#define NLS_ZERO_LENGTH_RUN 34143
#define NLS_RUN_EXCEEDS_EOM 34144
#define NLS_DUPLICATE_ALLOCATION 34145
#define NLS_PAGE_NOT_IN_BIT_MAP 34146
#define NLS_PAGE_IN_LIMBO 34147
#define NLS_FREE_PAGES 34148
#define NLS_FREE_PAGES_DISAGREEMENT 34149

#define NLS_PRIMARY_FHB_IO_ERROR 34160
#define NLS_NO_ALTERNATE_FHB 34161
#define NLS_ALTERNATE_FHB_IO_ERROR 34162
#define NLS_FHB_DISAGREEMENT 34163
#define NLS_PRIMARY_FHB_INVALID 34164
#define NLS_ALTERNATE_FHB_INVALID 34165
#define NLS_EXT_FHB_CHAIN_BROKEN 34166
#define NLS_NO_DIRECTORY_ENTRY_FOR_FHB 34167
#define NLS_CHECKSUM_ERROR 34168
#define NLS_FHB_PAGE_ERROR 34169
#define NLS_FHB_SEQ_ERROR 34170
#define NLS_EXT_FHB_NO_RUNS 34171
#define NLS_FHB_NOT_FULL 34172
#define NLS_FILENAME_ERROR 34173
#define NLS_DIRECTORY_ERROR 34174
#define NLS_FREE_FHBS_BROKEN 34175

#define NLS_INITIAL_FHB_HEADER 34180
#define NLS_EXTENSION_FHB_HEADER 34181
#define NLS_FREE_FHB_HEADER 34182
#define NLS_FHB_RUN 34183
#define NLS_FHB_RUN_SUMMARY 34184

#define NLS_MFD_PAGE_INVALID 34190
#define NLS_MFD_PAGE_IO_ERROR 34191
#define NLS_MFD_OVERFLOW 34192
#define NLS_MFD_ENTRY_INVALID 34193

#define NLS_RAW_DIRECTORY_PAGE_IO_ERROR 34200
#define NLS_DIRECTORY_PAGE_IO_ERROR 34201
#define NLS_RAW_DIRECTORY_PAGE_INVALID 34202
#define NLS_DIRECTORY_PAGE_INVALID 34203
#define NLS_DIRECTORY_FHB_INVALID 34204
#define NLS_DIRECTORY 34205
#define NLS_DIRECTORY_OVERFLOW 34206
#define NLS_FILE_WITHOUT_DIRECTORY 34207
#define NLS_CANT_VERIFY_DIRECTORY 34208
#define NLS_CANT_SORT_FILENAMES 34209

#define NLS_VERIFYING_FHBS 34210
#define NLS_ARCHIVING_FILES 34211
#define NLS_VERIFYING_FREE_FHBS 34212
#define NLS_VERIFYING_MFD 34213
#define NLS_VERIFYING_BIT_MAP 34214
#define NLS_VERIFYING_DIRECTORIES 34215
#define NLS_REINITIALIZE_VOLUME 34216
#define NLS_VERIFICATION_COMPLETE 34217

#define NLS_LOCAL 34220
#define NLS_MASTER 34221
#define NLS_MFD 34222
#define NLS_DEFAULT_WILDCARD 34223

#define NLS_MUST_OVERWRITE 34230
#define NLS_VOLUME_REQUIRED 34231
#define NLS_CONFIRM_INCONSISTENT 34232
#define NLS_FUTURE_DATE 34233
#define NLS_WILDCARD_MISMATCH 34234
#define NLS_CANT_OPEN_DEVICE 34235
#define NLS_NO_SUCH_VOLUME 34236
#define NLS_CANT_ACCESS 34237
#define NLS_CANT_OPEN_VOLUME 34238
#define NLS_NO_VHB 34239
#define NLS_ARCHIVE_OF 34240
#define NLS_INCREMENTAL_FROM 34241
#define NLS_VERIFICATION_SUSPECT 34242
#define NLS_TOO_MANY_VOLUMES 34243
#define NLS_OVERWRITE_EXPLICIT 34244

#define NLS_FILE_LIST_REQUIRED 34250
#define NLS_EXPANDING_WILDCARDS 34251
#define NLS_TOO_MANY_WILDCARDS 34252
#define NLS_WILDCARD_EXPANSION_ERROR 34253
#define NLS_WILDCARD_TOO_COMPLICATED 34254

#define NLS_CONFIRM_ARCHIVE 34260
#define NLS_CANT_ARCHIVE 34261
#define NLS_BACKING_UP 34262
#define NLS_IO_ERROR 34263
#define NLS_FILE_IO_ERROR 34264
#define NLS_FILE_ERROR 34265

#define NLS_FILES_ARCHIVED 34270
#define NLS_FILES_IO_ERRORS 34271
#define NLS_FILES_OTHER_ERRORS 34272
#define NLS_FILES_NOT_ARCHIVED 34273
#define NLS_FILES_BYPASSED 34274
#define NLS_TOTAL_FILES 34275

#define NLS_TOO_MANY_DATASETS 34280
#define NLS_FILE_LISTS_DISAGREE 34281
#define NLS_FILE_LIST_FROM_FORMAT 34282
#define NLS_SEQUENCE_INVALID 34283

#define NLS_CONFIRM_RESTORE 34290
#define NLS_FILE_EXISTS 34291
#define NLS_DID_NOT_RESTORE 34292
#define NLS_CANT_RESTORE 34293
#define NLS_CREATING_DIRECTORY 34294
#define NLS_DIRECTORY_CREATION_ERROR 34295
#define NLS_RESTORING 34296
#define NLS_OVERWRITING 34297
#define NLS_LIST_ONLY 34298
#define NLS_REPLACE  34299

#define NLS_FILES_PROCESSED 34300
#define NLS_FILES_RESTORED 34301
#define NLS_FILES_RESTORED_WITH_ERRORS 34302
#define NLS_FILES_WITHOUT_FHB 34303
#define NLS_FILES_NOT_RESTORED 34304
#define NLS_FILES_UNRECOVERABLE 34305

#define NLS_CREATING_SEQ_DATASET 34310
#define NLS_SERVICE_BUFFER_SIZE 34311
#define NLS_TOTAL_SERVICE_BUFFERS 34312
#define NLS_SERVICE_BUFFER_SIZE_FIELD 34313
#define NLS_TOTAL_SERVICE_BUFFERS_FIELD 34314
#define NLS_CANT_MOUNT_ARCHIVE 34315
#define NLS_SERVICE_BUFFER_TOO_SMALL 34316
#define NLS_INVALID_TAPE_MARK_SPEC 34317
#define NLS_DEVICE_INVALID_2 34318

/*-----------------------------------------------------------------------------
 To facilitate shared parsing of Executive (or interactive) command form
 parameters by the archive utilities, a common parameter descriptor array is
 utilized to describe information returned by the CTOS RgParam operation.  The
 index of the array element is the index passed to RgParam to identify the
 parameter.  The other data stored for each parameter is a pointer to the
 destination variable for the parameter, the final type (and input conversion
 necessary) of the parameter, the size of the destination parameter and the
 NLS message number of a string used to identify the parameter on the command
 form. */

typedef struct {
   void *destination;
   enum {hex_param, decimal_param, ascii_param, Boolean_param,
         fuzzy_Boolean_param, date_param, path_param, file_param,
         files_param} type;
   unsigned size;
   unsigned nls_msg;
} param_descr_type;
