# head -- print the first n lines of file list, default 10
#
# Head
#   File list
#   [Lines (default 10)]
#   [Log file]
#   

BEGIN {
		# set maxlines
		if (length(ARGV[2]) > 0)
			maxlines = int(ARGV[2])
		else
			maxlines = 10
		ARGV[2] = ""

		# set log file -- if not specified, send to screen
		if (length(ARGV[3]) > 0) {
			logfile = ARGV[3]
			printf ("Printing to %s ... ", logfile)
			fLog++;
		}
		else
			logfile = "[vid]"
		ARGV[3] = ""

		if (ARGC > 4)
				fmulti = 1

		# main loop
		for (i = 1; i < ARGC; i++) {
			# skip null parameters from above
			if (length(ARGV[i]) == 0)
				continue

			# check if we can access the file by reading first line
			if ((err = (getline x < ARGV[i])) < 0) {
				printf("error accessing %s\n", ARGV[i])
				continue
			}

			if (fmulti)
				printf("%s:\n\n", ARGV[i]) >logfile
			if (err == 0)						# if zero length file
				continue

			# print first maxlines of file
			for (j = 0; j < maxlines && err > 0; j++) {
				print x >logfile
				err = (getline x < ARGV[i])
			}

			if (fmulti)
				print >logfile					# print newline
		}
		if (fLog)
			print "done."
}