/*****************************  MODULE HEADER  *******************************/
/*                                                                           */
/*                                                                           */
/*  MACHINE:                LANGUAGE:  Metaware C            OS: CTOS        */
/*                                                                           */
/*  seq_service_dispatch_ngen.c                                              */
/*                                                                           */
/*  Dispatch tables for workstation CTOS Sequential Access service.          */
/*                                                                           */
/*  HISTORY:                                                                 */
/*  --------                                                                 */
/*                                                                           */
/*  MM/DD/YY  VVVV/MM  PROGRAMMER    /  DESCRIPTION                          */
/*                                                                           */
/*  12/08/90  121E.00  P. Johansson  /  Created.                             */
/*  01/02/91  121F.01  P. Johansson  /  Don't need device specific procedure */
/*                                      for version information, but do need */
/*                                      a new one for default information.   */
/*  01/28/91  121F.02  P. Johansson  /  Watchdog procedure dispatch array.   */
/*                                                                           */
/*                    PROPRIETARY  PROGRAM  MATERIAL                         */
/*                                                                           */
/*  THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO         */
/*  BE REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM       */
/*  LICENSE OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF          */
/*  UNISYS CORPORATION, DETROIT, MICHIGAN 48232, USA.                        */
/*                                                                           */
/*  COPYRIGHT (C) 1990 UNISYS CORPORATION. ALL RIGHTS RESERVED               */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*  UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE         */
/*  AND RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION. HOWEVER,  */
/*  NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY       */
/*  CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS     */
/*  OF PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO     */
/*  WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                */
/*                                                                           */
/*  THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE     */
/*  WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE       */
/*  JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                          */
/*                                                                           */
/**************************  END OF MODULE HEADER  ***************************/

/* Standard C library macros and functions invoked by this module */

pragma Off(List);
#include <intel80X86.h>
pragma Pop(List);

/* There are no procedures in the Sequential Access service that can cope with
   a variable number of arguments, so this pragma makes everything much more
   efficient.  However, it has to be established AFTER any standard C library
   functions are defined because it reverses the normal C convention. */

pragma Calling_convention(_CALLEE_POPS_STACK);

/* External CTOS and CTOS Toolkit functions invoked by this module */

pragma Off(List);
#include <ctoslib.h>
pragma Pop(List);

/* Type definitions used by this module */

pragma Off(List);
#include <ctosTypes.h>
#include "seq_service.h"
pragma Pop(List);

/* Other external functions in this application invoked by this module */

extern unsigned flem_qic_close(dcb_type *dcb);
extern unsigned flem_qic_ctrl(dcb_type *dcb);
extern unsigned flem_qic_defaults(default_info_type *default_info);
extern void flem_qic_init(dcb_type *dcb, unsigned base_address);
extern unsigned flem_qic_io(dcb_type *dcb);
extern unsigned flem_qic_mode_query(dcb_type *dcb,
                                    seq_parameters_type *seq_parameters);
extern unsigned flem_qic_mode_set(dcb_type *dcb,
                                  seq_parameters_type *seq_parameters);
extern unsigned flem_qic_open(dcb_type *dcb);
extern unsigned flem_qic_rq_done(dcb_type *dcb);
extern unsigned flem_qic_status(dcb_type *dcb);
extern void flem_qic_watchdog(watchdog_type *watchdog);
extern unsigned ngen_qic_close(dcb_type *dcb);
extern unsigned ngen_qic_ctrl(dcb_type *dcb);
extern unsigned ngen_qic_defaults(default_info_type *default_info);
extern void ngen_qic_init(dcb_type *dcb, unsigned base_address);
extern unsigned ngen_qic_io(dcb_type *dcb);
extern unsigned ngen_qic_mode_query(dcb_type *dcb,
                                    seq_parameters_type *seq_parameters);
extern unsigned ngen_qic_mode_set(dcb_type *dcb,
                                  seq_parameters_type *seq_parameters);
extern unsigned ngen_qic_open(dcb_type *dcb);
extern unsigned ngen_qic_rq_done(dcb_type *dcb);
extern unsigned ngen_qic_status(dcb_type *dcb);
extern void ngen_qic_watchdog(watchdog_type *watchdog);
extern unsigned scsi_buffer(dcb_type *dcb);
extern unsigned scsi_close(dcb_type *dcb);
extern unsigned scsi_ctrl(dcb_type *dcb);
extern unsigned scsi_defaults(default_info_type *default_info);
extern unsigned scsi_io(dcb_type *dcb);
extern unsigned scsi_open(dcb_type *dcb);
extern unsigned scsi_mode_query(dcb_type *dcb,
                                seq_parameters_type *seq_parameters);
extern unsigned scsi_mode_set(dcb_type *dcb,
                              seq_parameters_type *seq_parameters);
extern unsigned scsi_rq_done(dcb_type *dcb);
extern unsigned scsi_status(dcb_type *dcb);

/* Global variables exported by this manuscript */

unsigned (*device_buffer[])(dcb_type *dcb) = {scsi_buffer, 0, 0, 0, 0};
unsigned (*device_close[])(dcb_type *dcb) =
                            {scsi_close, ngen_qic_close, flem_qic_close, 0, 0};
unsigned (*device_ctrl[])(dcb_type *dcb) =
                               {scsi_ctrl, ngen_qic_ctrl, flem_qic_ctrl, 0, 0};
unsigned (*device_defaults[])(default_info_type *default_info) =
                   {scsi_defaults, ngen_qic_defaults, flem_qic_defaults, 0, 0};
void (*device_init[])(dcb_type *dcb, unsigned base_address) =
                                       {0, ngen_qic_init, flem_qic_init, 0, 0};
unsigned (*device_io[])(dcb_type *dcb) =
                                     {scsi_io, ngen_qic_io, flem_qic_io, 0, 0};
unsigned (*device_mode_query[])(dcb_type *dcb,
                                seq_parameters_type *seq_parameters)
           = {scsi_mode_query, ngen_qic_mode_query, flem_qic_mode_query, 0, 0};
unsigned (*device_mode_set[])(dcb_type *dcb,
                              seq_parameters_type *seq_parameters)
                 = {scsi_mode_set, ngen_qic_mode_set, flem_qic_mode_set, 0, 0};
unsigned (*device_open[])(dcb_type *dcb) =
                               {scsi_open, ngen_qic_open, flem_qic_open, 0, 0};
unsigned (*device_rq_done[])(dcb_type *dcb) =
                      {scsi_rq_done, ngen_qic_rq_done, flem_qic_rq_done, 0, 0};
unsigned (*device_status[])(dcb_type *dcb) =
                         {scsi_status, ngen_qic_status, flem_qic_status, 0, 0};
void (*device_watchdog[])(watchdog_type *watchdog) =
                               {0, ngen_qic_watchdog, flem_qic_watchdog, 0, 0};
