/***
*sys\stat.h - defines structure used by stat() and fstat()
*
*	Copyright 1985-1991, Microsoft Corporation.  All rights reserved.
*	Copyright 1991, Unisys Corporation.  All rights reserved.
*
*Purpose:
*	This file defines the structure used by the stat() and fstat()
*	routines.
*	[POSIX/System V]
*
****/

#if !defined(_SYS_STAT_DEFINED)

#define _SYS_STAT_DEFINED

#include <sys/types.h>
#include <time.h>

#if defined(_DLL) && !defined(_MT)
#error Cannot define _DLL without _MT
#endif

#if !defined(_FAR_)
#if defined(_MT)
#define _FAR_ _far
#else
#define _FAR_
#endif
#endif

/* define structure for returning status information */

struct stat {
	dev_t st_dev;
	ino_t st_ino;
#if !defined(_POSIX_SOURCE)
	unsigned short st_mode;
	short st_nlink;
	short st_uid;
	short st_gid;
#else
	mode_t st_mode;
	nlink_t st_nlink;
	uid_t st_uid;
	gid_t st_gid;
#endif
	dev_t st_rdev;
	off_t st_size;
	time_t st_atime;
	time_t st_mtime;
	time_t st_ctime;
#if defined(_POSIX_SOURCE)
	time_t st_etime;
#endif
	};

#define S_IFMT		0170000 	/* file type mask */
#define S_IFDIR		0040000 	/* directory */
#define S_IFCHR		0020000 	/* character special */
#define S_IFREG		0100000 	/* regular */
#define S_IREAD		0000400 	/* read permission, owner */
#define S_IWRITE	0000200 	/* write permission, owner */
#define S_IEXEC		0000100 	/* execute/search permission, owner */
#if defined(_POSIX_SOURCE)
#define S_IFLNK		0120000 	/* symbolic link */
#define S_IFBLK		0060000 	/* block special */
#define S_IFNAM		0050000 	/* name space entry */
#define S_IFIFO		0010000 	/* FIFO */
#define S_ISUID		0004000 	/* set user id on execution */
#define S_ISGID		0002000 	/* set group id on execution */
#define S_ISVTX		0001000 	/* save swapped text even after use */
#define S_IRUSR		0000400 	/* read permission, owner */
#define S_IWUSR		0000200 	/* write permission, owner */
#define S_IXUSR		0000100 	/* execute/search permission, owner */
#define S_IRGRP		0000040 	/* read permission, group */
#define S_IWGRP		0000020 	/* write permission, group */
#define S_IXGRP		0000010 	/* execute/search permission, group */
#define S_IROTH		0000004 	/* read permission, other */
#define S_IWOTH		0000002 	/* write permission, other */
#define S_IXOTH		0000001 	/* execute/search permission, other */

#define S_IRWXU		(S_IRUSR | S_IWUSR | S_IXUSR)
#define S_IRWXG		(S_IRGRP | S_IWGRP | S_IXGRP)
#define S_IRWXO		(S_IROTH | S_IWOTH | S_IXOTH)

#define S_IRWXPERM	(S_IRWXU | S_IRWXG | S_IRWXO)
#define S_IPERM		(S_ISUID | S_ISGID | S_ISVTX | S_IRWXPERM)

#define S_ISLNK(m)	(((m) & S_IFMT) == S_IFLNK)
#define S_ISREG(m)	(((m) & S_IFMT) == S_IFREG || ((m) & S_IFMT) == 0)
#define S_ISBLK(m)	(((m) & S_IFMT) == S_IFBLK)
#define S_ISNAM(m)	(((m) & S_IFMT) == S_IFNAM)
#define S_ISDIR(m)	(((m) & S_IFMT) == S_IFDIR)
#define S_ISCHR(m)	(((m) & S_IFMT) == S_IFCHR)
#define S_ISFIFO(m)	(((m) & S_IFMT) == S_IFIFO)
#endif


/* function prototypes */

extern signed int _FAR_ _cdecl fstat(signed int, struct stat _FAR_ *);
extern signed int _FAR_ _cdecl stat(const char _FAR_ *, struct stat _FAR_ *);
#if defined(_POSIX_SOURCE)
extern mode_t     _FAR_ _cdecl umask(mode_t);
extern signed int _FAR_ _cdecl mkdir(const char _FAR_ *, mode_t);
extern signed int _FAR_ _cdecl mkfifo(const char _FAR_ *, mode_t);
extern signed int _FAR_ _cdecl chmod(const char _FAR_ *, mode_t);
extern signed int _FAR_ _cdecl lstat(const char _FAR_ *, struct stat _FAR_ *);
extern signed int _FAR_ _cdecl mknod(const char _FAR_ *, mode_t, ...);
#endif

#endif /* !_SYS_STAT_DEFINED */
