/***
*errno.h - system wide error numbers (set by system calls)
*
*	Copyright 1985-1991, Microsoft Corporation.  All rights reserved.
*	Copyright 1991, Unisys Corporation.  All rights reserved.
*
*Purpose:
*	This file defines the system-wide error numbers (set by
*	system calls).	Conforms to the XENIX standard.  Extended
*	for compatibility with Uniforum standard.
*	[POSIX/ANSI/System V]
*
****/

#if !defined(_ERRNO_DEFINED)

#define _ERRNO_DEFINED

#if defined(_DLL) && !defined(_MT)
#error Cannot define _DLL without _MT
#endif

#if !defined(_FAR_)
#if defined(_MT)
#define _FAR_ _far
#else
#define _FAR_
#endif
#endif

/* declare reference to errno */

#if !defined(_POSIX_SOURCE)
#if defined(_MT)
extern signed int _far * _cdecl _far volatile _errno(void);
#define errno	(*_errno())
#else
extern signed int _near _cdecl volatile errno;
#endif
#else /* _POSIX_SOURCE */
extern signed int errno;
#endif

/* Error Codes */

#define EZERO		0
#define EPERM		1
#define ENOENT		2
#define ESRCH		3
#define EINTR		4
#define EIO		5
#define ENXIO		6
#define E2BIG		7
#define ENOEXEC 	8
#define EBADF		9
#define ECHILD		10
#define EAGAIN		11
#define ENOMEM		12
#define EACCES		13
#define EFAULT		14
#define ENOTBLK 	15
#define EBUSY		16
#define EEXIST		17
#define EXDEV		18
#define ENODEV		19
#define ENOTDIR 	20
#define EISDIR		21
#define EINVAL		22
#define ENFILE		23
#define EMFILE		24
#define ENOTTY		25
#define ETXTBSY 	26
#define EFBIG		27
#define ENOSPC		28
#define ESPIPE		29
#define EROFS		30
#define EMLINK		31
#define EPIPE		32
#define EDOM		33
#define ERANGE		34
#if !defined(_POSIX_SOURCE)
#define EUCLEAN 	35
#define EDEADLOCK	36
#else /* _POSIX_SOURCE */
#define EDEADLK		45
#define ENOLCK		59
#define ELOOP		62
#define ENAMETOOLONG	63
#define ENOTEMPTY	64
#define ENOSYS		65
#define EMAXIMUM	100
#define ERETRY		255
#endif /* _POSIX_SOURCE */

#endif /* !_ERRNO_DEFINED */
