; 9/02/80, RH
; 8/18/81, RH
; 1/11/84, JA, use OutSub in PitIntHandler, NGEN
; 1/29/84, MO, bigger code for t2 and 8086 NGen
; 6/11/84, MO, add support for cws
; 4/1/85,  MO, add support for Gws
; 4/23/86  DR, use InstallInterruptVector, CTOSp
; 11/4/88  KH, add support for PS2
; 11/30/88 KH, make more hardware independent
; 12/1/88  KH, use vf; clear rtc int by reading, not writing reg.
; 8/31/90  SG, add support for b38lcw
; 11/15/90 GWH, Moved SGEN RTC and PIT to use Ext. 8254 for interrupts.
; 02/05/91 SG, Fix b38lcw PIT.
; 08/08/91 FW, PCAT PIT.
; 05/11/93 FW, PS2 PIT.


$INCLUDE(:f1:ioaddr1.edf)

EOI_8259	EQU	20H
pitLsbMsb	EQU	30h
RtcIntBit	EQU	2h
ercPITFail	EQU	13
Newgen EQU 9


; Mask structure is (port, enableAnd, disableOr, oMem, iInt, cMask)
intPort EQU 0
intEnableAnd EQU 2
intDisableOr EQU 4
intoMem EQU 6
intiInt EQU 8
intcMask EQU 10

;tyCascade, tyPIT and tyRTC are defined in sysgen.mdf and ctosinternal.edf
oMasksCascade EQU 12 ;tyCascade * size of mask structure = 1 * 12
oMasksPIT EQU 36     ;tyPIT * size of mask structure     = 3 * 12
oMasksRTC EQU 48     ;tyRTC * size of mask structure     = 4 * 12
 
 
PUBLIC	ReadyForPITInt, ReadyForRtcInt ; TimerTestInt
PUBLIC	cRtcTestInt, cPITCount, fPITInt
EXTRN	RecordError: FAR
EXTRN	OutSub:FAR
EXTRN InstallInterruptVector:far

DGroup	GROUP	Data

Data	SEGMENT PUBLIC 'Data'
EXTRN			hardwareType: BYTE
EXTRN			processorType: BYTE
EXTRN			OCW1_8259: WORD
EXTRN			OCW2_8259: WORD
EXTRN			Ext8259_OCW2: WORD
EXTRN			cascadeOCW1_8259: WORD
EXTRN			cascadeOCW2_8259: WORD
EXTRN			modeWord8254NGen: WORD
EXTRN			modeWord8253: WORD
EXTRN			ClearRtcIntPort: WORD
EXTRN			mACascade: BYTE
EXTRN			mAHighest: BYTE
EXTRN			mptyDevMask: WORD
EXTRN			tyDevMax: WORD
EXTRN			intervalTimerSelect: BYTE
;EXTRN			fContinue: BYTE
;EXTRN			cChar: WORD
EXTRN			vf: byte
$Include(:f1:VfEqu.idf)

fPITInt			DB	0
fCheckPITInt	DB	0
fRepeatInt		DB	0
bSaveMask		DB	0
		EVEN
pPITInterrupt	DD	PITIntHandler
pRtcInterruptNGen	DD	RtcTestIntHandlerNGen
cRtcTestInt		DW	0
cPITCount		DW	0
Data	ENDS

PITtest1Code SEGMENT PUBLIC 'COED'
ASSUME	CS: PITTest1Code, DS: DGroup

ReadyForPITInt	PROC	FAR
	push	BP
	mov	BP, SP
	cli

	mov BX,oMasksPIT
	MOV	AX, mptyDevMask[BX+intiInt]

	lea	SI, pPITInterrupt
	push ax                  
	push word ptr [si+2]
	push word ptr [si]
	xor ax, ax
	push ax
	call InstallInterruptVector

	mov	fCheckPITInt, 0FFh
	mov	fRepeatInt, 0
	mov	fPITInt, 0						

	mov BX,oMasksPIT
	MOV	DX, mptyDevMask[BX+intPort]		
	IN	AL, DX
	AND	AX, mptyDevMask[BX+intEnableAnd]
	jmp	$+2
	out	DX, AL
	jmp	$+2
	test	vf_fb38Lcw, 1	
	jz	@14
	mov BX, oMasksCascade				; timer is on slave
	MOV	DX, mptyDevMask[BX+intPort]		; enable cascade on master
	IN	AL, DX
	mov bSaveMask, AL					; save mask 
	AND	AX, mptyDevMask[BX+intEnableAnd]
	jmp	$+2
	out	DX, AL

@14:
	sti
	pop	BP
	ret
ReadyForPITInt	ENDP


PITIntHandler	PROC	FAR
	push	AX
	push	DX
	push	BX
	cmp	fCheckPITInt, 0
	je	@1
	mov	fPITInt, 0FFh
@1:
	mov	fCheckPITInt, 0

	mov	AL, intervalTimerSelect
	or	AL, pitLsbMsb
	mov	DX, modeWord8254NGen
	test	vf_fb38Lcw, 1	
	jnz	@4
	test	vf_fpcAT, 1	
	jnz	@4
	test	vf_fSGEN,1
	jz  @9

@4:	mov	DX, modeWord8253    ;SGEN, B38Lcw & PCAT

@9:	out	DX, AL

	cmp	fRepeatInt, 0
	je	@2

	mov BX,oMasksPIT
	MOV	DX, mptyDevMask[BX+intPort]
	IN	AL, DX
	jmp $+2
	OR	AX, mptyDevMask[BX+intDisableOr]
	out	DX, AL
	jmp	$+2

	test	vf_fb38Lcw, 1	
	jz	@7
	mov BX, oMasksCascade
	MOV	DX, mptyDevMask[BX+intPort]		; restore mask
	MOV	AL, bSaveMask
	jmp	$+2
	out	DX, AL
@7:
	mov	AX, 15
	push	AX
	call	RecordError
@2:
	mov	fRepeatInt, 0FFh
	
	test	vf_fSGEN,1	;this might have to be duped in error case above
	jz	@3
;	mov	dx,SysControlPortB
;	in al,dx
;	jmp $+2
;	or	al,080h  ; must set bit 7 to clear IRQ0
;	out al,dx

	mov DX,234h	; Clear byte flip-flop
	XOR AX,AX
	OUT DX,AL

	MOV DX,Ext8259_OCW2		; EOI the external controller
	MOV AL,EOI_8259
	OUT DX,AL

	MOV DX,9Ch				; Clear ISP block
	XOR AX,AX
	OUT DX,AL
	JMP @8					; Exit, Sgen is through.
@3:
	test	vf_fb38Lcw, 1	
	jz	@5
	mov	AL, EOI_8259
	mov	DX, cascadeOCW2_8259
	out	DX, AL
	jmp	$+2

@5:
	test	vf_fPS2, 1	    ; Must clear IRQ0 on PS2          FWPS2
	jz	@6
	mov DX, sysControlPortB
	in  al, dx
	or  al, 80h
	jmp $+2
	out al, dx

@6:
	mov	AL, EOI_8259
	mov	DX, OCW2_8259
	out	DX, AL

@8:	pop BX
	pop	DX
	pop	AX
	iret
	jmp PitIntHandler
PITIntHandler	ENDP



ReadyForRtcInt	PROC	FAR
	push	BP
	mov	BP, SP
	cli

	mov BX, oMasksRTC
	MOV	AX, mptyDevMask[BX+intiInt]
	lea	SI, pRtcInterruptNGen

	push ax
	push word ptr [si+2]
	push word ptr [si]
	xor ax, ax
	push ax
	call InstallInterruptVector

	mov	cRtcTestInt, 0

	mov BX, oMasksRTC
	MOV	DX, mptyDevMask[BX+intPort]
	IN	AL, DX
	AND	AX, mptyDevMask[BX+intEnableAnd]
	jmp	$+2
	out	DX, AL

	TEST vf_fSGEN,1		  ; RTC interrupt on SGEN is on EXT. 8259.
	JNZ	 ExtNoCascade
	mov	DX, OCW1_8259
	in	AL, DX
	mov AH, maCascade     ; 0 if no cascade
	not AH                ; FF if no cascade
	and	AL, AH            ; no change if no cascade
	jmp	$+2
	out	DX, AL            ; this is faster than checking if the RTC is on
	                      ; a cascaded controller

ExtNoCascade:
	sti
	pop	BP
	ret
ReadyForRtcInt	ENDP

RtcTestIntHandlerNGen	PROC	FAR
	push	AX
	push	DX
	push	BX
	inc	cRtcTestInt

	cmp	cRtcTestInt, 10
	jb	@50

	mov BX, oMasksRTC
	MOV	DX, mptyDevMask[BX+intPort]
	IN	AL, DX
	OR	AX, mptyDevMask[BX+intDisableOR]
	jmp	$+2
	out	DX, AL

@50:
	test	vf_fSGen, 1			;for now assume NMI doesn't have to be FWPS2
	jnz	@57						;explicitly re-enabled
	test	vf_fpcAT, 1
	jnz	@51
	test	vf_fb38lcw, 1
	jz	@54
@51:
	mov	DX, RTCmosAddressReg
	mov	AL, 8Ch ; RTCmosStatusC or NMIoff
	out DX, AL
	JMP SHORT @58

@57:
; Clear byte flip-flop on SGEN
	Mov DX,235h
	MOV AL,00h
	OUT DX,AL
	Mov DX,Ext8259_OCW2
	MOV AL,EOI_8259
	OUT DX,AL						; EOI External Controller.
	JMP $+2
	MOV DX,09Ch						; Clear ISP block
	XOR AX,AX
	OUT DX,AL
	JMP $+2
	JMP @55							; used to jmp to @8 and do a ret, not IRET.

@54:
	test	vf_fnewgen, 1
	jz	@56
@58:
	mov DX, ClearRtcIntPort
	IN  DX,AL
	
@56:
	mov	AL, EOI_8259
	mov	DX, cascadeOCW2_8259
	out	DX, AL
	jmp	$+2

	mov	AL, EOI_8259
	mov	DX, OCW2_8259
	out	DX, AL

@55:
	pop BX
	pop	DX
	pop	AX
	iret
	jmp RtcTestIntHandlerNGen
RtcTestIntHandlerNGen	ENDP

PITtest1Code	ENDS

END
