$TITLE(02 FEB 85: Procedural Interface for GSCS Overlapped I/O)
$PAGEWIDTH(132)
$PAGELENGTH(60)
$LIST

; Procedural interface for overlapped I/O calls to the GenSync service.  The
; caller must provide a 64-byte work area (in which the request block is built)
; and an exchange at which the system service can eventually respond to the
; request.
;
; 10 APR 85

		EXTRN	Request:FAR, Wait:FAR

		PUBLIC	ReadGenSyncOvl
		PUBLIC	WriteGenSyncOvl
		PUBLIC	CheckReadGenSyncOvl
		PUBLIC	CheckWriteGenSyncOvl

GenSyncCode	SEGMENT	PUBLIC	'Code'
GenSyncCode	ENDS

parmsOffset	EQU	6			;Offset to parameters on stack

exchReply	EQU	parmsOffset+0		;Templates for parameters on
pRqOvl		EQU	parmsOffset+2		;the stack after ReadGenSyncOvl
timeoutOvl	EQU	parmsOffset+6		;or WriteGenSyncOvl
modeOvl		EQU	parmsOffset+8
sBufferOvl	EQU	parmsOffset+10
pBufferOvl	EQU	parmsOffset+12
commHandleOvl	EQU	parmsOffset+16


psDataRetChk	EQU	parmsOffset+0		;Templates for stack after a
pRqChk		EQU	parmsOffset+4		;call to the Check.. procedures

varsOffset	EQU	-4			;Local stack variables offset

pMsgRet		EQU	varsOffset+0		;DD for address from Wait

sCntInfo	EQU	0			;Template for the request block
nReqPbCb	EQU	2
nRespPbCb	EQU	3
userNum		EQU	4
exchResp	EQU	6
ercRet		EQU	8
rqCode		EQU	10
commHandle	EQU	12
mode		EQU	14
timeout		EQU	16
pBuffer		EQU	18
sBuffer		EQU	22
psDataRet	EQU	24
ssDataRet	EQU	28
sDataRet	EQU	30

openGenSyncRqCode	EQU	8003h		;GenSync request codes
closeGenSyncRqCode	EQU	8004h
readGenSyncRqCode	EQU	8005h
writeGenSyncRqCode	EQU	8006h
deinstallGenSyncRqCode	EQU	8007h
statusGenSyncRqCode	EQU	8008h
controlGenSyncRqCode	EQU	8009h

ercWrongpRqArgument	EQU	248		;Error return codes

CtosData	SEGMENT	AT 0

		DB	24Ch DUP (?)
ppPcbRun	DD	?			;Pointer to pointer to Pcb

pcbUserNum	EQU	14			;User number of active process

CtosData	ENDS
$EJECT
; The read and write overlapped I/O routines are essentially the same.  With
; the exception of the request code and counts of request/response pb/cb pairs
; (which are passed in registers to a common code section), the code builds a
; request block in the work area supplied by the user---incuding, of course,
; the reply exchange specified by the user---and then uses the CTOS Request
; primitive to pass it to the system service.  Return is made to the user
; directly after the request and, one hopes, the I/O is already underway.

GenSyncCode	SEGMENT
		ASSUME	CS:GenSyncCode

ReadGenSyncOvl	PROC	FAR
		PUSH	BP
		MOV	SI,readGenSyncRqCode
		MOV	DL,0            	;nReqPbCb
		MOV	DH,2			;nRespPbCb
		JMP	SHORT genSyncOvlIo
ReadGenSyncOvl	ENDP


WriteGenSyncOvl	PROC	FAR
		PUSH	BP
		MOV	SI,writeGenSyncRqCode
		MOV	DL,1            	;nReqPbCb
		MOV	DH,1			;nRespPbCb
genSyncOvlIo:	MOV	BP,SP
		PUSH	DS
		XOR	AX,AX
		MOV	ES,AX
		ASSUME	ES:CtosData
		LES	BX,ppPcbRun		;Double dereference pointer...
		MOV	BX,ES:[BX]		;...to Process Control Block
		MOV	AX,[BP+exchReply]	;Save exchReply in AX a moment
		MOV	CX,ES:[BX+pcbUserNum]	;OK, user number stashed in CX
		LDS	BX,DWORD PTR[BP+pRqOvl]	;Base DS:BX ==> request block
		MOV	WORD PTR[BX+sCntInfo],6	;Start building the request...
		MOV	[BX+nReqPbCb],DL	
		MOV	[BX+nRespPbCb],DH
		MOV	[BX+userNum],CX
		MOV	[BX+exchResp],AX
		MOV	WORD PTR[BX+ercRet],0
		MOV	[BX+rqCode],SI
		MOV	AX,[BP+commHandleOvl]
		MOV	[BX+commHandle],AX
		MOV	AX,[BP+modeOvl]
		MOV	[BX+mode],AX
		MOV	AX,[BP+timeoutOvl]
		MOV	[BX+timeout],AX
		MOV	AX,[BP+pBufferOvl]
		MOV	[BX+pBuffer],AX
		MOV	AX,[BP+pBufferOvl+2]
		MOV	[BX+pBuffer+2],AX
		MOV	AX,[BP+sBufferOvl]
		MOV	[BX+sBuffer],AX
		MOV	[BX+psDataRet+2],DS	;Address of our own sDataRet in
		LEA	AX,[BX+sDataRet]	;the request block---not user's
		MOV	[BX+psDataRet],AX
		MOV	WORD PTR[BX+ssDataRet],2
		MOV	WORD PTR[BX+sDataRet],0
		PUSH	DS
		PUSH	BX
		CALL	Request			;OK, give it a shot
		POP	DS
		POP	BP
		RET	18
WriteGenSyncOvl	ENDP
$EJECT
; The procedures to check the completion status of overlapped I/O are
; identical.  They simply wait at the exchange and then verufy that the
; address returned matches the address of the request block and exit.

CheckReadGenSyncOvl	EQU	THIS FAR
CheckWriteGenSyncOvl	EQU	THIS FAR

checkOvlIo	PROC	FAR
		PUSH	BP
		MOV	BP,SP
		SUB	SP,4		;Room on stack for local variables
		PUSH	DS
		LDS	BX,DWORD PTR[BP+pRqChk]	;DS:BX ==> request block
		PUSH	BX
		MOV	AX,[BX+exchResp]	;Push Wait parameters...
		PUSH	AX
		PUSH	SS
		LEA	AX,[BP+pMsgRet]
		PUSH	AX
		CALL	Wait			;...and Wait
		POP	BX
		AND	AX,AX			;This erc OK?
		 JNE	SHORT genSyncRet	;No, return directly to caller
		MOV	AX,[BX+sDataRet]	;Transfer data count 
		LES	DI,DWORD PTR[BP+psDataRetChk]
		MOV	ES:[DI],AX
		MOV	AX,[BX+ercRet]		;Transfer erc too (leave in AX)
		PUSH	AX
		PUSH	CX
		MOV	BX,[BP+pRqChk]		;Now match the addresses
		AND	BX,000Fh
		MOV	AX,[BP+pMsgRet]
		AND	AX,000Fh
		CMP	AX,BX			;This is the byte address
		 JNE	SHORT genSyncRqError
		MOV	BX,[BP+pRqChk]
		MOV	CL,4
		SHR	BX,CL
		ADD	BX,[BP+pRqChk+2]
		MOV	AX,[BP+pMsgRet]
		MOV	CL,4
		SHR	AX,CL
		ADD	AX,[BP+pMsgRet+2]
		CMP	AX,BX			;This is the paragraph address
genSyncRqError:	POP	CX
		POP	AX
		 JE	genSyncRet
		MOV	AX,ercWrongpRqArgument
genSyncRet:	POP	DS
		ADD	SP,4
		POP	BP
		RET	8
checkOvlIo	ENDP


GenSyncCode	ENDS
$EJECT
; Procedural interfaces for the remainder of the GenSync system service calls.
; These are handled through the CTOS built-in procedural interface feature,
; which is a bit of a kluge based upon CS:IP combinations that yield unique
; vector information when the INT is issued to the operating system.  Anyway,
; the two formulas used to map request code to a CS:IP pair and vice-verse are
; as follows:
;
;	CS = -(rqCode AND 0FFF8h)
;	IP = 210 + ((2 * rqCode) AND 0Fh) + (80h * (rqCode / 8))
;
;	rqCode = ((IP AND 0Fh) / 2) + NEG CS
;
; The syntax of the macro used to generate the entry point(s) is:
;
;	RqName(Request code, "routine name")
;
; See GenSyncRequest.0.Asm for more information on the ordering of the
; parameters on the stack when the procedural interface is invoked.

$INCLUDE(<Gen>RqLabl.Mdf)

%RqName(openGenSyncRqCode, "OpenGenSync")
%RqName(closeGenSyncRqCode, "CloseGenSync")
%RqName(readGenSyncRqCode, "ReadGenSync")
%RqName(writeGenSyncRqCode, "WriteGenSync")
%RqName(deinstallGenSyncRqCode, "DeinstallGenSync")
%RqName(statusGenSyncRqCode, "StatusGenSync")
%RqName(controlGenSyncRqCode, "ControlGenSync")

		END
