;******************************* MODULE HEADER *******************************;
;*                                                                           *;
;* FILE: SbuMsg.asm                                                          *;
;*                                                                           *;
;* MACHINE: B20        LANGUAGE: ASSEMBLER  OS: BTOS                         *;
;*                                                                           *;
;* DESCRIPTION:                                                              *;
;*                                                                           *;
;* Selective Backup messages                                                 *;
;*                                                                           *;
;* HISTORY:                                                                  *;
;*                                                                           *;
;* MM/DD/YY VVVV/MM PROGRAMMER   / DESCRIPTION OF CHANGE (Most recent first) *;
;*                                                                           *;
;* 01/15/90 120F.03 Arif Obaid   / Add 34605,modify 34614.                   *;
;* 11/08/89 120E.02 P. Campbell  / rgSbuBackingUpFile to match FileUtilMsg   *;
;* 11/07/88 120A.01 M. McLaughlin/ Added 49154 'Verify Write?'               *;
;*                                                                           *;
;* ----                                                                      *;
;* 10/16/86 MDD Added comments denoting message numbers in FileUtilMsg.mtxt  *;
;*                                                                           *;
;* TITLE:  BTOS SYSTEM SOFTWARE                                              *;
;*                                                                           *;
;*            PROPRIETARY PROGRAM MATERIAL                                   *;
;*                                                                           *;
;* THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO BE       *;
;* REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM LICENSE   *;
;* OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF UNISYS            *;
;* CORPORATION, DETROIT, MICHIGAN 48232, USA.                                *;
;*                                                                           *;
;* COPYRIGHT (C) 1980, 1989 CONVERGENT INCORPORATED. ALL RIGHTS RESERVED     *;
;* COPYRIGHT (C) 1980, 1989 UNISYS CORPORATION. ALL RIGHTS RESERVED          *;
;* ************************************************************************* *;
;*                                                                           *;
;* UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE AND      *;
;* RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION.  HOWEVER,      *;
;* NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY        *;
;* CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS OF   *;
;* PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO         *;
;* WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                 *;
;*                                                                           *;
;* THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE      *;
;* WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE        *;
;* JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                           *;
;*                                                                           *;
;*                                                                           *;
;*************************** END OF MODULE HEADER ****************************;

$INCLUDE(:f0:String.Mdf)
;
;************ NLS Internationalization ***************
;MDD 10/16/86 - Added comments to show location of error messages
;               in new message file FileUtilMsg.txt
;************ NLS Internationalization ***************
; --- 12.0 --- 
; MM 11/07/88 - From UNISYS Camarillo adding UVA. Added message number 49154
;               'Verify Write?'
;

%InitStrings
   ;
   ;  See "String.Mdf" for description of Macro definitions.
   ;
   ;     
   ;     
   ;    ****************************************************
   ;    *      Start of text messages for Sback.plm        *
   ;    ****************************************************
   ;     
%sbString rgSbuName ('Selective Backup ') ; NLS Msg 34601
%sbString rgSbuBackUpFile ('Back up file ') ; NLS Msg 34602
%sbString rgSbuFileListToBackup ('File list') ; NLS Msg 34603
%sbString rgSbuConfirmEach ('Confirm each?') ; NLS Msg 34604
%sbString rgTapeSbuName ('Tape Selective Backup ') ; NLS Msg 34605 ;M03;
%sbString rgSbuBUpFilesModifiedSince ('Incremental from') ; NLS Msg 34446
;*** Use NLS Msg 34606 for international version of the following message
%sbString rgSbuDelExistingArchiveFile ('Delete existing archive file?') 
%sbString rgSbuLogFile ('Log file') ; NLS Msg 34607
%sbString rgSbuBootTape ('Boot tape'); NLS Msg 34154
%sbString rgUnexpectedError ('Unexpected error while writing to the archive file.') ; NLS Msg 34608
;*** Use NLS Msg 34609 for international version of the following message
%sbString rgSbuFileNotAccessible ('Name of file not accessible for archiving') 
;*** The following 2 messages are combined to form NLS Msg 34564
%sbString rgProcessFile ('Processing file ')
%sbString rgLiteralOf ('of ')
; NLS Msg 34564: 25h = Percent character which macros don't like
%sbString rgProcFileOf ('Processing file ',25h,'0N of ',25h,'1N ... ') ; 
%sbString rgSbuSpaces ('                                        ') ; No NLS Msg
;*** Use NLS Msg 34611 for international version of the following message
%sbString rgNoFilesSelected ('No files were selected for backup.')
%sbString rgCantOpenLog ('Cannot open the log file.
'); NLS Msg 34458
%sbString rgIncreFrom ('Incremental from '); NLS Msg 34460
%sbString rgUnableOpenArch ('Unable to open archive file.'); NLS Msg 34614
%sbString rgSbuError (' error '); NLS Msg 34615
%sbString rgSbuQuesMark ('?'); Not Translated for NLS
%sbString rgSbuBackingUpFile ('Backing up file ',25h,'0S ... '); NLS Msg 34618
;*** Use NLS Msg 34617 for international version of the following message
%sbString rgSbuIoErrFileAtLFA ('        I/O error for file at LFA :')
%sbString rgSbuSpacesFile ('          file '); NLS Msg 34618
%sbString rgSbuDots (' ... '); Not translated for NLS
%sbString rgSbuNumFilesArchived ('
Number of files archived : '); NLS Msg 34620
;*** Use NLS Msg 34621 for international version of the following message
%sbString rgSbuNumFileHadIoErr ('
Number of files which had IO errors : ')
%sbString rgSbuNumFilesNotCompleteArchive ('
Number of files which were not completely archived : '); NLS Msg 34622
%sbString rgSbuExpanding ('Expanding wildcard ... '); NLS Msg 34623
%sbString rgSbuNumFileNotAccessible ('
Number of files which were not accessible for archiving : '); NLS Msg 34624

%sbString sbSbuRecordHeading ('Selective backup'); NLS Msg 34625
%sbString sbSbuIncremental (';  Incremental from '); NLS Msg 34626
%sbString rgTooManyFilesInWildCard ( 'Out of buffer space for wildcard expansion.'); NLS Msg 34627
%sbString rgErrorInExpansion ( 'Error in wildcard expansion.'); NLS Msg 34628
;*** Use NLS Msg 34629 for international version of the following message
%sbString rgSbuFutureDate ('The date given is in the future.'); NLS Msg 34464
%sbString rgSbuVerifyWrite( 'Verify Write?'); NLS Msg 49154

%FinishStrings
END
