# Set default for listcheck to NOLIST (case sensitive!)
listcheck=NOLIST

NothingSpecified:
	$(COPYSTRING:SFX=tmp)version=$(version) args=$(args) listcheck=$(listcheck) update
	Make\n$(GETSTRING:SFX=tmp)\g
	$(DELSTRING:SFX=tmp)

COPYSTRING=Copy\n[KBD]\n[Scr]<$>Make.SFX \nyes\g
GETSTRING =@[Scr]<$>Make.SFX
DELSTRING =Delete\n[Scr]<$>Make.SFX \g

# LIBMACRO must be specified after every library definition.


LIBMACRO=\
	Make\n$(listcheck)\g\
	$(COPYSTRING:.SFX=.Lib.Tmp)$?\
	Librarian\n$@\n$(GETSTRING:.SFX=.Lib.Tmp)\n\n\n\nyes\g\
	$(DELSTRING:.SFX=.Lib.Tmp)\
	Append Library Version\n$@\n$(version)\g\
	Delete\n*-old\g

##################################################################
# relink causes the "relinking" of run files by deleting all run #
# files and then reinvoking make to do an update.                #
##################################################################
relink:
	$(COPYSTRING:SFX=ReBld)$(RUNFLS)
	Delete\n$(GETSTRING:SFX=ReBld)\g
	$(DELSTRING:SFX=ReBld)
	$(COPYSTRING:SFX=tmp)-w version=$(version) $(args) listcheck=$(listcheck) update
	Make\n$(GETSTRING:SFX=tmp)\g\
	$(DELSTRING:SFX=tmp)\
	Delete\nMap.Err\g\
	Check Errors\n*.map\n\n\nYes\nMap.Err\g\
	Submit\n[sys]<sys>AppendMap.sub\n@Map.Err\g	

#############################################################
# relib causes "re-libing" and "re-linking" by deleting all #
# libraries and reinvoking make to do an update.            #
#############################################################
relib: relibx relink

relibx:
	$(COPYSTRING:SFX=ReBld)$(LIBFLS)
	Delete\n$(GETSTRING:SFX=ReBld)\g
	$(DELSTRING:SFX=ReBld)
	$(COPYSTRING:SFX=tmp)-w version=$(version) $(args) listcheck=$(listcheck) update
	Make\n$(GETSTRING:SFX=tmp)\g
	$(DELSTRING:SFX=tmp)

######################################################################
# rebuild "forces" a complete rebuild by deleting all object modules #
# and libraries and then reinvoking make to do an update.            #
######################################################################
rebuild:
	$(COPYSTRING:SFX=ReBld)$(OBJFLS)
	Delete\n$(GETSTRING:SFX=ReBld)\g
	$(DELSTRING:SFX=ReBld)
	$(COPYSTRING:SFX=tmp)-w version=$(version) $(args) listcheck=$(listcheck) update
	Make\n$(GETSTRING:SFX=tmp)\g\
	$(DELSTRING:SFX=tmp)\
	Delete\nMap.Err\g\
	Check Errors\n*.map\n\n\nYes\nMap.Err\g\
	Submit\n[sys]<sys>AppendMap.sub\n@Map.Err\g	

sourcelist:
	Copy\n[KBD]\nSource.tmp\nyes\g$(PLMFLS) $(ASMFLS) $(PASFLS) $(CFLS) $(A86FLS)

#############################################################################
# LIST is invoked by the LIBMACRO via make LIST (actually make $(version)). #
# The purpose of list is to check *.lst for errors and inform the humaniod  #
# involved of the presence of errors.                                       #
#############################################################################

LIST:
	Delete\nLst.Err\g\
	Check Errors\n*.lst\n\n\nYes\nLst.Err\g\
	Submit\n[sys]<sys>AppendList.sub\n@Lst.Err\g	


#####################################################
# NOLIST is a do nothing label which does not LIST. #
#####################################################

NOLIST:


LEGALIZE:
	LCopy\nLegalese\n[Sys]<Edf>\n\n\nyes\g
	Append\n[KBD]\nLegalese\gVERSION: $(version) (%d|!*w! !*n! !*d!, !yyyy!, !*t!:!0m!|)