		PAGE	60,132
		TITLE	21 MAY 85: BATCH+ Utilities

Code		SEGMENT	WORD PUBLIC 'Code'
Code		ENDS
Data		SEGMENT	PARA PUBLIC 'Data'
Data		ENDS
Stack		SEGMENT	PARA STACK 'Stack'
Stack		ENDS

		ASSUME	CS:Code
		ASSUME	DS:Data
		ASSUME	SS:Stack
		ASSUME	ES:Nothing

		INCLUDE	PCHEQUS.INC

;..............................................................................
;
;	Convert the symbol table from an unhashed, 1-way linked list into
;	multiple, hashed trees whose roots are in HashTable
;
;	Entry:	SI ==>	Unconverted symbol table

Code		SEGMENT
		PUBLIC	MakeTree

MakeTree	PROC
		PUSH	[SI].ST$Link	;Save address of next symbol
		CALL	SHORT MakeHash	;Append this symbol to the tree
		POP	SI		;Onward to next entry
		CMP	BYTE PTR [SI],0FFh
		 JNE	MakeTree	;Still more symbols in the table...
		RET
MakeTree	ENDP
Code		ENDS

;..............................................................................
;
;	Using an existing symbol table entry, insert it into its proper tree
;
;	Entry:	SI ==>	An 8-byte name string in the symbol table
;
;	Exit:	SI	Preserved

Code		SEGMENT
		PUBLIC	MakeHash

MakeHash	PROC
		CALL	SHORT HashSym	;Create the hash byte
		MOV	[BX],SI		;Most recently hashes is top of tree
		 JNZ	SHORT MakeLink	;Now tack on existing tree below us
		MOV	DI,0FFFFh	;There aren't any colliding symbols
MakeLink:	MOV	[SI].ST$Link,DI	;Link to next symbol or ground
		RET
MakeHash	ENDP
Code		ENDS

;..............................................................................
;
;	Create the hash value from an ASCII symbol name
;
;	Entry:	SI ==>	An 8-byte name string
;
;	Exit:	SI	Preserved
;		DI ==>	Most recent symbol table value with same hash
;		BX =	Hash table entry for that symbol
;		Zero	FALSE = symbol collision, TRUE = no collision

Data		SEGMENT
		EXTRN	HashTable:WORD
Data		ENDS

Code		SEGMENT
		PUBLIC	HashSym

HashSym		PROC
		PUSH	SI		;Save SI for exit
		XOR	AH,AH		;Build the hash byte in AH
		MOV	CX,SIZE ST$Name	;Maximum symbol size
HashIt:		LODSB			;Get next symbol name ASCII byte
		CMP	AL,' '		;End of the symbol?
		 JE	SHORT HashAddr
		XOR	AH,AL
		 LOOP	HashIt
HashAddr:	AND	AX,0FF00h	;Clear AL before the shift
		MOV	CL,7		;Effectively, x2 result in AX
		SHR	AX,CL
		MOV	BX,OFFSET HashTable
		ADD	BX,AX		;Now SI ==> hash table entry
		MOV	DI,[BX]		;OK, DX points to ASCII symbol
		OR	DI,DI		;Set the zero flag for collision or not
		POP	SI		;LEave with SI ==> symbol name
		RET
HashSym		ENDP

Code		ENDS

;..............................................................................
;
;	Get space for the values of new variables.  Leave the link to
;	the space in the symbol table address fields.
;
;	Entry:	AL =	Number of bytes to allocate
;		BX ==>	Symbol table link field
;
;	Exit:	AL 	Preserved
;		BX ==>	Allocated space

Code		SEGMENT
		EXTRN	BadMemory:NEAR
		PUBLIC	GetSpace

GetSpace	PROC
		PUSH	AX
		INC	AL		;Allow for "current length" byte
		CALL	FreeLook	;Well, can we get any memory?
		 JB	BadMemory	;Aaargh! No memory
		MOV	[BX],SI		;Link in the new value
		MOV	BX,SI		;Now point to allocated memory
		MOV	BYTE PTR [BX],0	;Guarantee zero length at first
		POP	AX
		RET			;Back to caller
GetSpace	ENDP
Code		ENDS

;..............................................................................
;
;	Get space for a user data from the free space at the top of the
;	symbol table.
;
;	Entry:	AX =	size (in bytes) of space needed,
;
;	Exit:	Carry	FALSE = space allocated, TRUE = no space available
;		BX ==>	User data area in allocated space

Data		SEGMENT

		EXTRN	SymbolEnd:BYTE
SymbolFree	DW	SymbolEnd

Data		ENDS

Code		SEGMENT
		EXTRN	BreakPoint:NEAR
		PUBLIC	UserSpace

UserSpace	PROC
		MOV	SI,SymbolFree
		MOV	DI,SI
		ADD	AX,2
		ADD	DI,AX
		MOV	SymbolFree,DI
		CMP	BYTE PTR [SI],0FFh
		 JNE	BreakPoint
		DEC	AX
		MOV	BYTE PTR [SI],AL
		INC	SI
		MOV	WORD PTR [DI-1],0FFFFh
		OR	AX,AX		;Insure false Carry, false Zero
		RET
UserSpace	ENDP
Code		ENDS

;..............................................................................
;
;	Check the free space list for an available memory area large enough
;	to satisfy the caller.
;
;	Entry:	AL =	Number of bytes needed
;
;	Exit:	Carry	TRUE = failure, FALSE = memory allocated
;		SI ==>	Memory area available for use (i.e. data area)
;		Zero	TRUE = free space list used, FALSE = new allocated
;
;	Each data area has an internal format as follows:
;
;	    +-------+---------------+-------/.../----+-------+
;	    | Length| Length in use | User data area | 0FFh  |
;	    +-------+---------------+-------/.../----+-------+

Data		SEGMENT
FreeList	DW	0
Data		ENDS

Code		SEGMENT

FreeLook	PROC
		XOR	AH,AH		;Clear upper AX in case UserSpace used
		MOV	SI,OFFSET FreeList-1	;Kluge for length byte
FreeLoop:	MOV	DI,SI		;Save start address of previous block
		MOV	SI,[SI+1]	;On to the next free block
		CMP	SI,0		;Anything there?
		 JE	UserSpace	;No, grab unused symbol table space
		CMP	BYTE PTR [SI],AL	;Is this block big enough?
		 JB	FreeLoop	;No, continue through free list
		MOV	AL,[SI]		;Return useable length
		DEC	AX		;Convert to real length
		INC	SI		;And point SI at user data area
		MOV	DX,[SI]		;Address of next free block
		MOV	[DI+1],DX	;Remove this block from the chain
		MOV	WORD PTR [SI],0	;And kill the old linkage address
		XOR	AH,AH		;Insure false Carry, true Zero on exit
		RET
FreeLook	ENDP
Code		ENDS

;..............................................................................
;
;	Clear the current symbol assembly area
;
;	Exit:	DI ==>	Start of current symbol assembly area

Data		SEGMENT
		PUBLIC	CurrentSymPtr,CurrentSymbol

CurrentSymPtr	DW	CurrentSymbol	;Pointer into current symbol
CurrentSymbol	DB	80 DUP(' ')	;Assembly area for current symbol

Data		ENDS

Code		SEGMENT
		PUBLIC	ClearCurrSym

ClearCurrSym	PROC
		MOV	SI,OFFSET CurrentSymbol
		PUSH	SI		;Save it for eventual exit
		MOV	CurrentSymPtr,SI
		MOV	BYTE PTR [SI],' '
		MOV	DI,SI
		INC	DI		;Ripple the character
		CLD			;Insure upwards propagation
		PUSH	DS		;Propagate in the same segment
		POP	ES
		MOV	CX,SIZE CurrentSymbol
		REP MOVSB
		POP	DI		;Exit with DI ==> current symbol area
		RET
ClearCurrSym	ENDP
Code		ENDS

;..............................................................................
;
;	Symbol table lookup
;
;	Entry:	SI ==>	Symbol name to be looked up
;
;	Exit:	Carry	TRUE = not found, FALSE = found
;		AL =	Symbol status byte
;		DI ==>	Symbol value area
;		BX ==>	Symbol table entry

Data		SEGMENT
Data		ENDS

Code		SEGMENT
		PUBLIC	SymbolLookup

SymbolLookup	PROC
		CALL	HashSym		;Hash the symbol and look for it
		 JZ	SHORT SymbolNotFound
SymbolCompare:	PUSH	SI		;Keep copy of SI ==> original name
		MOV	BX,DI		;Also set up BX ==> candidate
		PUSH	DS
		POP	ES
		REPNZ CMPSB		;See if names match
		POP	SI		;No affect to condition flags
		 JE	SymbolFound
		MOV	DI,[BX].ST$Link	;Link to next candidate name
		CMP	DI,0FFFFh	;End of the line?
		 JE	SymbolNotFound
		JMP	SymbolCompare

SymbolFound:	MOV	AL,[BX].ST$Status	;Type information for symbol
		MOV	DI,[BX].ST$ValueLink	;Start of symbol value field
		OR	AL,AL			;Known to be nonzero
SymbolNotFound:	RET
SymbolLookup	ENDP
Code		ENDS

;..............................................................................
;
;	Create a new entry in the symbol table.  All symbols are allocated
;	the maximum size value area and the status is initially set to
;	TRUE, CHAR and empty.
;
;	Entry:	AL =	size of value area to allocate (if less than max)
;		SI ==>	symbol name (maximum of eight bytes)
;
;	Exit:	xx ==>	start of the symbol table entry created

Code		SEGMENT
		PUBLIC	SymbolCreate

SymbolCreate	PROC
		INC	AL		;Allow for the current length byte
		CALL	FreeLook	;Get the memory from the free list
	 	 JB	BadMemory	;Disaster!
		MOV	DI,xx
		MOV	CX,SIZE ST$Name
		RET
SymbolCreate	ENDP
Code		ENDS
		END
