# makefile.hpp,v 1.1.1.1 1995/10/26 20:50:38 polk Exp
#
#   Michael Seibel
#   Networks and Distributed Computing
#   Computing and Communications
#   University of Washington
#   Administration Builiding, AG-44
#   Seattle, Washington, 98195, USA
#   Internet: mikes@cac.washington.edu
#
#   Please address all bugs and comments to "pine-bugs@cac.washington.edu"
#
#   Copyright 1991-1994  University of Washington
#
#    Permission to use, copy, modify, and distribute this software and its
#   documentation for any purpose and without fee to the University of
#   Washington is hereby granted, provided that the above copyright notice
#   appears in all copies and that both the above copyright notice and this
#   permission notice appear in supporting documentation, and that the name
#   of the University of Washington not be used in advertising or publicity
#   pertaining to distribution of the software without specific, written
#   prior permission.  This software is made available "as is", and
#   THE UNIVERSITY OF WASHINGTON DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
#   WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED
#   WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN
#   NO EVENT SHALL THE UNIVERSITY OF WASHINGTON BE LIABLE FOR ANY SPECIAL,
#   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
#   LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT
#   (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION
#   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#  
#   Pine and Pico are trademarks of the University of Washington.
#   No commercial use of these trademarks may be made without prior
#   written permission of the University of Washington.
#

#
# Makefile for HP/UX version of the PINE composer library and 
# stand-alone editor pico.
#

#includes symbol info for debugging 
DASHO=		-g
#for normal build
#DASHO=		-O

CFLAGS=	-Dhpp -DPOSIX -DJOB_CONTROL

# switches for library building
LIBCMD=		ar
LIBARGS=	ru
RANLIB=		:

LIBS=		-ltermcap -lV3

OFILES=		attach.o ansi.o basic.o bind.o browse.o buffer.o \
		composer.o display.o file.o fileio.o line.o osdep.o \
		pico.o random.o region.o search.o spell.o tcap.o window.o word.o

CFILES=		attach.c ansi.c basic.c bind.c browse.c buffer.c \
		composer.c display.c file.c fileio.c line.c osdep.c \
		pico.c random.c region.c search.c spell.c tcap.c window.c word.c

HFILES=		estruct.h edef.h efunc.h ebind.h pico.h


#
# dependencies for the Unix versions of pico and libpico.a
#
all:		pico

osdep.c:	os_unix.c
		rm -f osdep.c
		cp os_unix.c osdep.c

osdep.h:	os_unix.h
		rm -f osdep.h
		cp os_unix.h osdep.h

libpico.a:	$& osdep.c osdep.h $(OFILES)
		$(LIBCMD) $(LIBARGS) libpico.a $(OFILES)
		$(RANLIB) libpico.a

pico:		main.c libpico.a
		$(CC) $(CFLAGS) main.c libpico.a $(LIBS) -o pico

.c.o:		; $(CC) -c $(CFLAGS) $(DASHO) $*.c

$(OFILES):	$(HFILES)

clean:
		rm -f *.a *.o *~ osdep.c osdep.h

