#   Makefile for compiling unix, MSDOS and OS2 versions of
#   psgraph and psgsimp using SCO 3.2.0 cross compiler.
#   The resulting executables are:
#
#   unix:  psgraph  psgsimp
#   msdos: psgraph.exe  psgsimp.exe
#   os2:   psgraph2.exe psgsimp2.exe
#
#   make    -f makefile.sco         for all executables
#   make    -f makefile.sco  sco    only unix
#   make    -f makefile.sco  msdos  only msdos
#   make    -f makefile.sco  os2    only os2
#
#   Warning: This make removes all object files
#


all:    sco os2 msdos

sco: clean
	$(MAKE) -f makefile.sco2 PROLOG=\"/usr/local/lib/ps/psgraph.pro\" \
	SYSFLAGS=-DSCO LFLAGS=-lm EXENAME=psgraph EXENAME2=psgsimp

#   Note increased stack size for MSDOS and OS2.
#   Nesting psgraph includes consumes the stack quicly.

os2: clean
	-rm *.o
	$(MAKE) -f makefile.sco2 SYSFLAGS="-F 1400 -M0l -os2" EXENAME=psgraph2.exe \
	EXENAME2=psgsimp2.exe

msdos: clean
	-rm *.o
	$(MAKE) -f makefile.sco2 SYSFLAGS="-F 1400 -M0l -dos" EXENAME=psgraph.exe \
	EXENAME2=psgsimp.exe

clean:
	-rm *.o
