/*
 *  isis_parms.c,v 1.11 1993/01/07 22:39:47 jch Exp
 */

/* Gated Release 3.5 */
/* Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.  All */
/* rights reserved.  Refer to Particulars and other Copyright notices at */
/* the end of this file.  */
/*  */


#include "include.h"
#include "isis_includes.h"


struct parm_set {
	char * parm_addr;
	const char * parm_name;
	int parm_size;
	int set_val;
	int low_val;
	int high_val;
};

#define PARMS(n,lb,ub) { (char *)&n, "n" ,sizeof(n),0,lb,ub }
struct parm_set parm_def [] =
{
PARMS(dataLinkBlocksize,200,4096), 
/* this is receiveLSPBufferSize, max is dubious */
/* note that this must come before the following */
PARMS(origL1LSPBufSize,200,4096), 
PARMS(origL2LSPBufSize,200,4096), 
PARMS(sysHoldingTimer,1,65535),
PARMS(sysISHInterval,5,30),
PARMS(origL1LSPBufSize,1,10000),
PARMS(origL2LSPBufSize,1,10000),
PARMS(dataLinkBlocksize,1,10000),
PARMS(sysHoldingTimer,1,10000),
PARMS(sysISHInterval,1,10000),
PARMS(sysIIHInterval,1,10000),
PARMS(minLSPGenInterval,1,10000),
PARMS(maxLSPGenInterval,1,10000),
PARMS(minBLSPXmitInterval,1,10000),
PARMS(minLSPXmitInterval,1,10000),
PARMS(BLSPThrottle,1,10000),
PARMS(maximumAge,1,10000),
PARMS(completeSNPInterval,1,10000),
PARMS(partialSNPInterval,1,10000),
PARMS(zeroAgeLifetime,1,10000),
{0,0,0,0,0}} ;

void
isis_set_parm(str,val)
char * str; int val;
/* sleazy linear table lookup */
{
	int i;
	for (i=0; i<sizeof(parm_def)/sizeof(struct parm_set); i++) {
		struct parm_set *
		ppt = &parm_def[i];
		if (!ppt->parm_name) break;
		if (!strncmp(str, ppt->parm_name,strlen(ppt->parm_name)))
		/* note: we should do something a little more sophisticated here */
		/* we use strncmp to avoid figuring out the length of str, which
			is just a pointer into the parser text stream and isn't null
			terminated. Yuck. */
		{
			trace_tf(isis_trace_options,
				 TR_NORMAL,
				 0,
				 ("setting parm %s val %d\n",
				  str,
				  val));
			if ((val< ppt->low_val) || (ppt->high_val < val)) {
				trace_tf(isis_trace_options,
					 TR_NORMAL,
					 0,
					 ("value for %s : %d out of range (%d,%d)\n",
					  ppt->parm_name,
					  val,ppt->low_val,
					  ppt->high_val));
				return;
			}
			ppt->set_val = val;
			return;
		}
	}
	trace_log_tf(isis_trace_options,
		     0,
		     LOG_ERR,
		     ("parameter %s not found\n",
		      str));
}


/* 
 * Check if any parms have been reset in config file.
 */
void
isis_check_parms()
{
	int i;
	struct parm_set *ppt;

	for (i=0; i<sizeof(parm_def)/sizeof(struct parm_set); i++) {
		ppt = &parm_def[i];
		if (ppt->set_val) {
			trace_tf(isis_trace_options,
				 TR_NORMAL,
				 0,
				 ("setting parm %s val %d",
				  ppt->parm_name,
				  ppt->set_val));
			switch(ppt->parm_size) {
			case sizeof(char): 
				*(char *)ppt->parm_addr = ppt->set_val;
				break;
			case sizeof(short): 
				*(short *)ppt->parm_addr = ppt->set_val;
				break;
			case sizeof(long): 
				*(long *)ppt->parm_addr = ppt->set_val;
				break;
#ifdef	FLOATING_POINT
			case sizeof(double): 
				*(double *)ppt->parm_addr = ppt->set_val;
				break;
#endif	/* FLOATING_POINT */
			default:
				trace_log_tf(isis_trace_options,
					     0,
					     LOG_ERR,
					     ("unexpected parm size %d",
					      ppt->parm_size));
			}
		}
	}
}



/*
 * ------------------------------------------------------------------------
 * 
 * 	GateD, Release 3.5
 * 
 * 	Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 * 	    All rights reserved.
 * 
 * 	THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * 	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * 	LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * 	AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * 	Royalty-free licenses to redistribute GateD Release
 * 	3 in whole or in part may be obtained by writing to:
 * 
 * 	    GateDaemon Project
 * 	    Information Technologies/Network Resources
 * 	    200 CCC
 * 	    Cornell University
 * 	    Ithaca, NY  14853-2601  USA
 * 
 * 	GateD is based on Kirton's EGP, UC Berkeley's routing
 * 	daemon	 (routed), and DCN's HELLO routing Protocol.
 * 	Development of GateD has been supported in part by the
 * 	National Science Foundation.
 * 
 * 	Please forward bug fixes, enhancements and questions to the
 * 	gated mailing list: gated-people@gated.cornell.edu.
 * 
 * ------------------------------------------------------------------------
 * 
 *       Portions of this software may fall under the following
 *       copyrights:
 * 
 * 	Copyright (c) 1988 Regents of the University of California.
 * 	All rights reserved.
 * 
 * 	Redistribution and use in source and binary forms are
 * 	permitted provided that the above copyright notice and
 * 	this paragraph are duplicated in all such forms and that
 * 	any documentation, advertising materials, and other
 * 	materials related to such distribution and use
 * 	acknowledge that the software was developed by the
 * 	University of California, Berkeley.  The name of the
 * 	University may not be used to endorse or promote
 * 	products derived from this software without specific
 * 	prior written permission.  THIS SOFTWARE IS PROVIDED
 * 	``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * 	INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * 	MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * ------------------------------------------------------------------------
 * 
 * 	Copyright 1991 D.L.S. Associates
 * 
 * 	Permission to use, copy, modify, distribute, and sell this software
 * 	and its documentation for any purpose is hereby granted without
 * 	fee, provided that the above copyright notice appear in all copies
 * 	and that both that copyright notice and this permission notice
 * 	appear in supporting documentation, and that the name of D.L.S. not
 * 	be used in advertising or publicity pertaining to distribution of
 * 	the software without specific, written prior permission.  D.L.S.
 * 	makes no representations about the suitability of this software for
 * 	any purpose.  It is provided "as is" without express or implied
 * 	warranty.
 * 
 * 	D.L.S. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * 	INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * 	NO EVENT SHALL D.L.S.  BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * 	CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * 	OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * 	NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * 	CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 * 
 * 	Authors:  Robert Hagens and Dan Schuh
 * 
 * 
 */
