/*-
 * Copyright (c) 1995 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI login_skey.c,v 1.2 1995/08/18 04:01:12 prb Exp
 */
#include <sys/types.h>
#include <sys/param.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <pwd.h>
#include <stdio.h>
#include <syslog.h>
#include <stdlib.h>
#include <login_cap.h>
#include <string.h>
#include "skey.h"

char	*getpass __P((char *));
char	*getepass __P((char *));
void	f __P((char *));
int	rseq __P((char *));
char	*rchall __P((char *));

extern char *__progname;

main(argc, argv)
	int argc;
	char **argv;
{
	FILE *back;
    	char *class = 0;
    	char *username = 0;
	struct skey skey;
	struct passwd *pwd;
	char skeyprompt[80];
	char passbuf[80];
	char *pp;
	int i;
	int c;
	int ftp = 0;
	char *instance;

	skeyprompt[0] = '\0';

	(void)signal(SIGQUIT, SIG_IGN);
	(void)signal(SIGINT, SIG_IGN);
	(void)setpriority(PRIO_PROCESS, 0, 0);

	openlog("login", LOG_ODELAY, LOG_AUTH);

    	while ((c = getopt(argc, argv, "s:")) != EOF)
		switch(c) {
		case 's':	/* service */
			if (strcmp(optarg, "login") == 0)
				ftp = 0;
			else if (strcmp(optarg, "ftp") == 0)
				ftp = 1;
			else {
				syslog(LOG_ERR, "%s: invalid service for %s",
				    optarg, __progname);
				exit(1);
			}
			break;
		default:
			syslog(LOG_ERR, "usage error for %s", __progname);
			exit(1);
		}

	switch(argc - optind) {
	case 2:
		class = argv[optind + 1];
	case 1:
		username = argv[optind];
		break;
	default:
		syslog(LOG_ERR, "usage error for %s", __progname);
		exit(1);
	}

    	if (!ftp && !(back = fdopen(3, "a")))  {
		syslog(LOG_ERR, "reopening back channel for login_skey");
		exit(1);
	}

	if (i = skeychallenge(&skey, username, skeyprompt)) {
		/*
		 * User id is invalid (as far as S/Key goes).
		 * Feed bogus challenge string, be creative...
		 */
		sprintf(skeyprompt, "S/Key %s %d %s", skeymode,
		    rseq(username), rchall(username));
	}

	printf("%s\n", skeyprompt);
	fflush(stdout);
    	if (ftp) {
		if (fgets(passbuf, sizeof(passbuf), stdin) == NULL)
			exit(1);
		rip(passbuf);
		pp = passbuf;
	} else {
		pp = getpass("S/Key Password:");
		rip(pp);
		if (strlen(pp) == 0) {
			pp = getepass("S/Key Password [echo on]: ");
			rip(pp);
		}
    	}

	if (instance = strchr(username, '.'))
		*instance = 0;

	pwd = getpwnam(username);

	if (i == 0 && skeyverify(&skey, pp) == 0
	    && pwd && pwd->pw_passwd[0] != '*' && pwd->pw_passwd[0] != '#') {
		if (!ftp) {
			if (skey.n <= 1)
				printf("Warning! You MUST change your S/Key password now!\n");
			else if (skey.n < 5)
				printf("Warning! Change S/Key password soon\n");
			fprintf(back, BI_AUTH "\n");
			if (pwd->pw_uid == 0)
				fprintf(back, BI_ROOTOKAY "\n");
			fprintf(back, BI_SECURE "\n");
		}
		exit(0);
	}
	if (!ftp)
		fprintf(back, BI_REJECT "\n");
	exit(1);
}

static u_char rhash[9] = { 0, };

static void
rfeed(s)
	char *s;
{
	int i;
	int xor = 1;
	int index = 0;
    	u_char part[8];

	if (!s)
		return;

	while (*s) {
		for (i = 0; i < 8; ++i)
			rhash[(i + index) & 7] ^= (*s & (1 << i)) ^ (xor << i);
		++s;
		++index;
	}
	f((char *)rhash);
}

/*
 * Initialize the MD4/MD5 code such that until the passwd entry which
 * is used to help initialize is changed it will always seed the
 * MD4/MD5 code the same way.
 */
static void
initr(u)
	char *u;
{
	struct passwd *pw = 0;

	if (rhash[0] == 0)
		memcpy(rhash, "!A@B#C$D", 8);

	rfeed(u);
	if ((pw = getpwnam(u)) ||
	    (pw = getpwnam("skey")) ||
	    (pw = getpwnam("root"))) {
		rfeed(pw->pw_name);
		rfeed(pw->pw_passwd);
		rfeed(pw->pw_dir);
		rfeed(pw->pw_gecos);
		rfeed(pw->pw_shell);
		rfeed(pw->pw_class);
	}
}

/*
 * Return a "random" sequence number.
 * This number should always return the same value for
 * the same string "u" until one of the conditions in initr()
 * changes.
 */
int
rseq(u)
	char *u;
{
    	int n = 0;
	int i;

	initr(u);
	f((char *)rhash);

	for (i = 0; i < 8; ++i)
		n ^= rhash[i];
	return(5 + (n % 90));
}

/*
 * Return a "random" challange.
 * This challange should always return the same value for
 * the same string "u" until one of the conditions in initr()
 * changes.
 */
char *
rchall(u)
	char *u;
{
    	static char chan[17];
	int i;

	initr(u);
	f((char *)rhash);
	for (i = 0; i < 8; ++i) {
		chan[i * 2] = "0123456789abcdef"[rhash[i] >> 4];
		chan[i * 2 + 1] = "0123456789abcdef"[rhash[i] & 0xf];
	}
	chan[16] = 0;
	return(chan);
}
