/*	BSDI skeysubr.c,v 1.3 1995/11/27 17:41:09 polk Exp */

#include <stdio.h>
#ifdef HASSTDLIB
#include <stdlib.h>
#else
#include <sys/types.h>
#endif
#include <string.h>
#ifdef	__MSDOS__
#include <dos.h>
#else	/* Assume BSD unix */
#include <fcntl.h>
#include <sgtty.h>
#endif

#include "global.h"
#include "md5.h"
#include "md4.h"
#include "skey.h"

char SKEY_MD5[] = "MD5";
char SKEY_MD4[] = "MD4";
char *skeymode = SKEY_MD5;


/* Crunch a key:
 * concatenate the seed and the password, run through MD4 and
 * collapse to 64 bits. This is defined as the user's starting key.
 */
int
keycrunch(result,seed,passwd)
char *result;	/* 8-byte result */
char *seed;	/* Seed, any length */
char *passwd;	/* Password, any length */
{
	char *buf;
	MD4_CTX md4;
	MD5_CTX md5;
	unsigned long results[4];
	unsigned int buflen;
	
	buflen = strlen(seed) + strlen(passwd);
	if((buf = malloc(buflen+1)) == NULL)
		return -1;
	strcpy(buf,seed);
	strcat(buf,passwd);

	/* Crunch the key through MD[45] */
	sevenbit(buf);

	if (skeymode == SKEY_MD5) {
		MD5Init(&md5);
		MD5Update(&md5,(unsigned char *)buf,buflen);
		MD5Final((unsigned char *)results,&md5);
	} else /* if (skeymode == SKEY_MD4) */ {
		MD4Init(&md4);
		MD4Update(&md4,(unsigned char *)buf,buflen);
		MD4Final((unsigned char *)results,&md4);
	}
	free(buf);

	results[0] ^= results[2];
	results[1] ^= results[3];

	memcpy(result,(char *)results,8);

	return 0;
}

/* The one-way function f(). Takes 8 bytes and returns 8 bytes in place */
void
f(x)
char *x;
{
	MD4_CTX md4;
        MD5_CTX md5;
	unsigned long results[4];

	if (skeymode == SKEY_MD5) {
		MD5Init(&md5);
		MD5Update(&md5,(unsigned char *)x,8);
		MD5Final((unsigned char *)results,&md5);
	} else /* if (skeymode == SKEY_MD4) */ {
		MD4Init(&md4);
		MD4Update(&md4,(unsigned char *)x,8);
		MD4Final((unsigned char *)results,&md4);
	}
	/* Fold 128 to 64 bits */
	results[0] ^= results[2];
	results[1] ^= results[3];

	/* Only works on byte-addressed little-endian machines!! */
	memcpy(x,(char *)results,8);
}

/* Strip trailing cr/lf from a line of text */
void
rip(buf)
char *buf;
{
	char *cp;

	if((cp = strchr(buf,'\r')) != NULL)
		*cp = '\0';

	if((cp = strchr(buf,'\n')) != NULL)
		*cp = '\0';
}
/************************/
#ifdef	__MSDOS__
char *
readpass(buf,n)
char *buf;
int n;
{
	int i;
	char *cp;

	for(cp=buf,i = 0; i < n ; i++)
		if ((*cp++ = bdos(7,0,0)) == '\r')
			break;
	*cp = '\0';
	printf("\n");
	rip(buf);
	return buf;
}
#else
char *
readpass(buf,n)
char *buf;
int n;
{
	int fflags,lword,lwordsav;
	struct sgttyb ttyf,ttysave;

	/* Set normal line editing */
	fflags = fcntl(fileno(stdin),F_GETFL,0);
	fcntl(fileno(stdin),F_SETFL,fflags & ~FNDELAY);
	ioctl(fileno(stdin),TIOCLGET,&lword);
	ioctl(fileno(stdin),TIOCLGET,&lwordsav);
	lword |= LCRTERA|LCRTKIL;
	ioctl(fileno(stdin),TIOCLSET,&lword);

	/* Turn off echoing */
	ioctl(fileno(stdin), TIOCGETP, &ttyf);
	ioctl(fileno(stdin), TIOCGETP, &ttysave);
	ttyf.sg_flags &= ~(ECHO|RAW|CBREAK);
	ttyf.sg_flags |= CRMOD;
	ioctl(fileno(stdin),TIOCSETP,&ttyf);
	fgets(buf,n,stdin);
	rip(buf);

	/* Restore previous tty modes */
	fcntl(fileno(stdin),F_SETFL,fflags);
	ioctl(fileno(stdin),TIOCSETP,&ttysave);
	ioctl(fileno(stdin),TIOCLSET,&lwordsav);

	/*
	after the secret key is taken from the keyboard, the line feed is
	written to standard error instead of standard output.  That means that
	anyone using the program from a terminal won't notice, but capturing
	standard output will get the key words without a newline in front of
	them. 
	*/
        fprintf(stderr, "\n");
        fflush(stderr);
	sevenbit(buf);

	return buf;
}

#endif

/* removebackspaced over charaters from the string*/
backspace(buf)
char *buf;
{
	char bs = 0x8;
	char *cp = buf;
	char *out = buf;

	while(*cp){
		if( *cp == bs ) {
			if(out == buf){
				cp++;
				continue;
			}
			else {
			  cp++;
			  out--;
			}
		}
		else {
			*out++ = *cp++;
		}

	}
	*out = '\0';
	
}
sevenbit(s)
char *s;
{
	/* make sure there are only 7 bit code in the line*/
	while(*s){
		*s = 0x7f & ( *s);
		s++;
	}
}
