/*	BSDI $Id: in_proto.c,v 2.7 1995/11/03 17:35:53 ewv Exp $	*/

/*
 * Copyright (c) 1982, 1986, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)in_proto.c	8.1 (Berkeley) 6/10/93
 */

#include <sys/param.h>
#include <sys/socket.h>
#include <sys/protosw.h>
#include <sys/domain.h>
#include <sys/mbuf.h>

#include <net/if.h>
#include <net/radix.h>
#include <net/route.h>

#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/ip_var.h>
#include <netinet/ip_icmp.h>
#include <netinet/in_pcb.h>
#include <netinet/igmp_var.h>
#include <netinet/tcp.h>
#include <netinet/tcp_fsm.h>
#include <netinet/tcp_seq.h>
#include <netinet/tcp_timer.h>
#include <netinet/tcp_var.h>
#include <netinet/tcpip.h>
#include <netinet/tcp_debug.h>
#include <netinet/udp.h>
#include <netinet/udp_var.h>
/*
 * TCP/IP protocol family: IP, ICMP, UDP, TCP.
 */

#ifdef NSIP
void	idpip_input(), nsip_ctlinput();
#endif

#ifdef TPIP
void	tpip_input(), tpip_ctlinput(), tp_ctloutput();
int	tp_init(), tp_slowtimo(), tp_drain(), tp_usrreq();
#endif

#ifdef EON
void	eoninput(), eonctlinput(), eonprotoinit();
#endif /* EON */

#ifdef MROUTING
void	ipip_input();
#endif

extern	struct domain inetdomain;

struct protosw inetsw[] = {
{ 0,		&inetdomain,	0,		0,
  0,		ip_output,	0,		0,
  0,
  ip_init,	0,		ip_slowtimo,	ip_drain,	ip_sysctl
},
{ SOCK_DGRAM,	&inetdomain,	IPPROTO_UDP,	PR_ATOMIC|PR_ADDR,
  udp_input,	0,		udp_ctlinput,	ip_ctloutput,
  udp_usrreq,
  udp_init,	0,		0,		0,		udp_sysctl
},
{ SOCK_STREAM,	&inetdomain,	IPPROTO_TCP,	PR_CONNREQUIRED|PR_WANTRCVD,
  tcp_input,	0,		tcp_ctlinput,	tcp_ctloutput,
  tcp_usrreq,
  tcp_init,	tcp_fasttimo,	tcp_slowtimo,	tcp_drain,	tcp_sysctl
},
{ SOCK_RAW,	&inetdomain,	IPPROTO_RAW,	PR_ATOMIC|PR_ADDR,
  rip_input,	rip_output,	0,		rip_ctloutput,
  rip_usrreq,
  0,		0,		0,		0,
},
{ SOCK_RAW,	&inetdomain,	IPPROTO_ICMP,	PR_ATOMIC|PR_ADDR,
  icmp_input,	rip_output,	0,		rip_ctloutput,
  rip_usrreq,
  0,		0,		0,		0,		icmp_sysctl
},
#ifdef MROUTING
{ SOCK_RAW,	&inetdomain,	IPPROTO_IPIP,	PR_ATOMIC|PR_ADDR,
  ipip_input,	rip_output,	0,		rip_ctloutput,
  rip_usrreq,/*XXX*/
  0,		0,		0,		0,
},
#endif
{ SOCK_RAW,	&inetdomain,	IPPROTO_IGMP,	PR_ATOMIC|PR_ADDR,
  igmp_input,	rip_output,	0,		rip_ctloutput,
  rip_usrreq,
  igmp_init,	igmp_fasttimo,	igmp_slowtimo,	0,
},
#ifdef TPIP
{ SOCK_SEQPACKET,&inetdomain,	IPPROTO_TP,	PR_CONNREQUIRED|PR_WANTRCVD,
  tpip_input,	0,		tpip_ctlinput,	tp_ctloutput,
  tp_usrreq,
  tp_init,	0,		tp_slowtimo,	tp_drain,
},
#endif
/* EON (ISO CLNL over IP) */
#ifdef EON
{ SOCK_RAW,	&inetdomain,	IPPROTO_EON,	0,
  eoninput,	0,		eonctlinput,		0,
  0,
  eonprotoinit,	0,		0,		0,
},
#endif
#ifdef NSIP
{ SOCK_RAW,	&inetdomain,	IPPROTO_IDP,	PR_ATOMIC|PR_ADDR,
  idpip_input,	rip_output,	nsip_ctlinput,	0,
  rip_usrreq,
  0,		0,		0,		0,
},
#endif
	/* raw wildcard */
{ SOCK_RAW,	&inetdomain,	0,		PR_ATOMIC|PR_ADDR,
  rip_input,	rip_output,	0,		rip_ctloutput,
  rip_usrreq,
  rip_init,	0,		0,		0,
},
};

struct domain inetdomain =
    { AF_INET, "internet", 0, 0, 0, 
      inetsw, &inetsw[sizeof(inetsw)/sizeof(inetsw[0])], 0,
      rn_inithead, 32, sizeof(struct sockaddr_in) };

#include "imp.h"
#if NIMP > 0
extern	struct domain impdomain;
int	rimp_output(), hostslowtimo();

struct protosw impsw[] = {
{ SOCK_RAW,	&impdomain,	0,		PR_ATOMIC|PR_ADDR,
  0,		rimp_output,	0,		0,
  rip_usrreq,
  0,		0,		hostslowtimo,	0,
},
};

struct domain impdomain =
    { AF_IMPLINK, "imp", 0, 0, 0,
      impsw, &impsw[sizeof (impsw)/sizeof(impsw[0])] };
#endif

#include "hy.h"
#if NHY > 0
/*
 * HYPERchannel protocol family: raw interface.
 */
int	rhy_output();
extern	struct domain hydomain;

struct protosw hysw[] = {
{ SOCK_RAW,	&hydomain,	0,		PR_ATOMIC|PR_ADDR,
  0,		rhy_output,	0,		0,
  rip_usrreq,
  0,		0,		0,		0,
},
};

struct domain hydomain =
    { AF_HYLINK, "hy", 0, 0, 0, hysw, &hysw[sizeof (hysw)/sizeof(hysw[0])] };
#endif

/*
 * Internet configuration info
 */
#ifndef	IPFORWARDING
#ifdef GATEWAY
#define	IPFORWARDING	1	/* forward IP packets not for us */
#else /* GATEWAY */
#define	IPFORWARDING	0	/* don't forward IP packets not for us */
#endif /* GATEWAY */
#endif /* IPFORWARDING */

#ifndef IPFORWARDSRCRT
#if !defined(IPFORWARDING) || defined(GWSCREEN)
#define	IPFORWARDSRCRT	0	/* don't forward source-routed IP packets */
#else
#define	IPFORWARDSRCRT	1	/* forward source-routed IP packets */
#endif /* GWSCREEN */
#endif /* IPFORWARDSRCRT */

#ifndef	IPSENDREDIRECTS
#define	IPSENDREDIRECTS	1
#endif

int	ipforwarding = IPFORWARDING;		/* act as router? */
int	ipforward_srcrt = IPFORWARDSRCRT;	/* forward src-routed? */
int	ipsendredirects = IPSENDREDIRECTS;
int	ip_defttl = IPDEFTTL;

/*
 * If ip_input is compiled with GWSCREEN, it will call via ip_forward_fn
 * to forward packets.  The same binary will work for systems compiled
 * with or without GWSCREEN by initializing ip_forward_fn here
 * depending on the configuration when this (config-dependent) file
 * is compiled.
 */
#ifdef GWSCREEN
void ip_forwardscreen __P((struct mbuf *, int));
void (*ip_forward_fn) __P((struct mbuf *, int)) = ip_forwardscreen;
#else
void ip_forward __P((struct mbuf *, int));
void (*ip_forward_fn) __P((struct mbuf *, int)) = ip_forward;
#endif

#ifndef MROUTING
/* dummies when MROUTING is not defined */
int	ip_mrtproto;				/* for netstat only */
struct	socket *ip_mrouter;

int
ip_mrouter_set(cmd, so, m)
	int cmd;
	struct socket *so;
	struct mbuf *m;
{
	return (EOPNOTSUPP);
}

int
ip_mrouter_get(cmd, so, m)
	int cmd;
	struct socket *so;
	struct mbuf *m;
{
	return (EOPNOTSUPP);
}

int
mrt_ioctl(cmd, data)
	int cmd;
	caddr_t data;
{
	return (EINVAL);
}

ip_mrouter_done() { ; }

int
ip_mforward(ip, ifp, m)
	struct ip *ip;
	struct ifnet *ifp;
	struct mbuf *m;
{

	return (0);
}
#endif /* !MROUTING */

/* raw IP parameters */
/*
 * Nominal space allocated to a raw ip socket.
 */
#define	RIPSNDQ		8192
#define	RIPRCVQ		8192

u_long	rip_sendspace = RIPSNDQ;
u_long	rip_recvspace = RIPRCVQ;

/* ICMP parameters */
#ifdef GATEWAY
int	icmpmaskrepl = 1;
#else
int	icmpmaskrepl = 0;
#endif
int	icmp_rediraccept = 1;		/* accept and process redirects */
int	icmp_redirtimeout = 10 * 60;	/* 10 minutes */

/* TCP parameters */
int	tcp_sendspace = 1024 * 8;
int	tcp_recvspace = 1024 * 8;
int 	tcp_mssdflt = TCP_MSS;
int 	tcp_rttdflt = TCPTV_SRTTDFLT / PR_SLOWHZ;
int	tcp_do_rfc1323 = 1;
int	tcp_conntimeo = TCPTV_KEEP_INIT;	/* initial connection timeout */
/*
 * Parameters for keepalive option.
 * Connections for which SO_KEEPALIVE is set will be probed
 * after being idle for a time of tcp_keepidle (in units of PR_SLOWHZ).
 * Starting at that time, the connection is probed at intervals
 * of tcp_keepintvl (same units) until a response is received
 * or until tcp_keepcnt probes have been made, at which time
 * the connection is dropped.  Note that a tcp_keepidle value
 * under 2 hours is nonconformant with RFC-1122, Internet Host Requirements.
 */
int	tcp_keepidle = TCPTV_KEEP_IDLE;		/* time before probing idle */
int	tcp_keepintvl = TCPTV_KEEPINTVL;	/* interval betwn idle probes */
int	tcp_keepcnt = TCPTV_KEEPCNT;		/* max idle probes */
int	tcp_maxpersistidle = TCPTV_KEEP_IDLE;	/* max idle time in persist */

/*
 * Parameters for computing a desirable data segment size
 * given an upper bound (either interface MTU, or peer's MSS option)_.
 * As applications tend to use a buffer size that is a multiple
 * of kilobytes, try for something that divides evenly. However,
 * do not round down too much.
 *
 * Round segment size down to a multiple of TCP_ROUNDSIZE if this
 * does not result in lowering by more than (size/TCP_ROUNDFRAC).
 * For example, round 536 to 512.  Older versions of the system
 * effectively used MCLBYTES (1K or 2K) as TCP_ROUNDSIZE, with
 * a value of 1 for TCP_ROUNDFRAC (eliminating its effect).
 * We round to a multiple of 256 for SLIP.
 */
#ifndef	TCP_ROUNDSIZE
#define	TCP_ROUNDSIZE	256	/* round to multiple of 256 */
#endif
#ifndef	TCP_ROUNDFRAC
#define	TCP_ROUNDFRAC	10	/* round down at most N/10, or 10% */
#endif

int	tcp_roundsize = TCP_ROUNDSIZE;
int	tcp_roundfrac = TCP_ROUNDFRAC;

int
tcp_mss_round(val)
	int val;
{
	int frag;

	if (val > tcp_roundsize &&
	    (frag = val % tcp_roundsize) <= val / tcp_roundfrac)
		val -= frag;
	return (val);
}

/* UDP parameters */
int	udp_sendspace = 9216;		/* really max datagram size */
int	udp_recvspace = 40 * (1024 + sizeof(struct sockaddr_in));
					/* 40 1K datagrams */
