/*-
 * Copyright (c) 1993, 1994, 1995 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: if_p2pproto.c,v 2.4 1995/12/08 19:56:31 prb Exp $
 */

/*
 * Common code for point-to-point synchronous serial links
 */

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/kernel.h>
#include <sys/malloc.h>
#include <sys/mbuf.h>
#include <sys/protosw.h>
#include <sys/socket.h>
#include <sys/ioctl.h>

#include <net/if.h>
#include <net/netisr.h>
#include <net/route.h>
#include <net/if_dl.h>
#include <net/if_types.h>

#if INET
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>		/* XXX for slcompress */
#endif

#include <net/if_p2p.h>
#include <net/bpf.h>


extern int p2p_hdr();

#ifdef CISCO_HDLC
extern int c_hdlc_attach(), c_hdlc_init(), c_hdlc_output(), c_hdlc_input();
extern void c_hdlc_detach(), c_hdlc_shutdown();
#endif
#ifdef PPP
#include <net/slcompress.h>
extern int ppp_attach(), ppp_init(), ppp_output(), ppp_input(), ppp_ioctl(),
	   ppp_modem(), ppp_hdr();
extern void ppp_detach(), ppp_shutdown();
#endif


/*
 * The table of available point-to-point encapsulation protocols
 */
struct p2pprotosw p2pprotosw[] = {
	/* UNITIALIZED STATE */
{	IFT_NONE,
	0 /*attach*/,	0 /*detach*/,	0 /*init*/,	0 /*shutdown*/,
	0 /*output*/,	0 /*input*/,	0 /*ioctl*/, 	0 /*modem*/,
	0 /*hdr*/,	0 /*cskip*/,	DLT_NULL,	0 /*hdrlen*/,
},
#ifdef CISCO_HDLC
{	IFT_PTPSERIAL,
	c_hdlc_attach,	c_hdlc_detach,	c_hdlc_init,	c_hdlc_shutdown,
	c_hdlc_output,	c_hdlc_input,	0,		0,
	p2p_hdr,	16,		DLT_C_HDLC,	0,
},
#endif
#ifdef PPP
{	IFT_PPP,
	ppp_attach,	ppp_detach,	ppp_init,	ppp_shutdown,
	ppp_output,	ppp_input,	ppp_ioctl,	ppp_modem,
	ppp_hdr,	120,		DLT_PPP,	SLC_BPFHDR,
},
#endif
};

int np2pproto = (sizeof p2pprotosw / sizeof p2pprotosw[0]);
