/*	BSDI $Id: sys_sem.c,v 2.1 1995/02/03 07:53:48 polk Exp $	*/

/*
 * Copyright (c) 1991 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	%W% (Berkeley) %G%
 */

#include <sys/param.h>
#include <sys/proc.h>
#include <sys/kernel.h>
#include <sys/semaphore.h>

#define	MAX_SEM_SLEEP	5

static char wakeupaddr;

/* ARGSUSED */
int
sem_lock(p, uap, retval)
	struct proc *p;
	struct args {
		sem_t	 *addr;
	} *uap;
	int *retval;
{
	sem_t sem;
	int error;

	/* Get a copy of the user's lock. */
	if (error = copyin((caddr_t)uap->addr, (caddr_t)&sem, sizeof(sem_t)))
		return (error);

	/*
	 * XXX
	 * If lock available, turn off the want flag and return.  Else turn
	 * on the want flag and sleep.	The granularity of the sleep address
	 * is currently a single address for all processes.  Until we move
	 * to a multi-processor implementation there's no reason for finer
	 * granularity since the scheduler will serialize access to the lock,
	 * and the lock should be released by the time the process quantum
	 * has expired.	 Set a maximum delay just in case a process gets lost.
	 */
	sem.want = SEM_SPIN_ISLOCKED(&sem.lock) ? 1 : 0;
	if (error = copyout((caddr_t)&sem, (caddr_t)uap->addr, sizeof(sem_t)))
		return (error);

	if (sem.want) {
		error = tsleep((caddr_t)&wakeupaddr,
		    PCATCH | PLOCK, "semaphore", MAX_SEM_SLEEP * hz);
		if (error == EINTR || error == ERESTART)
			return (EINTR);
	}
	return (0);
}

int
sem_wakeup(p, uap, retval)
	struct proc *p;
	struct args {
		sem_t	 *addr;
	} *uap;
	int *retval;
{
	sem_t sem;
	int error;

	/* Get a copy of the user's lock. */
	if (error = copyin((caddr_t)uap->addr, (caddr_t)&sem, sizeof(sem_t)))
		return (error);

	/*
	 * Turn off the want flag, unlock the lock, copy back into the
	 * user's space and return.
	 */
	sem.want = 0;
	SEM_SPIN_UNLOCK(&sem.lock);

	if (error = copyout((caddr_t)&sem, (caddr_t)uap->addr, sizeof(sem_t)))
		return (error);

	wakeup((caddr_t)&wakeupaddr);
	return (0);
}
