/*-
 * Copyright (c) 1992, 1994 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: trap.c,v 2.1 1995/02/03 07:49:29 polk Exp $
 */
 
/*-
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * the University of Utah, and William Jolitz.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)trap.c	8.4 (Berkeley) 9/23/93
 */

/*
 * 386 Trap Handling
 */

#define KERNEL
#include <sys/cdefs.h>
#include <sys/types.h>
#include <i386/include/cpu.h>
#include <i386/include/psl.h>
#include <i386/include/reg.h>
#include <i386/include/trap.h>
#include <i386/include/param.h>
#include <i386/include/tss.h>


void *lidtdata;
int lidtsize;


char	badtrap[] = "reserved type";
char	*trap_type[] = {
	 badtrap,			/* T_RESADFLT	0 */
	"illegal instruction",		/* T_PRIVINFLT	1 */
	 badtrap,			/* T_RESOPFLT	2 */
	"breakpoint instruction",	/* T_BPTFLT	3 */
	 badtrap,			/* T_UNUSED	4 */
	 badtrap,			/* T_SYSCALL	5 */
	"arithmetic trap",		/* T_ARITHTRAP	6 */
	"ast",				/* T_ASTFLT	7 */
	 badtrap,			/* T_SEGFLT	8 */
	"protection fault",		/* T_PROTFLT	9 */
	"trace trap",			/* T_TRCTRAP	10 */
	 badtrap,			/* T_UNUSED2	11 */
	"page fault",			/* T_PAGEFLT	12 */
	 badtrap,			/* T_TABLEFLT	13 */
	"alignment fault",		/* T_ALIGNFLT	14 */
	 badtrap,			/* T_KSPNOTVAL	15 */
	 badtrap,			/* T_BUSERR	16 */
	 badtrap,			/* T_KDBTRAP	17 */
	"integer divide fault",		/* T_DIVIDE	18 */
	"non-maskable intr",		/* T_NMI	19 */
	"overflow trap",		/* T_OFLOW	20 */
	"bounds check",			/* T_BOUND	21 */
	"device not available fault",	/* T_DNA	22 */
	"double fault",			/* T_DOUBLEFLT	23 */
	"fp segment overrun",		/* T_FPOPFLT	24 */
	"invalid tss fault",		/* T_TSSFLT	25 */
	"segment not present fault",	/* T_SEGNPFLT	26 */
	"stack fault",			/* T_STKFLT	27 */
	 badtrap,			/* T_RESERVED_15	28 */
	 badtrap,			/* T_RESERVED_18	29 */
	 badtrap,			/* T_RESERVED_19	30 */
	 badtrap,			/* T_RESERVED_20	31 */
	 badtrap,			/* T_RESERVED_21	32 */
	 badtrap,			/* T_RESERVED_22	33 */
	 badtrap,			/* T_RESERVED_23	34 */
	 badtrap,			/* T_RESERVED_24	35 */
	 badtrap,			/* T_RESERVED_25	36 */
	 badtrap,			/* T_RESERVED_26	37 */
	 badtrap,			/* T_RESERVED_27	38 */
	 badtrap,			/* T_RESERVED_39	39 */
	 badtrap,			/* T_RESERVED_29	40 */
	 badtrap,			/* T_RESERVED_30	41 */
	 badtrap,			/* T_RESERVED_31	42 */
};
#define	TRAP_TYPES	(sizeof trap_type / sizeof(trap_type[0]))

void
trap(frame)
	volatile struct trapframe frame;
{
	int type, eva;
	extern int bootdebug;

	eva = rcr2();
	type = frame.tf_trapno;
	
	if (type == T_NMI) {
		if (bootdebug)
			printf("nmi trap\n");
		return;
	}

	printf("trap type %d code = %x eip = %x cs = %x eflags = %x ",
	    frame.tf_trapno, frame.tf_err, frame.tf_eip,
	    frame.tf_cs, frame.tf_eflags);
	printf("cr2 %x\n", eva);
	if ((unsigned)type < TRAP_TYPES)
		printf("unexpected trap: %s\n", trap_type[type]);
	reboot();
}

/* interrupt descriptor table */
struct gate_descriptor idt[32+16];

setidt(idx, func, typ, dpl, sel)
	char *func;
{
	struct gate_descriptor *ip = idt + idx;

	ip->gd_looffset = (int)func;
	ip->gd_selector = sel;
	ip->gd_stkcpy = 0;
	ip->gd_xx = 0;
	ip->gd_type = typ;
	ip->gd_dpl = dpl;
	ip->gd_p = 1;
	ip->gd_hioffset = ((int)func) >> 16;
}

#define	IDTVEC(name)	__CONCAT(X, name)
extern	IDTVEC(div), IDTVEC(dbg), IDTVEC(nmi), IDTVEC(bpt), IDTVEC(ofl),
	IDTVEC(bnd), IDTVEC(ill), IDTVEC(dna), IDTVEC(fpusegm),
	IDTVEC(tss), IDTVEC(missing), IDTVEC(stk), IDTVEC(prot),
	IDTVEC(page), IDTVEC(rsvd), IDTVEC(fpu), IDTVEC(align),
	IDTVEC(rsvd1), IDTVEC(rsvd2), IDTVEC(rsvd3), IDTVEC(rsvd4),
	IDTVEC(rsvd5), IDTVEC(rsvd6), IDTVEC(rsvd7), IDTVEC(rsvd8),
	IDTVEC(rsvd9), IDTVEC(rsvd10), IDTVEC(rsvd11), IDTVEC(rsvd12),
	IDTVEC(rsvd13), IDTVEC(rsvd14), IDTVEC(rsvd14), IDTVEC(syscall);

/* XXX need code to set up tss, load task register */
struct i386tss tss;

double_fault_handler()
{

	printf("double fault: eip=%x esp=%x\n", tss.tss_eip, tss.tss_esp);
a:	goto a;
}


trapinit()
{
	int sel;

	/* exceptions */
	sel = GSEL(GCODE_SEL, SEL_KPL);
	setidt(0, &IDTVEC(div),  SDT_SYS386TGT, SEL_KPL, sel);
	setidt(1, &IDTVEC(dbg),  SDT_SYS386TGT, SEL_KPL, sel);
	setidt(2, &IDTVEC(nmi),  SDT_SYS386TGT, SEL_KPL, sel);
 	setidt(3, &IDTVEC(bpt),  SDT_SYS386TGT, SEL_UPL, sel);
	setidt(4, &IDTVEC(ofl),  SDT_SYS386TGT, SEL_KPL, sel);
	setidt(5, &IDTVEC(bnd),  SDT_SYS386TGT, SEL_KPL, sel);
	setidt(6, &IDTVEC(ill),  SDT_SYS386TGT, SEL_KPL, sel);
	setidt(7, &IDTVEC(dna),  SDT_SYS386TGT, SEL_KPL, sel);
	setidt(9, &IDTVEC(fpusegm),  SDT_SYS386TGT, SEL_KPL, sel);
	setidt(10, &IDTVEC(tss), SDT_SYS386TGT, SEL_KPL, sel);
	setidt(11, &IDTVEC(missing),  SDT_SYS386TGT, SEL_KPL, sel);
	setidt(12, &IDTVEC(stk), SDT_SYS386TGT, SEL_KPL, sel);
	setidt(13, &IDTVEC(prot),  SDT_SYS386TGT, SEL_KPL, sel);
	setidt(14, &IDTVEC(page),  SDT_SYS386TGT, SEL_KPL, sel);
	setidt(15, &IDTVEC(rsvd),  SDT_SYS386TGT, SEL_KPL, sel);
	setidt(16, &IDTVEC(fpu),  SDT_SYS386TGT, SEL_KPL, sel);
	setidt(17, &IDTVEC(align),  SDT_SYS386TGT, SEL_KPL, sel);
	setidt(18, &IDTVEC(rsvd1),  SDT_SYS386TGT, SEL_KPL, sel);
	setidt(19, &IDTVEC(rsvd2),  SDT_SYS386TGT, SEL_KPL, sel);
	setidt(20, &IDTVEC(rsvd3),  SDT_SYS386TGT, SEL_KPL, sel);
	setidt(21, &IDTVEC(rsvd4),  SDT_SYS386TGT, SEL_KPL, sel);
	setidt(22, &IDTVEC(rsvd5),  SDT_SYS386TGT, SEL_KPL, sel);
	setidt(23, &IDTVEC(rsvd6),  SDT_SYS386TGT, SEL_KPL, sel);
	setidt(24, &IDTVEC(rsvd7),  SDT_SYS386TGT, SEL_KPL, sel);
	setidt(25, &IDTVEC(rsvd8),  SDT_SYS386TGT, SEL_KPL, sel);
	setidt(26, &IDTVEC(rsvd9),  SDT_SYS386TGT, SEL_KPL, sel);
	setidt(27, &IDTVEC(rsvd10),  SDT_SYS386TGT, SEL_KPL, sel);
	setidt(28, &IDTVEC(rsvd11),  SDT_SYS386TGT, SEL_KPL, sel);
	setidt(29, &IDTVEC(rsvd12),  SDT_SYS386TGT, SEL_KPL, sel);
	setidt(30, &IDTVEC(rsvd13),  SDT_SYS386TGT, SEL_KPL, sel);
	setidt(31, &IDTVEC(rsvd14),  SDT_SYS386TGT, SEL_KPL, sel);

	/* XXX need code to set up tss, load task register */
	sel = GSEL(GPANIC_SEL, SEL_KPL);
	setidt(8, 0, SDT_SYSTASKGT, SEL_KPL, sel);	/* double fault */

	lidtsize = sizeof(idt) - 1;
	lidtdata = idt;
	lidt(lidtdata, lidtsize);
}
