/*-
 * Copyright (c) 1994, 1995 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: stand.h,v 2.2 1995/10/26 04:00:54 karels Exp $
 */

#define WD_MAJORDEV	3	/* from conf.c */
#define FD_MAJORDEV	9	/* from conf.c */
#define SD_MAJORDEV	18	/* from conf.c */
#define SR_MAJORDEV	34	/* from conf.c */
#define BD_MAJORDEV	0

#define ISO_DEFAULT_BLOCK_SIZE	2048 
#define ISO_DEFAULT_BLOCK_SIZE_SHIFT	11

/*
 * For SCSI, ORing TWOK_BLOCKS into the adapter field
 * indicates use of a CD-ROM with 2K blocks.
 */
#define TWOK_BLOCKS	0x8


#ifndef SMALL
#define	KB_ABORT			/* abort I/O on keyboard input */
#endif

/* convert kilobytes to a multiple of the page size, in bytes */
#define k2truncpage(k)  (((k) * 1024) &~ (NBPG - 1))


#ifndef LOCORE
/*
 * Machine-dependent fields in standalone file structure.
 */
typedef struct iob {
	int	i_adapt;	/* adapter (XXX) */
	int	i_ctlr;		/* controller index */
	int	i_unit;		/* disk unit */
	int	i_part;		/* and partition */
	daddr_t	i_boff;
	struct	open_file *i_open_file;

	daddr_t	is_bn;		/* only used by scsi */
	char	*is_ma;		/* only used by scsi */
	u_int	is_cc;		/* only used by scsi */
	u_int	i_dbs;		/* dev block size of device */
	u_int	i_dbshift;	/* dev block shift value */
} iob_t;


struct boot_options {
	int	o_basemem;
	int	o_searchend;		/* -1 means use CMOS */
	int	o_extmem;
	int	o_changedisk;
	int	o_howto;
	int	o_loaded;
	int	o_entry;
	int	o_rootdev;
	int	o_rootdevset;
};

void	wait __P((int));
void	configure __P((void));
void	sizemem __P((struct boot_options *));
extern	int bootdebug;
#endif
