/*-
 * Copyright (c) 1994 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *      $Id: reboot.c,v 2.1 1995/02/03 07:49:02 polk Exp $
 */

#include <sys/param.h>
#include <i386/stand/bioscall.h>

/*
 * Reboot system, but wait for input first;
 * allow user time to read any messages,
 * and avoid continuous unattended reboot cycle.
 */
reboot()
{
	struct bios_args ba;

	printf("\nRelease CTRL and ALT, then press <CTRL-ALT-DEL> to reboot\n");
	printf("or press the reset button\n");
	bzero(&ba, sizeof(ba));
	while (1) {
		ba.ba_ax = 0;
		bios_call(0x16, &ba);
/* printf("got %x (%c)\n", ba.ba_ax, ba.ba_al); */
	}
}
