/*
 * Copyright (c) 1991, 1992, 1994, 1995 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: md-i386.c,v 2.2 1995/12/02 05:40:37 karels Exp $
 *
 * Machine-dependent code for devops lookup.
 */

#include <sys/param.h>
#include <sys/reboot.h>

#include <stand/stand.h>
#include <i386/stand/stand.h>
#include <string.h>

int	bootdebug = 0;		/* initialize to make patching easy */

#ifdef SMALL
/*
 * Small bootstraps have only one driver; propagate its
 * information and return its ops pointer.
 */

int
devopen(f)
	struct open_file *f;
{
	extern int bootdev;
	extern struct devsw devops;
	static struct iob iob;

	iob.i_adapt = B_ADAPTOR(bootdev);
	iob.i_ctlr = B_CONTROLLER(bootdev);
	iob.i_unit = B_UNIT(bootdev);
	iob.i_part = B_PARTITION(bootdev);
	iob.i_open_file = f;
	f->f_dev = &devops;
	f->f_devdata = &iob;
	return (devops.dv_open((void*)&iob));
}

#else /* SMALL */

/*
 * Full-size bootstraps have multiple drivers, named via xx(args).
 */

int	opendev;

/*
 * Decode a device specifier as an optional prefix to a filename,
 * expressed as:
 *	devname([[[[adapter,] controller,] unit,] part])
 * with missing components treated as zero.
 * If no such prefix is found (i.e. the open paren is not present),
 * the device is the boot device.
 *
 * The device value is returned in the standard bootdev encoding,
 * or -1 is returned if the prefix is malformed.
 * The checks for malformed strings are less than exhaustive.
 */
int
dev_decode(spec, filename)
	char *spec, **filename;
{
	register int i, d;
	int len;
	char *params;
	char *p;
	int nparam = 0;
	int paramval[4];
	int adapt, ctlr, unit, part;
	extern int bootdev;
	extern int ndevs;
	extern struct devsw *devsw[];

	/*
	 * Parse the file spec.
	 * First step: get the device name and map it to a device number.
	 */
	if ((params = index(spec, '(')) == 0) {
		if (filename)
			*filename = spec;
		return (bootdev);
	}

	len = params - spec;

	for (d = 0; d < ndevs; ++d)
		if (devsw[d] && devsw[d]->dv_name &&
		    strlen(devsw[d]->dv_name) == len &&
		    bcmp(devsw[d]->dv_name, spec, len) == 0)
			goto found;
	return (-1);
found:
	/*
	 * Find closing parenthesis.
	 */
	if ((p = index(params, ')')) == 0)
		return (-1);
	if (filename)
		*filename = p + 1;

	/*
	 * Parse the comma-delimited list of numbers in the spec.
	 * It looks like this: [[[[adapter,] controller,] unit,] part]
	 * Missing values are assumed to be 0.
	 */
	for (++params; nparam < 4; params = p + 1) {
		paramval[nparam++] = strtol(params, &p, 0);
		if (*p == ')')
			break;
		if (*p != ',')
			return (-1);
	}
	if (*p != ')')
		return (-1);
	i = 0;
	adapt = ctlr = unit = part = 0;
	switch (nparam) {
	case 4:
		adapt = paramval[i++];
	case 3:
		ctlr = paramval[i++];
	case 2:
		unit = paramval[i++];
	case 1:
		part = paramval[i++];
	case 0:
		break;
	}
	return (MAKEBOOTDEV(d, adapt, ctlr, unit, part));
}

/*
 * Machine-dependent part of open: determine device, and set up
 * device addressing information in machine-dependent part
 * of open_file struct.
 */
int
devopen(f, spec, filename)
	struct open_file *f;
	char *spec, **filename;
{
	register int i, d;
	char *params;
	char *p;
	int dev;
	extern int bootdev;
	extern int ndevs;
	extern struct devsw *devsw[];
	struct iob *io;

	dev = dev_decode(spec, filename);
	if (dev == -1)
		return (EINVAL);

	io = alloc(sizeof *io);
	io->i_open_file = f;
	f->f_devdata = io;
	d = B_TYPE(dev);
	f->f_dev = devsw[d];

	io->i_adapt = B_ADAPTOR(dev);
	io->i_ctlr = B_CONTROLLER(dev);
	io->i_unit = B_UNIT(dev);
	io->i_part = B_PARTITION(dev);
	opendev = dev;
	return (f->f_dev->dv_open((void *)io));
}

#endif /* !SMALL */
