/*	BSDI $Id: lib.c,v 1.1 1995/10/26 01:18:48 karels Exp $	*/

static unsigned char ibuf[8192];
static unsigned char *ihead = ibuf;
static unsigned char *itail = ibuf;

static char malloc_buf[256 * 1024];
static char *malloc_ptr = malloc_buf;

static lib_input = 0;

int
funzip(int fd)
{
	char *av[2];
	av[0] = "boot";
	av[1] = 0;

	funzip_main(1, av);
}

int
lib_storebytes(char *buf, int nbytes)
{
	int r = funzip_process(buf, nbytes);

	if (r < 0)
		lib_input = -1;
	return(r);
}
lib_fprintf(int file, char *fmt, long a1, long a2, long a3, long a4, long a5)
{
	printf(fmt, a1, a2, a3, a4, a5);
}

lib_nextbyte()
{
	int r;

	if (ihead >= itail) {
		itail = ihead = ibuf;
		if ((r = read(lib_input, ibuf, sizeof(ibuf))) <= 0)
			return(-1);
		itail += r;
	}
	return(*ihead++);
}

lib_nextbytes(char *buf, int nbytes)
{
	int c;
	int cnt = 0;

	while (nbytes-- > 0 && (c = lib_nextbyte()) != -1) {
		*buf++ = c;
		++cnt;
	}
	return(cnt);
}

memset(void *vdst, int c, int cnt)
{
	char *dst = (char *)vdst;

	while (cnt-- > 0)
		*dst++ = c;
}

memcpy(void *vdst, void *vsrc, int cnt)
{
	char *dst = (char *)vdst;
	char *src = (char *)vsrc;

	while (cnt-- > 0)
		*dst++ = *src++;
}

void *
malloc(int size)
{
	char *ret = 0;
    	if (malloc_ptr + size <= malloc_buf + sizeof(malloc_buf)) {
		ret = malloc_ptr;
		malloc_ptr += size;
		return(ret);
	}
	return(0);
}
