/*-
 * Copyright (c) 1994, 1995 Berkeley Software Design, Inc.  All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: configure.c,v 2.6 1996/01/11 16:37:59 karels Exp $
 */

#include <sys/param.h>
#include <sys/reboot.h>
#include <sys/device.h>
#include <i386/include/cpu.h>
#include <i386/isa/isa.h>
#include <i386/isa/isavar.h>
#include <i386/isa/icu.h>
#include <i386/isa/rtc.h>
#include <machine/psl.h>
#include <stand/stand.h>
#include <i386/stand/stand.h>
#include <i386/stand/bioscall.h>

extern struct bootparam *getbootparam __P((int, struct bootparam *));
extern int cpu;

void
configure()
{
	struct bootparam *bp;

	if (bootdebug) {
		char *type;

		switch (cpu) {
		case CPU_386SX:
		case CPU_386:
			type = "80386";
			break;
		case CPU_486SX:
		case CPU_486:
			type = "80486";
			break;
		case CPU_586:
			type = "Pentium"; /* (tm */
			break;
		default:
			type = "unk";
			break;
		}
		printf("cpu = %s\n", type);
	}

	if ((bp = getbootparam(B_BIOSGEOM, NULL)) == NULL)
		printf("no biosgeom???\n");
	else if (bp->b_len < sizeof(struct bootparam) +
	    4 * sizeof(struct biosgeom))
		printf("biosgeom too small, old 2nd stage boot blks\n");
	else {
		checkcmosgeom(0, &(((struct biosgeom *)B_DATA(bp))[0]));
		checkcmosgeom(1, &(((struct biosgeom *)B_DATA(bp))[1]));
		/*
		 * Get bios geometry for C:, D:
		 * biosgeom[0] and biosgeom[1] are CMOS info from INT 0x41/46;
		 * now get info from a BIOS call, to see what the BIOS
		 * actually uses.
		 */
		getbiosgeom(0x80, &(((struct biosgeom *)B_DATA(bp))[2]));
		getbiosgeom(0x81, &(((struct biosgeom *)B_DATA(bp))[3])); 
	}
}

printgeom(bgp)
	struct biosgeom *bgp;
{

	printf(" %d sectors %d heads %d cylinders\n",
	    bgp->nsectors, bgp->ntracks, bgp->ncylinders);
}

checkcmosgeom(unit, bgp)
	int unit;
	struct biosgeom *bgp;
{

	if (bootdebug) {
		printf("CMOS geom for %c:", "CD"[unit]);
		if (bgp->flags & BIOSGEOM_PRESENT)
			printgeom(bgp);
		else
			printf(" none\n");
	}
	if ((bgp->flags & BIOSGEOM_PRESENT) && bgp->ntracks > 16) {
		/* check for enhanced IDE encoding */
		printf("Warning, CMOS geometry for %c: is mapped, %s\n",
		   "CD"[unit], "too many heads");
		printf("Mapped geometry:");
		printgeom(bgp);
		/*
		 * The following is based on the enhanced IDE proposal
		 * in the Western Digital Enhanced IDE Implementation Guide,
		 * Revision 5.0, Nov 1993.
		 */
		if (bgp->flags & BIOSGEOM_EIDE) {
			bgp->nsectors = bgp->esectors;
			bgp->ntracks = bgp->etracks;
			bgp->ncylinders = bgp->ecyl[0] | (bgp->ecyl[1] << 8);
			bgp->flags |= BIOSGEOM_MAPPED;
			printf("Drive geometry:");
			printgeom(bgp);
		} else {
			printf("No EIDE information.  Faking it.\n");
			while (bgp->ntracks > 16) {
				bgp->ntracks /= 2;
				bgp->ncylinders *= 2;
			}
			bgp->flags |= BIOSGEOM_MAPPED;
			printf("Faked Drive geometry:");
			printgeom(bgp);
		}
	}
}

getbiosgeom(unit, bgp)
	int unit;
	struct biosgeom *bgp;
{
	struct bios_args ba;

	if (bootdebug) {
		printf("Press <ENTER> for BIOS geom for %c:", "CD"[unit&~0x80]);
		switch (cngetc()) {
		case '\n':
		case '\r':
			break;
		default:
			printf(" skipped\n");
			return;
		}
	}
	/*
	 * Some BIOS routines (e.g. on some SCSI host adapters)
	 * hang if we try to read drive parameters for a drive
	 * that is not present.  We first call to check whether
	 * the disk is present, then read the drive parameters if so.
	 */
	bzero(&ba, sizeof(ba));
	ba.ba_ah = 0x15;	/* read "DASD" type, check if disk present */
	ba.ba_dl = unit;
	bios_call(0x13, &ba);

	if (ba.ba_ah == 3) {	/* 3 indicates fixed disk present */
		bzero(&ba, sizeof(ba));
		ba.ba_ah = 0x8;		/* read drive parameters */
		ba.ba_dl = unit;
		bios_call(0x13, &ba);
	} else
		ba.ba_flags = PSL_C;
	if ((ba.ba_flags & PSL_C) == 0) {
		bgp->ncylinders = ((ba.ba_cl & 0xc0) << 2) + ba.ba_ch + 1;
		bgp->ntracks = ba.ba_dh + 1;
		bgp->nsectors = (ba.ba_cl & 0x3f);
		bgp->flags = BIOSGEOM_PRESENT;
		if (bootdebug)
			printgeom(bgp);
	} else if (bootdebug)
		printf(" none\n");
}
