/*-
 * Copyright (c) 1992, 1993, 1994, 1995 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: com.c,v 2.3 1995/11/16 02:15:17 karels Exp $
 */

/*-
 * Copyright (c) 1991, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	derived from @(#)com.c		8.1 (Berkeley) 6/11/93
 */

#include <stand/stand.h>
#include <sys/reboot.h>

#include <i386/isa/comreg.h>
#include <i386/isa/isa.h>
#include <i386/isa/ic/ns16550.h>

#define FIFO_TRIGGER FIFO_TRIGGER_4

int	comport = IO_COM1;
int	comrate = 9600;
static	u_short comports[] = { IO_COM1, IO_COM2, IO_COM3, IO_COM4 };

comcninit()
{
	int rate;

	outb(comport+com_cfcr, CFCR_DLAB);
#define divrnd(n, q)	(((n) * 2 / (q) + 1) / 2) /* divide and round off */
	rate = divrnd(COMTICK, comrate);
#undef divrnd
	outb(comport+com_dlbl, rate & 0xFF);
	outb(comport+com_dlbh, rate >> 8);
	outb(comport+com_cfcr, CFCR_8BITS);
	outb(comport+com_ier, IER_ERXRDY | IER_ETXRDY | IER_ERLS);
	outb(comport+com_mcr, MCR_ON);
	outb(comport+com_fifo,
	    FIFO_ENABLE|FIFO_RCV_RST|FIFO_XMT_RST|FIFO_TRIGGER);
	inb(comport+com_iir);
#ifndef SMALL
	/*
	 * drain part 
	 */
	while (comcnpoll())
		;
#endif
	/*
	 * Return 1 if carrier is on, 0 otherwise.
	 * (This is ignored if we were directed to use the serial console.)
	 */
	return ((inb(comport+com_msr) & MSR_DCD) != 0);
}

#ifndef SMALL
/*
 * Process console assignment to a com port.
 * Used only in /boot; could be elsewhere so standalong programs
 * wouldn't load this.
 */
setcomconsole(p, bc)
	char *p;
	struct bootcons *bc;
{
	int unit, val;
	char *p2;
	extern int comconsole;
	extern char *index();

	/*
	 * Supported inputs:
	 *	com			unit 0
	 *	com n [port [speed]]	unit n, optional port and speed
	 */
	p += sizeof("com") - 1;
	unit = strtol(p, &p2, 0);
	if (p2 != p && (p2 = index(p2, ' ')) && (val = strtol(p2, &p, 0)))
		comport = val;
	else if (unit < sizeof(comports) / sizeof(comports[0]))
		comport = comports[unit];
	else {
		printf("port for com%d unknown\n", unit);
		return (ENXIO);
	}
	if (p2 != p && (p2 = index(p, ' '))) {
		val = strtol(p2, NULL, 0);
		if (val)
			comrate = val;
	}
	(void) comcninit();
	comconsole = 1;
	bc->type = BOOTCONS_COM;
	bc->unit = unit;
	bc->val0 = comport;
	bc->val1 = comrate;
	return (0);
}

/*
 * input character routine.  Assumes that interrupts are off.
 */
int
comcngetc()
{
	short stat;
	int c;

	while ((inb(comport+com_lsr) & LSR_RXRDY) == 0)
		;
	c = inb(comport+com_data);
	stat = inb(comport+com_iir);
	return (c & 0x7f);
}

int
comcnpoll()
{

	if (inb(comport+com_lsr) & LSR_RXRDY) {
		do
			(void) comcngetc();
		while (inb(comport+com_lsr) & LSR_RXRDY);
		return (1);
	}
	return (0);
}
#endif

void
comcnputc(c)
	int c;
{
	register int timo;
	short stat;

	/* wait for any pending transmission to finish */
	timo = 50000;
	while (((stat = inb(comport+com_lsr)) & LSR_TXRDY) == 0 && --timo)
		;
	outb(comport+com_data, c);
#ifndef SMALL
	/* wait for this transmission to complete */
	timo = 1500000;
	while (((stat = inb(comport+com_lsr)) & LSR_TXRDY) == 0 && --timo)
		;
#endif
}
