F1_scancode     equ     59
reply_interval  equ     5               ; wait up to 5 seconds for reply
PrimBoot	equ	BootLocation - NewBootLocation

                include bootany.inc

code            segment

                assume  cs:Code, ds:Code, es:Code, ss:Code
                org     0

.386

bootany         proc    near
                mov     AX,CS           ; Get current segment
                mov     DS,AX           ; Set DS temporarily
                mov     SS,AX           ; set stack segment
                mov     SP,NewBootLocation ; initialize stack pointer
                sti                     ; enable interrupts
;
;               DOS loads this pgm at 0000:7C00. Any boot routine
;               we call also expects to execute there so the first
;               exercise is to move this code somewhere else.
;
                mov     CX,512          ; bytes to move
                mov     SI,BootLocation ; Get boot address
                les     DI,DWORD PTR SecBoot[SI] ; Where we relocate to
                rep     movsb           ; Copy to new location

                lea     SI,down+NewBootLocation ; address relocated e.p.
                jmp     SI

down            equ     $
;
;               Set up data segment to point to where we are moved to
;
                mov     AX,ES           ; Get current segment
                mov     DS,AX           ; Set data segment
;
;		Find active partition
;
 		mov	CX,4
		xor	BX,BX
findactive:
		cmp	BYTE PTR partitionTable.BootIndicator[BX],80h
		je	founda
		add	BX, SIZE PartitionEntry
		loop	findactive
founda:
		mov	activeAddr,BX; This is NoActivePart if too big
;
;               Display the menu
;
prompt:
                mov     CX,max_partitions ; set to max partitions
                xor     BX,BX           ; set base offset into bootany table
                mov     DL,Numeric      ; get first numeric value
promptloop:
                inc     DL              ; Increment Func Key number
		mov	AL,part.partition[BX]
                cmp     AL,0		; any entry?
                je      finishPrompt    ; No skip rest

                mov     key,DL          ; save in message
                lea     SI,FkeyMsg      ; get msg addr
                call    Send

                lea     SI,part.text[BX] ; get data addr
                call    Send

                add     BX,SIZE PartData ; next entry address
                loop    promptloop
finishPrompt:
		cmp	DL,Numeric+1
		jne	pickOne
		mov	BX,activeAddr	; This is NoActivePart if too big
		mov	DX,WORD PTR partitionTable.BootIndicator[BX]
		mov	CX,WORD PTR partitionTable.BeginSector[BX]
		mov	BX,PrimBoot	; Offset to primary boot strap
                mov     AX,201h         ; function, # of sectors
                int     13h             ; read system boot record
		jmp	JustBootIt
pickOne:
                mov     maxKey,DL

                lea     SI,defaultmsg
                call    Send
;
;               Compute timer tick count when we should time out
;
                sub     AH,AH           ; GetTickCount
                int     1ah             ; BiosTimerService
                add     DX,192*reply_interval/10 ; lo value at timeout
                adc     CX,0            ; hi value at timeout
                mov     EndTick,DX
                mov     EndTick+2,CX
;
;               Get the reply
;
reply:
                mov     AH,1            ; keyboard status
                int     16h             ; keybd bios service
                jnz     read_scancode   ; jump if reply
                sub     AH,AH           ; GetTickCount
                int     1ah             ; BiosTimerService
                cmp     CX,EndTick+2
                jb      reply           ; wait for scancode
                ja      timedout
                cmp     DX,EndTick      ; CX == EndTick+2, check low-order
                jb      reply           ; wait for scancode
timedout:
                mov     AH,default      ; prior system id
                cmp     AH,'?'          ; validate key
                je      prompt          ; no default
                jmp     system          ; boot default system
read_scancode:
                sub     AH,AH           ; read keyboard
                int     16h             ; keybd bios service
                sub     AH,F1_scancode-1 ; Turn into index
                jbe     prompt          ; Invalid code check
                add     AH,Numeric      ; Make numeric
                cmp     AH,maxKey	; max Function key
                ja      prompt
;
;               A valid function key was depressed (or defaulted)
;               Attempt to boot the corresponding partition.
;
system:
                mov     key,AH          ; save function key number
                sub     AH,Numeric+1    ; convert to binary

                mov     AL,SIZE PartData ; Get entry size
                mul     AH              ; Get offset
                mov     BX,AX           ; Offset into bootany table
		mov	SaveBX,BX
		;
		; Compute offset into FDISK partition table
		; The result will be bogus if we are not booting
		; from C:, but in that case we should not be
		; updating the partition table anyhow.
		;
		movzx	DX,BYTE PTR part.partition[BX]
		dec	DX
		shl	DX,4		; ... multiply by 16
		mov	PartOff,DX	; Offset into paritition table
;
;               Read in and validate the partition's boot sector.
;
select:
		mov	DX,WORD PTR part.drivehead[BX]
		mov	CX,WORD PTR part.sectorcyl[BX]
		mov	BX,PrimBoot	; Offset to primary boot strap
                mov     AX,201h         ; function, # of sectors
                int     13h             ; read system boot record
                jc      prompt          ; reprompt if error
                cmp     word ptr ES:Primboot+510,0aa55h ; test signature
                jne     prompt          ; reprompt if invalid
;
;		Change the active partition marker
;
                mov     DL,key          ; get depressed key number
                mov     AL,default      ; get last booted
                mov     default,DL      ; save Function key number
                cmp     AL,DL           ; current = default?
                je      EndBoot         ; yes - skip reset
		;
		; Grab the part number of what we are booting.
		; If it has 80 in it, it is on the second drive and
		; we should not touch the active flag
		;
		mov	BX,SaveBX
		mov	BL, part.partition[BX]	; new part
		test	BL, 80h
		jnz	EndBoot
		mov	DI, WORD PTR activeAddr
		cmp	DI, NoActivePart
		je	SetCurrent
                mov     BYTE PTR partitionTable.BootIndicator[DI],0h
                                        ; Make the old one not-startable
SetCurrent:
		mov	BX,PartOff
                mov     BYTE PTR partitionTable.BootIndicator[BX],80h
                                        ; Make the new one startable
;
;               Update the boot sector with new
;               values, and give control to the partitions boot program
;
EndBoot:
                mov     AX,301h         ; write sector
                les     BX,DWORD PTR SecBoot ; buffer address
                mov     CX,1            ; cylinder 0, sector 1
                mov     DX,80h          ; head 0, drive 0
                int     13h             ; replace boot record

                lea     SI,crlf		; print newline
                call    Send

JustBootIt:
                cli                     ; disable interrupts
;		mov	SI,WORD PTR PartOff ; Where our partition probably is
;		add	SI,PartAddr	; ... add in partition offset
;		mov	BP,SI		; For SCO??
;		mov	DI,BP		; For SCO??
		;
		; Next three lines are for SCO, but I don't
		; think it works.  If not, remove them.
		;
;		mov	BX,SaveBX
;		mov	DX,part.drivehead[BX]
;		mov	CX,part.sectorcyl[BX]
		xor	AX,AX
		mov	DS,AX
;		mov	SS,AX		; For SCO??
;		mov	SP,7c00h	; For SCO??
                jmp     far ptr bootcode        ; enter second level boot

Send:
                cld                     ; reset direction flag
                lodsb                   ; load argument from string
		btr	AX,7		; test and clear 8th bit
		pushf
                mov     AH,14           ; write tty
                int     10h             ; bios video service
		popf
                jnc     Send            ; do until end of string
                ret                     ; return to caller

SecBoot         dw      0,NewBootSeg    ; Relocation address
FkeyMsg         db      0dh,0ah,'F'
key             db      'X:',' '+80h
defaultmsg      db      0dh,0ah,'Default: F'
default         db      '?',' '+80h
used		equ	$ - bootany
toomuch		equ	"too much text/data"
spaceleft	equ	DataAddr - used

		.ERRE	used LE DataAddr, toomuch

		ORG	DataAddr

part            PartData max_partitions dup(<>)

crlf		db	0dh,0ah+80h	; \r\n, with high bit set on \n
					; This is also the bootany signature

partitionTable  PartitionEntry 4 dup(<>)

		dw	0aa55h

EndTick		dw	0,0		; low, high tick for timeout
SaveBX		dw	0
PartOff		dw	0		; 4242 is marker at end of our space
maxKey		db	0
activeAddr	dw	0

		ORG	7C00h
bootcode	LABEL	FAR

bootany         endp
code            ends

                end
