/*-
 * Copyright (c) 1994, 1995 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *      $Id: bioscall.c,v 2.3 1995/05/05 00:01:39 karels Exp $
 */

#include <sys/param.h>
#include <i386/stand/bioscall.h>

extern char bios_call_reloc;		/* Where we will be relocated to */
extern char bios_call_start;		/* Where we are relocated from */
extern char bios_call_end;		/* End of code to relocate */

static int bcallcopydone = 0;

#ifndef SMALL
static int bios_clobbered = 0;		/* True if bios code clobbered */

extern void *lidtdata;
extern int lidtsize;
#endif

void 
bios_call(inum, ba)
	int inum;
	struct bios_call *ba;
{

#ifndef SMALL
	if (lidtsize != 0)
		lidt(0, 1024);


	if (bios_clobbered) {
		printf("Call to BIOS after BIOS data was overwritten\n");
		printf("Press reset to reboot");
		for (;;)
			;
	}
#endif
	if (!bcallcopydone) {
		bcopy(&bios_call_start, &bios_call_reloc,
		    &bios_call_end - &bios_call_start);
		bcallcopydone = 1;
	}
	_bios_call(inum, ba);

#ifndef SMALL
	if (lidtsize != 0)
		lidt(lidtdata, lidtsize);
#endif
}

#ifndef	SMALL
void
copy_lowmem(s, d, n)
	char *s;
	char *d;
	int n;
{
	if (d < &bios_call_reloc + (&bios_call_end - &bios_call_start))
		bios_clobbered = 1;
    	bcopy(s, d, n);
}
#endif
