/*-
 * Copyright (c) 1992, 1993, 1994 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *      $Id: bios.c,v 2.2 1995/10/25 22:44:49 karels Exp $
 */

/*
 * Copyright (c) 1990 The Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Don Ahn.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the University of
 *      California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

/****************************************************************************/
/*                      standalone bios disk driver                         */
/****************************************************************************/
#include <sys/param.h>
#include <sys/dkbad.h>
#include <stand/stand.h>
#include <sys/reboot.h>
#include <sys/disklabel.h>
#include <i386/include/bootblock.h>
#include <i386/stand/bioscall.h>
#include <i386/stand/stand.h>

int	bdopen __P((void *));
int	bdclose __P((void *));
int	bdstrategy __P((void *, int, daddr_t, u_int, char *, u_int *));
#ifndef SMALL
static void bioserrprint __P((int, char *));
#endif

#ifdef SMALL
struct devsw devops = {"bios", bdopen, bdstrategy};
#else
struct devsw biosops = {"bios", bdopen, bdstrategy, bdclose};
#endif


#define NUMRETRY 10

#define BLKSIZE 512
#define NUMTYPES 4

#ifndef SMALL
extern int bootdebug;
#define dprintf(x)      if (bootdebug) printf x
#define dprintf1(x)     if (bootdebug > 1) printf x
#else
#define dprintf(x)
#define dprintf1(x)
#endif

#ifdef	SMALL
extern struct disklabel disklabel;
#endif

extern char bios_call_buffer[];     /* Where the bouce buffer is */

biosunit(io)
	register struct iob *io;
{
	
	if (io->i_adapt)
		return (io->i_unit | 0x80);
	return (io->i_unit);
}

/****************************************************************************/
/*                               bdstrategy                                 */
/****************************************************************************/
int
bdstrategy(IO,func, bn, cc, ma, resid)
	void *IO;
	int func;
	daddr_t bn;
	u_int cc;
	char *ma;
	u_int *resid;
{
	register struct iob *io = IO;
        char *address;
        long nblocks,blknum;
        int unit, iosize;

#ifdef SMALL
        printf(".");                    /* print some warm fuzzies/debugging */
#else
        dprintf1(("bdstrat "));
#endif
        unit = biosunit(io);

        /*
         * Set up block calculations.
         */
        iosize = cc / BLKSIZE;
        blknum = (unsigned long) (bn + io->i_boff)  * DEV_BSIZE / BLKSIZE;

        address = ma;
        while (iosize > 0) {
		int cnt = iosize;
                if ((cnt = bdio(func, unit, blknum, address, io, cnt)) == 0)
			return (EIO);
                iosize -= cnt;
                blknum += cnt;
                address += BLKSIZE * cnt;
        }
	*resid = cc;
        return (0);
}

int biosio;	/* see comment in kbd.c */

int
bdio(func, unit, blknum, address, io, cnt)
        int func, unit, blknum, cnt;
        char *address;
        struct iob *io;
{
        int cyl, sec, head;
	struct bios_args ba;
	static int size;
	static int nsectors;
	static int ntracks;
	static int ncylinders;
	static int lastunit = 0xffff;
	int retry;

	biosio = 1;

	if (cnt > BIOS_BUFSIZE / BLKSIZE)
		cnt = BIOS_BUFSIZE / BLKSIZE;

	/* pick up geometry if not same unit as last call */
	if (unit != lastunit) {
		ba.ba_ah = 0x8;
		ba.ba_dl = unit;
		dprintf1(("g"));
		bios_call(0x13, &ba);
		dprintf1((","));
		ncylinders = ((ba.ba_cl & 0xc0) << 2) + ba.ba_ch + 1;
		ntracks = ba.ba_dh + 1;
		nsectors = (ba.ba_cl & 0x3f);
		size = ncylinders * ntracks * nsectors;
		lastunit = unit;
	}

        dprintf1(("| %d ", blknum));

        cyl = blknum / (ntracks * nsectors);


        dprintf1(("r"));

        sec = blknum % (ntracks * nsectors);
        head = sec / nsectors;
        sec = sec % nsectors + 1;        /* origin 1 */
	if ((sec + cnt) > (nsectors + 1))
		cnt = nsectors - sec + 1;

        if (func == F_WRITE)
                bcopy(address, bios_call_buffer, BLKSIZE * cnt);

        /*
         * AH = 2 or 3 for read or write
         * AL = number of sectors (1)
         * CH/CL = encoded cyl/sector
         * DH = head
         * DL = unit
         * EX:BX = buffer
         */
        sec &= 0x3f;
        sec |= (cyl >> 2) & 0xc0;
        cyl &= 0xff;

        dprintf1(("W"));

	ba.ba_ah = func == F_READ ? 0x02 : 0x03;
	ba.ba_al = cnt;
	ba.ba_bx = (u_short)bios_call_buffer; 
	ba.ba_cx = (u_short)((cyl << 8) | sec),
	ba.ba_dx = (u_short)((head << 8) | unit),
	ba.ba_es = 0;
	dprintf1(("r"));
        bios_call(0x13, &ba);
	dprintf1((","));

    	/*
    	 * If we have an error then reset the drive and try again.
    	 */
	retry = 4;
    	while (ba.ba_ah) {
#ifndef	SMALL
		printf("%s error on block %d of unit %x.\n",
		    func == F_READ ? "Read" : "Write", blknum, unit);
		bioserrprint(ba.ba_ah, "  Retrying...");
#else
		printf("-");
#endif
		ba.ba_ah = 0;
		ba.ba_dx = unit;
		dprintf1(("R"));
		bios_call(0x13, &ba);
		dprintf1((","));

		ba.ba_ah = func == F_READ ? 0x02 : 0x03;
		ba.ba_al = cnt;
		ba.ba_bx = (u_short)bios_call_buffer; 
		ba.ba_cx = (u_short)((cyl << 8) | sec),
		ba.ba_dx = (u_short)((head << 8) | unit),
		ba.ba_es = 0;
		dprintf1(("r"));
		bios_call(0x13, &ba);
		dprintf1((","));
		if (retry-- == 0)
			break;
	}
	if (ba.ba_ah) {
#ifdef	SMALL
		printf("*");
#else
		printf("%s error on block %d of unit %x.\n",
		    func == F_READ ? "Read" : "Write", blknum, unit);
		bioserrprint(ba.ba_ah, "");
#endif
		return(0);
    	}

        if (func == F_READ)
                bcopy(bios_call_buffer, address, BLKSIZE * cnt);

        return (cnt);
}
	

/****************************************************************************/
/*                           bdopen/bdclose                                 */
/****************************************************************************/
int
bdopen(IO)
	void *IO;
{
        register struct iob *io = IO;
        static u_char buf[DEV_BSIZE];
	struct disklabel *dl;
        struct mbpart *mp, *getbsdpartition();
	char *data;
        int unit;
	struct bios_args ba;
	u_int i;

#ifdef SMALL
	extern int bootdev;
	/*
	 * all info comes through in type field
	 * the unit as used by the bios as been stuffed here.
	 * rest of data is zero. Partition data has been
	 * filled in also by bootxx
	 */
	if (bootdev & 0x80)
		io->i_adapt = 1;

	io->i_unit = bootdev & 0x1;
	bootdev = MAKEBOOTDEV(BD_MAJORDEV, io->i_adapt, 0,
	    io->i_unit, io->i_part);
#endif

	ba.ba_ah = 0x00;
	ba.ba_dl = biosunit(io);
	bios_call(0x13, &ba);

        unit = io->i_unit;
	/*
	 * We can only access up to two floppies and two hard disks
	 */
    	if (unit > 1) {
		printf("Cannot boot from unit %d\n", unit);
		if (io->i_adapt)
			_stop("hard drive unit must be 0 or 1\n");
		else
			_stop("floppy drive unit must be 0 or 1\n");
	}

	if (io->i_adapt == 0)
		return (0);		/* no partitions on floppies */

#ifdef	SMALL
	dl = &disklabel;
#else
        /* read the dos partition table to see where our label might be */
        if (bdstrategy((void*)io, F_READ, 0, DEV_BSIZE, (char *)buf, &i))
                return (EIO);
        i = LABELSECTOR;
        if (mp = getbsdpartition(buf))
                i += mp->start; 

        /* read the disk label */
        if (bdstrategy((void*)io, F_READ, i, DEV_BSIZE, (char *)buf, &i))
                return (ERDLAB);
        dl = (struct disklabel *)&buf[LABELOFFSET];
        if (dl->d_magic != DISKMAGIC)
                return (ERDLAB);
        if (io->i_part >= dl->d_npartitions)
                return (EPART);
#endif
        io->i_boff = dl->d_partitions[io->i_part].p_offset;
	return (0);
}

#ifndef SMALL
int
bdclose(IO)
        void *IO;
{
	return (0);
}

static char *errcodes[] = {
/*00*/  "no error",
        "invalid diskette paramter (bad command)",
        "address mark was not found",
        "attempted write on protected disk",
        "sector was not found",
        "reset failed",
        "diskette was removed",
        "bad parameter table",
        "DMA overrun on previous operation",
        "attemted to cross 64K segment boundry on DMA operation",
        "bad sector flag",
        "bad cylinder detected",
        "media type requested was not found",
        "invalid number of sectors in format",
        "control data address mark detected",
        "DMA arbitration level out of allowable range",
/*10*/  "CRC or ECC error on disk read",
        "ECC corrected data error",
};

#define	nerrcodes	(sizeof(errcodes)/sizeof(errcodes[0]))


static void
bioserrprint(code, trail)
	int code;
	char *trail;
{
    	char *e;

	switch (code) {
	case 0x20: e = "controller failed"; break;
	case 0x40: e = "seek operation failed"; break;
	case 0x80: e = "drive timed out, assumed not ready"; break;
	case 0xAA: e = "drive not ready"; break;
	case 0xBB: e = "undefined error"; break;
	case 0xCC: e = "write fault"; break;
	case 0xE0: e = "status error"; break;
	case 0xF0: e = "sense operation failed"; break;
	default:
		if (code >= 0 && code < nerrcodes)
			e = errcodes[code];
		else
			e = "unknown error";
		break;
	}

	printf("Error %x: %s.%s\n", code, e, trail);
}
#endif
