/*	BSDI $Id: saturn.c,v 2.3 1995/12/12 19:56:08 karels Exp $	*/

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/device.h>

#include <i386/isa/isavar.h>
#include <i386/isa/icu.h>
#include <i386/pci/pci.h>

/*
 * This driver is a kludge for resolving the problems of DMA underflows
 * and overruns in PCI machines which use the Saturn chipset.  In the
 * Saturn DCD chip (82424) or in PCMC chip (82434) there is a CPU-PCI
 * posting enable bit.  When set (default by most BIOSes for better ISA
 * bus benchmarks) it affects PCI busmasters and causes long latencies
 * which can make PCI devices drop/corrupt data.
 *
 * This must come before other PCI devices in the config file.
 */

#define	PCI_VENDORID(x)			((x) & 0xFFFF)
#define	PCI_CHIPID(x)			(((x) >> 16) & 0xFFFF)
#define	PCI_CFRV			0x08

#define	INTEL_VENDORID			0x8086
#define	SATURN_CHIPID			0x0483	/* i486 host bridge cache/mem controller */
#define PCMC_CHIPID			0x04A3	/* Pentium host bridge cache/mem controller */
#define SATURN_FAULTY_REV   		0x02
#define	PCMC_FAULTY_REV			0x03
#define	SATURN_HOST_BUFFER_CTRL_REG	0x53
#define	SATURN_HBC_POSTING_ENABLE	0x02	/* We want this cleared */
#define	PCMC_PCI_BUFFER_CTRL_REG	0x54
#define	PCMC_PBC_POSTING_ENABLE		0x01	/* We Want this set */

int saturn_probe(struct device *parent, struct cfdata *cf, void *aux);
int saturn_match(pci_devaddr_t *pa);
void saturn_attach(struct device *parent, struct device *self, void *aux);

struct cfdriver saturncd = {
    0, "saturn", saturn_probe, saturn_attach, DV_DULL, sizeof(struct device),
};

static int
saturn_probe(struct device *parent, struct cfdata *cf, void *aux)
{
	struct isa_attach_args *ia = aux;
	pci_devaddr_t *pa;

	pa = pci_scan(saturn_match);
	if (pa == NULL)
		return (0);
	ia->ia_irq = IRQNONE;
	ia->ia_aux = pa;
	return (1);
}

static int
saturn_match(pci_devaddr_t *pa)
{
	unsigned long id;

	id = pci_inl(pa, PCI_VENDOR_ID);
	if (PCI_VENDORID(id) == INTEL_VENDORID &&
	    (PCI_CHIPID(id) == SATURN_CHIPID || PCI_CHIPID(id) == PCMC_CHIPID))
		return (1);
	return (0);
}

static const char chip_fmt[]    = ": Intel %s chipset rev %d; CPU->PCI posting"
    " disabled";
static const char saturn2_fmt[] = "; old rev: reduced PCI burst size to 8";

void
saturn_attach(struct device *parent, struct device *self, void *aux)
{
	struct isa_attach_args *const ia = aux;
	pci_devaddr_t *const pa = ia->ia_aux;
	u_long rev;
	u_long id;
	u_long data;

	id = pci_inl(pa, PCI_VENDOR_ID);
	rev = pci_inl(pa, PCI_REVISION_ID) & 0xff;

	aprint_naive(": PCI chipset");
	if (PCI_CHIPID(id) == SATURN_CHIPID) {
		aprint_normal(chip_fmt, "82424", rev);
		data = pci_inl(pa, SATURN_HOST_BUFFER_CTRL_REG);
		if (data & SATURN_HBC_POSTING_ENABLE) {
			data &= ~SATURN_HBC_POSTING_ENABLE;
			pci_outl(pa, SATURN_HOST_BUFFER_CTRL_REG, data);
		}
		if (rev <= SATURN_FAULTY_REV) {
			pci_log2_burstsize = 3;
			aprint_normal(saturn2_fmt);
		}
	} else if (PCI_CHIPID(id) == PCMC_CHIPID) {
		aprint_normal(chip_fmt, "82434", rev);
		data = pci_inl(pa, PCMC_PCI_BUFFER_CTRL_REG);
		if ((data & PCMC_PBC_POSTING_ENABLE) == 0) {
			data |= PCMC_PBC_POSTING_ENABLE;
			pci_outl(pa, PCMC_PCI_BUFFER_CTRL_REG, data);
		}
		if (rev <= PCMC_FAULTY_REV) {
			pci_log2_burstsize = 3;
			aprint_normal(saturn2_fmt);
		}
	}
	printf("\n");
}
