/*-
 * Copyright (c) 1991, 1992, 1994 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: vga.c,v 2.2 1995/12/12 19:54:36 karels Exp $
 */

/*
 * Graphics display driver for vga/386.
 */

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/conf.h>
#include <sys/proc.h>
#include <sys/device.h>
#include <sys/malloc.h>

#include <machine/cpu.h>

#include <i386/isa/isa.h>
#include <i386/isa/isavar.h>

#include "vgavar.h"

int	vgaprobe __P((struct device *, struct cfdata *, void *));
void	vgaattach __P((struct device *, struct device *, void *));
int	vgaopen __P((dev_t, int, int, struct proc *));
int	vgaclose __P((dev_t, int, int, struct proc *));
int	vgamap __P((dev_t, int, int));
void	vgasave __P((struct vga_softc *));
void	vgarestore __P((struct vga_softc *));

struct cfdriver vgacd =
    { NULL, "vga", vgaprobe, vgaattach, DV_DULL, sizeof(struct vga_softc) };

struct devsw vgasw = {
	&vgacd,
	vgaopen, vgaclose, noread, nowrite, noioctl, seltrue, vgamap,
	nostrat, nodump, nopsize, 0,
	nostop
};

/*
 * Normal init routine called by configure() code
 */
/* ARGSUSED */
int
vgaprobe(parent, cf, aux)
	struct device *parent;
	struct cfdata *cf;
	void *aux;
{
	register struct isa_attach_args *ia = aux;

	/* XXX it'd be nice if we really checked to see if a card exists */
	ia->ia_irq = 0;		/* device doesn't interrupt */
	if (ia->ia_maddr && ia->ia_msize && ia->ia_iobase) {
		ia->ia_iosize = VGA_NPORT;
		return (1);
	}
	return (0);
}

/* ARGSUSED */
void
vgaattach(parent, self, aux)
	struct device *parent, *self;
	void *aux;
{
	register struct vga_softc *vgap = (struct vga_softc *)self;
	register struct isa_attach_args *ia = aux;

	printf(": VGA graphics\n");
	vgap->vga_mem_addr = ia->ia_maddr;
	vgap->vga_mem_size = ia->ia_msize;
	vgap->vga_io_addr = ia->ia_iobase;
}

int
vgaopen(dev, flags, mode, p)
	dev_t dev;
	int flags, mode;
	struct proc *p;
{
	int unit = VGAUNIT(dev);
	register struct vga_softc *vgap;

	/* Validate unit number */
	if (unit >= vgacd.cd_ndevs || (vgap = vgacd.cd_devs[unit]) == NULL)
		return (ENXIO);
	if (vgap->vga_flags & VGA_OPEN)
		return (EBUSY);
	/*
	 * First open.
	 */
	vgap->vga_flags |= VGA_OPEN;

	if (suser(p->p_ucred, &p->p_acflag) == 0)
		vgap->vga_flags |= VGA_PRIV;

	vgasave(vgap);
	return (0);
}

/*ARGSUSED*/
int
vgaclose(dev, flags, mode, p)
	dev_t dev;
	int flags, mode;
	struct proc *p;
{
	struct vga_softc *vgap = vgacd.cd_devs[VGAUNIT(dev)];

	vgap->vga_flags = VGA_DEAD;
	vgarestore(vgap);
	return (0);
}

/*ARGSUSED*/
int
vgamap(dev, off, prot)
	dev_t dev;
	int off, prot;
{
	struct vga_softc *vgap = vgacd.cd_devs[VGAUNIT(dev)];
	u_int paddr;

	/*
	 * Should limit mapping to VGA memory size, possibly adding
	 * the text memory.  For now, limit to IO memory space
	 * for non-privileged callers.
	 */
#if 0
	if (off + NBPG > vgap->vga_mem_size)
		return (-1);
#else
	if ((vgap->vga_flags & VGA_PRIV) == 0 && off + NBPG > IOM_SIZE)
		return (-1);
#endif
	return (((u_int)vgap->vga_mem_addr + off) >> PGSHIFT);
}

extern u_short *Crtat;
extern int pcscreenmem;

void 
vgasave(vgap)
	struct vga_softc *vgap;
{
	int  i;

	/*			 
	 * Get colorlookuptable 
	 */
	outb(VGA_COLMASK, 0xFF);
	outb(VGA_RCOLMODE, 0x00);
	for (i = 0; i < VGA_NCLUTENT; i++) 
		vgap->clut[i] = inb(VGA_CLUT); 

	/*
	 * get current screen text
	 */
	vgap->vga_screen = malloc(pcscreenmem, M_DEVBUF, M_WAITOK);
	bcopy(Crtat, vgap->vga_screen, pcscreenmem);

	vgap->mode = VGA_GRAPHICS;
}

void
vgarestore(vgap)
	struct vga_softc *vgap;
{
	int i;

	if (vgap->mode != VGA_GRAPHICS)
		return;

	/* 
	 * Restore screen text
	 */
	bcopy(vgap->vga_screen, Crtat, pcscreenmem);
	free(vgap->vga_screen, M_DEVBUF);
	vgap->vga_screen = NULL;

	/* 
	 * Restore color lookup table
	 */
	outb(VGA_COLMASK, 0xFF);
	outb(VGA_WCOLMODE, 0x00);
	for (i = 0; i < VGA_NCLUTENT; i++) 
		outb(VGA_CLUT, vgap->clut[i]);

	vgap->mode = VGA_TEXT;
}
