/*-
 * Copyright (c) 1994 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: sareg.h,v 2.1 1995/02/03 07:39:54 polk Exp $
 */

#define SA_NPORT 	0x20

#define SCSISEQ		0x00	/* scsi sequence control */
#define SXFRCTL0	0x01	/* scsi transfer control 0 */
#define SXFRCTL1	0x02	/* scsi transfer control 1 */
#define SCSISIG		0x03	/* scsi signal */
#define SCSIRATE	0x04	/* scsi rate */
#define SCSIID		0x05	/* scsi selection id */
#define SCSIDAT		0x06	/* scsi latched data */
#define SBUSBUS		0x07	/* scsi bus data */
#define STCNT0		0x08	/* scsi Low order byte of transfer count */
#define STCNT1		0x09	/* scsi Mid byte of transfer count */
#define STCNT2		0x0a	/* scsi High order byte of transfer count */
#define SSTAT0		0x0b	/* scsi status byte 0 */
#define SSTAT1		0x0c	/* scsi status byte 1 */
#define SSTAT2		0x0d	/* scsi status byte 2 */
#define SSTAT3		0x0e	/* scsi status byte 3 */
#define SCSITEST	SSTAT3
#define SSTAT4		0x0f	/* scsi status byte 4 */
#define SIMODE0		0x10	/* scsi interrupt mode 0 */
#define SIMODE1		0x11	/* scsi interrupt mode 1 */
#define DMACNTRL0	0x12	/* DMA control 0 */
#define DMACNTRL1	0x13	/* DMA control 1 */
#define DMASTAT		0x14	/* DMA status */
#define FIFOSTAT	0x15	/* fifo status */
#define DATAPORTL	0x16	/* data port low byte */
#define DATAPORTH	0x17	/* data port high byte*/
#define DATA		DATAPORTL
#define BURSTCNTRL	0x18	/* burst control */
#define PORTA		0x1a	/* Port A ???? */
#define PORTB		0x1b	/* Port A ???? */
#define REV		0x1c	/* Revision ?? of chip ?? */
#define STACK		0x1d	/* stack not used except for probe */
#define TESTREG		0x1e	/* test register */

/* SCSISEQ 0x00 */
#define SS_TEMODEO	0x80
#define SS_ENSELO	0x40
#define SS_ENSELI	0x20
#define SS_ENRESELI	0x10
#define SS_ENAUTOATNO	0x08
#define SS_ENAUTOATNI	0x04
#define SS_ENAUTOATNP	0x02
#define SS_SCSIRSTO	0x01

/* SXFRCTL0 0x01 */
#define XF0_SCSIEN	0x80
#define XF0_DMAEN	0x40
#define XF0_CH1		0x20
#define XF0_CLRSTCNT	0x10	/* self clearing */
#define XF0_SPIOEN	0x08
#define XF0_CLRCH1	0x02	/* self clearing */

/* SXFRCTL1 0x02 */
#define XF1_BITBUCKEN	0x80
#define XF1_SWRAPEN	0x40
#define XF1_ENSPCHK	0x20	/* enable parity check */
#define XF1_STIMESEL_M	0x18
#define XF1_STIMESEL_S	3
#define XF1_ENSTIMER	0x04
#define XF1_BYTEALIGN	0x02

/* SCSISIG 0x03 */
#define SIG_CD		0x80
#define SIG_IO		0x40
#define SIG_MSG		0x20
#define SIG_ATTEN	0x10
#define SIG_SELECT	0x08
#define SIG_BUSY	0x04
#define SIG_REQ		0x02
#define SIG_ACK		0x01

typedef enum {
	P_DATA_OUT	= 0,
	P_DATA_IN	= SIG_IO,
	P_COMMAND	= SIG_CD,
	P_STATUS	= SIG_CD  | SIG_IO,
	P_MSG_OUT	= SIG_MSG | SIG_CD,
	P_MSG_IN	= SIG_MSG | SIG_CD | SIG_IO,
	P_SELECTED	= SIG_MSG	/* not real scsi phase */
	} phase_t;

#define PHASE_M  (SIG_IO | SIG_CD | SIG_MSG)


/* SCSIRATE */
#define SR_SXFR_M	0x70
#define SR_SXFR_S	3
#define SR_SOFS_M	0x0f

/* SCSIID 0x05 */
#define SI_OID_M	0x70
#define SI_OID_S	4
#define SI_TID_M	0x07

/* SSTAT0 0x0B */
#define SS0_TARGET	0x80
#define SS0_SELDO	0x40	/* selection out target mode re-selection out*/
#define SS0_SELDI	0x20	/* re-selection in target mode selection in*/
#define SS0_SELINGO	0x10	/* Selection Initiated Out */
#define SS0_SWRAP	0x08	/* Transfer counter Wrap */
#define SS0_SDONE	0x04	/* SCSI done. Target mode only  */
#define SS0_SPIORDY	0x02	/* SCSI PIO Ready. Req is asserted on Bus */
#define SS0_DMADONE	0x01	/* Only useful in with DMA controller */
#define SS0_CLRALL	0x7f	/* Clear all interrupt conditions */

/* SSTAT1 0x0C */
#define SS1_SELTO	0x80	/* Selection Timeout Expired */
#define SS1_ATNTARG	0x40	/* Only vailid in target mode */
#define SS1_SCSIRSTI	0x20	/* SCSI bus reset occured, we cause this too*/
#define SS1_PHASEMIS	0x10	/* Qualified by REQINIT bit */
#define SS1_BUSFREE	0x08	/* BSY & SEL false for .4 usec */
#define SS1_SCSIIPERR	0x04	/* Parity Error */
#define SS1_PHASECHG	0x02	/* PHASEMIS not quallied by bit 0 */
#define SS1_REQINT	0x01	/* True if REQINT is asserted */
#define SS1_CLRALL	0xef	/* Clear all interrupt conditions */

/* SSTAT2 0x0D */
#define SS2_SOFFSET	0x20
#define SS2_SEMPTY	0x10
#define SS2_SFULL	0x08
#define SS2_SFCNT_M	0x07

/* SSTAT3 0x0E */
#define SS3_SCSICNT_M	0xf0;
#define SS3_SCSICNT_S	4
#define SS3_OFFCNT_M	0x0f;


/* S_STATUS4 */
#define	SS4_SYNCERR	0x04
#define	SS4_FWERR	0x02
#define	SS4_FRERR	0x01



/* SIMODE0 */
#define IM0_ENSELDO	0x40	/* selection out interrupt enable */
#define IM0_ENSELDI	0x20	/* selection in interrupt enable */
#define IM0_ENSELINGO	0x10	/* selection initiated interrupt enable */
#define IM0_ENSWRAP	0x08	/* interrupt when swrap bit is set */
#define IM0_ENSDONE	0x04	/* enterupt when SDONE bit is set */
#define IM0_ENSPIORDY	0x02	/* interrupt when SPIORDY is set */
#define IM0_ENDMADONE	0x01	/* interrupt when dma done bit is set */

/* SIMODE1 */
#define IM1_ENSELTIMO	0x80	/* interrupt on SS1_SELT0 */
#define IM1_ENATNTARG	0x40	/* interrupt on SS1_ATNTARG */
#define IM1_ENSCSIRST	0x20	/* interrupt on SS1_SCSIRSTI */
#define IM1_ENPHASEMIS	0x10	/* interrupt on SS1_PHASEMIS */
#define IM1_ENBUSFREE	0x08	/* interrupt on SS1_BUSFREE */
#define IM1_ENSCSIPERR	0x04	/* interrupt on SS1_SCSIPERR */
#define IM1_ENPHSCHG	0x02	/* interrupt on SS1_PHASECHG */
#define IM1_ENREQINT	0x01	/* interrupt on SS1_REQINIT */

/* DMACNTRL0 */
#define DMA0_ENDMA	0x80
#define DMA0_8BIT	0x40
#define DMA0_DMA	0x20
#define DMA0_WRITE	0x08
#define DMA0_INTEN	0x04
#define DMA0_RSTFIFO	0x02
#define DMA0_SWINT	0x01

/* DMACNTRL1 */
#define DMA1_PWRDWN	0x80
#define DMA1_STK_M	0x0f

/* DMASTAT 0x14 */
#define DMAS_ATDONE	0x80
#define DMAS_WORDRDY	0x40
#define DMAS_INTSTAT	0x20	/* or or all enabled interrups conditions */
#define DMAS_DFIFOFULL	0x10
#define DMAS_DFIFOEMP	0x08

/* DATAPORTL & DATAPORTH */
#define FIFO_MAXW	128	/* maximum that can be shoved into fifo */


/* BURSTCTL */
#define BURST_ON	0xf0
#define BURST_ON_S	4
#define BURST_OFF	0x0f

/* TESTREG */
#define TR_BOFFTMR	0x40
#define TR_BONTMR	0x20
#define TR_STCNTH	0x08
#define TR_STCNTM	0x04
#define TR_STCNTL	0x10
#define TR_SCSIBLK	0x02
#define TR_DMABLK	0x01

/* SA_PORTB */
/*
 * These defines are for 1520 board. This stuff doesn't work for
 * some the the on cpu board implemtations such as the NEC board.
 * The sa driver no longer uses this port
 */

#define PB_IRQ_M	0x18
#define PB_IRQ_S	3		/* shift to right justify irq */
#define PB_IRQ9		0		/* IRQ values right justified */
#define PB_IRQ10	2
#define PB_IRQ11	1
#define PB_IRQ12	3
