/*
 * Copyright (c) 1991, 1994 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	$Id: pcconsioctl.h,v 2.1 1995/02/03 07:39:17 polk Exp $
 */

/*
 * Structure used in mapping/unmapping ranges of I/O ports to user processes.
 */
struct iorange {
	int  iobase;		/* base ioport */
	int  cnt;		/* number of ports */
};

struct cnbell {
	enum	belltype { BEL_NONE, BEL_AUDIBLE /*, BEL_BLINK */ } type;
	int	freq;			/* hz */
	int	duration;		/* ms */
};

#define	PCCONIOCRAW	_IO('G', 1)		/* turn kbd raw mode on */
#define	PCCONIOCCOOK	_IO('G', 2)		/* turn kbd raw mode off */
#define PCCONIOCSETLED	_IOW('G', 3, char)	/* set keyboard leds */
#define	PCCONIOCBEEP	_IO('G', 4)		/* kbd beep */
#define	PCCONIOCSTARTBEEP	_IOW('G', 5, short)	/* start beep */
#define	PCCONIOCSTOPBEEP	_IO('G', 6)		/* stop beep */

#define	PCCONIOCMAPPORT	_IOW('G', 7, struct iorange)	/* enable io ports */
#define	PCCONIOCUNMAPPORT _IOW('G', 8, struct iorange)	/* disable io ports */
#define	PCCONENABIOPL _IO('G', 9)	/* enable IOPL privileges */
#define	PCCONDISABIOPL _IO('G', 10)	/* disable IOPL privileges */

#define	PCCONIOCGBELL _IOR('G', 11, struct cnbell)	/* get cons bell */
#define	PCCONIOCSBELL _IOW('G', 12, struct cnbell)	/* set cons bell */

#define	PCCONIOCGSCRN _IOR('G', 13, int)	/* get my screen number */
#define	PCCONIOCGCUR  _IOR('G', 14, int)	/* get cur screen number */
#define	PCCONIOCSWTCH _IOW('G', 15, int)	/* switch to screen number */
#define	PCCONIOCSWSIG _IOW('G', 16, int)	/* signal on switch */
#define	PCCONIOCGRPT _IOR('G', 17, int)		/* get typematic (repeat) val */
#define	PCCONIOCSRPT _IOW('G', 18, int)		/* set typematic (repeat) val */

#define LED_SCR			0x01
#define	LED_NUM			0x02
#define LED_CAP			0x04
