/*--------------------------------------------------------------*/
/* Cyclom-Y Device Driver for BSDI BSD/OS 2.x.			*/
/*								*/
/* Copyright (C) 1995 Cyclades Corporation. All rights reserved.*/
/*								*/
/* This code was modified by Marcio Saito from original code	*/
/* originally developed by Brian Litzinger.			*/
/*								*/
/*--------------------------------------------------------------*/

/* definition for the Cirrus Logic CD1400 */

#define CD1400_NCHAN	 4	/* Total number of channels */
#define CD1400_TPC	16	/* Ticks per character */

/*
 * Global Registers
 */
#define CD1400_GFRCR            2*0x40  /* global firmware revision code */
#define CD1400_CAR              2*0x68  /* channel access */
#define CD1400_GCR              2*0x4b  /* global config  */
#define CD1400_SVRR             2*0x67  /* service request */
#define CD1400_RICR             2*0x44  /* receive intr channel */
#define CD1400_TICR             2*0x45  /* transmit intr channel */
#define CD1400_MICR             2*0x46  /* modem intr channel */
#define CD1400_RIR              2*0x6B  /* receive interrupt status */
#define CD1400_TIR              2*0x6A  /* transmit interrupt status */
#define CD1400_MIR              2*0x69  /* modem interrupt status */
#define CD1400_PPR              2*0x7e

/*
    Virtual Registers
*/
#define CD1400_RIVR             2*0x43  /* receive intr vector */
#define CD1400_TIVR             2*0x42  /* transmit intr vector */
#define CD1400_MIVR             2*0x41  /* modem intr vector */
#define CD1400_LIVR             2*0x18  /* local intr vector */
#define CD1400_TDR              2*0x63  /* tx data */
#define CD1400_RDSR             2*0x62  /* rx data/status */
#define CD1400_MISR             2*0x4c  /* modem intr status */
#define CD1400_EOSRR            2*0x60  /* end of service request */



/*
 * Channel Registers
 */
#define CD1400_LIVR             2*0x18  /* local intr vector */
#define CD1400_CCR              2*0x05  /* channel control */
#define CD1400_SRER             2*0x06  /* service request enable */
#define CD1400_COR1             2*0x08  /* channel option 1 */
#define CD1400_COR2             2*0x09  /* channel option 2 */
#define CD1400_COR3             2*0x0A  /* channel option 3 */
#define CD1400_COR4             2*0x1E  /* channel option 4 */
#define CD1400_COR5             2*0x1F  /* channel option 5 */
#define CD1400_CCSR             2*0x0b  /* channel control status */
#define CD1400_RDCR             2*0x0e  /* rx data count */
#define CD1400_SCHR1            2*0x1A  /* special character 1 */
#define CD1400_SCHR2            2*0x1B  /* special character 2 */
#define CD1400_SCHR3            2*0x1C  /* special character 3 */
#define CD1400_SCHR4            2*0x1D  /* special character 4 */
#define CD1400_SCRL             2*0x22  /* special char range, low */
#define CD1400_SCRH             2*0x23  /* special char range, high */
#define CD1400_LNC              2*0x24  /* LNext character */
#define CD1400_MCOR1            2*0x15  /* modem change 1 */
#define CD1400_MCOR2            2*0x16  /* modem change 2 */
#define CD1400_RTPR             2*0x21  /* receive timeout period */
#define CD1400_MSVR1            2*0x6c  /* modem signals */
#define CD1400_MSVR2            2*0x6d  /* modem signals */

#define CD1400_RBPR             2*0x78  /* receive baud rate period */
#define CD1400_RCOR             2*0x7C  /* receive clock option */
#define CD1400_TBPR             2*0x72  /* transmit baud rate period */
#define CD1400_TCOR             2*0x76  /* transmit clock option */

/*
 * Channel Address Register
 */
#define CAR_CHAN	0x7	/* Channel Number Mask */

/*
 * Channel Command Register
 * (commands in groups can be OR-ed)
 */
#define CCR_HARDRESET	0x81	/* Reset the chip */

#define CCR_SOFTRESET	0x80	/* Soft Channel Reset */

#define CCR_CORCHG1	0x42	/* Channel Option Register 1 Changed */
#define CCR_CORCHG2	0x44	/* Channel Option Register 2 Changed */
#define CCR_CORCHG3	0x48	/* Channel Option Register 3 Changed */

#define CCR_SSCH1	0x21	/* Send Special Character 1 */

#define CCR_SSCH2	0x22	/* Send Special Character 2 */

#define CCR_SSCH3	0x23	/* Send Special Character 3 */

#define CCR_SSCH4	0x24	/* Send Special Character 4 */

#define CCR_TXEN	0x18	/* Enable Transmitter */
#define CCR_RXEN	0x12	/* Enable Receiver */

#define CCR_TXDIS	0x14	/* Diasable Transmitter */
#define CCR_RXDIS	0x11	/* Diasable Receiver */

/*
 * Channel Option Register 1
 */
#define COR1_ODDP	0x80	/* Odd Parity */
#define COR1_PARMODE	0x60	/* Parity Mode mask */
#define  COR1_NOPAR	 0x0	 /* No Parity */
#define  COR1_FORCEPAR	 0x20	 /* Force Parity */
#define  COR1_NORMPAR	 0x40	 /* Normal Parity */
#define COR1_IGNORE	0x10	/* Ignore Parity on RX */
#define COR1_STOPBITS	0xc	/* Number of Stop Bits */
#define  COR1_1SB	 0x0	 /* 1 Stop Bit */
#define  COR1_15SB	 0x4	 /* 1.5 Stop Bits */
#define  COR1_2SB	 0x8	 /* 2 Stop Bits */
#define COR1_CHARLEN	0x3	/* Character Length */
#define	 COR1_5BITS	 0x0	 /* 5 bits */
#define	 COR1_6BITS	 0x1	 /* 6 bits */
#define	 COR1_7BITS	 0x2	 /* 7 bits */
#define	 COR1_8BITS	 0x3	 /* 8 bits */

/*
 * Channel Option Register 2
 */
#define COR2_IXM	0x80	/* Implied XON mode */
#define COR2_TXIBE	0x40	/* Enable In-Band (XON/XOFF) Flow Control */
#define COR2_ETC	0x20	/* Embedded Tx Commands Enable */
#define COR2_LLM	0x10	/* Local Loopback Mode */
#define COR2_RLM	0x8	/* Remote Loopback Mode */
#define COR2_RTSAO	0x4	/* RTS Automatic Output Enable */
#define COR2_CTSAE	0x2	/* CTS Automatic Enable */
#define COR2_DSRAE	0x1	/* DSR Automatic Enable */

/*
 * Channel Option Register 3
 */
#define COR3_XONCH	0x80	/* XON is a pair of characters (spec. 1&3) */
#define COR3_XOFFCH	0x40	/* XOFF is a pair of characters (2&4) */
#define COR3_FCT	0x20	/* Flow-Control Transparency Mode */
#define COR3_SCDE	0x10	/* Special Character Detection Enable */
#define COR3_RXTH	0xf	/* RX FIFO Threshold value (1-12) */

/*
  Channel Option Register 4
*/
#define COR4_IGNCR   0x80
#define COR4_ICRNL   0x40
#define COR4_INLCR   0x20
#define COR4_IGNBRK  0x10
#define COR4_NBRKINT 0x08
#define COR4_PFOEXCP 0x00
#define COR4_PFOGOOD 0x01
#define COR4_PFODISC 0x02
#define COR4_PFONULL 0x03
#define COR4_PFOMARK 0x04

/*
  Channel Option Register 5
*/

#define COR5_ISTRIP 0x80
#define COR5_IEXTEN 0x40
#define COR5_ONLCR  0x02
#define COR5_OCRNL  0x01

/*
 * Modem Change Option Register 1
 */
#define MCOR1_DSRZD	0x80	/* Detect 0->1 transition of DSR */
#define MCOR1_CTSZD	0x40	/* Detect 0->1 transition of CTS */
#define MCOR1_RIZD	0x20	/* Detect 0->1 transition of RI */
#define MCOR1_CDZD	0x10	/* Detect 0->1 transition of CD *r
#define MCOR1_DTRTH	0xf	/* Automatic DTR flow control Threshold (1-12)*/
#define MCOR1_NODTRFC	0x0	/* Automatic DTR flow control disabled */

/*
 * Modem Change Option Register 2
 */
#define MCOR2_DSROD	0x80	/* Detect 1->0 transition of DSR */
#define MCOR2_CTSOD	0x40	/* Detect 1->0 transition of CTS */
#define MCOR2_RIOD	0x20	/* Detect 1->0 transition of RI */
#define MCOR2_CDOD	0x10	/* Detect 1->0 transition of CD */

/*
 * Modem Signal Value Registers
 */
#define MSVR2_DSR	0x80	/* Current state of DSR input */
#define MSVR2_CTS	0x40	/* Current state of CTS input */
#define MSVR2_RI 	0x20	/* Current state of RI  input */
#define MSVR2_CD	0x10	/* Current state of CD  input */
#define MSVR2_DTR	0x02	/* Current state of DTR output */

#define MSVR1_RTS	0x01	/* Current state of RTS output */

/*
 * Escape characters
 */
#define CD1400_C_ESC	0x0	/* Escape character */
#define CD1400_C_SBRK	0x81	/* Start sending BREAK */
#define CD1400_C_DELAY	0x82	/* Delay output */
#define CD1400_C_EBRK	0x83	/* Stop sending BREAK */

#define MISR_CDCHG 0x10


#define CD1400_SVRR_RX  0x01
#define CD1400_SVRR_TX  0x02
#define CD1400_SVRR_MDM 0x04

#define SRER_MDM  0x80
#define SRER_RXD  0x10
#define SRER_TXD  0x04
#define SRER_NNDT 0x01

