/*--------------------------------------------------------------*/
/* Cyclom-Y Device Driver for BSDI BSD/OS 2.x.			*/
/*								*/
/* Copyright (C) 1995 Cyclades Corporation. All rights reserved.*/
/*								*/
/* This code was modified by Marcio Saito from original code	*/
/* originally developed by Brian Litzinger.			*/
/*								*/
/*--------------------------------------------------------------*/

/*
 * Address mapping between Cirrus Logic CD1400 chip internal registers
 * and ISA port addresses:
 *
 */
#define CY_ADDR(reg)	(reg)

/* Input Byte from CL CD1400 register */
#define rinb(base, reg)		(*((base)+CY_ADDR(reg)))

/* Output Byte to CL CD1400 register */
#define routb(base, reg, val)	(*((base)+CY_ADDR(reg))=val)

#define CY_NPORT	16	/* decoder recognizes 16 addresses... */

#define CD1400_MEMSIZE 0x400
#define cy_RESET_16             0x1400                  /* cyclom-16y reset */
#define cy_CLEAR_INTR           0x1800                  /* intr ack address */
#define CYCLOM_CLOCK            25000000                /* baud rate clock */
#define CD1400_CLOCK_25_1MS     0x31
#define CD1400_NO_OF_CHANNELS   4
#define CD1400_MAX_FIFO_SIZE    12

