/*-
 *	Copyright (c) 1993 Robert J.Dunlop. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, is permitted provided the following conditions are met:
 *   1.	Redistributions in source form must retain the above copyright, this
 *	list of conditions and the following disclaimers.
 *   2. Redistributions in binary form must reproduce all items from condition
 *	1 in the accompanying documentation and/or other materials.
 *   3. Neither the names of Chase Research PLC and it's subsidiary companies,
 *	nor that of Robert Dunlop may be used to endorse, advertise or promote
 *	products derived from this software without specific written permission
 *	from the party or parties concerned.
 *   4.	Adaptation of this software to operating systems other than BSD/OS
 *	requires the prior written permission of Chase Research PLC.
 *   5.	Adaptation of this software for operation with communications hardware
 *	other than the Chase IOPRO and IOLITE series requires the prior written
 *	permission of Chase Research PLC.
 */

/*
 *	Chase Research IOPRO (aim) driver
 *
 *	Ioctl definitions for BSD/OS driver
 *
 *	WARNING: The calls, structures and semantics differ completely from
 *		 those used in other Chase IOPRO drivers.
 *
 *	aimioctl.h,v 1.7 1995/07/28 08:59:37 rjd Exp
 */

#ifndef _AIMIOCTL_H_
#define _AIMIOCTL_H_

#include <sys/ioctl.h>

/*
 *	Flag all the ioctls with this code in an attempt to make them unique.
 *	Don't really matter as they should only normally be issued on our
 *	private control devices.
 */
#define IOPRO_IO	'I'


/*
 *	Minor device assignment
 *
 *	The control demon dynamically links minor device numbers with channel
 *	pages in the external unit. This is necessary as the units may power
 *	up and down separately from the host.
 */
struct iopro_assign_info {
	int	ia_driver;	/* We only have an async data driver at present
				 * but leave room for expansion
				 */
	unsigned ia_minor;	/* The minor device number to assign */
	unsigned ia_page;	/* The unit page to assign it to. The unit is
				 * already identified by which control port we
				 * are using.
				 */
	int	ia_spare;	/* I'd hate to be caught short in the future */
};

#define	IOPRO_ASYNC	0

#define IOPRO_ASSIGN	_IOW ( IOPRO_IO, 0, struct iopro_assign_info )


/*
 *	Set debug level flags
 */
#define IOPRO_DEBUG	_IOW ( IOPRO_IO, 1, int )

#define DBG_ENTRY	0x0001			/* Entry points */
#define DBG_INTR	0x0002			/* Interrupts */
#define DBG_INPUT	0x0004			/* Input code */
#define DBG_OUTPUT	0x0008			/* Output code */
#define DBG_OPEN	0x0010			/* Open/close code */
#define DBG_MISC	0x0100			/* All the other stuff */


/*
 *	External unit processor control
 */
#define	IOPRO_RESET	_IO ( IOPRO_IO, 16 )	/* Hold processor in reset state
						 */
#define	IOPRO_RELEASE	_IO ( IOPRO_IO, 17 )	/* Remove halt or reset hold */
#define	IOPRO_ATTN	_IO ( IOPRO_IO, 18 )	/* Attract firmware attention by
						 * sending it an interrupt. Not
						 * used with current IOPRO
						 * firmware.
						 */
#define	IOPRO_SWRESET	_IO ( IOPRO_IO, 19 )	/* Much more forceful attention
						 * grabber. ( Issues an NMI ).
						 * Again not used with current
						 * IOPRO firmware.
						 */

#ifndef KERNEL
/*
 *	User program typing savers
 */
#define iopro_reset(D)		ioctl ((D), IOPRO_RESET )
#define iopro_release(D)	ioctl ((D), IOPRO_RELEASE )
#define iopro_attention(D)	ioctl ((D), IOPRO_ATTN )
#define iopro_swreset(D)	ioctl ((D), IOPRO_SWRESET )

#endif
#endif
