/*-
 * Copyright (c) 1995 Berkeley Software Design, Inc.  All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: aicreg.h,v 2.1 1995/06/21 01:23:54 cp Exp $
 */

/*
 * following struct is only used to look at code with debugger. Driver
 * uses a function with offset to address io space. This is because
 * with the AIC-7770 access is via ports rather than memory mapped
 */
typedef struct aic_io {
	u_char aic_scsiseq;	/*	0x00	*/
	u_char aic_sxfrctl0;	/*	0x01	*/
	u_char aic_sxfrctl1;	/*	0x02	*/
	u_char aic_scsisig;	/*	0x03	*/
	u_char aic_scsirate;	/*	0x04	*/
	u_char aic_scsiid;	/*	0x05	*/
	u_char aic_scsidatl;	/*	0x06	*/
	u_char aic_scsidath;	/*	0x07	*/
	u_char aic_stcnt0;	/*	0x08	*/
	u_char aic_stcnt1;	/*	0x09	*/
	u_char aic_stcnt2;	/*	0x0A	*/
	u_char aic_sstat0;	/*	0x0B	*/
	u_char aic_sstat1;	/*	0x0C	*/
	u_char aic_sstat2;	/*	0x0D	*/
	u_char aic_sstat3;	/*	0x0E	*/
	u_char aic_scsitest;	/*	0x0F	*/
	u_char aic_simode0;	/*	0x10	*/
	u_char aic_simode1;	/*	0x11	*/
	u_char aic_scsibusl;	/*	0x12	*/
	u_char aic_scsibush;	/*	0x13	*/
	u_long aic_shaddr;	/*	0x14-17	*/
	u_char aic_seltimer;	/*	0x18	*/
	u_char aic_selid;	/*	0x19	*/
	u_char aic_f4[2];	/*	0x1a,1b */
	u_char aic_sleepctl;	/*	1c,	*/
	u_char aic_brdctl;	/*	0x1d	*/
	u_char aic_seectl;	/*	0x1e	*/
	u_char aic_sblkctl;	/*	0x1F	*/
	u_char aic_sram[0x40];	/*	0x20	*/
	u_char aic_seqctl;	/*	0x60	*/
	u_char aic_seqram;	/*	0x61	*/
	u_char aic_seqaddr0;	/*	0x62	*/
	u_char aic_seqaddr1;	/*	0x63	*/
	u_char aic_accum;	/*	0x64	*/
	u_char aic_srcptr;	/*	0x65	*/
	u_char aic_dstptr;	/*	0x66	*/
#define aic_sindex aic_srcptr
#define aic_dindex aic_dstptr
	u_char aic_brkaddr0;	/*	0x67	*/
	u_char aic_brkaddr1;	/*	0x68	*/
	u_char aic_allones;	/*	0x69	*/
	u_char aic_allzeros;	/*	0x6A	*/
#define aic_none aic_allzeros;
	u_char aic_flags;	/*	0x6B	*/
	u_char aic_srcdata;	/*	0x6C	*/
	u_char aic_dstdata;	/*	0x6D	*/
#define aic_sindir srcdata
#define aic_dindir dstdata
	u_char aic_funct1;	/*	0x6E	*/
	u_char aic_stack;	/*	0x6F	*/
	u_char aic_f1[0x10];

	u_char aic_bid0;	/*	0x80	*/
	u_char aic_bid1;	/*	0x81	*/
	u_char aic_bid2;	/*	0x82	*/
	u_char aic_bid3;	/*	0x83	*/
	u_char aic_bctl;	/*	0x84	*/
	u_char aic_bustime;	/*	0x85	*/
	u_char aic_busspd;	/*	0x86	*/
	u_char aic_hcntrl;	/*	0x87	*/
	u_long aic_haddr;	/*	0x88-8B	*/
	u_long aic_hcnt;	/*	0x8C-8f	*/
	u_char aic_scbptr;	/*	0x90	*/
	u_char aic_intstat;	/*	0x91	*/
	u_char aic_clrint;	/*	0x92	*/
#define aic_error aic_clrint;
	u_char aic_dfcntrl;	/*	0x93	*/
	u_char aic_dfstatus;	/*	0x94	*/
	u_char aic_dfwaddr;	/*	0x95	*/
	u_char  aic_f2;
	u_char aic_dfraddr;	/*	0x97	*/
	u_char  aic_f3;
	u_char aic_dfdat;	/*	0x99	*/
	u_char aic_scbcnt;	/*	0x9A	*/
	u_char aic_qinfifo;	/*	0x9B	*/
	u_char aic_qincnt;	/*	0x9C	*/
	u_char aic_qoutfifo;	/*	0x9D	*/
	u_char aic_qoutcnt;	/*	0x9E	*/
	u_char aic_testchip;	/*	0x9F	*/
	u_char aic_scb[0x20];	/*	0xa0	*/

} aic_io_t;


#define	AIC_SCSISEQ	0x00
#define AIC_SXFRCTL0	0x01
#define AIC_SXFRCTL1	0x02
#define AIC_SCSISIGO	0x03
#define AIC_SCSISIGI	0x03
#define AIC_SCSIRATE	0x04
#define AIC_SCSIID	0x05
#define AIC_SCSIDATL	0x06
#define AIC_SCSIDATH	0x07
#define AIC_STCNT0	0x08
#define AIC_STCNT1	0x09
#define AIC_STCNT2	0x0a
#define AIC_CLRSINT0	0x0b
#define AIC_SSTAT0	0x0b
#define AIC_CLRSINT1	0x0c
#define AIC_SSTAT1	0x0c
#define AIC_SSTAT2	0x0d
#define AIC_SSTAT3	0x0e
#define AIC_SCSITEST	0x0f
#define AIC_SIMODE0	0x10
#define AIC_SIMODE1	0x11
#define AIC_SCSIBUSL	0x12
#define AIC_SCSIBUSH	0x13
#define AIC_SHADDR0	0x14
#define AIC_SHADDR1	0x15
#define AIC_SHADDR2	0x16
#define AIC_SHADDR3	0x17
#define AIC_SELTIMER	0x18
#define AIC_SELID	0x19
#define AIC_SLEEPCTL	0x1c
#define AIC_SBLKCTL	0x1f
#define AIC_SRAM	0x20
#define AIC_SRAMSIZE	0x40


#define AIC_SEQCTL	0x60
#define AIC_SEQRAM	0x61
#define AIC_SEQADDR0	0x62
#define AIC_SEQADDR1	0x63
#define AIC_ACCUM	0x64
#define AIC_SINDEX	0x65
#define AIC_DINDEX	0x66
#define AIC_BRKADDR0	0x67
#define AIC_BRKADDR1	0x68
#define AIC_ALLONES	0x69
#define AIC_ALLZEROS	0x6a
#define AIC_NONE	0x6a
#define AIC_FLAGS	0x6b
#define AIC_SINDIR	0x6c
#define AIC_DINDIR	0x6d
#define AIC_FUNCT1	0x6e
#define AIC_STACK	0x6f

#define AIC_BID0	0x80
#define AIC_BID1	0x81
#define AIC_BID2	0x82
#define AIC_BID3	0x83
#define AIC_BCTL	0x84
#define AIC_BUSTIME	0x85
#define AIC_BUSSPD	0x86
#define AIC_HCNTRL	0x87
#define AIC_HADDR0	0x88
#define AIC_HADDR1	0x89
#define AIC_HADDR2	0x8a
#define AIC_HADDR3	0x8b
#define AIC_HCNT0	0x8c
#define AIC_HCNT1	0x8d
#define AIC_HCNT2	0x8e
#define AIC_HCNT3	0x8f
#define AIC_SCBPTR	0x90
#define AIC_INTSTAT	0x91
#define AIC_CLRINT	0x92
#define AIC_ERROR	0x92
#define AIC_DFCNTRL	0x93
#define AIC_DFSTATUS	0x94
#define AIC_DFWADDR	0x95
#define AIC_DFRADDR	0x97
#define AIC_DFDAT	0x99
#define AIC_SCBCNT	0x9a
#define AIC_QINFIFO	0x9b
#define AIC_QINCNT	0x9c
#define AIC_QOUTFIFO	0x9d
#define AIC_QOUTCNT	0x9e
#define AIC_TESTCHIP	0x9f

#define AIC_SCB		0xA0
#define AIC_SCBSIZE	0x20

#define AIC_SCRATCHBASE	0x20
#define AIC_SCRATCHSIZE	0x40

#define AIC_S_OR	0
#define AIC_S_AND	1
#define AIC_S_XOR	2
#define AIC_S_TST	13	/* and jnz add 2 to get jz  */
#define AIC_S_CMP	12	/* xor jnz add 2 to get jz  */
#define AIC_S_JMP	8
#define AIC_S_JC	9
#define AIC_S_JNC	10
#define AIC_S_CALL	11
#define AIC_S_ADD	03
#define AIC_S_ADDC	04

#define AIC_S_JNZ	0	/* used as offset to AIC_S_{TST,CMP} */
#define AIC_S_JZ	2	/* used as offset to AIC_S_{TST,CMP} */

#define AIC_S_ROL	05

typedef struct aic_sg {		
	vm_offset_t	sg_addr;
	u_int		sg_count :24;
	u_int		sg_flags  :8;
} aic_sg_t;

