/*-
 * Copyright (c) 1991, 1992, 1994 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: abvar.h,v 2.2 1995/09/05 16:08:52 cp Exp $
 */

/*
 * Common part of device structures for AHA 154x / Buslogic drivers.
 * This is actually a derived class whose base class is a generic host adapter.
 * The generic host adapter in turn has a generic device as its base class.
 * Thus code can use generic device and generic host adapter pointers
 * to refer to objects of this type.
 */
struct ab_softc {
	struct	hba_softc ab_hba;
	struct	isadev ab_isa;
	struct	intrhand ab_ih;

	int	ab_port;		/* base port for device */
	int	ab_sync_base;		/* base rate for synch xfer */
	u_char	ab_id;			/* adapter's SCSI ID */

	/* interrupt state from the current transfer */
	u_char	ab_istat;		/* last interrupt status */
	u_char	ab_stat;		/* last SCSI status */
	u_char	ab_targ;		/* current target */
	u_char	ab_lun;			/* current LUN */
	u_char	ab_watchon;		/* watchdog running */
	u_char	ab_setlevel	:1;	/* have made edge to level change */
	u_char	ab_is32capable	:1;	/* this is a 32 bit controller */
	u_char	ab_isbuslogic	:1;	/* this is a Buslogic controller */
	u_char	ab_modifyintdone;	/* setlevel & fasttime done */
	u_int	ab_ioout;		/* outstanding io count */
	u_int	ab_iototal;		/* total io count for this controller */
	u_int	ab_watchtime;		/* timeout length */
	u_int	ab_wedgetime;		/* timeouts per check for wedged io */
	u_int	ab_wedgecounter;	/* down counter for wedged io */
	u_int	ab_resid;		/* last residual byte count */
	int	ab_irq;			/* needed late to transit from edge to
						level interrupts */

	/*
	 * In/out mailbox information (see ahareg.h).  The <base,lim>
	 * fields are purely for convenience/speed.  Note that the
	 * outbound base is the same as the whole base (mboxv), and
	 * the outbound limit is the same as the inbound base.
	 *
	 * (We do not know whether these are 24- or 32-bit mboxes,
	 * hence `void *'.)
	 */
	void	*ab_mboxv;		/* base virtual address of mbox */
	u_long	ab_mbox_phys;		/* physical address (for dma) */
	int	ab_mbox_count;		/* number of in & out mboxes */
#define	ab_mbobase ab_mboxv		/* mbox outbound base */
	void	*ab_mbolim;		/* mbox outbound limit */
#define	ab_mbibase ab_mbolim		/* mbox inbound base */
	void	*ab_mbilim;		/* mbox inbound limit */

	/* command control block information */
	void	*ab_sccbv;		/* base virtual address of softccbs */
	u_long	ab_sccb_phys;		/* physical address (for dma) */
	int	ab_sccb_count;		/* number of sccbs */
	void	*ab_sccblim;		/* much like mbolim and mbilim */
};

int	ab_fastcmd __P((int, int, u_char *, u_char *));
int	ab_probe __P((struct isa_attach_args *, int));
void	ab_attach __P((struct ab_softc *, struct isa_attach_args *, int,
			int, size_t, int, size_t));
void	ab_attach2 __P((struct ab_softc *, int (*)(struct ab_softc *, int)));
void	ab_reset __P((int, int, u_char *, int));
int	ab_sgmap __P((struct buf *, struct sg32 *, int, u_int *));
void	ab_error __P((struct ab_softc *, int));
int	ab_intr __P((struct ab_softc *));
void	ab_modifyint __P((struct ab_softc *));

#ifndef AB_WEDGETIME
#define AB_WEDGETIME	60
#endif

#ifndef AB_DOBUSRESET
#define AB_DOBUSRESET	1
#endif

#define AB_HARDRESET 1
#define AB_SOFTRESET 0
