/*-
 * Copyright (c) 1995 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: shlib.h,v 2.1 1995/07/05 21:17:38 donn Exp $
 */

/*
 * Machine-dependent definitions for BSD/OS static shared libraries.
 */

#ifdef LOCORE

/*
 * Assembly defines, used in creating jump tables.
 */

#define	JUMPTO(addr)	.align 3; jmp addr

#define	PAGE_ALIGN	.align 12

#define	JUMPENTRY(j,addr) \
	.globl j; \
	.align 3; \
	j: \
		jmp addr

#else

/*
 * C defines (really assembly escapes!), used in bootstrapping.
 */

#define	ENTRY \
	asm(".text; jmp _loader");

/* don't forget the obnoxious pad word */
caddr_t __mmap __P((caddr_t, size_t, int, int, int, int, off_t));
void __abort __P((void));

#define	LIBRARY \
	asm (".text; 0: jmp ___cerror; .align 2; ___mmap: leal 197,%eax; lcall $7,$0; jb 0b; ret"); \
	asm (".text; .align 2; ___cerror: movl $-1,%eax; ret"); \
	asm (".text; .align 2; ___abort: hlt");

#define	PAD \
	asm (".text; .org 4096 - 32");

/*
 * Structure of the library table __LIBRARY_TABLE[].
 * The address is the base address of the library's text;
 * the loader maps the first page and calls address+sizeof(struct exec)
 * to complete the initialization.
 * The loader itself is the first element in the table.
 * Our data address is compiled in (this file is compiled once
 * for each library, with the object file inserted in the library).
 */
struct ldtab {
	char *name;
	caddr_t address;
};

#endif /* C */
