/*-
 * Copyright (c) 1992, 1993, 1994, 1995 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: locore.s,v 2.7 1995/12/20 20:36:56 karels Exp $
 */
 
/*-
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * William Jolitz.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	from: @(#)locore.s	7.3 (Berkeley) 5/13/91
 *	from NetBSD: Id: locore.s,v 1.12 1993/05/27 16:44:13 cgd Exp
 *
 *      @(#)locore.s	8.3 (Berkeley) 9/23/93
 */

/*
 * locore.s:	4BSD machine support for the Intel 386
 */

#include "assym.s"

#include <machine/assembly.h>
#include <machine/psl.h>
#include <machine/pte.h>
#include <machine/vmlayout.h>
#include <machine/limits.h>
#include <machine/trap.h>
#include <machine/segments.h>

#include <sys/syscall.h>
#include <sys/reboot.h>
#include <sys/errno.h>

#include <i386/i386/specialreg.h>
#include <i386/isa/isa.h>
#include <i386/isa/timerreg.h>
#include <i386/isa/rtc.h>

#define	KCSEL		GSEL(GCODE_SEL, SEL_KPL)
#define	KDSEL		GSEL(GDATA_SEL, SEL_KPL)
#define	KSSEL		GSEL(GSTACK_SEL, SEL_KPL)

#if /*defined(GENERIC) &&*/ !defined(DEBUG)
#define DEBUG	/* force run-time startup debugging for GENERIC */
#endif

#ifdef DEBUG
#define CRT_MONO	(0xb0000 + (24*80*2))	/* start of last line */
#define CRT_COLOR	(0xb8000 + (24*80*2))
/*
 * Debugging stuff:
 * Print one character at specified column on last line of display,
 * then delay briefly.  PUT works while in physical mode;
 * VPUT works in virtual mode after atdevbase is set, and uses %ecx.
 * Do it in both the color and mono memory so it will be visible on
 * any machine.
 */
#define	PUT(c,col) \
	cmpl	$0,PHYS(_bootdebug); \
	je	7f; \
	movw	$(0x1f<<8)+(c),CRT_MONO+2*(col); \
	movw	$(0x1f<<8)+(c),CRT_COLOR+2*(col); \
	DEL(100000); \
7:
#define	FPUT(c,col) \
	cmpl	$0,PHYS(_bootdebug); \
	je	7f; \
	movw	$(0x1f<<8)+(c),CRT_MONO+2*(col); \
	movw	$(0x1f<<8)+(c),CRT_COLOR+2*(col); \
7:

#define	VPUT(c,col) \
	cmpl	$0,_bootdebug; \
	je	7f; \
	movl	_atdevbase,%ecx;\
	addl	$CRT_MONO-IOM_BEGIN+2*(col),%ecx; \
	movw	$(0x1f<<8)+(c),(%ecx); \
	movl	_atdevbase,%ecx;\
	addl	$CRT_COLOR-IOM_BEGIN+2*(col),%ecx; \
	movw	$(0x1f<<8)+(c),(%ecx); \
	VDEL(100000); \
7:

#define	DEL(n) \
	cmpl	$0,PHYS(_bootdebug); \
	je	8f; \
	pushl %ecx; \
	movl	$(n),%ecx; \
9:	outb	%al,$0x80; \
	loop	9b; \
	popl %ecx; \
8:

#define	VDEL(n) \
	cmpl	$0,_bootdebug; \
	je	8f; \
	pushl %ecx; \
	movl	$(n),%ecx; \
9:	outb	%al,$0x80; \
	loop	9b; \
	popl %ecx; \
8:

#else /* DEBUG */
#define	PUT(c,col)	/* nothing */
#define	VPUT(c,col)	/* nothing */
#define	DEL(n)		/* nothing */
#define	VDEL(n)		/* nothing */
#endif /* DEBUG */


#define	PHYS(x)	((x) - KERNBASE)	/* physical location of text/data */

/*
 * Convert a virtual address adrs into a physical address in reg;
 * the address must be in the statically-loaded part of the kernel,
 * which is loaded around the I/O hole.
 */
#define CONVADRS(adrs, reg) \
	lea	adrs - KERNBASE, reg; \
	cmpl    PHYS(_basemem), reg; \
	jb	8f; \
	addl	PHYS(holesize), reg; \
8:

#ifdef LITE
#define	NOP	inb $0x84, %al ; inb $0x84, %al 
#else
#define	NOP	;
#endif
#define	ALIGN32	.align 2	/* 2^2  = 4 */

/*
 * port to read for delay/write buffer flush
 * Was 0x84 (unused page register), but this caused problems;
 * now use DMA page register 0.
 */
#define	DPORT	0x87

/*
 * PTmap is recursive pagemap at top of virtual address space.
 * Within PTmap, the page directory can be found (third indirection).
 */
	.globl	_PTmap, _PTD, _PTDpde
	.set	_PTmap, _PTMAP
	.set	_PTD, _PTMAP + (PTDPTDI * NBPG)
	.set	_PTDpde, _PTD + (SZ_PDE * PTDPTDI)

/*
 * APTmap, APTD is the alternate recursive pagemap.
 * It's used when modifying another process's page tables.
 */
	.globl	_APTmap, _APTD, _APTDpde
	.set	_APTmap, _APTMAP
	.set	_APTD, _APTMAP + (APTDPTDI * NBPG)
	.set	_APTDpde, _PTD + (SZ_PDE * APTDPTDI)

/*
 * Access to each processes kernel stack is via a region of
 * per-process address space (at the beginning), immediatly above
 * the user process stack.
 */
	.set	_kstack, _KSTACK
	.globl	_kstack
	.set	KSTKPTEOFF, (NBPG / SZ_PDE) - UPAGES

/*
 * Initialization
 */
	.data
	.globl	_cpu,_cold,_boothowto,_bootdev,_cyloffset,_atdevbase,_atdevphys
_cold:		.long	1	# cold till we are not
_atdevbase:	.long	0	# location of start of iomem in virtual
_atdevphys:	.long	0	# location of device mapping ptes (phys)

	.globl	_IdlePTD, _KPTphys
_IdlePTD:	.long	0
_KPTphys:	.long	0

	.globl	_maxmem
/*
 * MAXMEM is the amount of memory configured; normally this is passed
 * from the bootstrap, so the value here is just a fallback.
 */
#define	MAXMEM	((4 * 1024 * 1024) / NBPG)	/* 4 MB / NBPG */
_maxmem:	.long	MAXMEM

/*
 * The kernel load address is specified in the system Makefile.
 * The bootstrap uses the low bits of the entry address as the physical
 * start address, and loads the kernel there.  This allows us to skip
 * over the BIOS area, leaving it intact for various reasons.
 * KERNBASE is the virtual address for the logical start of the kernel,
 * and it corresponds to physical address 0.  SYSTEM is the virtual address
 * for the first part of text in the kernel a.out file.
 *
 * The stack grows down from "start" until virtual memory is enabled.
 */
	.text
	.globl	start
start:
	.globl	SYSTEM			# for gdb -k; this is start of a.out
	.set	SYSTEM,start		# virtual address of system start
	jmp	1f

	/*
	 * The following are in text space for ease of access
	 * before we turn on virtual memory, so that we can use PHYS().
	 */
	.globl	_basemem
	.align	2
_bootdebug:	.long	0	# debugging flag for startup, from boothowto
	.globl	_bootparamp
_bootparamp:	.long	0		# location of boot parameters
_basemem:	.long	640*1024	# size of base memory (bytes)
holesize:	.long	IOM_SIZE	# IOM_END - _basemem

	.globl	_cpu_id
_cpu_id: .space	4		# eax value from cpuid instruction
_cpu:	.long	CPU_386		# are we 386, 386sx, or 486; default to 386

	/*
	 * Parameters are passed on bootstrap's stack
	 * as (howto, bootdev, cyloffset, bootparams).
	 * Note: (%esp) is return address of boot.
	 */
1:
	PUT(0x41,0)	/* 'A' */
	movw	$0x1234,%ax
	movw	%ax,0x472	# warm boot
	/*
	 * Check for boot parameters first.
	 * We expect the first parameter to be the biosinfo,
	 * including base and extended memory.  We need to know
	 * about base memory to see where the bootstrap loaded us
	 * (wrapping around the I/O hole) before using _basemem
	 * or CONVADRS.
	 */
	leal	16(%esp),%eax
	cmpl	$BOOT_MAGIC,B_MAGIC(%eax)
	jne	1f
	movl	%eax,PHYS(_bootparamp)
	addl	$8,%eax
	cmpl	$B_BIOSINFO,(%eax)
	jne	1f		 /* no bios info. Go with minimal default */

	addl	$8,%eax		/* eax now point at biosinfo struct */
	movl	(%eax),%edx
	movl	%edx, PHYS(_basemem)
	movl	$IOM_END,%edx
	subl	(%eax),%edx
	movl	%edx,PHYS(holesize)
	movl	4(%eax),%edx		/* extended memory (bytes) */
	addl	$IOM_END,%edx		/* convert to end of extended mem */
	shrl	$PGSHIFT,%edx
	CONVADRS(_maxmem, %eax)
	movl	%edx, (%eax)
	
1:
	movl	4(%esp),%eax
	CONVADRS(_boothowto, %ebx)
	movl	%eax,(%ebx)
	andl	$RB_KDB,%eax		/* extract debugging flag */
	movl	%eax,PHYS(_bootdebug)	/* for easy access as we go */
	movl	8(%esp),%eax
	CONVADRS(_bootdev, %ebx)
	movl	%eax,(%ebx)
	movl	12(%esp),%eax
	CONVADRS(_cyloffset, %ebx)
	movl	%eax,(%ebx)

	/* Done with parameters from /boot; move to temporary kernel stack */
	movl	$PHYS(start),%esp	# bootstrap stack end location

	/* establish standard flags */
	pushl	$PSL_MBO
	popf

	/* determine cpu type */
	movl	%esp,%edx
	andl 	$~3,%esp
	pushfl				# stuff EFLAGS on the stack
	popl	%eax			# so we can grab them into AX
	movl	%eax,%ecx		# save a copy of orig EFLAGS in CX
	orl	$PSL_AC,%eax		# set AC bit (on 486+)
	xorl	$PSL_ID,%eax		# toggle ID bit (Pentium+)
	pushl	%eax			# stuff new EFLAGS on the stack
	popfl				# so we can hand them to the processor
	pushfl				# have it push them on the stack
	popl	%eax			# and grab the new EFLAGS into AX
	pushl	%ecx			# restore original EFLAGS
	popfl
 	movl	%edx,%esp
	CONVADRS(_cpu, %ebx)
	testl	$PSL_AC,%eax		# see if AC bit stayed (only on 486+)
	jz	1f			# is this really a 386?
	movl	$CPU_486,(%ebx)		# no, must be a 486+
	/*
	 * Check the PSL_ID bit, which can be toggled on Pentium
	 * and newer 486 chips; if so, the cpuid instruction is supported.
	 */
	andl	$PSL_ID,%eax		# see if ID bit stayed (only on newer)
	andl	$PSL_ID,%ecx
	cmpl	%eax,%ecx		# see if ID bit toggled
	je	1f			# if no cpuid instruction, done

#if 0
	cmpl	$0,PHYS(_bootdebug)	# if bootdebug is set, do not try cpuid
	jne	1f
#endif

	/* try cpuid instruction, see what we get */
#define	cpuid	.byte 0x0f, 0xa2
	xorl	%eax,%eax		# input value to cpuid
	cpuid				# find highest input value supported
	cmpl	$1,%eax			# must be at least 1 (we want 1)
	jb	1f
	movl	$1,%eax			# input to cpuid: find ID
	cpuid
	movl	%eax,PHYS(_cpu_id)	# family/model/stepping
#if 0
	movl	%ebx,PHYS(_cpu_id+4)	# on Intel, "Genu" (G is low nibble)
	movl	%edx,PHYS(_cpu_id+8)	# on Intel, "ineI"
	movl	%ecx,PHYS(_cpu_id+12)	# on Intel, "ntel"
#endif
	andl	$0xf00,%eax		# extract family
	cmpl	$0x500,%eax		# family 5 is Pentium, 4 is 486
	jl	1f

	shrl	$8,%eax			# isolate the family value
	CONVADRS(_cpu, %ebx)
	movl	%eax,(%ebx)		# must be a Pentium or later
1:
	PUT(0x42,1)	/* 'B' */

/*
 * Virtual address space of kernel:
 * text | data | bss | page dir | proc0 kernel stack | usr stk map | Sysmap
 *	size in pages:	1               UPAGES	       1             1
 *
 * Additional pages of "Sysmap" are allocated later; we do one here,
 * enough to map the kernel proper and get us going.
 */

/* find end of kernel image; save aligned space for bootparams at _end */
	movl	$PHYS(_end),%ecx
	movl	PHYS(_bootparamp),%eax
	cmpl	$0,%eax
	je	1f
	addl	$3,%ecx			# force alignment
	andl	$~3,%ecx
	addl	B_LEN(%eax),%ecx
1:
	addl	$NBPG-1,%ecx
	andl	$~(NBPG-1),%ecx
	movl	%ecx,%esi		# kernel size before page directory

	/*
	 * Check whether the kernel (text/data/bss) plus page tables, etc.
	 * fit below the I/O "hole".  If not, the overflow will be
	 * above the hole.  The code below assumes that the page table
	 * pages, etc. are contiguous, so round up bss to the
	 * beginning of the hole if they would span the hole.
	 */
	movl	PHYS(_basemem), %eax
	subl	$((1+UPAGES+1+1)*NBPG), %eax
	cmpl	%eax, %ecx		# does everything fit in basemem?
	jbe     2f
	cmpl    PHYS(_basemem), %ecx	# no, does bss end below hole?
	ja      1f
	movl    PHYS(_basemem), %ecx	# round up to hole
	movl	%ecx,%esi		# save rounded-up size
1:	addl    PHYS(holesize), %ecx
2:	pushl	%esi			# rounded kernel size before page dir
	movl	%ecx,%esi
	addl	$(1+UPAGES+1+1)*NBPG,%ecx

/* clear bss and memory for bootstrap pagetables. */
	CONVADRS(_edata, %edi)		# Clearing from _edata
	xorl	%eax,%eax		# pattern
	cld
	cmpl	$IOM_END, %edi		# Are both above IO hole?
	jae	1f
	cmpl	PHYS(_basemem), %ecx	# Are both below?
	jbe	1f
	pushl	%ecx			# Save top
	movl	PHYS(_basemem), %ecx	# Clear to hole first
	subl	%edi, %ecx
	rep
	stosb
	movl	$IOM_END, %edi		# Now clear above hole
	popl	%ecx			# Restore top
1:
	subl    %edi,%ecx
	rep
	stosb
	PUT(0x43,2)	/* 'C' */

/* save boot params at _end if present */
	pushl	%esi
	movl	PHYS(_bootparamp),%esi
	cmpl	$0,%esi
	je	1f
	movl	$PHYS(_end),%edi
	addl	$3,%edi			# force alignment
	andl	$~3,%edi
	movl	%edi,%eax
	orl	$KERNBASE,%eax		# convert to virtual for later
	movl	%eax,PHYS(_bootparamp)	# new location of bootparams
	movl	B_LEN(%esi),%ecx
	cmpl	PHYS(_basemem), %edi	# ...Just CONVADRS
	jb	2f
	addl	PHYS(holesize), %edi
2:	movsb
	cmpl	PHYS(_basemem), %edi
	jne	3f
	PUT(0x50, 21)	/* 'P' */
	movl	$IOM_END, %edi
3:	loop	2b
1:	popl	%esi

	CONVADRS(_IdlePTD, %ebx)
	movl	%esi,(%ebx)	 /* physical address of Idle Address space */
	PUT(0x44,3)	/* 'D' */

#define	fillkpt(prot)		\
1:	orl	$(prot),%eax	; \
	movl	%eax,(%ebx)	; \
	andl	$~(prot),%eax	; \
	addl	$NBPG,%eax	; /* increment physical address */ \
	cmpl	PHYS(_basemem),%eax; /* run into the hole? */ \
	jne	2f		; \
	PUT(0x54, 22)		; /* 'T' */ \
	movl	$IOM_END,%eax	; /* jump over the hole */ \
2:	addl	$4,%ebx		; /* next pte */ \
	loop	1b		;

#define	ofillkpt		\
1:	movl	%eax,(%ebx)	; \
	addl	$NBPG,%eax	; /* increment physical address */ \
	addl	$4,%ebx		; /* next pte */ \
	loop	1b		;

/*
 * Map Kernel
 *
 * First step - build page tables
 * Map the kernel text read-only (useful on the 486)
 */

#ifdef KGDB		/* XXX make life simpler for breakpoints */
	popl	%ecx			# this much memory,
	shrl	$PGSHIFT,%ecx		# for this many pte s
	addl	$1+UPAGES+1,%ecx	# including our early context
	xorl	%eax,%eax		# starting with page 0
	lea	((1+UPAGES+1)*NBPG)(%esi),%ebx	# physical addr of KPT in proc 0
	CONVADRS(_KPTphys, %edx)
	movl	%ebx,(%edx)		#    in the kernel page table,
	fillkpt(PG_KW|PG_V)
#else
	lea	PHYS(_etext),%ecx	# text size
	shrl	$PGSHIFT,%ecx
	xorl	%eax,%eax		# starting with page 0
	leal	((1+UPAGES+1)*NBPG)(%esi),%ebx
	CONVADRS(_KPTphys, %edx)
	movl	%ebx,(%edx)
	fillkpt(PG_KR|PG_V)

	/* data and bss are r/w */
	popl	%ecx			/* total kernel size */
	subl	$PHYS(_etext),%ecx	/* minus text size */
	shrl	$PGSHIFT,%ecx
	addl	$1+UPAGES+1,%ecx
	fillkpt(PG_KW|PG_V)
#endif
/* map I/O memory map */

	movl	$(IOM_SIZE/NBPG),%ecx	# for this many pte s,
	movl	$(IOM_BEGIN|PG_UW|PG_V),%eax
	CONVADRS(_atdevphys, %edx)
	movl	%ebx,(%edx)		#   remember phys addr of ptes
	ofillkpt

/* map proc 0's kernel stack into user page table page */

	lea	(1*NBPG)(%esi),%eax	# physical address in proc 0
	lea	(KERNBASE)(%eax),%edx
	cmpl	PHYS(_basemem), %esi
	jb	1f
	subl	PHYS(holesize), %edx
1:	CONVADRS(_proc0paddr, %ecx)
	movl	%edx,(%ecx)	  # remember VA for 0th process init
	movl	$UPAGES,%ecx		# for this many pte s,
	orl	$PG_V|PG_KW,%eax	#  having these bits set,
	lea	((1+UPAGES)*NBPG)(%esi),%ebx # physical addr of stk pt in proc 0
	addl	$(KSTKPTEOFF * SZ_PDE),%ebx
	ofillkpt

/*
 * Construct a page table directory (of page directory elements - pde's).
 * We fill in only one kernel entry here, and do the rest in pmap_bootstrap.
 */
	/* install a pde for temporary double map of bottom of VA */
	lea	((1+UPAGES+1)*NBPG)(%esi),%eax	# physical addr of kernel pt
	orl	$PG_KW|PG_V,%eax	# pde entry is valid
	movl	%eax,(%esi)		# which is where temp maps!

	/* first kernel pde */
	movl	%eax,(KPTDI_FIRST*4)(%esi)	# offset of first pde for kernel

	/* install a pde recursively mapping page directory as a page table! */
	movl	%esi,%eax		# phys address of ptd in proc 0
	orl	$PG_KW|PG_V,%eax	# pde entry is valid
	movl	%eax, PTDPTDI*4(%esi)	# which is where PTmap maps!

	/* install a pde to map kernel stack for proc 0 */
	lea	((1+UPAGES)*NBPG)(%esi),%eax	# physical addr of pt in proc 0
	orl	$PG_KW|PG_V,%eax	# pde entry is valid
	movl	%eax,KSTKPTDI*4(%esi)	# which is where kernel stack maps!

	PUT(0x45,4)	/* 'E' */
	/* load base of page directory, and enable mapping */
	movl	%esi,%eax		# phys address of ptd in proc 0
#if I386_CR3PAT != 0
 	orl	$I386_CR3PAT,%eax
#endif
	movl	%eax,%cr3		# load ptd addr into mmu
	movl	%cr0,%eax		# get control word
	orl	$CR0_PG|CR0_PE,%eax	# and let's page!
	movl	%eax,%cr0		# NOW!

	pushl	$begin			# jump to high mem
	ret

begin: /* now running relocated at KERNBASE where the system is linked to run */

	movl	_atdevphys,%edx	# get pte PA
	subl	_KPTphys,%edx	# remove base of ptes, now have phys offset
	shll	$PGSHIFT-2,%edx  # corresponding to virt offset
	addl	$KERNBASE,%edx	# add virtual base
	movl	%edx, _atdevbase

	/* Set up bootstrap stack, saving room for a syscall frame */
	movl	$_kstack + UPAGES * NBPG - SYSC_FRAMESIZE,%esp
	VPUT(0x46,5)	/* 'F' */
	xorl	%eax,%eax		# mark end of frames
	movl	%eax,%ebp
	movl	_proc0paddr, %eax
	movl	%esi, PCB_CR3(%eax)

	/* process boot parameters */
	call	_checkbootparams

	lea	(1+UPAGES+1+1)*NBPG(%esi),%esi	# skip past stack.
	pushl	%esi
	
	VPUT(0x47,6)	/* 'G' */
	DEL(1000000)
	call	_init386		# wire 386 chip for kernel operation
	addl	$4,%esp
	
	movl	$0,_PTD

	/*
	 * Build outer stack frame to pass to main.
	 * exec of init will modify this frame, and we
	 * will then use it to "return" to user mode in init.
	 */
	.globl	__ucodesel,__udatasel
	movzwl	__ucodesel,%eax
	movzwl	__udatasel,%ecx
	movl	%ecx,SF_SS(%esp)	# user ss
	movl	$USRSTACK,SF_ESP(%esp)	# user esp
	movl	%eax,SF_CS(%esp)	# user cs
	movl	$0,SF_EIP(%esp)		# user ip
	movl	$PSL_USERSET,SF_EFLAGS(%esp) # user eflags

	pushl	%esp			# &frame
	call 	_main
	addl	$4,%esp

#ifdef LITE
	movzwl	__ucodesel,%eax
	movzwl	__udatasel,%ecx
	movw	%ax,%fs		# double map cs to fs
	movw	%cx,%gs		# and ds to gs
#endif
	/* now in init, ready to go to user mode */
	jmp	Lsyscall_return

	.globl	_sigcode, _szsigcode
_sigcode:
	movl	12(%esp),%eax	# unsure if call will dec stack 1st
	call	%eax
	xorl	%eax,%eax	# smaller movl $103,%eax
	movb	$103,%al	# sigreturn()
	lcall	$LSEL(L43BSDCALLS_SEL,SEL_UPL),$0
	hlt			# never gets here

_szsigcode:
	.long	_szsigcode-_sigcode

	/*
	 * Support routines for GCC
	 */
	ALIGN32
ENTRY(__udivsi3)
	movl 4(%esp),%eax
	xorl %edx,%edx
	divl 8(%esp)
	ret

	ALIGN32
ENTRY(__divsi3)
	movl 4(%esp),%eax
	#xorl %edx,%edx		/* not needed - cltd sign extends into %edx */
	cltd
	idivl 8(%esp)
	ret

	/*
	 * I/O bus instructions via C
	 * Many of these are normally done inline now.
	 */
	ALIGN32
ENTRY(inb)			/* normally done inline now */
	movl	4(%esp),%edx
	subl	%eax,%eax	# clr eax
	inb	%dx,%al
	NOP
	ret

	ALIGN32
ENTRY(inw)			/* normally done inline now */
	movl	4(%esp),%edx
	subl	%eax,%eax	# clr eax
	inw	%dx,%ax
	NOP
	ret


	ALIGN32
ENTRY(rtcin)
	movl	4(%esp),%eax
	outb	%al,$0x70
	subl	%eax,%eax	# clr eax
	inb	$0x71,%al
	ret
	
	ALIGN32
ENTRY(rtcout)
	movl	4(%esp),%eax
	outb	%al,$0x70
	NOP	
	movb	8(%esp),%al
	outb	%al,$0x71
	NOP
	ret

	ALIGN32
ENTRY(outb)			/* normally done inline now */
	movl	4(%esp),%edx
	NOP
	movl	8(%esp),%eax
	outb	%al,%dx
	NOP
	ret

ENTRY(outw)			/* normally done inline now */
	movl	4(%esp),%edx
	NOP
	movl	8(%esp),%eax
	outw	%ax,%dx
	NOP
	ret

	/*
	 * fillw (pat,base,cnt)
	 */
	ALIGN32
ENTRY(fillw)
#ifdef LITE
	pushl	%edi
	movl	8(%esp),%eax
	movl	12(%esp),%edi
	movw	%ax, %cx
	rorl	$16, %eax
	movw	%cx, %ax
	cld
	movl	16(%esp),%ecx
	shrl	%ecx
	rep
	stosl
	movl	16(%esp),%ecx
	andl	$1, %ecx
	rep
	stosw
	popl	%edi
	ret
#else
	pushl	%edi
	movl	8(%esp),%eax
	movl	12(%esp),%edi
	movl	16(%esp),%ecx
	cld
	rep
	stosw
	popl	%edi
	ret
#endif

	# insb(port,addr,cnt)
	ALIGN32
ENTRY(insb)
	pushl	%edi
	movw	8(%esp),%dx
	movl	12(%esp),%edi
	movl	16(%esp),%ecx
	cld
	NOP
	rep
	insb
	NOP
	movl	%edi,%eax
	popl	%edi
	ret

	# insw(port,addr,cnt)
	ALIGN32
ENTRY(insw)
	pushl	%edi
	movw	8(%esp),%dx
	movl	12(%esp),%edi
	movl	16(%esp),%ecx
	cld
	rep; insw
	movl	%edi,%eax
	popl	%edi
	ret

	# insl(port,addr,cnt)
	ALIGN32
ENTRY(insl)
	pushl	%edi
	movw	8(%esp),%dx
	movl	12(%esp),%edi
	movl	16(%esp),%ecx
	cld
	rep; insl
	movl	%edi,%eax
	popl	%edi
	ret

        # outsb(port,addr,cnt)
	ALIGN32
ENTRY(outsb)
        pushl   %esi
        movw    8(%esp),%dx
        movl    12(%esp),%esi
        movl    16(%esp),%ecx
        cld
        rep
        outsb
        movl    %esi,%eax
        popl    %esi
        ret

	# outsw(port,addr,cnt)
	ALIGN32
ENTRY(outsw)
	pushl	%esi
	movw	8(%esp),%dx
	movl	12(%esp),%esi
	movl	16(%esp),%ecx
	cld
	rep; outsw
	movl	%esi,%eax
	popl	%esi
	ret

	# outsl(port,addr,cnt)
	ALIGN32
ENTRY(outsl)
	pushl	%esi
	movw	8(%esp),%dx
	movl	12(%esp),%esi
	movl	16(%esp),%ecx
	cld
	rep; outsl
	movl	%esi,%eax
	popl	%esi
	ret

	/*
	 * void lgdt(*gdt, ngdt);
	 * This could take a "struct region_descriptor"
	 * as parameter, but that is subject to problems
	 * with compiler alignment padding.
	 */
	.data
xxx:	.word 31
	.long 0
	.text
ENTRY(lgdt)
	/* reload the descriptor table */
	movl	4(%esp),%eax
	movl	%eax,xxx+2
	movl	8(%esp),%eax
	movw	%ax,xxx
	lgdt	xxx
	/* flush the prefetch q */
	jmp	1f
	nop
1:
	/* reload "stale" selectors */
	movw	$KDSEL,%ax
	movw	%ax,%ds
	movw	%ax,%es
	movw	$KSSEL,%ax
	movw	%ax,%ss

	/* reload code selector by turning return into intersegmental return */
	movl	(%esp),%eax
	pushl	%eax
	movl	$KCSEL,4(%esp)
	lret

	/*
	 * void lidt(*idt, nidt);
	 * As with lgdt, this could take a "struct region_descriptor".
	 */
	.data
yyy:	.word	255
	.long	0 
	.text
ENTRY(lidt)
	movl	4(%esp),%eax
	movl	%eax,yyy+2
	movl	8(%esp),%eax
	movw	%ax,yyy
	lidt	yyy
	ret

	/*
	 * void lldt(u_short sel)
	 */
ENTRY(lldt)
	lldt	4(%esp)
	ret

	/*
	 * void ltr(u_short sel)
	 */
ENTRY(ltr)
	ltr	4(%esp)
	ret

	/*
	 * void lcr3(caddr_t cr3)
	 */
	ALIGN32
ALTENTRY(load_cr3, _lcr3)
ENTRY(lcr3)
	movl	4(%esp),%eax
#if I386_CR3PAT != 0
 	orl	$I386_CR3PAT,%eax
#endif
	movl	%eax,%cr3
	ret

	/*
	 * void tlbflush(void)
	 */
	ALIGN32
ENTRY(tlbflush)
	movl	%cr3,%eax
#if I386_CR3PAT != 0
 	orl	$I386_CR3PAT,%eax
#endif
	movl	%eax,%cr3
	ret

	/*
	 * void tbis(u_int phys)
	 */
	ALIGN32
ENTRY(tbis)
	cmpl	$CPU_386,_cpu
	jle	_tlbflush
	movl	4(%esp),%eax
#if notyet
	invlpg	(%eax)
#else
	.byte	0xf,0x1,0x38
#endif
	ret

	/*
	 * void lcr0(int cr0)
	 */
	ALIGN32
ALTENTRY(load_cr0, _lcr0)
ENTRY(lcr0)
	movl	4(%esp),%eax
	movl	%eax,%cr0
	ret

	/*
	 * int rcr0(void)
	 */
	ALIGN32
ENTRY(rcr0)
	movl	%cr0,%eax
	ret

	/* 
	 * int rcr2(void)
	 */
	ALIGN32
ENTRY(rcr2)
	movl	%cr2,%eax
	ret

	/*
	 * int rcr3(void)
	 */
	ALIGN32
ENTRY(rcr3)
	movl	%cr3,%eax
	ret

	# ssdtosd(*ssdp,*sdp)
	ALIGN32
ENTRY(ssdtosd)
	pushl	%ebx
	movl	8(%esp),%ecx
	movl	8(%ecx),%ebx
	shll	$16,%ebx
	movl	(%ecx),%edx
	roll	$16,%edx
	movb	%dh,%bl
	movb	%dl,%bh
	rorl	$8,%ebx
	movl	4(%ecx),%eax
	movw	%ax,%dx
	andl	$0xf0000,%eax
	orl	%eax,%ebx
	movl	12(%esp),%ecx
	movl	%edx,(%ecx)
	movl	%ebx,4(%ecx)
	popl	%ebx
	ret

/*
 * The following primitives manipulate the run queues.  _whichqs tells which
 * of the 32 queues _qs have processes in them.  Setrunqueue puts processes
 * into queues, Remrq removes them from queues.  The running process is on
 * no queue, other processes are on a queue related to p->p_priority, divided
 * by 4 actually to shrink the 0-127 range of priorities into the 32 available
 * queues.
 */
	.globl	_whichqs,_qs,_cnt,_panic
	.comm	_prevproc,4
	.comm	_runrun,4

/*
 * void setrunqueue(struct proc *)
 *
 * Interrupts that cause process state transitions must be blocked.
 */
	ALIGN32
ENTRY(setrunqueue)
	movl	4(%esp),%eax
	cmpl	$0,P_BACK(%eax)		# should not be on q already
	je	set1
	pushl	$set2
	call	_panic
set1:
	movzbl	P_PRIORITY(%eax),%edx
	shrl	$2,%edx
	btsl	%edx,_whichqs		# set q full bit
	shll	$3,%edx
	addl	$_qs,%edx		# locate q hdr
	movl	%edx,P_FORW(%eax)	# link process on tail of q
	movl	P_BACK(%edx),%ecx
	movl	%ecx,P_BACK(%eax)
	movl	%eax,P_BACK(%edx)
	movl	%eax,P_FORW(%ecx)
	ret

set2:	.asciz	"setrunqueue"

/*
 * void remrq(struct proc *)
 *
 * Interrupts that cause process state transitions must be blocked.
 */
	ALIGN32
ENTRY(remrq)
	movl	4(%esp),%eax
	movzbl	P_PRIORITY(%eax),%edx
	shrl	$2,%edx
	btrl	%edx,_whichqs		# clear full bit, panic if clear already
	jb	rem1
	pushl	$rem3
	call	_panic
rem1:
	pushl	%edx
	movl	P_FORW(%eax),%ecx	# unlink process
	movl	P_BACK(%eax),%edx
	movl	%edx,P_BACK(%ecx)
	movl	P_BACK(%eax),%ecx
	movl	P_FORW(%eax),%edx
	movl	%edx,P_FORW(%ecx)
	popl	%edx
	movl	$_qs,%ecx
	shll	$3,%edx
	addl	%edx,%ecx
	cmpl	P_FORW(%ecx),%ecx	# q still has something?
	je	rem2
	shrl	$3,%edx			# yes, set bit as still full
	btsl	%edx,_whichqs
rem2:
	movl	$0,P_BACK(%eax)		# zap reverse link to indicate off list
	ret

rem3:	.asciz	"remrq"
sw0:	.asciz	"cpu_switch"

/*
 * When no processes are on the run queue, cpu_switch branches to idle
 * to wait for something to come ready.
 */
	ALIGN32
ENTRY(Idle)
idle:
	movl	_curproc,%eax
	movl	%eax,_prevproc		# remember which proc is mapped
	movl	$0,_curproc		# don't bill idle time to previous proc
1:
	call	_spl0
	cmpl	$0,_whichqs
	jne	sw1
	hlt		# wait for interrupt
	jmp	1b

	.align 4 /* ..so that profiling doesn't lump Idle with cpu_switch().. */
badsw:
	pushl	$sw0
	call	_panic
	/*NOTREACHED*/

/*
 * void cpu_switch(void)
 * (actually, curproc is passed as a parameter, thanks!)
 */
ENTRY(cpu_switch)

	/* switch to new process. first, save context as needed */

	movl	_curproc,%ecx
switch_entry:
#ifdef LITE	/* does this happen??? */

	/* if no process to save, don't bother */
	cmpl	$0,%ecx
	je	sw1

#endif /* LITE */
	movl	P_ADDR(%ecx),%ecx


	movl	(%esp),%eax		# Hardware registers
	movl	%eax, PCB_EIP(%ecx)
	movl	%ebx, PCB_EBX(%ecx)
	movl	%esp, PCB_ESP(%ecx)
	movl	%ebp, PCB_EBP(%ecx)
	movl	%esi, PCB_ESI(%ecx)
	movl	%edi, PCB_EDI(%ecx)

/* the following section is used only with an NPX enabled */
	.globl	_npxproc
	movl	%cr0, %eax
	testb	$CR0_EM, %al
	jne	1f
#ifdef notyet
	fwait				/* paranoid, get exceptions now */
#else
	fnsave	PCB_SAVEFPU(%ecx)
	movl	$0, _npxproc
#endif
	orb 	$CR0_EM,%al		/* disable fpu */
	movl	%eax,%cr0
1:
/* end only with NPX */

#ifndef LITE
	movl	_CMAP2,%eax		# save temporary map PTE
	movl	%eax,PCB_CMAP2(%ecx)	# in our context
#endif

	/* save is done, now choose a new process or idle */
sw1:
	cli				# XXX?
	movl	_whichqs,%edi
2:
	bsfl	%edi,%eax		# find a full q
	jz	idle			# if none, idle
	/* XX update whichqs? */
swfnd:
	btrl	%eax,%edi		# clear q full status
	jnb	2b			# if it was clear, look for another
	movl	%eax,%ebx		# save which one we are using

	shll	$3,%eax
	addl	$_qs,%eax		# select q
	movl	%eax,%esi

#ifdef	DIAGNOSTIC
	cmpl	P_FORW(%eax),%eax # linked to self? (e.g. not on list)
	je	badsw			# not possible
#endif

	movl	P_FORW(%eax),%ecx	# unlink from front of process q
	movl	P_FORW(%ecx),%edx
	movl	%edx,P_FORW(%eax)
	movl	P_BACK(%ecx),%eax
	movl	%eax,P_BACK(%edx)

	cmpl	P_FORW(%ecx),%esi	# q empty
	je	3f
	btsl	%ebx,%edi		# nope, set to indicate full
3:
	movl	%edi,_whichqs		# update q status

	movl	$0,%eax
	movl	%eax,_want_resched

#ifdef	DIAGNOSTIC
	cmpl	%eax,P_WCHAN(%ecx)
	jne	badsw
	cmpb	$SRUN,P_STAT(%ecx)
	jne	badsw
#endif

	movl	%eax,P_BACK(%ecx) 	/* isolate process to run */
	movl	P_ADDR(%ecx),%edx
	movl	PCB_CR3(%edx),%ebx

	/* switch address space */
	movl	%ebx,%cr3

	/* restore context */
	movl	PCB_EBX(%edx), %ebx
	movl	PCB_ESP(%edx), %esp
	movl	PCB_EBP(%edx), %ebp
	movl	PCB_ESI(%edx), %esi
	movl	PCB_EDI(%edx), %edi
	movl	PCB_EIP(%edx), %eax
	movl	%eax, (%esp)

#ifndef LITE
	movl	PCB_CMAP2(%edx),%eax	# get temporary map
	movl	%eax,_CMAP2		# reload temporary map PTE
#endif

	movl	PCB_LDTDEFCALL(%edx),%eax	/* install the default ... */
	movl	%eax,_ldt+(LDEFCALLS_SEL*8)	/* ... system call descriptor */
	movl	(PCB_LDTDEFCALL+4)(%edx),%eax
	movl	%eax,_ldt+((LDEFCALLS_SEL*8)+4)

	movl	%ecx,_curproc		/* into next process */
	movl	%edx,_curpcb

	movl	%edx,%eax		# return (1);
	ret

/*
 * switch_exit() -- Crude, temporary hack so that curproc may be left unset
 * while this process makes its last context switch.  We can't permit
 * curproc to be set, since hardclock looks at it and does awful things.
 */
ENTRY(switch_exit)
	incl	_cnt+V_SWTCH
	movl	4(%esp),%ecx
	jmp	switch_entry

	ALIGN32
ENTRY(mvesp)
	movl	%esp,%eax
	ret

#ifdef notdef
/*
 * struct proc *switch_to_inactive(p) ; struct proc *p;
 *
 * At exit of a process, move off the address space of the
 * process and onto a "safe" one. Then, on a temporary stack
 * return and run code that disposes of the old state.
 * Since this code requires a parameter from the "old" stack,
 * pass it back as a return value.
 */
	ALIGN32
ENTRY(switch_to_inactive)
	popl	%edx			# old pc
	popl	%eax			# arg, our return value
	movl	_IdlePTD,%ecx
	movl	%ecx,%cr3		# good bye address space
 #write buffer?
	movl	$tmpstk-4,%esp		# temporary stack, compensated for call
	jmp	%edx			# return, execute remainder of cleanup
#endif

/*
 * savectx(pcb, altreturn)
 * Update pcb, saving current processor state and arranging
 * for alternate return ala longjmp in cpu_switch if altreturn is true.
 */
	ALIGN32
ENTRY(savectx)
	movl	4(%esp), %ecx
	movl	(%esp), %eax	
	movl	%eax, PCB_EIP(%ecx)
	movl	%ebx, PCB_EBX(%ecx)
	movl	%esp, PCB_ESP(%ecx)
	movl	%ebp, PCB_EBP(%ecx)
	movl	%esi, PCB_ESI(%ecx)
	movl	%edi, PCB_EDI(%ecx)

/* the following section is used only with an NPX enabled */
	/*
	 * If the current process has used floating point,
	 * either the current savefpu area is valid, in which case
	 * we don't need to do anything here, or the caller has
	 * used floating point since the last context switch.
	 * In this case, the CR0_EM bit will be off, and we need
	 * to save the current state in the new pcb.
	 */
	movl	%cr0, %edx
	testb	$CR0_EM, %dl
	jne	1f
	fnsave	PCB_SAVEFPU(%ecx)
1:
/* end only with NPX */
#ifndef LITE
	movl	_CMAP2, %edx		# save temporary map PTE
	movl	%edx, PCB_CMAP2(%ecx)	# in our context
#endif

	cmpl	$0, 8(%esp)
	je	1f
	movl	%esp, %edx		# relocate current sp relative to pcb
	subl	$_kstack, %edx		#   (sp is relative to kstack):
	addl	%edx, %ecx		#   pcb += sp - kstack;
	movl	%eax, (%ecx)		# write return pc at (relocated) sp@
	# this mess deals with replicating register state gcc hides
	movl	12(%esp),%eax
	movl	%eax,12(%ecx)
	movl	16(%esp),%eax
	movl	%eax,16(%ecx)
	movl	20(%esp),%eax
	movl	%eax,20(%ecx)
	movl	24(%esp),%eax
	movl	%eax,24(%ecx)
1:
	xorl	%eax, %eax		# return 0
	ret

#if 0
/*
 * addupc(int pc, struct uprof *up, int ticks):
 * update profiling information for the user process.
 */

	ALIGN32
ENTRY(addupc)
#ifndef LITE
	movl	4(%esp),%eax		/* pc */
	movl	8(%esp),%ecx		/* up */

	/* does sampled pc fall within bottom of profiling window? */
	subl	PR_OFF(%ecx),%eax 	/* pc -= up->pr_off; */
	jl	1f 			/* if (pc < 0) return; */

	/* construct scaled index */
	shrl	$1,%eax			/* reduce pc to a short index */
	mull	PR_SCALE(%ecx)		/* pc*up->pr_scale */
	shrdl	$15,%edx,%eax 		/* praddr >> 15 */
	cmpl	$0,%edx			/* if overflow, ignore */
	jne	1f
	andb	$0xfe,%al		/* praddr &= ~1 */

	/* within profiling buffer? if so, compute address */
	cmpl	%eax,PR_SIZE(%ecx)	/* if (praddr >= up->pr_size) return; */
	jle	1f
	addl	PR_BASE(%ecx),%eax	/* praddr += up->pr_base; */

	/* tally ticks to selected counter */
	movl	_curpcb,%ecx
	movl	$proffault,PCB_ONFAULT(%ecx) #in case we page/protection violate
	movl	12(%esp),%edx		/* ticks */
	addw	%dx,(%eax)
	movl	$0,PCB_ONFAULT(%ecx)
1:	ret

proffault:
	/* disable profiling if we get a fault */
	movl	$0,PR_SCALE(%ecx) /*	up->pr_scale = 0; */
	movl	_curpcb,%ecx
	movl	$0,PCB_ONFAULT(%ecx)
	ret
#else
	pushl %ebp
	movl %esp,%ebp
	movl 12(%ebp),%edx		/* up */
	movl 8(%ebp),%eax		/* pc */

	subl PR_OFF(%edx),%eax		/* pc -= up->pr_off */
	jl L1				/* if (pc < 0) return */

	shrl $1,%eax			/* praddr = pc >> 1 */
	imull PR_SCALE(%edx),%eax	/* praddr *= up->pr_scale */
	shrl $15,%eax			/* praddr = praddr << 15 */
	andl $-2,%eax			/* praddr &= ~1 */

	cmpl PR_SIZE(%edx),%eax		/* if (praddr > up->pr_size) return */
	ja L1

/*	addl %eax,%eax			/* praddr -> word offset */
	addl PR_BASE(%edx),%eax		/* praddr += up-> pr_base */
	movl 16(%ebp),%ecx		/* ticks */

	movl _curpcb,%edx
	movl $proffault,PCB_ONFAULT(%edx)
	addl %ecx,(%eax)		/* storage location += ticks */
	movl $0,PCB_ONFAULT(%edx)
L1:
	leave
	ret

proffault:
	/* if we get a fault, then kill profiling all together */
	movl $0,PCB_ONFAULT(%edx)	/* squish the fault handler */
 	movl 12(%ebp),%ecx
	movl $0,PR_SCALE(%ecx)		/* up->pr_scale = 0 */
	leave
	ret
#endif
#endif /* 0 */

.data
	.globl	_cyloffset, _curpcb
_cyloffset:	.long	0
	.globl	_proc0paddr
_proc0paddr:	.long	0

#define	PANIC(msg)	xorl %eax,%eax; movl %eax,_waittime; pushl 1f; \
			call _panic; 1: .asciz msg
#define	PRINTF(n,msg)	pushal; nop; pushl 1f; call _printf; MSG(msg) ; \
			 popl %eax ; popal
#define	MSG(msg)	.data; 1: .asciz msg; .text

	.text

/*
 * Trap and fault vector routines
 */ 
#define	TRAP(a)		pushl $(a) ; jmp alltraps
#ifdef KGDB
#define	BPTTRAP(a)	pushl $(a) ; jmp bpttraps
#else
#define	BPTTRAP(a)	TRAP(a)
#endif

	.globl	_START_TRAPS
_START_TRAPS:
IDTVEC(div)
	pushl $0; TRAP(T_DIVIDE)
IDTVEC(dbg)
	pushl $0; BPTTRAP(T_TRCTRAP)
IDTVEC(nmi)
	pushl $0; TRAP(T_NMI)
IDTVEC(bpt)
	pushl $0; BPTTRAP(T_BPTFLT)
IDTVEC(ofl)
	pushl $0; TRAP(T_OFLOW)
IDTVEC(bnd)
	pushl $0; TRAP(T_BOUND)
IDTVEC(ill)
	pushl $0; TRAP(T_PRIVINFLT)
IDTVEC(dna)
	pushl $0; TRAP(T_DNA)
IDTVEC(fpusegm)
	pushl $0; TRAP(T_FPOPFLT)
IDTVEC(tss)
	TRAP(T_TSSFLT)
	/*PANIC("TSS not valid");*/
IDTVEC(missing)
	TRAP(T_SEGNPFLT)
IDTVEC(stk)
	TRAP(T_STKFLT)
IDTVEC(prot)
	TRAP(T_PROTFLT)
IDTVEC(page)
	TRAP(T_PAGEFLT)
IDTVEC(rsvd)
	pushl $0; TRAP(T_RESERVED_15)
IDTVEC(fpu)
#ifndef LITE
	pushl $0; TRAP(T_ARITHTRAP)
#else
#ifdef NPX
	/*
	 * Handle like an interrupt so that we can call npxintr to clear the
	 * error.  It would be better to handle npx interrupts as traps but
	 * this is difficult for nested interrupts.
	 */
	pushl	$0		/* dummy error code */
	pushl	$T_ASTFLT
	pushal
	nop			/* silly, the bug is for popal and it only
				 * bites when the next instruction has a
				 * complicated address mode */
	pushl	%ds
	pushl	%es		/* now the stack frame is a trap frame */
	movl	$KDSEL,%eax
	movl	%ax,%ds
	movl	%ax,%es
	pushl	_cpl
	pushl	$0		/* dummy unit to finish building intr frame */
	incl	_cnt+V_TRAP
	call	_npxintr
	jmp	doreti
#else
	pushl $0; TRAP(T_ARITHTRAP)
#endif
#endif /* LITE */
IDTVEC(align)
	pushl $0; TRAP(T_ALIGNFLT)
	/* 18 - 31 reserved for future exp */
IDTVEC(rsvd1)
	pushl $0; TRAP(T_RESERVED_18)
IDTVEC(rsvd2)
	pushl $0; TRAP(T_RESERVED_19)
IDTVEC(rsvd3)
	pushl $0; TRAP(T_RESERVED_20)
IDTVEC(rsvd4)
	pushl $0; TRAP(T_RESERVED_21)
IDTVEC(rsvd5)
	pushl $0; TRAP(T_RESERVED_22)
IDTVEC(rsvd6)
	pushl $0; TRAP(T_RESERVED_23)
IDTVEC(rsvd7)
	pushl $0; TRAP(T_RESERVED_24)
IDTVEC(rsvd8)
	pushl $0; TRAP(T_RESERVED_25)
IDTVEC(rsvd9)
	pushl $0; TRAP(T_RESERVED_26)
IDTVEC(rsvd10)
	pushl $0; TRAP(T_RESERVED_27)
IDTVEC(rsvd11)
	pushl $0; TRAP(T_RESERVED_28)
IDTVEC(rsvd12)
	pushl $0; TRAP(T_RESERVED_29)
IDTVEC(rsvd13)
	pushl $0; TRAP(T_RESERVED_30)
IDTVEC(rsvd14)
	pushl $0; TRAP(T_RESERVED_31)

	ALIGN32
alltraps:
	pushal
	nop
	push %ds
	push %es
	movw	$KDSEL,%ax
	movw	%ax,%ds
	movw	%ax,%es
calltrap:
	call	_trap
#ifndef LITE
	pop %es
	pop %ds
	popal
	nop
	addl	$8,%esp			# pop type, code

	.globl _iret_from_trap
_iret_from_trap:
	iret
#else /* LITE */
	/*
	 * Return through doreti to handle ASTs.  Have to change trap frame
	 * to interrupt frame.
	 */
	movl	$T_ASTFLT,4+4+32(%esp)	/* new trap type (err code not used) */
	pushl	_cpl
	pushl	$0			/* dummy unit */
	jmp	doreti
#endif /* LITE */

#ifdef KGDB
/*
 * This code checks for a kgdb trap, then falls through
 * to the regular trap code.
 */
	ALIGN32
bpttraps:
	pushal				# save trapframe
	nop
	push	%es
	push	%ds
	movw	$KDSEL,%ax		# switch to kernel data segment
	movw	%ax,%ds
	movw	%ax,%es
	xorl	%eax,%eax
	movw	52(%esp),%eax		# test code segment
	testl	$3,%eax			# was it user code?
	jne	calltrap		# yes, call trap
	cli				# no, lock out interrupts and call kgdb
	call	_kgdb_trap_glue		#   (interrupts are re-enabled by iret)
	/*
	 * Note: kgdb will do its own iret and never return.  However,
	 * if the debugger isn't there (i.e., it's improperly configured)
	 * then it can return --- in this case, we'll panic via trap.
	 */
	jmp	calltrap
#endif

	.globl	_END_TRAPS
_END_TRAPS:

/*
 * Call gate entry for syscall
 */

	ALIGN32
IDTVEC(syscall)
	pushfl	# only for stupid carry bit and more stupid wait3 cc kludge
	pushal	# only need eax,ecx,edx - trap resaves others
	nop
	movl	$KDSEL,%eax		# switch to kernel segments
	movl	%ax,%ds
	movl	%ax,%es
	call	_syscall
Lsyscall_return:
#ifndef LITE
	movw	__udatasel,%ax	# switch back to user segments
	movw	%ax,%ds
	movw	%ax,%es
	popal
	nop
	popfl

	/*
	 * Note: if we ever change syscall to return with an iret,
	 * will will have to make sure we clear the PSL_NT first.
	 * lret ignores this bit, so we don't have to worry about
	 * it now.
	 */
	.globl _lret_from_syscall
_lret_from_syscall:
	lret
#else /* LITE */
	/*
	 * Return through doreti to handle ASTs.  Have to change syscall frame
	 * to interrupt frame.
	 *
	 * XXX - we should have set up the frame earlier to avoid the
	 * following popal/pushal (not much can be done to avoid shuffling
	 * the flags).  Consistent frames would simplify things all over.
	 */
	movl	32+0(%esp),%eax	/* old flags, shuffle to above cs:eip */
	movl	32+4(%esp),%ebx	/* `int' frame should have been ef, eip, cs */
	movl	32+8(%esp),%ecx
	movl	%ebx,32+0(%esp)
	movl	%ecx,32+4(%esp)
	movl	%eax,32+8(%esp)
	popal
	nop
	pushl	$0		/* dummy error code */
	pushl	$T_ASTFLT
	pushal
	nop
	movl	__udatasel,%eax	/* switch back to user segments */
	push	%eax		/* XXX - better to preserve originals? */
	push	%eax
	pushl	_cpl
	pushl	$0
	jmp	doreti
#endif /* LITE */

/*
 * Switch to vm86 mode.
 * We clean kernel stack each time.
 */

ENTRY(switch_to_vm86)
	cli
	movl	4(%esp), %esi			# from
	movl	8(%esp), %edi			# to
	movl	12(%esp), %ecx			# count
	movl	%edi, %esp			# new stack
	shrl	$2,%ecx	
	cld
	rep
	movsl
# below ala return from trap
	pop	%eax				# drop es
	pop	%eax				# drop ds
	pop	%edi
	pop	%esi
	pop	%ebp
	pop	%eax				# drop sp
	pop	%ebx
	pop	%edx
	pop	%ecx
	pop	%eax
	addl	$8,%esp			# pop type, code
	iret


/* The following are normally done in-line */
	ALIGN32
ALTENTRY(htonl, _ntohl)
ENTRY(ntohl)
	movl	4(%esp),%eax
	xchgb	%al,%ah
	roll	$16,%eax
	xchgb	%al,%ah
	ret

	ALIGN32
ALTENTRY(htons, _ntohs)
ENTRY(ntohs)
	movzwl	4(%esp),%eax
	xchgb	%al,%ah
	ret

#ifndef HZ
/*
 * Implementation of microtime that reads timer 0 to determine
 * the time within the current tick.  Assumes 100 Hz clock.
 */
ENTRY(microtime)
	pushl	%edi
	pushl	%esi
	pushl	%ebx

	movl	$_time,%ebx

	cli				# disable interrupts

	movl	(%ebx),%edi		# sec = time.tv_sec
	movl	4(%ebx),%esi		# usec = time.tv_usec

	movl	$(TIMER_SEL0|TIMER_LATCH),%eax
	outb	%al,$TIMER_MODE		# latch timer 0's counter

	#	
	# Read counter value into ebx, LSB first
	#
	inb	$TIMER_CNTR0,%al
	movzbl	%al,%ebx
	inb	$TIMER_CNTR0,%al
	movb	%al,%bh

	cmpl	$11932,%ebx	# check for bogus values
	ja	3f		# if bogus, don't use it

	#
	# Now check for counter overflow.  This is tricky because the
	# timer chip doesn't let us atomically read the current counter
	# value and the output state (i.e., overflow state).  We have
	# to read the ICU interrupt request register (IRR) to see if the
	# overflow has occured.  Because we lack atomicity, we use
	# the (completely accurate) heuristic that we only check for
	# overflow if the value read is close to the interrupt period.
	# E.g., if we just checked the IRR, we might read a non-overflowing
	# value close to 0, experience overflow, then read this overflow
	# from the IRR, and mistakingly add a correction to the "close
	# to zero" value.
	#
	# We compare the counter value to heuristic constant 11890.
	# If the counter value is less than this, we assume the counter
	# didn't overflow between disabling interrupts above and latching
	# the counter value.  For example, we assume that the above 10 or so
	# instructions take less than 11932 - 11890 = 42 microseconds to
	# execute.
	#
	# Otherwise, the counter might have overflowed.  We check for this
	# condition by reading the interrupt request register out of the ICU.
	# If it overflowed, we add in one clock period.
	#
	cmpl	$11890,%ebx
	jle	2f
	movl	$0x0a,%eax	# tell ICU we want IRR
	outb	%al,$IO_ICU1

	inb	$IO_ICU1,%al	# read IRR in ICU
	testb	$1,%al		# is a timer interrupt pending?
	je	1f
	addl	$-11932,%ebx	# yes, subtract one clock period
1:
	movl	$0x0b,%eax	# tell ICU we want ISR 
	outb	%al,$IO_ICU1	#   (rest of kernel expects this)
2:
	sti			# enable interrupts

	movl	$11932,%eax	# subtract counter value from 11932 since
	subl	%ebx,%eax	#   it is a count-down value
	imull	$1000,%eax,%eax
	movl	$0,%edx		# zero extend eax for div
	movl	$1193,%ecx
	idivl	%ecx		# convert to usecs: mult by 1000/1193

	addl	%eax,%esi	# add counter usecs to time.tv_usec
	cmpl	$1000000,%esi	# carry in timeval?
	jl	3f
	subl	$1000000,%esi	# adjust usec
	incl	%edi		# bump sec
3:
	movl	16(%esp),%ecx	# load timeval pointer arg
	movl	%edi,(%ecx)	# tvp->tv_sec = sec
	movl	%esi,4(%ecx)	# tvp->tv_usec = usec

	popl	%ebx		# restore regs
	popl	%esi
	popl	%edi
	ret
#endif /* HZ */

	.align 4		/* for icu.o, immediately following */
