/*-
 * Copyright (c) 1993, 1994 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: i386_param.c,v 2.3 1995/12/01 22:47:39 cp Exp $
 */

/*
 * Configuration-dependent data for i386 kernels.
 */

#include <sys/param.h>
#include <sys/reboot.h>
#include <sys/systm.h>
#include <sys/device.h>
#include <sys/ioctl.h>
#include <sys/tty.h>

#include <i386/i386/cons.h>

/*
 * Parameters
 */
#ifndef SYSPTSIZE
#define	SYSPTSIZE 0		/* dynamically chosen based on physmem */
#endif
int	sysptsize = SYSPTSIZE;	/* system page table size, in pages */

/*
 * Root configuration
 */
configroot()
{

#if GENERIC
	if ((boothowto & RB_ASKNAME) == 0)
		setroot();
	setconf();
#else
	setroot();
#endif
}

/*
 * Machine-dependent onfiguration parameters.
 */
#ifdef PARITY_ERR_PANIC
int	nmi_panic = 1;	/* panic on NMI parity errors/channel checks */
#else
int	nmi_panic = 0;	/* do not panic on NMI parity errors/channel checks */
#endif

/*
 * Configuration for com driver.
 * This is referenced by checkbootparams, so is always included. These
 * are overridden if the bootstrap passes a com console specification.
 */
#include <i386/isa/isa.h>

#include "com.h"

#ifdef COMCONSOLE
int	comconsole = COMCONSOLE;
#else
int	comconsole = -1;
#endif
#ifndef	COMCNADDR
#define COMCNADDR IO_COM1
#endif
int	com_cnaddr = COMCNADDR;		/* console base address */
int	com_cnrate = TTYDEF_SPEED;	/* for console */


/*
 * configuration for pccons console driver
 */
#include "pccons.h"
#if NPCCONS > 0

#include <i386/isa/isavar.h>
#include <i386/isa/pcconsvar.h>

#ifdef PCCONS_NOCOLOR
int	pccons_trycolor = 0;
#else
int	pccons_trycolor = 1;
#endif
int	cntlaltdel = 1;		/* recognize cntl-alt-del, ask reboot? */
#ifdef DEBUG
int	cntlaltdelcore = 1;	/* ask about core dump? */
#else
int	cntlaltdelcore = 0;	/* ask about core dump? */
#endif

#ifndef	KBD
#define	KBD	US
#endif

/*
 * Macro magic to #include KBDPREF ## KBD
 */
#undef i386
#ifdef __STDC__ 
#define KBDPREF	i386/isa/kbd/pcconstab.
#define	R(a,b)	< ## a ## b ## >
#define	S(a,b)	R(a,b)

#include S(KBDPREF,KBD)

#else /* __STDC__ */

#define KBDPREF	i386/isa/kbd/pcconstab
#define	D	KBDPREF.KBD
#define	I	<D>
#include I
#endif /* __STDC__ */
#define	i386
#endif

/* configuration for indirect console driver */
/* XXX - all this could be autoconfig()ed */
#if NPCCONS > 0
int pccnprobe(), pccninit(), pccngetc(), pccnputc();
#endif
#if NCOM > 0
int comcnprobe(), comcninit(), comcngetc(), comcnputc();
#endif

struct	consdev constab[] = {
#if NPCCONS > 0
	{ pccnprobe,	pccninit,	pccngetc,	pccnputc },
#endif
#if NCOM > 0
	{ comcnprobe,	comcninit,	comcngetc,	comcnputc },
#endif
	{ 0 },
};
/* end XXX */

#include "npx.h"
#if NNPX == 0
npxinit(p, control)
	struct proc *p;
	int control;
{
}
#endif

/* 
 * Only look a the first 32 of 256 pci buses. Some machines wrap the
 * address space. The Compaq Proliant wraps at 64.
 */
#ifndef	PCI_SCAN_BUSES
#define	PCI_SCAN_BUSES 32
#endif 
int	pci_scan_buses = PCI_SCAN_BUSES;

/*
 * By default only look at the first function on each pci agent.
 */
#ifndef	PCI_SCAN_FUNCTIONS
#define	PCI_SCAN_FUNCTIONS 1
#endif
int	pci_scan_functions = PCI_SCAN_FUNCTIONS;
