/*
 * Copyright (c) 1992, 1993, 1994, 1995 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: scsi_subr.c,v 2.4 1995/12/12 22:29:42 karels Exp $
 */

/*
 * Copyright (c) 1992, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This software was developed by the Computer Systems Engineering group
 * at Lawrence Berkeley Laboratory under DARPA contract BG 91-66 and
 * contributed to Berkeley.
 *
 * All advertising materials mentioning features or use of this software
 * must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Lawrence Berkeley Laboratories.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)scsi_subr.c	8.1 (Berkeley) 6/16/93
 *
 * from: Header: scsi_subr.c,v 1.10 93/02/01 19:21:58 torek Exp (LBL)
 */

/*
 * Generic SCSI host adapter driver.
 * Does almost nothing (most work is relegated to per-hba drivers).
 */

#include <sys/param.h>
#include <sys/buf.h>
#include <sys/device.h>
#include <sys/reboot.h>

#include <dev/scsi/scsi.h>
#include <dev/scsi/scsivar.h>
#include <dev/scsi/disktape.h>

/*
 * General subroutines, and scsi data.
 */

/*
 * Table of scsi commands users are allowed to access via `format'
 * mode.  0 means not legal.  1 means `immediate' (doesn't need dma).
 * -1 means needs dma and/or wait for intr (i.e., `slow').
 */
char scsi_legal_cmds[256] = {
/*****  0   1   2   3   4   5   6   7     8   9   A   B   C   D   E   F */
/*00*/	1, -1,  0,  1, -1,  0,  0,  0,   -1,  0,  0,  0,  0,  0,  0,  0,
/*10*/ -1, -1,  1,  0,  0,  1,  0,  0,    0, -1,  1, -1,  0,  1,  1,  0,
/*20*/	0,  0,  0,  0,  0,  1,  0,  0,   -1,  0, -1,  0,  0,  0,  0,  0,
/*30*/	0,  0,  0,  0,  0,  1,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
/*40*/	0,  0,  0,  1,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
/*50*/	0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
/*60*/	0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
/*70*/	0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
/*80*/	0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
/*90*/	0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
/*a0*/	0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
/*b0*/	0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
/*c0*/	0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
/*d0*/	0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
/*e0*/	0,  0,  1,  0,  1,  1,  1,  1,    0,  1,  0,  0,  1,  0,  0,  0,
/*f0*/	0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
};

/* table of lengths of scsi commands */
const char scsicmdlen[8] = { 6, 10, 10, 0, 0, 12, 10, 10 };

/* table of lengths of scsi messages */
const signed char scsimsglen[0x24] = {
	SMLEN_DONE,		/* MSG_CMD_COMPLETE */
	SMLEN_EXTENDED,		/* MSG_EXT_MESSAGE */
	1,			/* MSG_SAVE_DATA_PTR */
	1,			/* MSG_RESTORE_PTR */
	1,			/* MSG_DISCONNECT */
	1,			/* MSG_INIT_DETECT_ERROR */
	1,			/* MSG_ABORT */
	1,			/* MSG_REJECT */
	1,			/* MSG_NOOP */
	1,			/* MSG_PARITY_ERROR */
	1,			/* MSG_LCC */
	1,			/* MSG_LCCF */
	1,			/* MSG_BUS_DEVICE_RESET */
	1,			/* MSG_ABORT_TAG */
	1,			/* MSG_CLEAR_QUEUE */
	1,			/* MSG_INITIATE_RECOVERY */
	1,			/* MSG_RELEASE_RECOVERY */
	1,			/* MSG_TERMINATE_PROCESS */
	SMLEN_UNDEF,		/* 0x12 */
	SMLEN_UNDEF,		/* 0x13 */
	SMLEN_UNDEF,		/* 0x14 */
	SMLEN_UNDEF,		/* 0x15 */
	SMLEN_UNDEF,		/* 0x16 */
	SMLEN_UNDEF,		/* 0x17 */
	SMLEN_UNDEF,		/* 0x18 */
	SMLEN_UNDEF,		/* 0x19 */
	SMLEN_UNDEF,		/* 0x1a */
	SMLEN_UNDEF,		/* 0x1b */
	SMLEN_UNDEF,		/* 0x1c */
	SMLEN_UNDEF,		/* 0x1d */
	SMLEN_UNDEF,		/* 0x1e */
	SMLEN_UNDEF,		/* 0x1f */
	2,			/* MSG_SIMPLE_QTAG */
	2,			/* MSG_HEAD_QTAG */
	2,			/* MSG_ORDERED_QTAG */
	2,			/* MSG_IGNORE_WIDE_RESID */
};

const char *const scsisensekeymsg[16] = {
	"no sense",
	"recovered error",
	"not ready",
	"media error",		/* [sic -- a concession to illiteracy] */
	"hardware error",
	"illegal request",
	"unit attention",
	"data protect",
	"blank check",
	"vendor specific error",
	"copy aborted",
	"aborted command",
	"equal comparison",
	"volume overflow",
	"miscompare",
	"reserved error code"
};

const struct asccode {
	u_char	a_asc;
	u_char	a_ascq;
	const	char *a_code;
} asctab[] = {
	{ 0x00, 0x00, "no additional sense information" },
#if 0 /* not really errors */
	{ 0x00, 0x01, "filemark" },
	{ 0x00, 0x02, "end of partition/medium" },
	{ 0x00, 0x03, "setmark" },
	{ 0x00, 0x04, "beginning-of-partition/medium" },
	{ 0x00, 0x05, "end-of-data" },
	{ 0x00, 0x06, "I/O process terminated" },
	{ 0x00, 0x11, "audio play in progress" },
	{ 0x00, 0x12, "audio play paused" },
	{ 0x00, 0x13, "audio play completed" },
	{ 0x00, 0x14, "audio play stopped due to error" },
	{ 0x00, 0x15, "no current audio status to return" },
#endif
	{ 0x01, 0x00, "no index/sector signal" },
	{ 0x02, 0x00, "no seek complete" },
	{ 0x03, 0x00, "device write fault" },
	{ 0x03, 0x01, "no write current" },
	{ 0x03, 0x02, "excessive write errs" },
	{ 0x04, 0x00, "not ready, cause not reportable" },
	{ 0x04, 0x01, "becoming ready" },
	{ 0x04, 0x02, "not ready, init command required" },
	{ 0x04, 0x03, "not ready, manual intervention required" },
	{ 0x04, 0x04, "not ready, format in progress" },
	{ 0x05, 0x00, "unit does not respond to selection" },
	{ 0x06, 0x00, "no reference position found" },
	{ 0x07, 0x00, "multiple peripheral devices selected" },
	{ 0x08, 0x00, "unit communication failure" },
	{ 0x08, 0x01, "unit communication time-out" },
	{ 0x08, 0x02, "unit communication parity err" },
	{ 0x09, 0x00, "track following err" },
	{ 0x09, 0x01, "track servo failure" },
	{ 0x09, 0x02, "focus servo failure" },
	{ 0x09, 0x03, "spindle servo failure" },
	{ 0x0a, 0x00, "error log overflow" },
	{ 0x0c, 0x00, "write error" },
	{ 0x0c, 0x01, "write error recovered w/auto realloc" },
	{ 0x0c, 0x02, "write error, auto realloc failed" },
	{ 0x10, 0x00, "ID CRC or ECC error" },
	{ 0x11, 0x00, "unrecovered read error" },
	{ 0x11, 0x01, "read retries exhausted" },
	{ 0x11, 0x02, "error too long to correct" },
	{ 0x11, 0x03, "multiple read errors" },
	{ 0x11, 0x04, "unrecovered read error, auto realloc failed" },
	{ 0x11, 0x05, "L-EC uncorrectable error" },
	{ 0x11, 0x06, "CIRC unrecovered error" },
	{ 0x11, 0x07, "data resynch error" },
	{ 0x11, 0x08, "incomplete block read" },
	{ 0x11, 0x09, "no gap found" },
	{ 0x11, 0x0a, "miscorrected error" },
	{ 0x11, 0x0b, "unrecovered read error, recommend reassignment" },
	{ 0x11, 0x0c, "unrecovered read error, recommend rewrite" },
	{ 0x12, 0x00, "address mark not found, ID" },
	{ 0x13, 0x00, "address mark not found, data" },
	{ 0x14, 0x00, "recorded entity not found" },
	{ 0x14, 0x01, "record not found" },
	{ 0x14, 0x02, "filemark/setmark not found" },
	{ 0x14, 0x03, "end-of-data not found" },
	{ 0x14, 0x04, "block seq error" },
	{ 0x15, 0x00, "random positioning error" },
	{ 0x15, 0x01, "mech. positioning error" },
	{ 0x15, 0x02, "positioning error (read of medium)" },
	{ 0x16, 0x00, "data synch mark error" },
	{ 0x17, 0x00, "recovered data, no error correction" },
	{ 0x17, 0x01, "recovered data, retries" },
	{ 0x17, 0x02, "recovered data, pos head off" },
	{ 0x17, 0x03, "recovered data, neg head off" },
	{ 0x17, 0x04, "recovered data, retries and or CIRC" },
	{ 0x17, 0x05, "recovered data w/previous sector ID" },
	{ 0x17, 0x06, "recovered data w/o ECC, data auto-realloc" },
	{ 0x17, 0x07, "recovered data w/o ECC, recommend reassign" },
	{ 0x17, 0x08, "recovered data w/o ECC, recommend rewrite" },
	{ 0x18, 0x00, "recovered data w/error corr." },
	{ 0x18, 0x01, "recovered data w/error corr. and retries" },
	{ 0x18, 0x02, "recovered data, data auto-reallocated" },
	{ 0x18, 0x03, "recovered data w/CIRC" },
	{ 0x18, 0x04, "recovered data w/LEC" },
	{ 0x18, 0x05, "recovered data, recommend reassign" },
	{ 0x18, 0x06, "recovered data, recommend rewrite" },
	{ 0x19, 0x00, "defect list error" },
	{ 0x19, 0x01, "defect list not available" },
	{ 0x19, 0x02, "defect list error in primary list" },
	{ 0x19, 0x03, "defect list error in grown list" },
	{ 0x1a, 0x00, "param list length error" },
	{ 0x1b, 0x00, "sync data transfer error" },
	{ 0x1c, 0x00, "defect list not found" },
	{ 0x1c, 0x01, "primary defect list not found" },
	{ 0x1c, 0x02, "grown defect list not found" },
	{ 0x1d, 0x00, "miscompare during verify" },
	{ 0x1e, 0x00, "recovered ID w/ECC correction" },
	{ 0x20, 0x00, "invalid command opcode" },
	{ 0x21, 0x00, "logical block out of range" },
	{ 0x21, 0x01, "invalid element address" },
	{ 0x22, 0x00, "illegal function" },
	{ 0x24, 0x00, "illegal field in CDB" },
	{ 0x25, 0x00, "unit not supported" },
	{ 0x26, 0x00, "invalid field in param list" },
	{ 0x26, 0x01, "param not supported" },
	{ 0x26, 0x02, "param value invalid" },
	{ 0x26, 0x03, "threshold params not supported" },
	{ 0x27, 0x00, "write protected" },
	{ 0x28, 0x00, "ready transition (medium changed)" },
	{ 0x29, 0x00, "power on/reset/bus device reset" },
	{ 0x2a, 0x00, "params changed" },
	{ 0x2a, 0x01, "mode params changed" },
	{ 0x2a, 0x02, "log params changed" },
	{ 0x2b, 0x00, "cannot copy, host cannot disconnect" },
	{ 0x2c, 0x00, "command seq error" },
	{ 0x2c, 0x01, "too many windows" },
	{ 0x2c, 0x02, "invalid combination of windows" },
	{ 0x2d, 0x00, "overwrite error" },
	{ 0x2f, 0x00, "commands cleared by another initiator" },
	{ 0x30, 0x00, "incompat medium" },
	{ 0x30, 0x01, "cannot read, unknown format" },
	{ 0x30, 0x02, "cannot read, incompat format" },
	{ 0x30, 0x03, "cleaning cartridge" },
	{ 0x31, 0x00, "medium format corrupted" },
	{ 0x31, 0x01, "format failed" },
	{ 0x32, 0x00, "no defect spare location available" },
	{ 0x32, 0x01, "defect list update failure" },
	{ 0x33, 0x00, "tape len error" },
#if 0 /* printers only */
	{ 0x36, 0x00, "ribbon, ink or toner failure" },
#endif
	{ 0x37, 0x00, "rounded param" },
	{ 0x39, 0x00, "saving params not supported" },
	{ 0x3a, 0x00, "no medium" },
	{ 0x3b, 0x00, "seq positioning error" },
	{ 0x3b, 0x01, "tape position err, beginning-of-medium" },
	{ 0x3b, 0x02, "tape position err, end-of-medium" },
#if 0 /* printers only */
	{ 0x3b, 0x03, "tape or electronic vertical forms unit not ready" },
	{ 0x3b, 0x04, "slew failure" },
	{ 0x3b, 0x05, "paper jam" },
	{ 0x3b, 0x06, "failed to sense top-of-form" },
	{ 0x3b, 0x07, "failed to sense bottom-of-form" },
#endif
	{ 0x3b, 0x08, "reposition error" },
#if 0 /* scanners only */
	{ 0x3b, 0x09, "read past end of medium" },
	{ 0x3b, 0x0a, "read past beginning of medium" },
	{ 0x3b, 0x0b, "position past end of medium" },
	{ 0x3b, 0x0c, "position past beginning of medium" },
#endif
	{ 0x3b, 0x0d, "medium dest element full" },
	{ 0x3b, 0x0e, "medium source element empty" },
	{ 0x3d, 0x00, "invalid bits in id message" },
	{ 0x3e, 0x00, "unit not self-configured yet" },
	{ 0x3f, 0x00, "target operating conditions changed" },
	{ 0x3f, 0x01, "microcode changed" },
	{ 0x3f, 0x02, "changed operating def" },
	{ 0x3f, 0x03, "inquiry data changed" },
	{ 0x40, 0x00, "RAM failure" },
	{ 0x41, 0x00, "data path failure" },
	{ 0x42, 0x00, "power-on/self-test failure" },
	{ 0x43, 0x00, "message error" },
	{ 0x44, 0x00, "internal target failure" },
	{ 0x45, 0x00, "select/reselect failure" },
	{ 0x46, 0x00, "unsuccessful soft reset" },
	{ 0x47, 0x00, "SCSI parity error" },
	{ 0x48, 0x00, "initiator detected error message" },
	{ 0x49, 0x00, "invalid message error" },
	{ 0x4a, 0x00, "command phase error" },
	{ 0x4b, 0x00, "data phase error" },
	{ 0x4c, 0x00, "unit failed self-conf" },
	{ 0x4e, 0x00, "overlapped commands" },
	{ 0x50, 0x00, "write append error" },
	{ 0x50, 0x01, "write append position error" },
	{ 0x50, 0x02, "position error wrt timing" },
	{ 0x51, 0x00, "erase failure" },
	{ 0x52, 0x00, "cartridge fault" },
	{ 0x53, 0x00, "media load or eject failed" },
	{ 0x53, 0x01, "unload tape failed" },
	{ 0x53, 0x02, "medium removal prevented" },
#if 0 /* processors only */
	{ 0x54, 0x00, "SCSI to host system interface failure" },
	{ 0x55, 0x00, "system resource failure" },
#endif
	{ 0x57, 0x00, "unable to recover TOC" },
	{ 0x58, 0x00, "generation does not exist" },
	{ 0x59, 0x00, "updated block read" },
	{ 0x5a, 0x00, "operator req for state change input" },
	{ 0x5a, 0x01, "operator medium removal req" },
	{ 0x5a, 0x02, "operator selected write prot" },
	{ 0x5a, 0x03, "operator selected write permit" },
	{ 0x5b, 0x00, "log exception" },
	{ 0x5b, 0x01, "threshold condition met" },
	{ 0x5b, 0x02, "log counter at max" },
	{ 0x5b, 0x03, "log list codes exhausted" },
	{ 0x5c, 0x00, "RPL status change" },
	{ 0x5c, 0x01, "spindles synched" },
	{ 0x5c, 0x02, "spindles not synched" },
#if 0 /* scanners only */
	{ 0x60, 0x00, "lamp failure" },
	{ 0x61, 0x00, "video acquisition error" },
	{ 0x61, 0x01, "unable to acquire video" },
	{ 0x61, 0x02, "out of focus" },
	{ 0x62, 0x00, "scan head positioning error" },
#endif
	{ 0x63, 0x00, "end of user area on track" },
	{ 0x64, 0x00, "illegal mode for track" },
	{ 0 }
};

/* definition of `tg' target driver for autoconfig */
static int scsi_targmatch __P((struct device *, struct cfdata *, void *));
static void scsi_targattach __P((struct device *, struct device *, void *));
struct cfdriver tgcd =
    { NULL, "tg", scsi_targmatch, scsi_targattach,
      DV_DULL, sizeof(struct targ) };

void	scsi_targstart __P((struct device *, struct sq *, struct buf *,
			scdgo_fn, struct device *));
int	scsi_targgo __P((struct device *, int targ,
			scintr_fn, struct device *, struct buf *, int));
void	scsi_targintr __P((struct device *, int, int));
void	scsi_targrel __P((struct device *));

#define	NOBUF	((caddr_t)0)

/*
 * Perform a TEST UNIT READY immediate (polled) command
 * on the given <target,unit> pair.  Return the status byte
 * returned, or -1 for none.
 */
int
scsi_test_unit_ready(hba, targ, unit)
	struct hba_softc *hba;
	int targ, unit;
{
	struct scsi_cdb cdb;

	bzero(&cdb, sizeof(cdb));
	CDB6(&cdb)->cdb_cmd = CMD_TEST_UNIT_READY;
	CDB6(&cdb)->cdb_lun_lbah = unit << 5;
	return (hba->hba_driver->hd_icmd(hba, targ, &cdb, NOBUF, 0, 0));
}

#ifdef notyet
/*
 * Execute some CDB, and if the result is not `OK', discard sense
 * data in case of an Extended Contingent Allegiance.  (??? make
 * sense data available instead?)
 */
int
scsi_execute(u, cdb, buf, len, rw)
	struct unit *u;
	struct scsi_cdb *cdb;
	char *buf;
	int len, rw;
{
	struct hba_softc *hba;
	int i;
	char sense[28];

	hba = u->u_hba;
	i = hba->hba_driver->hd_icmd(hba, u->u_targ, &cdb, buf, len, rw);
	if ((i & STS_MASK) != STS_GOOD && i >= 0)
		(void)scsi_request_sense(hba, u->u_targ, u->u_unit,
		    sense, sizeof sense);
	return (i);
}
#endif

/*
 * Do a test-unit-ready plus sense; this clears any pending unit-attention
 * condition.
 */
int
scsi_test(hba, targ, unit)
	struct hba_softc *hba;
	int targ, unit;
{
	register int i;
	char sense[28];

	i = scsi_test_unit_ready(hba, targ, unit);
	if ((i & STS_MASK) != STS_GOOD && i >= 0)
		(void)scsi_request_sense(hba, targ, unit, sense, sizeof sense);
	return (i);
}

/*
 * Request sense.  The sense is to be written into the given buffer.
 * The given length must be < 256.
 */
int
scsi_request_sense(hba, targ, unit, buf, len)
	struct hba_softc *hba;
	int targ, unit;
	caddr_t buf;
	int len;
{
	struct scsi_cdb cdb;

	bzero(&cdb, sizeof(cdb));
	CDB6(&cdb)->cdb_cmd = CMD_REQUEST_SENSE;
	CDB6(&cdb)->cdb_lun_lbah = unit << 5;
	CDB6(&cdb)->cdb_len = len;
	return (hba->hba_driver->hd_icmd(hba, targ, &cdb, buf, len, B_READ));
}

/*
 * Called (indirectly, via config_found) from scsi_hbaattach.
 * Print target number, and if no device was configured there,
 * the hba as well.
 */
int
scsi_targprint(aux, hba)
	void *aux;
	char *hba;
{

	if (hba) {
		printf("target %d on %s", *(int *)aux, hba);
		return (UNCONF);
	}
	printf(" target %d", *(int *)aux);
	return (QUIET);
}

/*
 * Print information about a unit found on some target.
 * If the unit was not configured, `targ' is the name of the target
 * on which the unit was found.  If it was, targ is NULL and we
 * let the unit's attach routine print the INQUIRE result if
 * appropriate.
 */
static int
scsi_unitprint(aux, targ)
	void *aux;
	char *targ;
{
	register struct scsi_attach_args *sa = aux;

	if (targ) {
		printf("unit %d at %s", sa->sa_unit, targ);
		if ((sa->sa_inq_status & STS_MASK) == STS_GOOD) {
			printf(" (");
			scsi_printinq(&sa->sa_si);
			printf(")");
		}
		return (UNCONF);
	}
	printf(" unit %d", sa->sa_unit);
	return (QUIET);
}

/*
 * Generic target-match.
 */
static int
scsi_targmatch(parent, cf, aux)
	struct device *parent;
	register struct cfdata *cf;
	void *aux;
{
	int targ = *(int *)aux;

	return (cf->cf_loc[0] == targ || cf->cf_loc[0] == -1);
}

/*
 * And now, a generic `target attach' routine.
 * We assume that INQUIRY works.
 */
static void
scsi_targattach(parent, self, aux)
	struct device *parent, *self;
	void *aux;
{
	register struct targ *t = (struct targ *)self;
	register struct hba_softc *hba;
	register struct hbadriver *hd;
	register int targ, unit;
	struct scsi_attach_args sa;
	struct scsi_cdb si;
	int status;

	printf("\n");
	t->t_targ = targ = *(int *)aux;
	hba = (struct hba_softc *)parent;
	hba->hba_targets[targ] = t;

	/*
	 * Probe each of the 8 units using the sequence
	 *	TEST UNIT READY
	 *	REQUEST SENSE
	 *	INQUIRY
	 * The first should not be necessary, but some SCSI devices
	 * refuse to speak until it is done.  The second is only necessary
	 * if the first returns a CHECK CONDITION status, but we do it
	 * anyway.
	 */
	hd = hba->hba_driver;
	sa.sa_targ = targ;
	bzero(&si, sizeof(si));
	CDB6(&si)->cdb_cmd = CMD_INQUIRY;
	CDB6(&si)->cdb_len = sizeof sa.sa_si;
	for (unit = 0; unit < 8; unit++) {
		/* clear any residual sense status */
		sa.sa_req_status = scsi_request_sense(hba, targ, unit,
		    (caddr_t)&sa.sa_sn, sizeof sa.sa_sn);
		if ((status = scsi_test_unit_ready(hba, targ, unit)) == -1)
			continue;
		sa.sa_unit = unit;
		sa.sa_req_status = scsi_request_sense(hba, targ, unit,
		    (caddr_t)&sa.sa_sn, sizeof sa.sa_sn);
		/* print sense data only if AC_VERBOSE && AC_DEBUG */
		if (autoprint & AC_VERBOSE)
			aprint_debug("%s: unit %d: tur = %x, rs = %x, %x %x %x %x %x %x %x %x %x %x %x %x %x %x\n",
			    self->dv_xname, unit, status, sa.sa_req_status,
			    sa.sa_sn.sn_vcc, sa.sa_sn.sn_var[0],
			    sa.sa_sn.sn_var[1], sa.sa_sn.sn_var[2],
			    sa.sa_sn.sn_var[3], sa.sa_sn.sn_var[4],
			    sa.sa_sn.sn_var[5], sa.sa_sn.sn_var[6],
			    sa.sa_sn.sn_addl[0], sa.sa_sn.sn_addl[1],
			    sa.sa_sn.sn_addl[2], sa.sa_sn.sn_addl[3],
			    sa.sa_sn.sn_addl[4], sa.sa_sn.sn_addl[5]);
		if ((sa.sa_req_status & STS_MASK) != STS_GOOD)
			/* This unit is hosed */
			continue;
		if (XSENSE_ISSTD(&sa.sa_sn) && SENSE_ISXSENSE(&sa.sa_sn) &&
		    XSENSE_KEY(&sa.sa_sn) == SKEY_ILLEGAL &&
		    XSENSE_HASASC(&sa.sa_sn) &&
		    XSENSE_ASC(&sa.sa_sn) == ASC_LUN_NOT_SUPPORTED)
			/* The standard way to report an unsupported unit */
			continue;
		CDB6(&si)->cdb_lun_lbah = unit << 5;
		sa.sa_inq_status = (*hd->hd_icmd)(hba, targ, &si,
		    (caddr_t)&sa.sa_si, sizeof sa.sa_si, B_READ);
		/* print inquiry data only if AC_VERBOSE && AC_DEBUG */
		if (autoprint & AC_VERBOSE)
		    aprint_debug("%s: unit %d: inq = %x, %x %x %x %x %x %x %x %x\n",
			self->dv_xname, unit, sa.sa_inq_status,
			sa.sa_si.si_type, sa.sa_si.si_qual,
			sa.sa_si.si_version, sa.sa_si.si_v2info,
			sa.sa_si.si_len, sa.sa_si.si_more[0],
			sa.sa_si.si_more[1], sa.sa_si.si_more[2]);
		if ((sa.sa_inq_status & STS_MASK) == STS_GOOD &&
#ifdef notdef /* XXX don't know if this is a reasonable test */
		    (sa.sa_si.si_type & TYPE_QUAL_MASK) == TYPE_QUAL_NOTCONN &&
#endif
		    (sa.sa_si.si_type & TYPE_TYPE_MASK) == TYPE_NP) {
			/* one more hurdle -- is the type 'not present'? */
			continue;
		}
		config_found(&t->t_dev, (void *)&sa, scsi_unitprint);
	}
}

/*
 * Each unit calls scsi_establish to tell the hba and target of
 * its existence.
 */
void
scsi_establish(u, dev, unit)
	register struct unit *u;
	struct device *dev;
	register int unit;
{
	register struct targ *t;
	register struct hba_softc *hba;
	register struct hbadriver *hbd;
	struct unit *u1;

	u->u_dev = dev;
	t = (struct targ *)dev->dv_parent;
	hba = (struct hba_softc *)t->t_dev.dv_parent;
	hbd = hba->hba_driver;
	t->t_units[unit] = u;
	if (t->t_nunits == 0) {
		/*
		 * This is the first unit on the target.  We can
		 * probably just call the hba start code, avoiding
		 * one level of calls and queueing.  If we attach
		 * another target we will fix this in the code below.
		 */
		u->u_start = hbd->hd_start;
		u->u_go = hbd->hd_go;
		u->u_rel = hbd->hd_rel;
		u->u_updev = &hba->hba_dev;
		t->t_firstunit = unit;
	} else {
		/*
		 * This is not the only unit on the target, so we
		 * must call the target start code rather than the
		 * hba start code.  Fix the linkage on the first
		 * target too (possibly for the 2nd, 3rd, ..., time).
		 */
		u1 = t->t_units[t->t_firstunit];
		u1->u_start = scsi_targstart;
		u1->u_go = scsi_targgo;
		u1->u_rel = scsi_targrel;
		u1->u_updev = &t->t_dev;
		u->u_start = scsi_targstart;
		u->u_go = scsi_targgo;
		u->u_rel = scsi_targrel;
		u->u_updev = &t->t_dev;
	}
	t->t_nunits++;			/* another unit is alive */
	u->u_unit = unit;
	u->u_targ = t->t_targ;		/* record target number, */
	u->u_hba = hba;			/* hba ... */
	u->u_hbd = hbd;			/* and driver */
}

/* NO DOUBT SOME OF THE STUFF PRINTED HERE IS USELESS */
void
scsi_printinq(inq)
	register struct scsi_inquiry *inq;
{
	register int iso, ecma, ansi, t;
	static char *types[] = { "disk", "tape", "printer", "processor",
	    "WORM", "ROM disk", "scanner", "magneto-optical",
	    "jukebox", "lan" };

	if ((t = (inq->si_type & TYPE_QUAL_MASK)) != 0)
		printf("type-qual=0x%x ", t);
	t = inq->si_type & TYPE_TYPE_MASK;
	if (t < sizeof types / sizeof *types)
		printf("%s", types[t]);
	else
		printf("<type %d>", t);
	if (inq->si_qual & QUAL_RMB)
		printf(" (removable)");
	printf(" qual=0x%x", inq->si_qual & QUAL_MASK);
	iso = (inq->si_version >> VER_ISO_SHIFT) & VER_ISO_MASK;
	ecma = (inq->si_version >> VER_ECMA_SHIFT) & VER_ECMA_MASK;
	ansi = (inq->si_version >> VER_ANSI_SHIFT) & VER_ANSI_MASK;
	printf(" version=<iso %d, ecma %d, ansi %d>", iso, ecma, ansi);
	if (ansi == 1 || ansi == 2) {
		char v[9], p[17], r[5];

		scsi_inq_ansi((struct scsi_inq_ansi *)inq, v, p, r);
		printf(" vendor %s, product %s, rev %s", v, p, r);
	}
}

/* copy a counted string but trim trailing blanks; make the dest a C string */
static void
scsi_str(src, dst, len)
	register char *src, *dst;
	register int len;
{

	while (src[len - 1] == ' ') {
		if (--len == 0) {
			*dst = 0;
			return;
		}
	}
	bcopy(src, dst, len);
	dst[len] = 0;
}

void
scsi_inq_ansi(si, vendor, product, rev)
	register struct scsi_inq_ansi *si;
	char *vendor, *product, *rev;
{
	register int i, len;

	/* if too short, extend with blanks */
	len = si->si_len + 5;	/* 5 fixed; len is `additional' */
	if (len < sizeof(*si))
		for (i = len; i < sizeof *si; i++)
			((char *)si)[i] = ' ';
	scsi_str(si->si_vendor, vendor, sizeof si->si_vendor);
	scsi_str(si->si_product, product, sizeof si->si_product);
	scsi_str(si->si_rev, rev, sizeof si->si_rev);
}

/*
 * Tell all the devices on the given hba that it has been reset.
 * SHOULD PROBABLY DO MORE HERE
 */
void
scsi_reset_units(hba)
	register struct hba_softc *hba;
{
	register int targ, unit;
	register struct targ *t;
	register struct unit *u;

	for (targ = 0; targ < 8; targ++) {
		if ((t = hba->hba_targets[targ]) == NULL)
			continue;
		for (unit = 0; unit < 8; unit++)
			if ((u = t->t_units[unit]) != NULL)
				(*u->u_driver->ud_reset)(u);
	}
}

/*
 * Start a unit on a target.
 * If the target is busy, just enqueue the unit;
 * once the target becomes free, we will call the hba start routine.
 * Otherwise, call the hba start routine now, and then when the hba
 * becomes free it will call the unit's dgo routine.
 */
void
scsi_targstart(self, sq, bp, dgo, dev)
	struct device *self;
	register struct sq *sq;
	struct buf *bp;
	scdgo_fn dgo;
	struct device *dev;
{
	register struct targ *t = (struct targ *)self;
	register struct hba_softc *hba;

	sq->sq_forw = NULL;
	if (t->t_head == NULL)
		t->t_head = sq;
	else
		t->t_tail->sq_forw = sq;
	t->t_tail = sq;
	if (t->t_busy == 0) {
		t->t_busy = 1;
		hba = (struct hba_softc *)t->t_dev.dv_parent;
		(*hba->hba_driver->hd_start)(&hba->hba_dev, &t->t_forw, bp,
		    dgo, dev);
	} else {
		sq->sq_bp = bp;
		sq->sq_dgo = dgo;
		sq->sq_dev = dev;
	}
}

/*
 * The unit got the bus, and wants the hba to go.
 * Remember its interrupt handler; substitute ours instead.
 */
int
scsi_targgo(self, targ, intr, dev, bp, pad)
	struct device *self;
	int targ;
	scintr_fn intr;
	struct device *dev;
	struct buf *bp;
	int pad;
{
	register struct targ *t = (struct targ *)self;
	register struct hba_softc *hba;

	t->t_intr = intr;
	t->t_intrdev = dev;
	hba = (struct hba_softc *)t->t_dev.dv_parent;
	return ((*hba->hba_driver->hd_go)(&hba->hba_dev, targ,
	    scsi_targintr, &t->t_dev, bp, pad));
}

/*
 * The hba got an interrupt.  Dequeue the unit from the target
 * (the target is already off the hba queue) and then call the
 * underlying interrupt handler.
 */
void
scsi_targintr(self, stat, resid)
	struct device *self;
	int stat, resid;
{
	register struct targ *t = (struct targ *)self;
	register struct hba_softc *hba;
	register struct sq *sq;

	sq = t->t_head;
if (sq == NULL) panic("scsi_targintr");
	/*
	 * Defer setting new value of sq until after interrupt handler
	 * is called, as t->t_head may be modified.
	 */
	t->t_head = sq->sq_forw;
	(*t->t_intr)(t->t_intrdev, stat, resid);
	sq = t->t_head;
	if (sq != NULL) {
		hba = (struct hba_softc *)t->t_dev.dv_parent;
		(*hba->hba_driver->hd_start)(&hba->hba_dev, &t->t_forw,
		    sq->sq_bp, sq->sq_dgo, sq->sq_dev);
	} else
		t->t_busy = 0;
}

/*
 * The unit decided that it needed to `give up' its hold on the bus early.
 */
void
scsi_targrel(self)
	struct device *self;
{
	register struct targ *t = (struct targ *)self;
	register struct hba_softc *hba;
	register struct sq *sq;

	hba = (struct hba_softc *)t->t_dev.dv_parent;
	sq = t->t_head;
if (sq == NULL) panic("scsi_targrel");
	/*
	 * This target is at the head of the hba queue.
	 * Remove it by calling hba bus release.  Then, if the
	 * target queue is not empty, put it back on the hba queue.
	 * (This produces round robin service.)
	 */
	(*hba->hba_driver->hd_rel)(&hba->hba_dev);
	sq = sq->sq_forw;
	if ((t->t_head = sq) != NULL)
		(*hba->hba_driver->hd_start)(&hba->hba_dev, &t->t_forw,
		    sq->sq_bp, sq->sq_dgo, sq->sq_dev);
	else
		t->t_busy = 0;
}

/*
 * Translate ASC/ASCQ codes to English.
 */
const char *
scsi_translate_asc(asc, ascq)
	int asc, ascq;
{
	const struct asccode *a, *generic;
	static char buf[128];

	if (asc == 0x40 && ascq >= 0x80) {
		sprintf(buf, "diagnostic failure on component 0x%x", ascq);
		return (buf);
	}
	generic = 0;
	for (a = asctab; a->a_code && asc >= a->a_asc; ++a) {
		if (a->a_asc == asc && a->a_ascq == ascq)
			return (a->a_code);
		if (a->a_asc == asc && a->a_ascq == 0)
			generic = a;
	}
	if (generic && generic->a_asc == asc) {
		sprintf(buf, "%s (ascq 0x%x)", generic->a_code, ascq);
		return (buf);
	}
	sprintf(buf, "asc 0x%x, ascq 0x%x", asc, ascq);
	return (buf);
}

int
scsi_mode_sense(u, buf, len, pc, pagecode)
	struct unit *u;
	char *buf;
	int len;
	int pc, pagecode;
{
	struct scsi_cdb_modesense6 ms;

	bzero(&ms, sizeof(ms));
	ms.cdb_cmd = CMD_MODE_SENSE6;
	ms.cdb_lun_flags = u->u_unit << 5;
	ms.cdb_pcc = (pc << 6) | (pagecode & 0x3f);
	ms.cdb_len = len;

	return (u->u_hbd->hd_icmd(u->u_hba, u->u_targ, (struct scsi_cdb *)&ms,
	    buf, len, B_READ));
}

int
scsi_mode_select(u, buf, len, pf, sp)
	struct unit *u;
	char *buf;
	int len;
	int pf, sp;
{
	struct scsi_cdb_modeselect6 ms;
	struct scsi_ms6 *msb = (struct scsi_ms6 *)buf;

	/* is this necessary? */
	msb->ms_len = 0;
	msb->ms_mt = 0;
	msb->ms_dsp &= ~SCSI_MS_DSP_WP;	/* turn off write protect? */
	/* XXX assume that len is consistent with mss->ms_bdl */

	bzero(&ms, sizeof(ms));
	ms.cdb_cmd = CMD_MODE_SELECT6;
	ms.cdb_lun_flags = (u->u_unit << 5) | ((pf & 1) << 4) | (sp & 1);
	ms.cdb_len = len;

	return (u->u_hbd->hd_icmd(u->u_hba, u->u_targ, (struct scsi_cdb *)&ms,
	    buf, len, B_WRITE));
}
