.\" $XConsortium: XF86_Mono.man,v 1.6 95/01/23 15:33:29 kaleb Exp $
.\" $XFree86: xc/programs/Xserver/hw/xfree86/XF86_Mono.man,v 3.13 1995/07/08 13:24:07 dawes Exp $
.TH XF86_Mono 1 "Version 3.1.2"  "XFree86"
.SH NAME
XF86_Mono - 1 bit non-accelerated X Window System servers for UNIX on
x86 platforms
.SH SYNOPSIS
.B XF86_Mono
[:displaynumber] [ option ] ...
.SH DESCRIPTION
.I XF86_Mono
is a 1-bit StaticGrey server for VGA and Super-VGA cards and for some other
monochrome cards.
.SH CONFIGURATIONS
.PP
The
.I XF86_Mono
server supports the following popular SuperVGA chipsets in monochrome mode:
.RS .5i
.TP 4
ATI:
18800, 18800-1, 28800-2, 28800-4, 28800-5, 28800-6, 68800-3, 68800-6, 68800AX,
68800LX, 88800CX, 88800GX
.TP 4
Tseng:
ET3000, ET4000, ET4000/W32
.TP 4
Western Digital:
PVGA1, WD90C00, WD90C10, WD90C11, WD90C30, WD90C31, WD90C33
.TP 4
Genoa:
GVGA
.TP 4
Trident:
TVGA8800CS, TVGA8900B, TVGA8900C, TVGA8900CL, TVGA9000
.TP 4
NCR:
77C22, 77C22E
.TP 4
Compaq:
AVGA
.TP 4
Oak:
OTI067, OTI077, OTI087
.TP 4
Cirrus:
CLGD5420, CLGD5422, CLGD5424, CLGD5426, CLGD5428, CLGD5429, CLGD5430,
CLGD5434, CLGD5436, CLGD6205, CLGD6215, CLGD6225, CLGD6235,
CL6410, CL6412, CL6420, CL6440
.RE
.PP
The
.I XF86_Mono
server supports the following monochrome cards and resolutions:
.RS .5i
.TP 4
Sigma:
L-View, LaserView PLUS (in 1bpp mode): 1664x1280
.TP 4
Hyundai:
HGC-1280: 1280[1472]x1024
.TP 4
Apollo:
Monochrome card (with ID 9) from Apollo workstations: 1280x1024
.TP 4
Hercules and compatibles cards: 720x348
.RE
.PP
Additionally it supports generic VGA cards with a maximum virtual resolution
of (approximately) 800x650.
.PP
On supported SVGA chipsets, 
.I XF86_Mono
will use up to 1/4 of display memory, which yields a maximum virtual
resolution of (approximately) 1664x1260 with 1MB of display memory.
.I XF86_Mono
does not support the accelerated functions of the supported chipsets.
.SH OPTIONS
In addition to the normal server options described in the \fIXserver(1)\fP
manual page, \fIXF86_Mono\fP accepts some more
command line switches, as described in the 
.I XFree86(1) 
manpage.
.SH SETUP
.I XFree86
uses a configuration file called \fBXF86Config\fP for its initial setup.  
See the 
.I XF86Config(4/5) 
manpage for general details. Here only the
.I XF86_Mono
specific parts are explained.
.PP
The \fBDriver\fP entry in \fBScreen\fP section of the XF86Config file should
be set to \fBvga2\fP for VGA and SVGA boards, and \fBmono\fP for non-vga
mono boards.  If \fBScreen\fP sections are present for both of these, the
server will start in a dual-headed configuration.
.PP
Entries for the \fBDevice\fP section in the XF86Config file include:
.br
.ne 3i
.TP 8
.B chipset \fI"name"\fP
specifies a chipset so the correct driver can be used.  Possible chipsets
are:
.sp
VGA2:
.RS 1.5i
.TP 4
ATI:
vgawonder
.TP 4
Tseng:
et3000, et4000, et4000w32, et4000w32i, et4000w32p
.TP 4
Western Digital:
pvga1, wd90c00, wd90c10, wd90c30, wd90c31, wd90c33
.TP 4
Genoa:
gvga
.TP 4
Trident:
tvga8800cs, tvga8900b, tvga8900c, tvga8900cl, tvga9000 
.TP 4
NCR:
ncr77c22, ncr77c22e
.TP 4
Compaq:
cpq_avga
.TP 4
OAK:
oti067, oti077, oti087
.TP 4
Cirrus:
clgd5420, clgd5422, clgd5424, clgd5426, clgd5428, clgd5429, clgd5430,
clgd5434, clgd5436, clgd6205, clgd6215, clgd6225, clgd6235,
cl6410, cl6412, cl6420, cl6440
.TP 4
Generic VGA:
generic 
.RE
.RS 8
.PP
MONO:
.RE
.RS 1.5i
.TP 4
Hyundai:
hgc1280
.TP 4
Sigma:
sigmalview
.TP 4
Apollo:
apollo9
.TP 4
Hercules:
hercules
.RE
.TP 8
.B MemBase \fImemaddress\fP
specifies the base address of the video memory.  This option is only used
for the Sigma LaserView cards.  Valid addresses for these cards are
\fI0xA0000\fP, \fI0xB0000\fP, \fI0xC0000\fP, \fI0xD0000\fP, \fI0xE0000\fP.
The default is \fI0xE0000\fP.
.TP 8
.B Black \fIred green blue\fP
sets the ``black'' colour to the rgb values specified.  These values must be
given as integers in the range 0\-63.  The default is \fI0\ 0\ 0\fP.  This
option is only valid for the \fBvga2\fP screen type.
.TP 8
.B White \fIred green blue\fP
sets the ``white'' colour to the rgb values specified.  These values must be
given as integers in the range 0\-63.  The default is \fI63\ 63\ 63\fP.  This
option is only valid for the \fBvga2\fP screen type.
.TP 8
.B Option \fI"optionstring"\fP
allows the user to select certain options provided by the drivers.  Currently 
the following strings are recognized:
.sp
\fBlegend\fP - for Sigma Legend ET4000-based boards.  This option enables
a special clock-selection algorithm used on Legend boards, and MUST be
specified for these boards to function correctly.
.sp
\fBswap_hibit\fP - for Western Digital/PVGA1 chipsets.  Some Western Digital
based boards require the high-order clock-select lead to be inverted.  It
is not possible for the server to determine this information at run-time.
If the 9th clock in the list of clocks detected by the server is less than
30Mhz, this option likely needs to be set.
.sp
\fBhibit_low\fP, \fBhibit_high\fP - for Tseng ET4000 chipsets.  With
some ET4000 cards, the server has difficulty getting the state of the
high-order clocks select bit right when started from a high-resolution text
mode.  These options allow the correct initial state of that bit to be
specified.  To find out what the correct initial state is, start the server
from an 80x25 text mode.  This option is only needed if the clocks reported
by the server when started from a high-resolution text mode differ from
those reported when it is started from an 80x25 text mode.
.sp
\fB8clocks\fP - for the PVGA1 chipset the default is 4 clocks.  Some
cards with this chipset may support 8 clocks.  Specifying this option
will allow the driver to detect and use the extra clocks.
.sp
\fB16clocks\fP - for Trident TVGA8900B and 8900C chipsets.  Some newer boards
using 8900B and 8900C chipsets actually support 16 clocks rather than the
standard 8 clocks.  Such boards will have a "TCK9002" or "TCK9004" chip
on them.  Specifying this option will allow the driver to detect and use
the extra 8 clocks.
.sp
\fBpower_saver\fP - This option enables the server
to use the power saving features of VESA DPMS compatible monitors.
The suspend level is currently not supported.
Refer to the \fIXF86Config(4/5)\fP
manual page for details of how to set the timeouts for the different levels
of operation.  This option is experimental.
.sp
\fBsecondary\fP - for the hgc1280 and apollo9 chipsets. This option allows
to use these cards jumpered to the secondary I/O / memory address.
These addresses are:
.RS 8
.TP 4
hgc1280:
I/O 0x3B0-0x3BF, mem 0xB0000-0xBFFFF (prim.)
.br
I/O 0x390-0x39F, mem 0xC8000-0xCFFFF (sec.)
.TP 4
apollo9:
I/O 0x3B0-0x3BF, mem 0xFA0000-0xFDFFFF (prim.)
.br
I/O 0x3D0-0x3DF, mem 0xA0000-0xDFFFF (sec.)
.RE
.RS 8
\fIXFree86\fP can detect the HGC-1280 on both primary and secondary
address; for the apollo card the primary address is used by default.
.RE
.ig
intern_disp (use internal display for laptops -- WD90C2x)
extern_disp (use external display for laptops -- WD90C2x)
..
.PP
Note that \fIXFree86\fP has some internal capabilities to determine
what hardware
it is running on. Thus normally the keywords \fIchipset\fP, \fIclocks\fP,
and \fIvideoram\fP don't have to be specified.  But there
may be occasions when this autodetection mechanism fails, (for example, too
high of load on the machine when you start the server).  For cases like this,
one should first run \fIXF86_Mono\fP on an unloaded machine, look at the
results of the autodetection (that are printed out during server startup)
and then explicitly specify these parameters in the configuration file.
\fBIt is recommended that all parameters, especially Clock values,
be specified in the XF86Config file.\fP
.PP
.SH FILES
.TP 30
<XRoot>/bin/XF86_Mono
The monochrome X server for VGA, SVGA and other monochrome cards
.TP 30
/etc/XF86Config
Server configuration file
.TP 30
<XRoot>/lib/X11/XF86Config
Server configuration file
.LP
Note: <XRoot> refers to the root of the X11 install tree.
.SH "SEE ALSO"
X(1), Xserver(1), XFree86(1), XF86Config(4/5), xf86config(1),
xvidtune(1), xdm(1), xinit(1)
.SH BUGS
There are no known bugs at this time, although we welcome reports emailed
to the address listed below.
.SH CONTACT INFO
\fIXFree86\fP source is available from the FTP server
\fIftp.XFree86.org\fP.  Send email to
\fIXFree86@XFree86.org\fP for details.
.SH AUTHORS
.PP
Refer to the
.I XFree86(1)
manual page.
