.\" xrunclient.man,v 1.1.1.1 1995/01/05 22:43:07 polk Exp
.\" Copyright (c) 1994 David DiGiacomo
.\"
.\" The X Consortium, and any party obtaining a copy of these files from
.\" the X Consortium, directly or indirectly, is granted, free of charge, a
.\" full and unrestricted irrevocable, world-wide, paid up, royalty-free,
.\" nonexclusive right and license to deal in this software and
.\" documentation files (the "Software"), including without limitation the
.\" rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons who receive
.\" copies from any such party to do so.  This license includes without
.\" limitation a license to do the foregoing actions under any patents of
.\" the party supplying this software to the X Consortium.
.TH XRUNCLIENT 1 "Release 6" "X Version 11"
.SH NAME
xrunclient \- launch an X client
.SH SYNOPSIS
.B xrunclient
[
.B \-display
.I displayname
]
[
.B \-t
.I seconds
]
.I command
[
.I args ...
]
.SH DESCRIPTION
The
.I xrunclient
program is used to launch an X client program from
.I .xinitrc
or a similar script.  It waits until the client creates a top level window
before exiting so that clients start smoothly and sequentially, instead of
chaotically competing for system resources.
.SH OPTIONS
.TP 8
.B \-display \fIdisplayname\fP
This option specifies the display to which
.I xrunclient
will connect to determine when the client program has created a window.
.I xrunclient
will set the
.B DISPLAY
environment variable to the same value, so it is not necessary to
also give a
.B \-display
option to the client program.
.TP 8
.B \-timeout \fIseconds\fP
This option specifies the length of time in seconds that
.I xrunclient
will wait for the client program to create a window.
If the timeout occurs,
.I xrunclient
will exit with a status of 0.  The default timeout is 15 seconds.
.SH EXAMPLE
Below is an example
.I .xinitrc
file using
.I xrunclient
to control client startup:
.sp
.in +8
.nf
xrdb \-load $HOME/.Xresources
xrunclient xterm \-C \-title Console \-geometry 80x24+0+0
twm &
xrunclient xsetroot \-solid gray
xrunclient xclock \-geometry 50x50\-0+0 \-bw 0
xrunclient xload \-geometry 50x50\-50+0 \-bw 0
xrunclient xterm \-geometry 80x24+0\-0
wait
.fi
.in -8
.sp
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number if the
.B \-display
option is not used.
.SH "SEE ALSO"
.IR xinit (1)
.SH AUTHOR
David DiGiacomo, david@slack.com
