/*	BSDI roll.c,v 1.3 1995/10/02 13:49:55 torek Exp	*/

/*
 *	This routine rolls ndie nside-sided dice.
 *
 * @(#)roll.c	1.1 (Berkeley) 4/1/82
 *
 */

/*
 * If you do not have <stdlib.h>, or your <stdlib.h> fails to define
 * RAND_MAX, put the correct definition in the Imakefile.
 */
#ifndef RAND_MAX
#include <stdlib.h>
#endif

# define	reg	register

/*
 * To choose a number between 0 and N-1, using only the upper bits
 * from the rand() function (because it is typically an LCRNG; see
 * Knuth vol 2):
 *
 *	random[0,n-1] = (int)((double)rand() / ((double)RAND_MAX + 1) * n)
 *
 * This is somewhat unfair when (RAND_MAX + 1) mod n is not 0; the `extra'
 * values are scattered across the range of the above function, biasing
 * the result in favor of such values.  As long as n is sufficiently small
 * w.r.t. RAND_MAX, however, the error will be unnoticeable.
 *
 * In our case, we want ndie numbers in [1,nsides], so we add 1.  The
 * denominator of the division becomes ((double)RAND_MAX + 1) / nsides.
 */

roll(ndie, nsides)
reg int	ndie, nsides; {

	reg int		tot;
	reg double	denom;

	denom = ((double)RAND_MAX + 1) / nsides;
	tot = 0;
	while (ndie--)
		tot += rand() / denom + 1;
	return tot;
}
