.TH XLOADIMAGE 1 "16 November 1992"
.SH NAME
xloadimage, xsetbg, xview \- load images into an X11 window or onto
the root window
.SH SYNOPSIS
\fIxloadimage\fR [global_options] {[image_options] image ...}
.br
\fIxloadimage\fR [global_options] [image_options] stdin < image
.SH DESCRIPTION
\fIXloadimage\fR displays images in an X11 window or loads them onto
the root window.  See the \fIIMAGE TYPES\fR section below for
supported image types.
.PP
If the filename \fIstdin\fR is given, xloadimage will read the image
from standard input.
.PP
To have a "slideshow" of many images supply multiple image file names
on the command line.  The 'n', 'return', and 'space' keys will proceed
to the next image and 'p' will return to the previous when the
keyboard focus is on the window.  Also see the \fI-delay\fR,
\fI-idelay\fR, and \fI-goto\fR options.
.PP
You may exit the window by typing 'q' or '^C' when the keyboard focus
is on the window.
.PP
If the destination display cannot support the number of colors in the
image, the image will be dithered (monochrome destination) or have its
colormap reduced (color destination) as appropriate.  This can also be
done forcibly with the \fI-halftone\fR, \fI-dither\fR, and
\fI-colors\fR options.
.PP
A variety of image manipulations can be specified, including gamma
correction, brightening, clipping, dithering, depth-reduction,
rotation, and zooming.  Most of these manipulations have simple
implementations; speed was opted for above accuracy.
.PP
If you are viewing a large image in a window, the initial window will
be at most 90% of the size of the display unless the window manager
does not correctly handle window size requests or if you've used the
\fI-fullscreen\fR option.  You may move the image around in the window
by dragging with the first mouse button.  The cursor will indicate
which directions you may drag, if any.
.PP
A wide variety of common image manipulations can be done by mixing and
matching the available options.  See the section entitled \fIHINTS FOR
GOOD IMAGE DISPLAYS\fR for some ideas.
.PP
\fIXsetbg\fR is equivalent to \fIxloadimage -onroot -quiet\fR and
\fIxview\fR is equivalent to \fIxloadimage -view -verbose\fR.
.SH RESOURCE CLASS
\fIXloadimage\fR uses the resource class name \fIXloadimage\fR for
window managers which need this resource set.  This name changed
in version 2.00 and 2.01; some previous versions used the name
\fIXLoadImage\fR (which was difficult to predict) or \fIxloadimage\fR
(which conflicted with class naming conventions).
.SH GLOBAL OPTIONS
The following options affect the global operation of \fIxloadimage\fR.
They may be specified anywhere on the command line.
.TP 8
-border \fIcolor\fR
This sets the background portion of the window which is not covered by
any images to be \fIcolor\fR.
.TP
-default
Set the root background to the default root weave.  This is the same
as \fIxsetroot\fR with no arguments.
.TP
-debug
Talk to the X server in synchronous mode.  This is useful for
debugging.  If an X error is seen while in this mode, a core will be
dumped.
.TP
-delay \fIsecs\fR
Automatically advance to the next image after \fIsecs\fR seconds.
.TP
-display \fIdisplay_name\fR
X11 display name to send the image(s) to.
.TP
-fit
Force image to use the default visual and colormap.  This is useful if
you do not want technicolor effects when the colormap focus is inside
the image window, but it may reduce the quality of the displayed
image.  This is on by default if -onroot or -windowid is specified.
.TP
-fork
Fork xloadimage.  This causes xloadimage to disassociate itself from
the shell.  This option automatically turns on -quiet.
.TP
-fullscreen
Use the entire screen to display images.  If combined with -onroot,
the image will be zoomed to fill the entire rootwindow.
.TP
-geometry \fIWxH[{+-X}{+-}Y]\fR
This sets the size of the window onto which the images are loaded to a
different value than the size of the image.  When viewing an image in
a window, this can be used to reduce the size of the destination
window.  When loading an image onto the root window, this option
controls the size of the pixmap which will be loaded onto the root.
If the size is smaller than that of the display, the image will be
replicated.
.TP
-goto image_name
Forces the next image to be displayed to be the image named
\fIimage_name\fR.  This is useful for generating looped slideshows.
If more than one image of the same name as the target exists on the
argument list, the first in the argument list is used.
.TP
-help [option ...]
Give information on an option or list of options.  If no option is
given, a simple interactive help facility is invoked.
.TP
-identify
Identify the supplied images rather than display them.
.TP
-install
Forcibly install the image's colormap when the window is focused.
This violates ICCCM standards and only exists to allow operation with
naive window managers.  Use this option only if your window manager
does not install colormaps properly.
.TP
-list
List the images which are along the image path.
.TP
-onroot
Load image(s) onto the root window instead of viewing in a window.
This option automatically sets the -fit option.
This is the opposite of \fI-view\fR.  \fIXSetbg\fR has this option set
by default.
.TP
-path
Displays the image path and image suffixes which will be used when
looking for images.  These are loaded from ~/.xloadimagerc and
optionally from a systemwide file (normally /usr/lib/xloadimagerc).
.TP
-pixmap
Force the use of a pixmap as backing-store.  This is provided for
servers where backing-store is broken (such as some versions of the
AIXWindows server).  It may improve scrolling performance on servers
which provide backing-store.
.TP
-private
Force the use of a private colormap.  Normally colors are allocated
shared unless there are not enough colors available.
.TP
-quiet
Forces \fIxloadimage\fR and \fIxview\fR to be quiet.  This is the
default for \fIxsetbg\fR, but the others like to whistle. 
.TP
-supported
List the supported image types. 
.TP
-verbose
Causes \fIxloadimage\fR to be talkative, telling you what kind of
image it's playing with and any special processing that it has to do. 
This is the default for \fIxview\fR and \fIxloadimage\fR. 
.TP
-version
Print the version number and patchlevel of this version of
\fIxloadimage\fR.
.TP
-view
View image(s) in a window.  This is the opposite of \fI-onroot\fR and
the default for \fIxview\fR and \fIxloadimage\fR. 
.TP
-visual \fIvisual_name\fR
Force the use of a specific visual type to display an image.  Normally
\fIxloadimage\fR tries to pick the best available image for a
particular image type.  The available visual types are:  DirectColor,
TrueColor, PseudoColor, StaticColor, GrayScale, and StaticGray.
Nonconflicting names may be abbreviated and case is ignored.
.TP
-windowid \fIhex_window_id\fR
Sets the background pixmap of a particular window ID.  The argument
must be in hexadecimal and must be preceeded by "0x" (\fIeg\fR
-windowid 0x40000b.  This is intended for setting the background
pixmap of some servers which use untagged virtual roots
(\fIeg\fR HP-VUE), but can have other interesting applications.
.SH IMAGE OPTIONS
The following options may preceed each image.  These options are
local to the image they preceed. 
.TP
-at \fIX\fR,\fIY\fR
Indicates coordinates to load the image at on the base image.  If
this is an option to the first image, and the \fI-onroot\fR option is
specified, the image will be loaded at the given location on the
display background. 
.TP
-background \fIcolor\fR
Use \fIcolor\fR as the background color instead of the default
(usually white but this depends on the image type) if you are
transferring a monochrome image to a color display. 
.TP
-brighten \fIpercentage\fR
Specify a percentage multiplier for a color image's colormap.  A value
of more than 100 will brighten an image, one of less than 100 will
darken it. 
.TP
-center
Center the image on the base image loaded.  If this is an option to
the first image, and the \fI-onroot\fR option is specified, the image
will be centered on the display background. 
.TP
-clip \fIX\fR,\fIY\fR,\fIW\fR,\fIH\fR
Clip the image before loading it.  \fIX\fR and \fIY\fR define the
upper-left corner of the clip area, and \fIW\fR and \fIH\fR define the
extents of the area.  A zero value for \fIW\fR or \fIH\fR will be
interpreted as the remainder of the image. 
.TP
-colors \fIn\fR
Specify the maximum number of colors to use in the image.  This is a
way to forcibly reduce the depth of an image.
.TP
-dither
Dither a color image to monochrome using a Floyd-Steinberg dithering
algorithm.  This happens by default when viewing color images on a
monochrome display.  This is slower than \fI-halftone\fR and affects
the image accuracy but usually looks much better.
.TP
-foreground \fIcolor\fR
Use \fIcolor\fR as the foreground color instead of black if you are
transferring a monochrome image to a color display.  This can also be
used to invert the foreground and background colors of a monochrome
image. 
.TP
-gamma \fIdisplay_gamma\fR
Specify the gamma correction for the display.
The default value is 1.0, a typical display needs 2.0 to 2.5.
.TP
-gray
Convert an image to grayscale.  This is very useful when displaying
colorful images on servers with limited color capability.  The
optional spelling \fI-grey\fR may also be used.
.TP
-halftone
Force halftone dithering of a color image when displaying on a
monochrome display.  This option is ignored on monochrome images.
This dithering algorithm blows an image up by sixteen times; if you
don't like this, the \fI-dither\fR option will not blow the image up
but will take longer to process and will be less accurate.
.TP
-idelay \fIsecs\fR
Set the delay to be used for this image to \fIsecs\fR seconds (see
\fI-delay\fR).  If \fI-delay\fR was specified, this overrides it.  If
it was not specified, this sets the automatic advance delay for this
image while others will wait for the user to advance them.
.TP
-invert
Inverts a monochrome image.  This is shorthand for \fI-foreground
white -background black\fR.
.TP
-merge
Merge this image onto the base image after local processing.  The base
image is considered to be the first image specified or the last image
that was not preceeded by \fI-merge\fR.  If used in conjunction with
\fI-at\fR and \fI-clip\fR, very complex images can be built up.  This
option is on by default for all images if the \fI-onroot\fR or
\fI-windowid\fR options are specified.
.TP
-name \fIimage_name\fR
Force the next argument to be treated as an image name.  This is
useful if the name of the image is \fI-dither\fR, for instance. 
.TP
-newoptions
Reset options that propagate.  The \fI-bright, -colors, -delay,
-dither, -gamma, -normalize, -smooth, -xzoom, -yzoom\fR, and
\fI-zoom\fR options normally propagate to all following images.
.TP
-normalize
Normalize a color image.
.TP
-rotate \fIdegrees\fR
Rotate the image by \fIdegrees\fR clockwise.  The number must be a
multiple of 90.
.TP
-smooth
Smooth a color image.  This reduces blockiness after zooming an image
up.  If used on a monochrome image, nothing happens.  This option can
take awhile to perform, especially on large images.  You may specify
more than one \fI-smooth\fR option per image, causing multiple
iterations of the smoothing algorithm.
.TP
-xzoom \fIpercentage\fR
Zoom the X axis of an image by \fIpercentage\fR.  A number greater
than 100 will expand the image, one smaller will compress it.  A zero
value will be ignored.  This option, and the related \fI-yzoom\fR are
useful for correcting the aspect ratio of images to be displayed.
.TP
-yzoom \fIpercentage\fR
Zoom the Y axis of an image by \fIpercentage\fR.  See \fI-xzoom\fR for
more information. 
.TP
-zoom \fIpercentage\fR
Zoom both the X and Y axes by \fIpercentage\fR.  See \fI-xzoom\fR for
more information.  Technically the percentage actually zoomed is the
square of the number supplied since the zoom is to both axes, but I
opted for consistency instead of accuracy.
.SH EXAMPLES
To load the rasterfile "my.image" onto the background and replicate
it to fill the entire background:
.sp
.ti +5
xloadimage -onroot my.image
.PP
To load a monochrome image "my.image" onto the background, using red
as the foreground color, replicate the image, and overlay
"another.image" onto it at coordinate (10,10):
.sp
.ti +5
xloadimage -foreground red my.image -at 10,10 another.image
.PP
To center the rectangular region from 10 to 110 along the X axis and
from 10 to the height of the image along the Y axis:
.sp
.ti +5
xloadimage -center -clip 10,10,100,0 my.image
.PP
To double the size of an image:
.sp
.ti +5
xloadimage -zoom 200 my.image
.PP
To halve the size of an image:
.sp
.ti +5
xloadimage -zoom 50 my.image
.PP
To brighten a dark image:
.sp
.ti +5
xloadimage -brighten 150 my.image
.PP
To darken a bright image:
.sp
.ti +5
xloadimage -brighten 50 my.image
.SH HINTS FOR GOOD IMAGE DISPLAYS
Since images are likely to come from a variety of sources, they may be
in a variety of aspect ratios which may not be supported by your
display.  The \fI-xzoom\fR and \fI-yzoom\fR options can be used to
change the aspect ratio of an image before display.  If you use these
options, it is recommended that you increase the size of one of the
dimensions instead of shrinking the other, since shrinking looses
detail.  For instance, many GIF and G3 FAX images have an X:Y ratio of
about 2:1.  You can correct this for viewing on a 1:1 display with
either \fI-xzoom 50\fR or \fI-yzoom 200\fR (reduce X axis to 50% of
its size and expand Y axis to 200% of its size, respectively) but the
latter should be used so no detail is lost in the conversion.
.PP
When zooming color images up you can reduce blockiness with
\fI-smooth\fR.  For zooms of 300% or more, I recommend two smoothing
passes (although this can take awhile to do on slow machines).  There
will be a noticable improvement in the image.
.PP
You can perform image processing on a small portion of an image by
loading the image more than once and using the \fI-merge\fR, \fI-at\fR
and \fI-clip\fR options.  Load the image, then merge it with a
clipped, processed version of itself.  To brighten a 100x100 rectangular
portion of an image located at (50,50), for instance, you could type:
.sp
.ti +5
xloadimage my.image -merge -at 50,50 -clip 50,50,100,100 -brighten 150 my.image
.PP
If you're using a display with a small colormap to display colorful
images, try using the \fI-gray\fR option to convert to grayscale.
.SH PATHS AND EXTENSIONS
The file ~/.xloadimagerc (and optionally a system-wide file) defines
the path and default extensions that \fIxloadimage\fR will use when
looking for images.  This file can have two statements: "path=" and
"extension=" (the equals signs must follow the word with no spaces
between).  Everything following the "path=" keyword will be prepended
to the supplied image name if the supplied name does not specify an
existing file.  The paths will be searched in the order they are
specified.  Everything following the "extension=" keyword will be
appended to the supplied image name if the supplied name does not
specify an existing file.  As with paths, these extensions will be
searched in the order they are given.  Comments are any portion of a
line following a hash-mark (#).
.PP
The following is a sample ~/.xloadimagerc file:
.PP
.nf
  # paths to look for images in
  path= /usr/local/images
        /home/usr1/guest/madd/images
        /usr/include/X11/bitmaps

  # default extensions for images; .Z is automatic; scanned in order
  extension= .csun .msun .sun .face .xbm .bm
.fi
.PP
Versions of \fIxloadimage\fR prior to version 01, patchlevel 03 would
load the system-wide file (if any), followed by the user's file.  This
behavior made it difficult for the user to configure her environment
if she didn't want the default.  Newer versions will ignore the
system-wide file if a personal configuration file exists.
.SH IMAGE TYPES
.PP
\fIXloadimage\fR currently supports the following image types:
.sp
.nf
  CMU Window Manager raster files
  Faces Project images
  Fuzzy Bitmap (FBM) images
  GEM bit images
  GIF images
  G3 FAX images
  McIDAS areafiles
  MacPaint images
  PC Paintbrush (PCX) images
  Portable Bitmap (PBM, PGM, PPM) images
  Sun monochrome rasterfiles
  Sun color RGB rasterfiles
  Utah Raster Toolkit (RLE) files
  X pixmap files
  X10 bitmap files
  X11 bitmap files
  X Window Dump (except TrueColor and DirectColor)
.fi
.PP
Normal, compact, and raw PBM images are supported.  Both standard and
run-length encoded Sun rasterfiles are supported.  Any image whose
name ends in .Z is assumed to be a compressed image and will be
filtered through "uncompress".
.SH AUTHOR
.nf
Jim Frost
CenterLine Software
jimf@centerline.com
.fi
.PP
For a more-or-less complete list of other contributors (there are a
\fIlot\fR of them), please see the README file enclosed with the
distribution.
.SH FILES
.nf
.in +5
xloadimage              - the image loader and viewer
xsetbg                  - pseudonym which quietly sets the background
xview                   - pseudonym which views in a window
/usr/lib/X11/Xloadimage - default system-wide configuration file
~/.xloadimagerc         - user's personal configuration file
.in -5
.fi
.SH COPYRIGHT
Copyright (c) 1989, 1990, 1991, 1992 Jim Frost and others.
.PP
\fIXloadimage\fR is copywritten material with a very loose copyright
allowing unlimited modification and distribution if the copyright
notices are left intact.  Various portions are copywritten by various
people, but all use a modification of the MIT copyright notice.
Please check the source for complete copyright information.  The
intent is to keep the source free, not to stifle its distribution, so
please write to me if you have any questions.
.SH BUGS
Zooming dithered images, especially downwards, is UGLY.
.PP
Images can come in a variety of aspect ratios.  \fIXloadimage\fR cannot
detect what aspect ratio the particular image being loaded has, nor
the aspect ratio of the destination display, so images with differing
aspect ratios from the destination display will appear distorted.  See
\fIHINTS FOR GOOD IMAGE DISPLAYS\fR for more information.
.PP
The GIF format allows more than one image to be stored in a single GIF
file, but \fIxloadimage\fR will only display the first.
.PP
Only GIF87a format is supported.
.PP
One of the pseudonyms for \fIxloadimage\fR, \fIxview\fR, is the same
name as Sun uses for their SunView-under-X package.  This will be
confusing if you're one of those poor souls who has to use Sun's
XView.
.PP
Some window managers do not correctly handle window size requests.  In
particular, many versions of the twm window manager use
the MaxSize hint instead of the PSize hint, causing images which
are larger than the screen to display in a window larger than the
screen, something which is normally avoided.  Some versions of twm
also ignore the MaxSize argument's real function, to limit the maximum
size of the window, and allow the window to be resized larger than the
image.  If this happens, \fIxloadimage\fR merely places the image in
the upper-left corner of the window and uses the zero-value'ed pixel
for any space which is not covered by the image.  This behavior is
less-than-graceful but so are window managers which are cruel enough
to ignore such details.
.PP
The order in which operations are performed on an image is independent
of the order in which they were specified on the command line.
Wherever possible I tried to order operations in such a way as to look
the best possible (zooming before dithering, for instance) or to
increase speed (zooming downward before compressing, for instance).
