/* typeres.h
   type resources for extended types. */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.3     08 April 1993                  */
     /*                version 1.2     20 November 1992               */
     /*                version 1.1     20 April 1992                  */
     /*                version 1.0     04 March 1992                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing and Communications Services Office   */
     /* Copyright 1992, 1993 by                                       */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/

#ifndef TYPERES_H
#define TYPERES_H

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>


typedef struct {
	String		sameAs;
	String		description;
	String		prefix;
	String		servers;
	copyType	dataType;
	String		execCommand;
	Boolean		wait;
	} typeResources, *typeResourcesP;


#define GOffset(x) XtOffset(typeResourcesP, x)

#define TE_DESCR	1
#define TE_PREFIX	2

static XtResource typeEntry[] = {
    {"sameAs", "SameAs", XtRString, sizeof(String),
		GOffset(sameAs), XtRImmediate, (XtPointer) NULL},
    {"description", "Description", XtRString, sizeof(String),
		GOffset(description), XtRString, (XtPointer) NULL},
    {"prefix", "Prefix", XtRString, sizeof(String),
		GOffset(prefix), XtRString, (XtPointer) NULL},
    {"servers", "Servers", XtRString, sizeof(String),
		GOffset(servers), XtRImmediate, (XtPointer) NULL},
    {"dataType", "DataType", XgRCopyType, sizeof(int),
		GOffset(dataType), XtRImmediate, (XtPointer) copyTypeUnspec},
    {"execCommand", "ExecCommand", XtRString, sizeof(String),
		GOffset(execCommand), XtRImmediate, (XtPointer) NULL},
    {"wait", "Wait", XtRBoolean, sizeof(Boolean),
		GOffset(wait), XtRImmediate, (XtPointer) False},
    };

#undef GOffset

typeResources *getTypeResources(
#ifdef PROTO
	String,		/* name */
	String		/* class */
#endif
);

#endif   /* TYPERES_H */
